/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import com.ibm.Compiler.Internal.Quad;
import java.math.BigInteger;
import java.util.Arrays;

class DivisionLong {
    DivisionLong() {
    }

    static BigInteger oddModPow(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n = bigInteger3.numberLength + 1 >> 1 << 6;
        BigInteger bigInteger4 = bigInteger.shiftLeft(n).mod(bigInteger3);
        BigInteger bigInteger5 = BigInteger.ZERO.setBit(n).mod(bigInteger3);
        int[] nArray = DivisionLong.oddModPow(bigInteger.digits, bigInteger2.digits, bigInteger3.digits, bigInteger5.digits, bigInteger4.digits);
        BigInteger bigInteger6 = new BigInteger(1, nArray);
        return bigInteger6;
    }

    static int[] oddModPow(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        long[] lArray = DivisionLong.arraycopyItoL(nArray);
        long[] lArray2 = DivisionLong.arraycopyItoL(nArray2);
        long[] lArray3 = DivisionLong.arraycopyItoL(nArray3);
        long[] lArray4 = DivisionLong.arraycopyItoL(nArray4);
        long[] lArray5 = DivisionLong.arraycopyItoL(nArray5);
        long[] lArray6 = DivisionLong.oddModPow(lArray, lArray2, lArray3, lArray4, lArray5);
        int[] nArray6 = DivisionLong.arraycopyLtoI(lArray6);
        return nArray6;
    }

    static long[] oddModPow(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) {
        long l = lArray3[0];
        long l2 = 1L;
        long l3 = 2L;
        do {
            if ((l * l2 & l3) == 0L) continue;
            l2 |= l3;
        } while ((l3 <<= 1) != 0L);
        l2 = -l2;
        int n = DivisionLong.numberLength(lArray3);
        long[] lArray6 = n == 1 ? DivisionLong.squareAndMultiply(lArray4, lArray5, lArray2, lArray3, n, l2) : DivisionLong.slidingWindow(lArray4, lArray5, lArray2, lArray3, n, l2);
        long[] lArray7 = new long[]{1L};
        lArray6 = DivisionLong.monPro(lArray6, lArray7, lArray3, n, l2);
        return lArray6;
    }

    static long[] squareAndMultiply(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, int n, long l) {
        for (int i = DivisionLong.bitLength(lArray3) - 1; i >= 0; --i) {
            lArray = DivisionLong.monPro(lArray, lArray, lArray4, n, l);
            if (!DivisionLong.testBit(lArray3, i)) continue;
            lArray = DivisionLong.monPro(lArray, lArray2, lArray4, n, l);
        }
        return lArray;
    }

    static long[] slidingWindow(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, int n, long l) {
        int n2;
        long[][] lArrayArray = new long[8][];
        lArrayArray[0] = lArray2;
        long[] lArray5 = DivisionLong.monSquare(lArray2, lArray4, n, l);
        for (n2 = 1; n2 <= 7; ++n2) {
            lArrayArray[n2] = DivisionLong.monPro(lArrayArray[n2 - 1], lArray5, lArray4, n, l);
        }
        for (n2 = DivisionLong.bitLength(lArray3) - 1; n2 >= 0; --n2) {
            if (DivisionLong.testBit(lArray3, n2)) {
                int n3;
                int n4 = 1;
                int n5 = n2;
                for (n3 = Math.max(n2 - 3, 0); n3 <= n2 - 1; ++n3) {
                    if (!DivisionLong.testBit(lArray3, n3)) continue;
                    if (n3 < n5) {
                        n5 = n3;
                        n4 = n4 << n2 - n3 ^ 1;
                        continue;
                    }
                    n4 ^= 1 << n3 - n5;
                }
                for (n3 = n5; n3 <= n2; ++n3) {
                    lArray = DivisionLong.monSquare(lArray, lArray4, n, l);
                }
                lArray = DivisionLong.monPro(lArrayArray[n4 - 1 >> 1], lArray, lArray4, n, l);
                n2 = n5;
                continue;
            }
            lArray = DivisionLong.monSquare(lArray, lArray4, n, l);
        }
        return lArray;
    }

    static long[] monSquare(long[] lArray, long[] lArray2, int n, long l) {
        if (n == 1) {
            return DivisionLong.monPro(lArray, lArray, lArray2, n, l);
        }
        long[] lArray3 = new long[(n << 1) + 1];
        int n2 = Math.min(n, DivisionLong.numberLength(lArray));
        DivisionLong.monMulSq(lArray, n2, lArray3);
        DivisionLong.monReduceSq(lArray, lArray2, l, n, lArray3);
        for (int i = 0; i < n + 1; ++i) {
            lArray3[i] = lArray3[i + n];
        }
        return DivisionLong.finalSubtraction(lArray3, n, lArray2, n);
    }

    static void monMulSq(long[] lArray, int n, long[] lArray2) {
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            long l2 = lArray[i];
            for (int j = i + 1; j < n; ++j) {
                Quad quad = Quad.mul(lArray[j], l2);
                quad = Quad.add(quad, lArray2[i + j]);
                quad = Quad.add(quad, l);
                lArray2[i + j] = Quad.lo(quad);
                l = Quad.hi(quad);
            }
            lArray2[i + n] = l;
        }
        DivisionLong.shiftLeft(lArray2, lArray2, 0, 1);
        long l = 0L;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            Quad quad = Quad.mul(lArray[n2], lArray[n2]);
            quad = Quad.add(quad, lArray2[n3]);
            quad = Quad.add(quad, l);
            lArray2[n3] = Quad.lo(quad);
            l = Quad.hi(quad);
            quad = Quad.add(lArray2[++n3], l);
            lArray2[n3] = Quad.lo(quad);
            l = Quad.hi(quad);
            ++n2;
            ++n3;
        }
    }

    static void monReduceSq(long[] lArray, long[] lArray2, long l, int n, long[] lArray3) {
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            long l3 = 0L;
            Quad quad = Quad.mul(lArray3[i], l);
            long l4 = Quad.lo(quad);
            for (int j = 0; j < n; ++j) {
                Quad quad2 = Quad.mul(l4, lArray2[j]);
                quad2 = Quad.add(quad2, lArray3[i + j]);
                quad2 = Quad.add(quad2, l3);
                lArray3[i + j] = Quad.lo(quad2);
                l3 = Quad.hi(quad2);
            }
            quad = Quad.add(l2, lArray3[i + n]);
            quad = Quad.add(quad, l3);
            lArray3[i + n] = Quad.lo(quad);
            l2 = Quad.hi(quad);
        }
        lArray3[n << 1] = l2;
    }

    static long[] monPro(long[] lArray, long[] lArray2, long[] lArray3, int n, long l) {
        int n2 = DivisionLong.numberLength(lArray) - 1;
        int n3 = DivisionLong.numberLength(lArray2) - 1;
        long[] lArray4 = new long[(n << 1) + 1];
        for (int i = 0; i < n; ++i) {
            int n4;
            long l2 = 0L;
            long l3 = i > n2 ? 0L : lArray[i];
            for (n4 = 0; n4 < n; ++n4) {
                long l4 = n4 > n3 ? 0L : lArray2[n4];
                Quad quad = Quad.mul(l4, l3);
                quad = Quad.add(quad, lArray4[n4]);
                quad = Quad.add(quad, l2);
                lArray4[n4] = Quad.lo(quad);
                l2 = Quad.hi(quad);
            }
            Quad quad = Quad.add(lArray4[n], l2);
            lArray4[n] = Quad.lo(quad);
            lArray4[n + 1] = Quad.hi(quad);
            quad = Quad.mul(lArray4[0], l);
            long l5 = Quad.lo(quad);
            quad = Quad.mul(l5, lArray3[0]);
            quad = Quad.add(quad, lArray4[0]);
            l2 = Quad.hi(quad);
            for (n4 = 1; n4 < n; ++n4) {
                quad = Quad.mul(l5, lArray3[n4]);
                quad = Quad.add(quad, lArray4[n4]);
                quad = Quad.add(quad, l2);
                lArray4[n4 - 1] = Quad.lo(quad);
                l2 = Quad.hi(quad);
            }
            quad = Quad.add(lArray4[n], l2);
            lArray4[n - 1] = Quad.lo(quad);
            l2 = Quad.hi(quad);
            lArray4[n] = lArray4[n + 1] + l2;
        }
        return DivisionLong.finalSubtraction(lArray4, lArray4.length - 1, lArray3, n);
    }

    static long[] finalSubtraction(long[] lArray, int n, long[] lArray2, int n2) {
        int n3;
        boolean bl = false;
        for (n3 = n; n3 > 0 && lArray[n3] == 0L; --n3) {
        }
        if (n3 == n2 - 1) {
            while (n3 >= 0 && lArray[n3] == lArray2[n3]) {
                --n3;
            }
            bl = n3 >= 0 && DivisionLong.lessThan(lArray[n3], lArray2[n3]);
        } else {
            bl = n3 < n2 - 1;
        }
        Arrays.fill(lArray, n2 + 1, lArray.length, 0L);
        if (!bl) {
            DivisionLong.inplaceSubtract(lArray, DivisionLong.numberLength(lArray), lArray2, n2);
        }
        return lArray;
    }

    static boolean lessThan(long l, long l2) {
        if (l >= 0L && l2 >= 0L) {
            return l < l2;
        }
        if (l < 0L && l2 < 0L) {
            return l < l2;
        }
        return l >= 0L;
    }

    static void inplaceSubtract(long[] lArray, int n, long[] lArray2, int n2) {
        DivisionLong.subtract(lArray, lArray, n, lArray2, n2);
    }

    private static void subtract(long[] lArray, long[] lArray2, int n, long[] lArray3, int n2) {
        Quad quad;
        int n3;
        long l = 0L;
        for (n3 = 0; n3 < n2; ++n3) {
            quad = Quad.sub(lArray2[n3], l);
            quad = Quad.sub(quad, lArray3[n3]);
            lArray[n3] = Quad.lo(quad);
            l = -Quad.hi(quad);
        }
        while (n3 < n) {
            quad = Quad.sub(lArray2[n3], l);
            lArray[n3] = Quad.lo(quad);
            l = -Quad.hi(quad);
            ++n3;
        }
    }

    static void shiftLeft(long[] lArray, long[] lArray2, int n, int n2) {
        int n3;
        if (n2 == 0) {
            System.arraycopy(lArray2, 0, lArray, n, lArray.length - n);
        } else {
            n3 = 64 - n2;
            lArray[lArray.length - 1] = 0L;
            for (int i = lArray.length - 1; i > n; --i) {
                int n4 = i;
                lArray[n4] = lArray[n4] | lArray2[i - n - 1] >>> n3;
                lArray[i - 1] = lArray2[i - n - 1] << n2;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            lArray[n3] = 0L;
        }
    }

    static boolean testBit(long[] lArray, int n) {
        return (lArray[n >> 6] & 1L << (n & 0x3F)) != 0L;
    }

    static int bitLength(long[] lArray) {
        int n = DivisionLong.numberLength(lArray);
        int n2 = n << 6;
        long l = lArray[n - 1];
        return n2 -= Long.numberOfLeadingZeros(l);
    }

    static final int numberLength(long[] lArray) {
        int n = lArray.length;
        while (n > 0 && lArray[--n] == 0L) {
        }
        return ++n;
    }

    static long[] arraycopyItoL(int[] nArray) {
        int n = DivisionLong.numberLengthI(nArray);
        long[] lArray = new long[n + 1 >> 1];
        DivisionLong.arraycopyItoL(nArray, 0, lArray, 0, n);
        return lArray;
    }

    static void arraycopyItoL(int[] nArray, int n, long[] lArray, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        while (n4 < n + n3 - 1) {
            lArray[n5] = ((long)nArray[n4] & 0xFFFFFFFFL) + (((long)nArray[n4 + 1] & 0xFFFFFFFFL) << 32);
            n4 += 2;
            ++n5;
        }
        if (n4 < n + n3) {
            lArray[n5] = (long)nArray[n4] & 0xFFFFFFFFL;
        }
    }

    static int[] arraycopyLtoI(long[] lArray) {
        int n = 2 * DivisionLong.numberLength(lArray);
        int[] nArray = new int[n];
        DivisionLong.arraycopyLtoI(lArray, 0, nArray, 0, n);
        return nArray;
    }

    static void arraycopyLtoI(long[] lArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n3 >> 1;
        int n5 = n;
        int n6 = n2;
        while (n5 < n + n4) {
            nArray[n6] = (int)lArray[n5];
            nArray[n6 + 1] = (int)(lArray[n5] >>> 32);
            ++n5;
            n6 += 2;
        }
        if ((n3 & 1) == 1) {
            nArray[n6] = (int)lArray[n5];
        }
    }

    static boolean equalsArrays(int[] nArray, int[] nArray2) {
        int n;
        if (DivisionLong.numberLengthI(nArray) != DivisionLong.numberLengthI(nArray2)) {
            return false;
        }
        for (n = DivisionLong.numberLengthI(nArray) - 1; n >= 0 && nArray[n] == nArray2[n]; --n) {
        }
        return n < 0;
    }

    static final int numberLengthI(int[] nArray) {
        int n = nArray.length;
        while (n > 0 && nArray[--n] == 0) {
        }
        return ++n;
    }
}

