/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

class BitLevel {
    private BitLevel() {
    }

    static int bitLength(BigInteger bigInteger) {
        int n;
        if (bigInteger.sign == 0) {
            return 0;
        }
        int n2 = bigInteger.numberLength << 5;
        int n3 = bigInteger.digits[bigInteger.numberLength - 1];
        if (bigInteger.sign < 0 && (n = bigInteger.getFirstNonzeroDigit()) == bigInteger.numberLength - 1) {
            --n3;
        }
        return n2 -= Integer.numberOfLeadingZeros(n3);
    }

    static int bitCount(BigInteger bigInteger) {
        int n;
        int n2 = 0;
        if (bigInteger.sign == 0) {
            return 0;
        }
        if (bigInteger.sign > 0) {
            for (n = bigInteger.getFirstNonzeroDigit(); n < bigInteger.numberLength; ++n) {
                n2 += Integer.bitCount(bigInteger.digits[n]);
            }
        } else {
            n2 += Integer.bitCount(-bigInteger.digits[n]);
            ++n;
            while (n < bigInteger.numberLength) {
                n2 += Integer.bitCount(~bigInteger.digits[n]);
                ++n;
            }
            n2 = (bigInteger.numberLength << 5) - n2;
        }
        return n2;
    }

    static boolean testBit(BigInteger bigInteger, int n) {
        return (bigInteger.digits[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    static boolean nonZeroDroppedBits(int n, int[] nArray) {
        int n2;
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        for (n2 = 0; n2 < n3 && nArray[n2] == 0; ++n2) {
        }
        return n2 != n3 || nArray[n2] << 32 - n4 != 0;
    }

    static BigInteger shiftLeft(BigInteger bigInteger, int n) {
        int n2 = n >> 5;
        int n3 = bigInteger.numberLength + n2 + ((n &= 0x1F) == 0 ? 0 : 1);
        int[] nArray = new int[n3];
        BitLevel.shiftLeft(nArray, bigInteger.digits, n2, n);
        BigInteger bigInteger2 = new BigInteger(bigInteger.sign, n3, nArray);
        bigInteger2.cutOffLeadingZeroes();
        return bigInteger2;
    }

    static void inplaceShiftLeft(BigInteger bigInteger, int n) {
        int n2 = n >> 5;
        bigInteger.numberLength = bigInteger.numberLength + (n2 + (Integer.numberOfLeadingZeros(bigInteger.digits[bigInteger.numberLength - 1]) - (n & 0x1F) >= 0 ? 0 : 1));
        BitLevel.shiftLeft(bigInteger.digits, bigInteger.digits, n2, n & 0x1F);
        bigInteger.cutOffLeadingZeroes();
        bigInteger.unCache();
    }

    static void shiftLeft(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        if (n2 == 0) {
            System.arraycopy(nArray2, 0, nArray, n, nArray.length - n);
        } else {
            n3 = 32 - n2;
            nArray[nArray.length - 1] = 0;
            for (int i = nArray.length - 1; i > n; --i) {
                int n4 = i;
                nArray[n4] = nArray[n4] | nArray2[i - n - 1] >>> n3;
                nArray[i - 1] = nArray2[i - n - 1] << n2;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3] = 0;
        }
    }

    static void shiftLeftOneBit(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray2[i];
            nArray[i] = n3 << 1 | n2;
            n2 = n3 >>> 31;
        }
        if (n2 != 0) {
            nArray[n] = n2;
        }
    }

    static BigInteger shiftLeftOneBit(BigInteger bigInteger) {
        int n = bigInteger.numberLength;
        int n2 = n + 1;
        int[] nArray = new int[n2];
        BitLevel.shiftLeftOneBit(nArray, bigInteger.digits, n);
        BigInteger bigInteger2 = new BigInteger(bigInteger.sign, n2, nArray);
        bigInteger2.cutOffLeadingZeroes();
        return bigInteger2;
    }

    static BigInteger shiftRight(BigInteger bigInteger, int n) {
        int n2 = n >> 5;
        n &= 0x1F;
        if (n2 >= bigInteger.numberLength) {
            return bigInteger.sign < 0 ? BigInteger.MINUS_ONE : BigInteger.ZERO;
        }
        int n3 = bigInteger.numberLength - n2;
        int[] nArray = new int[n3 + 1];
        BitLevel.shiftRight(nArray, n3, bigInteger.digits, n2, n);
        if (bigInteger.sign < 0) {
            int n4;
            for (n4 = 0; n4 < n2 && bigInteger.digits[n4] == 0; ++n4) {
            }
            if (n4 < n2 || n > 0 && bigInteger.digits[n4] << 32 - n != 0) {
                for (n4 = 0; n4 < n3 && nArray[n4] == -1; ++n4) {
                    nArray[n4] = 0;
                }
                if (n4 == n3) {
                    ++n3;
                }
                int n5 = n4;
                nArray[n5] = nArray[n5] + 1;
            }
        }
        BigInteger bigInteger2 = new BigInteger(bigInteger.sign, n3, nArray);
        bigInteger2.cutOffLeadingZeroes();
        return bigInteger2;
    }

    static void inplaceShiftRight(BigInteger bigInteger, int n) {
        int n2 = bigInteger.signum();
        if (n == 0 || bigInteger.signum() == 0) {
            return;
        }
        int n3 = n >> 5;
        bigInteger.numberLength -= n3;
        if (!BitLevel.shiftRight(bigInteger.digits, bigInteger.numberLength, bigInteger.digits, n3, n & 0x1F) && n2 < 0) {
            int n4;
            for (n4 = 0; n4 < bigInteger.numberLength && bigInteger.digits[n4] == -1; ++n4) {
                bigInteger.digits[n4] = 0;
            }
            if (n4 == bigInteger.numberLength) {
                ++bigInteger.numberLength;
            }
            int n5 = n4;
            bigInteger.digits[n5] = bigInteger.digits[n5] + 1;
        }
        bigInteger.cutOffLeadingZeroes();
        bigInteger.unCache();
    }

    static boolean shiftRight(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4;
        boolean bl = true;
        for (n4 = 0; n4 < n2; ++n4) {
            bl &= nArray2[n4] == 0;
        }
        if (n3 == 0) {
            System.arraycopy(nArray2, n2, nArray, 0, n);
            n4 = n;
        } else {
            int n5 = 32 - n3;
            bl &= nArray2[n4] << n5 == 0;
            for (n4 = 0; n4 < n - 1; ++n4) {
                nArray[n4] = nArray2[n4 + n2] >>> n3 | nArray2[n4 + n2 + 1] << n5;
            }
            nArray[n4] = nArray2[n4 + n2] >>> n3;
            ++n4;
        }
        return bl;
    }

    static BigInteger flipBit(BigInteger bigInteger, int n) {
        int n2 = bigInteger.sign == 0 ? 1 : bigInteger.sign;
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        int n5 = Math.max(n3 + 1, bigInteger.numberLength) + 1;
        int[] nArray = new int[n5];
        int n6 = 1 << n4;
        System.arraycopy(bigInteger.digits, 0, nArray, 0, bigInteger.numberLength);
        if (bigInteger.sign < 0) {
            if (n3 >= bigInteger.numberLength) {
                nArray[n3] = n6;
            } else {
                int n7 = bigInteger.getFirstNonzeroDigit();
                if (n3 > n7) {
                    int n8 = n3;
                    nArray[n8] = nArray[n8] ^ n6;
                } else if (n3 < n7) {
                    int n9;
                    nArray[n3] = -n6;
                    for (n9 = n3 + 1; n9 < n7; ++n9) {
                        nArray[n9] = -1;
                    }
                    int n10 = n9;
                    nArray[n10] = nArray[n10] - 1;
                } else {
                    int n11 = n3;
                    nArray[n11] = -(-nArray[n3] ^ n6);
                    if (nArray[n11] == 0) {
                        ++n11;
                        while (nArray[n11] == -1) {
                            nArray[n11] = 0;
                            ++n11;
                        }
                        int n12 = n11;
                        nArray[n12] = nArray[n12] + 1;
                    }
                }
            }
        } else {
            int n13 = n3;
            nArray[n13] = nArray[n13] ^ n6;
        }
        BigInteger bigInteger2 = new BigInteger(n2, n5, nArray);
        bigInteger2.cutOffLeadingZeroes();
        return bigInteger2;
    }
}

