/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.sequence;

import com.ibm.gsk.ikeyman.sequence.Sequence;
import com.ibm.gsk.ikeyman.sequence.SequenceFactory$CompositeSequence$1;
import com.ibm.gsk.ikeyman.sequence.SequenceFactory$SubSequence;
import com.ibm.gsk.ikeyman.sequence.SequenceIterator;
import java.util.Iterator;

final class SequenceFactory$CompositeSequence
implements Sequence {
    private static final long serialVersionUID = 2L;
    private final Sequence seq1;
    private final Sequence seq2;
    private final int len1;
    private final int len2;
    private int hc;
    private boolean hcCalculated;
    private String ts;

    SequenceFactory$CompositeSequence(Sequence sequence, Sequence sequence2) {
        this.seq1 = sequence;
        this.seq2 = sequence2;
        this.len1 = sequence.length();
        this.len2 = sequence2.length();
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.len1 + this.len2) {
            throw new IndexOutOfBoundsException();
        }
        if (n < this.len1) {
            return this.seq1.get(n);
        }
        return this.seq2.get(n - this.len1);
    }

    public int length() {
        return this.len1 + this.len2;
    }

    public Sequence append(Sequence sequence) throws NullPointerException {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (sequence.length() == 0) {
            return this;
        }
        return new SequenceFactory$CompositeSequence(this, sequence);
    }

    public Sequence getSubSequence(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n2 > this.len1 + this.len2 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new SequenceFactory$SubSequence(this, n, n2);
    }

    public int indexOf(Object object) {
        int n = this.seq1.indexOf(object);
        if (n == -1) {
            int n2 = this.seq2.indexOf(object);
            return n2 == -1 ? -1 : n2 + this.len1;
        }
        return n;
    }

    public int indexOf(int n, Object object) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.len1 + this.len2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        SequenceIterator sequenceIterator = this.getIterator(n);
        while (sequenceIterator.hasNext()) {
            int n2 = sequenceIterator.getPosition();
            Object e = sequenceIterator.next();
            if (!(e == null ? object == null : e.equals(object))) continue;
            return n2;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.seq2.lastIndexOf(object);
        if (n == -1) {
            return this.seq1.lastIndexOf(object);
        }
        return n + this.seq1.length();
    }

    public int lastIndexOf(int n, Object object) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.len1 + this.len2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        SequenceIterator sequenceIterator = this.getIterator(n);
        while (sequenceIterator.hasPrevious()) {
            Object object2 = sequenceIterator.previous();
            int n2 = sequenceIterator.getPosition();
            if (!(object2 == null ? object == null : object2.equals(object))) continue;
            return n2;
        }
        return -1;
    }

    public boolean isEmpty() {
        return false;
    }

    public Iterator iterator() {
        return this.getIterator(0);
    }

    public SequenceIterator getIterator() {
        return this.getIterator(0);
    }

    public SequenceIterator getIterator(int n) throws IndexOutOfBoundsException {
        int n2 = this.len1 + this.len2;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return new SequenceFactory$CompositeSequence$1(this, n, n2);
    }

    public String toString() {
        if (this.ts == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            Iterator iterator = this.seq1.iterator();
            Iterator iterator2 = this.seq2.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext() && !iterator2.hasNext()) continue;
                stringBuilder.append("][");
            }
            while (iterator2.hasNext()) {
                stringBuilder.append(iterator2.next());
                if (!iterator2.hasNext()) continue;
                stringBuilder.append("][");
            }
            stringBuilder.append("]");
            this.ts = stringBuilder.toString();
        }
        return this.ts;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Sequence)) {
            return false;
        }
        Sequence sequence = (Sequence)object;
        if (sequence.length() != this.len1 + this.len2) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = sequence.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Object e = iterator.next();
            Object t = iterator2.next();
            if (!(e == null ? t != null : !e.equals(t))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hcCalculated) {
            int n = 461;
            int n2 = 73;
            for (Object e : this) {
                if (e == null) continue;
                n2 = n2 * 461 + e.hashCode();
            }
            this.hc = n2;
            this.hcCalculated = true;
        }
        return this.hc;
    }

    static int access$200(SequenceFactory$CompositeSequence sequenceFactory$CompositeSequence) {
        return sequenceFactory$CompositeSequence.len1;
    }

    static Sequence access$300(SequenceFactory$CompositeSequence sequenceFactory$CompositeSequence) {
        return sequenceFactory$CompositeSequence.seq1;
    }

    static Sequence access$400(SequenceFactory$CompositeSequence sequenceFactory$CompositeSequence) {
        return sequenceFactory$CompositeSequence.seq2;
    }
}

