/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.ext;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.ext.CACertificates$1;
import com.ibm.gsk.ikeyman.keystore.ext.CACertificates$2;
import com.ibm.gsk.ikeyman.keystore.ext.CACertificates$3;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree$KeymanTreeNode;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.Pair;
import com.ibm.misc.BASE64Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class CACertificates {
    static final Pair RSA_LABEL_PAIR = new Pair("RSA Data Security Inc.", "rsa");
    static final Pair RSA_SECURE_SERVER_CA_LABEL_PAIR = new Pair("RSA Secure Server Certification Authority", "rsaSecureServerCA");
    static final Pair THAWTE_LABEL_PAIR = new Pair("Thawte Consulting", "thawte");
    static final Pair THAWTE_PRIMARY_ROOT_CERT_LABEL_PAIR = new Pair("Thawte Primary Root CA", "thawteprimaryrootCA");
    static final Pair THAWTE_PRIMARY_ROOT_CERT_G2_ECC_LABEL_PAIR = new Pair("Thawte Primary Root CA - G2 ECC", "thawteprimaryrootCAG2ECC");
    static final Pair THAWTE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR = new Pair("Thawte Server CA", "thawteServerCA");
    static final Pair THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR = new Pair("Thawte Premium Server CA", "thawtePremiumServerCA");
    static final Pair THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL_PAIR = new Pair("Thawte Personal Basic CA", "thawtePersonalBasicCA");
    static final Pair THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR = new Pair("Thawte Personal Freemail CA", "thawtePersonalFreemailCA");
    static final Pair THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR = new Pair("Thawte Personal Premium CA", "thawtePersonalPremiumCA");
    static final Pair VERISIGN_LABEL_PAIR = new Pair("Verisign Inc.", "verisign");
    static final Pair VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR = new Pair("VeriSign Class 1 Public Primary Certification Authority - G3", "verisignClass1G3CA");
    static final Pair VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR = new Pair("VeriSign Class 2 Public Primary Certification Authority - G3", "verisignClass2G3CA");
    static final Pair VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR = new Pair("VeriSign Class 3 Public Primary Certification Authority - G3", "verisignClass3G3CA");
    static final Pair VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G5_LABEL_PAIR = new Pair("VeriSign Class 3 Public Primary Certification Authority - G5", "verisignClass3G5CA");
    static final Pair VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR = new Pair("VeriSign Class 4 Public Primary Certification Authority - G3", "verisignClass4G3CA");
    static final Pair VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR = new Pair("VeriSign Class 1 Public Primary Certification Authority - G2", "verisignClass1G2CA");
    static final Pair VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR = new Pair("VeriSign Class 2 Public Primary Certification Authority - G2", "verisignClass2G2CA");
    static final Pair VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR = new Pair("VeriSign Class 3 Public Primary Certification Authority - G2", "verisignClass3G2CA");
    static final Pair VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR = new Pair("VeriSign Class 4 Public Primary Certification Authority - G2", "verisignClass4G2CA");
    static final Pair VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_LABEL_PAIR = new Pair("VeriSign Class 1 Public Primary Certification Authority", "verisignClass1CA");
    static final Pair VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_LABEL_PAIR = new Pair("VeriSign Class 2 Public Primary Certification Authority", "verisignClass2CA");
    static final Pair VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_LABEL_PAIR = new Pair("VeriSign Class 3 Public Primary Certification Authority", "verisignClass3CA");
    static final Pair ENTRUST_LABEL_PAIR = new Pair("Entrust.net", "entrust");
    static final Pair ENTRUST_SECURE_SERVER_CA_LABEL_PAIR = new Pair("Entrust.net Secure Server Certification Authority", "entrustSecureServerCA");
    static final Pair ENTRUST_CA_2048_LABEL_PAIR = new Pair("Entrust.net Certification Authority (2048)", "entrust2048CA");
    static final Pair ENTRUST_CLIENT_CA_LABEL_PAIR = new Pair("Entrust.net Client Certification Authority", "entrustClientCA");
    static final Pair ENTRUST_GLOBAL_CLIENT_CA_LABEL_PAIR = new Pair("Entrust.net Global Client Certification Authority", "entrustGlobalClientCA");
    static final Pair ENTRUST_GLOBAL_SECURE_SERVER_CA_LABEL_PAIR = new Pair("Entrust.net Global Secure Server Certification Authority", "entrustGlobalServerCA");
    static final Pair ENTRUST_CA_2048_29_LABEL_PAIR = new Pair("Entrust.net Certification Authority (2048) 29", "entrust2048_29CA");
    static final Pair ENTRUST_CA_EC1_LABEL_PAIR = new Pair("Entrust Root Certification Authority - EC1", "entrustEC1CA");
    static final Pair ENTRUST_CA_EV_LABEL_PAIR = new Pair("Entrust Root Certification Authority - EV", "entrustEVCA");
    static final Pair ENTRUST_CA_G2_LABEL_PAIR = new Pair("Entrust Root Certification Authority - G2", "entrustG2CA");
    static final Pair DIGICERT_LABEL_PAIR = new Pair("DigiCert", "digiCert");
    static final Pair DIGICERT_GLOBAL_ROOT_CA_CERT_LABEL_PAIR = new Pair("DigiCert Global Root CA", "digiCertGlobalRootCA");
    static final Pair DIGICERT_SHA2_SECURE_SERVER_CA_CERT_LABEL_PAIR = new Pair("DigiCert SHA2 Secure Server CA", "digiCertSha2SecureServerCA");
    static final Pair ISRG_ROOT_X1_CA_CERT_LABEL_PAIR = new Pair("ISRG Root CA X1", "isrgRootCAX1");
    static final Pair LETS_ENC_LABEL_PAIR = new Pair("Let's Encrypt", "letsEncrypt");
    static final Pair LETS_ENC_AUTH_CA_CERT_LABEL_PAIR = new Pair("Lets Encrypt Authority R3", "letsEncryptAuthorityR3");
    static Map CACERTS = new HashMap(35);
    static Map DEFAULT_CACERTS = new HashMap(29);
    static Map IBM_CLOUD_CACERTS = new HashMap(6);
    static Map FRIENDLY_LABEL_NAME_MAP = new HashMap(35);
    static Map DEFAULT_FRIENDLY_LABEL_NAME_MAP = new HashMap(29);
    static Map IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP = new HashMap(6);
    static KeymanTree CERTIFICATE_TREE = null;
    static KeymanTree DEFAULT_CERTIFICATE_TREE = null;
    static KeymanTree IBM_CLOUD_CERTIFICATE_TREE = null;
    static Map CERTIFICATE_GROUPING = new TreeMap(new CACertificates$1());
    static Map DEFAULT_CERTIFICATE_GROUPING = new TreeMap(new CACertificates$2());
    static Map IBM_CLOUD_CERTIFICATE_GROUPING = new TreeMap(new CACertificates$3());

    private static byte[] getRSASecureServerCASelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 52, 48, -126, 1, -95, 2, 16, 2, -83, 102, 126, 78, 69, -2, 94, 87, 111, 60, -104, 25, 94, -35, -64, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 32, 48, 30, 6, 3, 85, 4, 10, 19, 23, 82, 83, 65, 32, 68, 97, 116, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 44, 32, 73, 110, 99, 46, 49, 46, 48, 44, 6, 3, 85, 4, 11, 19, 37, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 52, 49, 49, 48, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 49, 48, 48, 49, 48, 55, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 32, 48, 30, 6, 3, 85, 4, 10, 19, 23, 82, 83, 65, 32, 68, 97, 116, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 44, 32, 73, 110, 99, 46, 49, 46, 48, 44, 6, 3, 85, 4, 11, 19, 37, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -101, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -119, 0, 48, -127, -123, 2, 126, 0, -110, -50, 122, -63, -82, -125, 62, 90, -86, -119, -125, 87, -84, 37, 1, 118, 12, -83, -82, -114, 44, 55, -50, -21, 53, 120, 100, 84, 3, -27, -124, 64, 81, -55, -65, -113, 8, -30, -118, -126, 8, -46, 22, -122, 55, 85, -23, -79, 33, 2, -83, 118, 104, -127, -102, 5, -94, 75, -55, 75, 37, 102, 34, 86, 108, -120, 7, -113, -9, -127, 89, 109, -124, 7, 101, 112, 19, 113, 118, 62, -101, 119, 76, -29, 80, -119, 86, -104, 72, -71, 29, -89, 41, 26, 19, 46, 74, 17, 89, -100, 30, 21, -43, 73, 84, 44, 115, 58, 105, -126, -79, -105, 57, -100, 109, 112, 103, 72, -27, -35, 45, -42, -56, 30, 123, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, 126, 0, 101, -35, 126, -31, -78, -20, -80, -30, 58, -32, -20, 113, 70, -102, 25, 17, -72, -45, -57, -96, -76, 3, 64, 38, 2, 62, 9, -100, -31, 18, -77, -47, 90, -10, 55, -91, -73, 97, 3, -74, 91, 22, 105, 59, -58, 68, 8, 12, -120, 83, 12, 107, -105, 73, -57, 62, 53, -36, 108, -71, -69, -86, -33, 92, -69, 58, 47, -109, 96, -74, -87, 75, 77, -14, 32, -9, -51, 95, 127, 100, 123, -114, -36, 0, 92, -41, -6, 119, -54, 57, 22, 89, 111, 14, -22, -45, -75, -125, 127, 77, 77, 66, 86, 118, -76, -55, 95, 4, -8, 56, -8, -21, -46, 95, 117, 95, -51, 123, -4, -27, -114, -128, 124, -4, 80};
        return byArray;
    }

    private static byte[] getThawtePrimaryRootCert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIEIDCCAwigAwIBAgIQNE7VVyDV7exJ9C/ON9srbTANBgkqhkiG9w0BAQUFADCBqTELMAkGA1UEBhMCVVMxFTATBgNVBAoTDHRoYXd0ZSwgSW5jLjEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjE4MDYGA1UECxMvKGMpIDIwMDYgdGhhd3RlLCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxHzAdBgNVBAMTFnRoYXd0ZSBQcmltYXJ5IFJvb3QgQ0EwHhcNMDYxMTE3MDAwMDAwWhcNMzYwNzE2MjM1OTU5WjCBqTELMAkGA1UEBhMCVVMxFTATBgNVBAoTDHRoYXd0ZSwgSW5jLjEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjE4MDYGA1UECxMvKGMpIDIwMDYgdGhhd3RlLCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxHzAdBgNVBAMTFnRoYXd0ZSBQcmltYXJ5IFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCsoPD7gFnUnMekz52hWXMJEEUMDSxuaPFsW0hoSVk3/AszGcJ3f8wQLZU0HObrTQmnHNK4yZc2AreJ1CRfBsDMRJSUjQJib+ta3RGNKJpchJAQeg29dGYvajig4tVUROsdB58Hum/u6f1OCyn1PoSgAfGcq/gcfomk6KHYcWUNo1F77rzSImANuVud37r8UVsLr5iy6S7pBOhih94ryNdOwUxkHt3Ph1i6Sk/KaAcdHJ1KxtUvkcx8cXIcxcBn6zL9yZJclNqFwJu/U30rCfSMnZEfl2pSy94JNqR32HuHUETVPm4pafs5SSYeCaWAe0At6+gnhcn+Yf1+5nyXHdWdAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBR7W0XPr87Lev0xkhpqtvNG61dIUDANBgkqhkiG9w0BAQUFAAOCAQEAeRHAS7ORtvzw6WfUDW5FvlXok9LOAz/t2iWwHVfLHjp2oEzsUHboZHIMpKnxuIvW1oeEuzLlQRHAd9mzYJ3rG9XRbkREqaYB7FViHXe4XI5ISXycO1cRrK1zN44veFyQaEfZYGDm/Ac9IiAXxPcW6cTYcvnIc3zfFi8VqT79aie2oetaupgf1eNNZAqdE8hhuvU5HIe6uL17In/2/qxAeeWsEG89jxt5dovEN7MhGITlNgDrYyCZuen+MwS7QcjBAvlEYyCegc5C09YLHbTY5xZ3Y+m4Q6gLkH3LpVHz7z9M/P2C2F+fpErgUfCJzDupxBdN49cOSvkBPB7jVaMaA==");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getThawtePrimaryRootCertG2Ecc() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIICiDCCAg2gAwIBAgIQNfwmXNmET8k9Jj1Xm67XVjAKBggqhkjOPQQDAzCBhDELMAkGA1UEBhMCVVMxFTATBgNVBAoTDHRoYXd0ZSwgSW5jLjE4MDYGA1UECxMvKGMpIDIwMDcgdGhhd3RlLCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxJDAiBgNVBAMTG3RoYXd0ZSBQcmltYXJ5IFJvb3QgQ0EgLSBHMjAeFw0wNzExMDUwMDAwMDBaFw0zODAxMTgyMzU5NTlaMIGEMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMdGhhd3RlLCBJbmMuMTgwNgYDVQQLEy8oYykgMjAwNyB0aGF3dGUsIEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTEkMCIGA1UEAxMbdGhhd3RlIFByaW1hcnkgUm9vdCBDQSAtIEcyMHYwEAYHKoZIzj0CAQYFK4EEACIDYgAEotWcgnuVnfFSeIf+iha/BebfowJPDQfGAFG6DAJSLSKkQjnE/o/qycG+1E3/n3qe4rF8mq2nhglzh9HnmuN6papu+7qzcMBniKI11KOasf2twu8x+qi58/sIxpHR+ymVo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUmtgAMADna3+FGO6Lts6KDPgR4bswCgYIKoZIzj0EAwMDaQAwZgIxAN344FdHW6fmCsO99YCKlzUNG4k8VIZ3KMqh9HneteY4sPBlcIx/AlTCv//YoT7ZzwIxAMSNlPzcU9LcnXgWHxUzI1NS41oxXZ3Krr0TKUQNJ1uo52icEvdYPy5yAlejj6EULg==");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getThawteRootSelfSignedCert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIDIjCCAougAwIBAgIQNKT/9jCvTKU8MxdCoZRmdTANBgkqhkiG9w0BAQUFADCBxDELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYDVQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhhd3RlIFNlcnZlciBDQTEmMCQGCSqGSIb3DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0ZS5jb20wHhcNOTYwODAxMDAwMDAwWhcNMjEwMTAxMjM1OTU5WjCBxDELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYDVQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhhd3RlIFNlcnZlciBDQTEmMCQGCSqGSIb3DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0ZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANOkUG7I/1Zr5s9dtuoMaHVHoqrC2oQl/Kj0R1HahbUgdJSGHg91yekIYfUGbTBuFRkC6VLAYttNmZ7iagxEOM3+vuNkCXDF/rFrKbYvScg71CcEJRCXL+eQbcAoQpnXTEPew/UhbVSfXcNY4cDk2VuwuNy0e982OsK1ZiIS1ocNAgMBAAGjEzARMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEFBQADgYEAvkBpQW/G28GnvwfAReTQtUMeTJUzNelewj4o9qgNUNX/4gwP/FACjq6Rua00io2fJ3GqGcxL6ATK1BdrEhrWxl/WzV7/iXa/2EjYWb0IiokdV81FHlK6EpqE+hiJX+j5MDVqAWC5mYCDhQpu2vTJj15zLTFKY6B08h+LItIpPus=");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getThawteSPRRootSelfSignedCert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIDNjCCAp+gAwIBAgIQNhIilsXjOKUgodJfTNcJVDANBgkqhkiG9w0BAQUFADCBzjELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYDVQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhhd3RlIFByZW1pdW0gU2VydmVyIENBMSgwJgYJKoZIhvcNAQkBFhlwcmVtaXVtLXNlcnZlckB0aGF3dGUuY29tMB4XDTk2MDgwMTAwMDAwMFoXDTIxMDEwMTIzNTk1OVowgc4xCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEdMBsGA1UEChMUVGhhd3RlIENvbnN1bHRpbmcgY2MxKDAmBgNVBAsTH0NlcnRpZmljYXRpb24gU2VydmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRoYXd0ZSBQcmVtaXVtIFNlcnZlciBDQTEoMCYGCSqGSIb3DQEJARYZcHJlbWl1bS1zZXJ2ZXJAdGhhd3RlLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0jY2aovXwlue2oFBYo847kkEVdbQ7xwblRZH7xhINTpS9CtqBo87L+pW46+GjZ4X9560ZXUCTe/LCaIhUdib0GfQug2SBhRz1JPLlyoAnFxODLz6FVL88kRu2hFKbgifLy3j+ao6hnO2RlNYyIkFvYMRuHM/qgeN9EJN50CdHDcCAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOBgQBlkKyID1bZ5jA01CbH0FDxkt5r1DmICSLGpmODA/eZd9iy5Ri4XWPz1HP7bJyZePFLeH0ZJMMrAoT4vCLZiiLXoPxx7JGHIPG47LHlVYCsPVLIOQ7C8MAFT9aCdYy9X9LcdpoFEsmvcsPcJX6kTY4XpeCHf+GaWuFg3GQjPEIuTQ==");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getThawtePBasicRootSelfSignedCert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIDMDCCApmgAwIBAgIQDY4VEuGsu3eNOOMk34ww8jANBgkqhkiG9w0BAQUFADCByzELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYDVQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhhd3RlIFBlcnNvbmFsIEJhc2ljIENBMSgwJgYJKoZIhvcNAQkBFhlwZXJzb25hbC1iYXNpY0B0aGF3dGUuY29tMB4XDTk2MDEwMTAwMDAwMFoXDTIxMDEwMTIzNTk1OVowgcsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEaMBgGA1UEChMRVGhhd3RlIENvbnN1bHRpbmcxKDAmBgNVBAsTH0NlcnRpZmljYXRpb24gU2VydmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRoYXd0ZSBQZXJzb25hbCBCYXNpYyBDQTEoMCYGCSqGSIb3DQEJARYZcGVyc29uYWwtYmFzaWNAdGhhd3RlLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAvLyTU23AUE+CFeZIlDWmWr5vQvoPR+53dXLdjUmbllegeNTKP1GzaQuRdhciB5dqxFGTS+CN7zeVoQxN2jSQHReJl+A1OFdKwPQIcOk8RHtQfmGakOMj04gRRif1CwcOu93RfyAKiLlWCy4cgNrx454p7xS9CkT7G1sY0b8jkyECAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOBgQCIO/64+XpCRhGgpKJkhc1IHJzVilHNL8F9sQfP1wHeMj+W5IT+0V6tDH4OY0lqDhDkl9A/xacp2aZTHkseP1T6wIQ1c+qRqdxdk1cFBgwHua8LRDmIIaDugnOpRi9pbCV0qc3fp9f9hTAElDVKpxszJCxEFu0KxN+AqmUav3Em8A==");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getThawtePFreeRootSelfSignedCert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIDPDCCAqWgAwIBAgIQEj3w59oqIkekOIngiu7JZzANBgkqhkiG9w0BAQUFADCB0TELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYDVQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEkMCIGA1UEAxMbVGhhd3RlIFBlcnNvbmFsIEZyZWVtYWlsIENBMSswKQYJKoZIhvcNAQkBFhxwZXJzb25hbC1mcmVlbWFpbEB0aGF3dGUuY29tMB4XDTk2MDEwMTAwMDAwMFoXDTIxMDEwMTIzNTk1OVowgdExCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEaMBgGA1UEChMRVGhhd3RlIENvbnN1bHRpbmcxKDAmBgNVBAsTH0NlcnRpZmljYXRpb24gU2VydmljZXMgRGl2aXNpb24xJDAiBgNVBAMTG1RoYXd0ZSBQZXJzb25hbCBGcmVlbWFpbCBDQTErMCkGCSqGSIb3DQEJARYccGVyc29uYWwtZnJlZW1haWxAdGhhd3RlLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA1GnX1LCUZFtx6UfYDFG26nKRsIRefS0Nj3sS34UldSh0OkIsYyeflXtL734Zhx2G6qPduc6WZBrCFG5ErHzmj+hND3EfQDimAKOHePb5lIZererAXnbr2RSjXW56fAylS1V/Bhkpf56aJtVquzgkCGqYx7Hao5iR/Xnb5VrEHLkCAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOBgQAemGDU5fJUYLA9GoFkR/dbo9lvwykLp9KpgUn2w22FFChFRAH0cVyVLhQPGivRqWvBX2c9FvFyIK++FsoOMF/Jy6WTLMNnVB5yIoojdmyUHVFSbJ3E4EcC18y/8IB7GG4l3GJh1qb+wR1/2bP9jVxFEFrGZWSa6yz1A0/WSGL7Lg==");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getThawtePPRRootSelfSignedCert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIDODCCAqGgAwIBAgIQQAWyU6AaRkNQCYGPEhB27DANBgkqhkiG9w0BAQUFADCBzzELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYDVQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEjMCEGA1UEAxMaVGhhd3RlIFBlcnNvbmFsIFByZW1pdW0gQ0ExKjAoBgkqhkiG9w0BCQEWG3BlcnNvbmFsLXByZW1pdW1AdGhhd3RlLmNvbTAeFw05NjAxMDEwMDAwMDBaFw0yMTAxMDEyMzU5NTlaMIHPMQswCQYDVQQGEwJaQTEVMBMGA1UECBMMV2VzdGVybiBDYXBlMRIwEAYDVQQHEwlDYXBlIFRvd24xGjAYBgNVBAoTEVRoYXd0ZSBDb25zdWx0aW5nMSgwJgYDVQQLEx9DZXJ0aWZpY2F0aW9uIFNlcnZpY2VzIERpdmlzaW9uMSMwIQYDVQQDExpUaGF3dGUgUGVyc29uYWwgUHJlbWl1bSBDQTEqMCgGCSqGSIb3DQEJARYbcGVyc29uYWwtcHJlbWl1bUB0aGF3dGUuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJZtn4B0TPuYwu8KHvE0VsBd/eJxZRNkERbGw77f4QfRKe5ZtCmv5gMcNmt3M6SK5O0DI3lIi1DbbZ8/JE2dWIEt12TfIa/G8jHnrx2JhFTgcQ7xZC0EN1bUre4qrJMf8fAHB8Zs8QJQi6+u4A6UYDZicRFTuqW/KY3TZCstqIdQIDAQABoxMwETAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBALpkCujztDHJJ2+idqAtNnHHhsAIwk7t2pokGYf8WiOcck0I361cwzskgR1Xj7YSpSID7xK90S1elo8mJk9LG3w7oFIapag3hsRHKsrdQfho9cITQSma8AyozaH8FSMC23or1GJRQkfEox/00sVNVBDr2vDMp083DL08yxDjGugV");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getVeriSignClass1PublicPrimaryCAG3Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 26, 48, -126, 3, 2, 2, 17, 0, -117, 91, 117, 86, -124, 84, -123, 11, 0, -49, -81, 56, 72, -50, -79, -92, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, 30, 23, 13, 57, 57, 49, 48, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -35, -124, -44, -71, -76, -7, -89, -40, -13, 4, 120, -100, -34, 61, -36, 108, 19, 22, -39, 122, -35, 36, 81, 102, -64, -57, 38, 89, 13, -84, 6, 8, -62, -108, -47, 51, 31, -16, -125, 53, 31, 110, 27, -56, -34, -86, 110, 21, 78, 84, 39, -17, -60, 109, 26, -20, 11, -29, 14, -16, 68, -91, 87, -57, 64, 88, 30, -93, 71, 31, 113, -20, 96, -10, 109, -108, -56, 24, 57, -19, -2, 66, 24, 86, -33, -28, 76, 73, 16, 120, 78, 1, 118, 53, 99, 18, 54, -35, 102, -68, 1, 4, 54, -93, 85, 104, -43, -94, 54, 9, -84, -85, 33, 38, 84, 6, -83, 63, -54, 20, -32, -84, -54, -83, 6, 29, -107, -30, -8, -99, -15, -32, 96, -1, -62, 127, 117, 43, 76, -52, -38, -2, -121, -103, 33, -22, -70, -2, 62, 84, -41, -46, 89, 120, -37, 60, 110, -49, -96, 19, 0, 26, -72, 39, -95, -28, -66, 103, -106, -54, -96, -59, -77, -100, -35, -55, 117, -98, -21, 48, -102, 95, -93, -51, -39, -82, 120, 25, 63, 35, -23, 92, -37, 41, -67, -83, 85, -56, 27, 84, -116, 99, -10, -24, -90, -22, -57, 55, 18, 92, -93, 41, 30, 2, -39, -37, 31, 59, -76, -41, 15, 86, 71, -127, 21, 4, 74, -81, -125, 39, -47, -59, 88, -120, -63, -35, -10, -86, -89, -93, 24, -38, 104, -86, 109, 17, 81, -31, -65, 101, 107, -97, -106, 118, -47, 61, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -85, 102, -115, -41, -77, -70, -57, -102, -74, -26, 85, -48, 5, -15, -97, 49, -115, 90, -86, -39, -86, 70, 38, 15, 113, -19, -91, -83, 83, 86, 98, 1, 71, 42, 68, -23, -2, 63, 116, 11, 19, -101, -71, -12, 77, 27, -78, -47, 95, -78, -74, -46, -120, 92, -77, -97, -51, -53, -44, -89, -39, 96, -107, -124, 58, -8, -63, 55, 29, 97, -54, -25, -80, -59, -27, -111, -38, 84, -90, -84, 49, -127, -82, -105, -34, -51, 8, -84, -72, -64, -105, -128, 127, 110, 114, -92, -25, 105, 19, -107, 101, 31, -60, -109, 60, -3, 121, -113, 4, -44, 62, 79, -22, -9, -98, -50, -51, 103, 124, 79, 101, 2, -1, -111, -123, 84, 115, -57, -1, 54, -9, -122, 45, -20, -48, 94, 79, -1, 17, -97, 114, 6, -42, -72, 26, -15, 76, 13, 38, 101, -30, 68, -128, 30, -57, -97, -29, -35, -24, 10, -38, -20, -91, 32, -128, 105, 104, -95, 79, 126, -31, 107, -49, 7, 65, -6, -125, -114, -68, 56, -35, -80, 46, 17, -79, 107, -78, 66, -52, -102, -68, -7, 72, 34, 121, 74, 25, 15, -78, 28, 62, 32, 116, -39, 106, -61, -66, -14, 40, 120, 19, 86, 121, 79, 109, 80, -22, 27, -80, -75, 87, -79, 55, 102, 88, 35, -13, -36, 15, -33, 10, -121, -60, -17, -122, 5, -43, 56, 20, 96, -103, -93, 75, -34, 6, -106, 113, 44, -14, -37, -74, 31, -92, -17, 63, -18};
        return byArray;
    }

    private static byte[] getVeriSignClass2PublicPrimaryCAG3Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 25, 48, -126, 3, 1, 2, 16, 97, 112, -53, 73, -116, 95, -104, 69, 41, -25, -80, -90, -39, 80, 91, 122, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, 30, 23, 13, 57, 57, 49, 48, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -81, 10, 13, -62, -43, 44, -37, 103, -71, 45, -27, -108, 39, -35, -91, -66, -32, -80, 77, -113, -77, 97, 86, 60, -42, 124, -61, -12, -51, 62, -122, -53, -94, -120, -30, -31, -40, -92, 105, -59, -75, -30, -65, -63, -90, 71, 80, 94, 70, 57, -117, -43, -106, -70, -75, 111, 20, -65, 16, -50, 39, 19, -98, 5, 71, -101, 49, 122, 19, -40, 31, -39, -45, 2, 55, -117, -83, 44, 71, -16, -114, -127, 6, -89, 13, 48, 12, -21, -9, 60, 15, 32, 29, -36, 114, 70, -18, -91, 2, -56, 91, -61, -55, 86, 105, 76, -59, 24, -63, -111, 123, 11, -43, 19, 0, -101, -68, -17, -61, 72, 62, 70, 96, 32, -123, 42, -43, -112, -74, -51, -117, -96, -52, 50, -35, -73, -3, 64, 85, -78, 80, 28, 86, -82, -52, -115, 119, 77, -57, 32, 77, -89, 49, 118, -17, 104, -110, -118, -112, 30, 8, -127, 86, -78, -83, 105, -93, 82, -48, -53, 28, -60, 35, 61, 31, -103, -2, 76, -24, 22, 99, -114, -58, 8, -114, -10, 49, -10, -46, -6, -27, 118, -35, -75, 28, -110, -93, 73, -51, -51, 1, -51, 104, -51, -87, 105, -70, -93, -21, 29, 13, -100, -92, 32, -90, -63, -96, -59, -47, 70, 76, 23, 109, -46, -84, 102, 63, -106, -116, -32, -124, -44, 54, -1, 34, 89, -59, -7, 17, 96, -88, 95, 4, 125, -14, 26, -10, 37, 66, 97, 15, -60, 74, -72, 62, -119, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 52, 38, 21, 60, -64, -115, 77, 67, 73, 29, -67, -23, 33, -110, -41, 102, -100, -73, -34, -59, -72, -48, -28, 93, 95, 118, 34, -64, 38, -7, -124, 58, 58, -7, -116, -75, -5, -20, 96, -15, -24, -50, 4, -80, -56, -35, -89, 3, -113, 48, -13, -104, -33, -92, -26, -92, 49, -33, -45, 28, 11, 70, -36, 114, 32, 63, -82, -18, 5, 60, -92, 51, 63, 11, 57, -84, 112, 120, 115, 75, -103, 43, -33, 48, -62, 84, -80, -88, 59, 85, -95, -2, 22, 40, -51, 66, -67, 116, 110, -128, -37, 39, 68, -89, -50, 68, 93, -44, 27, -112, -104, 13, 30, 66, -108, -79, 0, 44, 4, -48, 116, -93, 2, 5, 34, 99, 99, -51, -125, -75, -5, -63, 109, 98, 107, 105, 117, -3, 93, 112, 65, -71, -11, -65, 124, -33, -66, -63, 50, 115, 34, 33, -117, 88, -127, 123, 21, -111, 122, -70, -29, 100, 72, -80, 127, -5, 54, 37, -38, -107, -48, -15, 36, 20, 23, -35, 24, -128, 107, 70, 35, 57, 84, -11, -114, 98, 9, 4, 29, -108, -112, -90, -101, -26, 37, -30, 66, 69, -86, -72, -112, -83, -66, 8, -113, -87, 11, 66, 24, -108, -49, 114, 57, -31, -79, 67, -32, 40, -49, -73, -25, 90, 108, 19, 107, 73, -77, -1, -29, 24, 124, -119, -117, 51, 93, -84, 51, -41, -89, -7, -38, 58, 85, -55, 88, 16, -7, -86, -17, 90, -74, -49, 75, 75, -33, 42};
        return byArray;
    }

    private static byte[] getVeriSignClass3PublicPrimaryCAG3Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 26, 48, -126, 3, 2, 2, 17, 0, -101, 126, 6, 73, -93, 62, 98, -71, -43, -18, -112, 72, 113, 41, -17, 87, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, 30, 23, 13, 57, 57, 49, 48, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -53, -70, -100, 82, -4, 120, 31, 26, 30, 111, 27, 55, 115, -67, -8, -55, 107, -108, 18, 48, 79, -16, 54, 71, -11, -48, -111, 10, -11, 23, -56, -91, 97, -63, 22, 64, 77, -5, -118, 97, -112, -27, 118, 32, -63, 17, 6, 125, -85, 44, 110, -90, -11, 17, 65, -114, -6, 45, -83, 42, 97, 89, -92, 103, 38, 76, -48, -24, -68, 82, 91, 112, 32, 4, 88, -47, 122, -55, -92, 105, -68, -125, 23, 100, -83, 5, -117, -68, -48, 88, -50, -115, -116, -11, -21, -16, 66, 73, 11, -99, -105, 39, 103, 50, 110, -31, -82, -109, 21, 28, 112, -68, 32, 77, 47, 24, -34, -110, -120, -24, 108, -123, 87, 17, 26, -23, 126, -29, 38, 17, 84, -94, 69, -106, 85, -125, -54, 48, -119, -24, -36, -40, -93, -19, 42, -128, 63, 127, 121, 101, 87, 62, 21, 32, 102, 8, 47, -107, -109, -65, -86, 71, 47, -88, 70, -105, -16, 18, -30, -2, -62, 10, 43, 81, -26, 118, -26, -73, 70, -73, -30, 13, -90, -52, -88, -61, 76, 89, 85, -119, -26, -24, 83, 92, 28, -22, -99, -16, 98, 22, 11, -89, -55, 95, 12, -16, -34, -62, 118, -50, -81, -9, 106, -14, -6, 65, -90, -94, 51, 20, -55, -27, 122, 99, -45, -98, 98, 55, -43, -123, 101, -98, 14, -26, 83, 36, 116, 27, 94, 29, 18, 83, 91, -57, 44, -25, -125, 73, 59, 21, -82, -118, 104, -71, 87, -105, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 17, 20, -106, -63, -85, -110, 8, -9, 63, 47, -55, -78, -2, -28, 90, -97, 100, -34, -37, 33, 79, -122, -103, 52, 118, 54, 87, -35, -48, 21, 47, -59, -83, 127, 21, 31, 55, 98, 115, 62, -44, -25, 95, -50, 23, 3, -37, 53, -6, 43, -37, -82, 96, 9, 95, 30, 95, -113, 110, -69, 11, 61, -22, 90, 19, 30, 12, 96, 111, -75, -64, -75, 35, 34, 46, 7, 11, -53, -87, 116, -53, 71, -69, 29, -63, -41, -91, 107, -52, 47, -46, 66, -3, 73, -35, -89, -119, -49, 83, -70, -38, 0, 90, 40, -65, -126, -33, -8, -70, 19, 29, 80, -122, -126, -3, -114, 48, -113, 41, 70, -80, 30, 61, 53, -38, 56, 98, 22, 24, 74, -83, -26, -74, 81, 108, -34, -81, 98, -21, 1, -48, 30, 36, -2, 122, -113, 18, 26, 18, 104, -72, -5, 102, -103, 20, 20, 69, 92, -82, -25, -82, 105, 23, -127, 43, 90, 55, -55, 94, 42, -12, -58, -30, -95, 92, 84, -101, -90, 84, 0, -49, -16, -15, -63, -57, -104, 48, 26, 59, 54, 22, -37, -93, 110, -22, -3, -83, -78, -62, -38, -17, 2, 71, 19, -118, -64, -15, -77, 49, -83, 79, 28, -31, 79, -100, -81, 15, 12, -99, -9, 120, 13, -40, -12, 53, 86, -128, -38, -73, 109, 23, -113, -99, 30, -127, 100, -31, -2, -59, 69, -70, -83, 107, -71, 10, 122, 78, 79, 75, -124, -18, 75, -15, 125, -35, 17};
        return byArray;
    }

    private static byte[] getVeriSignClass3PublicPrimaryCAG5Cert() {
        byte[] byArray = new byte[]{48, -126, 4, -45, 48, -126, 3, -69, -96, 3, 2, 1, 2, 2, 16, 24, -38, -47, -98, 38, 125, -24, -69, 74, 33, 88, -51, -52, 107, 59, 74, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 50, 48, 48, 54, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 53, 48, 30, 23, 13, 48, 54, 49, 49, 48, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 50, 48, 48, 54, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 53, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -81, 36, 8, 8, 41, 122, 53, -98, 96, 12, -86, -25, 75, 59, 78, -36, 124, -68, 60, 69, 28, -69, 43, -32, -2, 41, 2, -7, 87, 8, -93, 100, -123, 21, 39, -11, -15, -83, -56, 49, -119, 93, 34, -24, 42, -86, -90, 66, -77, -113, -8, -71, 85, -73, -79, -73, 75, -77, -2, -113, 126, 7, 87, -20, -17, 67, -37, 102, 98, 21, 97, -49, 96, 13, -92, -40, -34, -8, -32, -61, 98, 8, 61, 84, 19, -21, 73, -54, 89, 84, -123, 38, -27, 43, -113, 27, -97, -21, -11, -95, -111, -62, 51, 73, -40, 67, 99, 106, 82, 75, -46, -113, -24, 112, 81, 77, -47, -119, 105, 123, -57, 112, -10, -77, -36, 18, 116, -37, 123, 93, 75, 86, -45, -106, -65, 21, 119, -95, -80, -12, -94, 37, -14, -81, 28, -110, 103, 24, -27, -12, 6, 4, -17, -112, -71, -28, 0, -28, -35, 58, -75, 25, -1, 2, -70, -12, 60, -18, -32, -117, -21, 55, -117, -20, -12, -41, -84, -14, -10, -16, 61, -81, -35, 117, -111, 51, 25, 29, 28, 64, -53, 116, 36, 25, 33, -109, -39, 20, -2, -84, 42, 82, -57, -113, -43, 4, 73, -28, -115, 99, 71, -120, 60, 105, -125, -53, -2, 71, -67, 43, 126, 79, -59, -107, -82, 14, -99, -44, -47, 67, -64, 103, 115, -29, 20, 8, 126, -27, 63, -97, 115, -72, 51, 10, -49, 93, 63, 52, -121, -106, -118, -18, 83, -24, 37, 21, 2, 3, 1, 0, 1, -93, -127, -78, 48, -127, -81, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 109, 6, 8, 43, 6, 1, 5, 5, 7, 1, 12, 4, 97, 48, 95, -95, 93, -96, 91, 48, 89, 48, 87, 48, 85, 22, 9, 105, 109, 97, 103, 101, 47, 103, 105, 102, 48, 33, 48, 31, 48, 7, 6, 5, 43, 14, 3, 2, 26, 4, 20, -113, -27, -45, 26, -122, -84, -115, -114, 107, -61, -49, -128, 106, -44, 72, 24, 44, 123, 25, 46, 48, 37, 22, 35, 104, 116, 116, 112, 58, 47, 47, 108, 111, 103, 111, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 118, 115, 108, 111, 103, 111, 46, 103, 105, 102, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 127, -45, 101, -89, -62, -35, -20, -69, -16, 48, 9, -13, 67, 57, -6, 2, -81, 51, 49, 51, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -109, 36, 74, 48, 95, 98, -49, -40, 26, -104, 47, 61, -22, -36, -103, 45, -67, 119, -10, -91, 121, 34, 56, -20, -60, -89, -96, 120, 18, -83, 98, 14, 69, 112, 100, -59, -25, -105, 102, 45, -104, 9, 126, 95, -81, -42, -52, 40, 101, -14, 1, -86, 8, 26, 71, -34, -7, -7, 124, -110, 90, 8, 105, 32, 13, -39, 62, 109, 110, 60, 13, 110, -40, -26, 6, -111, 64, 24, -71, -8, -63, -19, -33, -37, 65, -86, -32, -106, 32, -55, -51, 100, 21, 56, -127, -55, -108, -18, -94, -124, 41, 11, 19, 111, -114, -37, 12, -35, 37, 2, -37, -92, -117, 25, 68, -46, 65, 122, 5, 105, 74, 88, 79, 96, -54, 126, -126, 106, 11, 2, -86, 37, 23, 57, -75, -37, 127, -25, -124, 101, 42, -107, -118, -67, -122, -34, 94, -127, 22, -125, 45, 16, -52, -34, -3, -88, -126, 42, 109, 40, 31, 13, 11, -60, -27, -25, 26, 38, 25, -31, -12, 17, 111, 16, -75, -107, -4, -25, 66, 5, 50, -37, -50, -99, 81, 94, 40, -74, -98, -123, -45, 91, -17, -91, 125, 69, 64, 114, -114, -73, 14, 107, 14, 6, -5, 51, 53, 72, 113, -72, -99, 39, -117, -60, 101, 95, 13, -122, 118, -100, 68, 122, -10, -107, 92, -10, 93, 50, 8, 51, -92, 84, -74, 24, 63, 104, 92, -14, 66, 74, -123, 56, 84, -125, 95, -47, -24, 44, -14, -84, 17, -42, -88, -19, 99, 106};
        return byArray;
    }

    private static byte[] getVeriSignClass4PublicPrimaryCAG3Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 26, 48, -126, 3, 2, 2, 17, 0, -20, -96, -89, -117, 110, 117, 106, 1, -49, -60, 124, -52, 47, -108, 94, -41, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 52, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, 30, 23, 13, 57, 57, 49, 48, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 52, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -83, -53, -91, 17, 105, -58, 89, -85, -15, -113, -75, 25, 15, 86, -50, -52, -75, 31, 32, -28, -98, 38, 37, 75, -32, 115, 101, -119, 89, -34, -48, -125, -28, -11, 15, -75, -69, -83, -15, 124, -24, 33, -4, -28, -24, 12, -18, 124, 69, 34, 25, 118, -110, -76, 19, -73, 32, 91, 9, -6, 97, -82, -88, -14, -91, -115, -123, -62, 42, -42, -34, 102, 54, -46, -101, 2, -12, -88, -110, 96, 124, -100, 105, -76, -113, 36, 30, -48, -122, 82, -10, 50, -100, 65, 88, 30, 34, -67, -51, 69, 98, -107, 8, 110, -48, 102, -35, 83, -94, -52, -16, 16, -36, 84, 115, -117, 4, -95, 70, 51, 51, 92, 23, 64, -71, -98, 77, -45, -13, -66, 85, -125, -24, -79, -119, -114, 90, 124, -102, -106, 34, -112, 59, -120, 37, -14, -46, 83, -120, 2, 12, 11, 120, -14, -26, 55, 23, 75, 48, 70, 7, -28, -128, 109, -90, -40, -106, 46, -24, 44, -8, 17, -77, 56, 13, 102, -90, -101, -22, -55, 35, 91, -37, -114, -30, -13, 19, -114, 26, 89, 45, -86, 2, -16, -20, -92, -121, 102, -36, -63, 63, -11, -40, -71, -12, -20, -126, -58, -46, 61, -107, 29, -27, -64, 79, -124, -55, -39, -93, 68, 40, 6, 106, -41, 69, -84, -16, 107, 106, -17, 78, 95, -8, 17, -126, 30, 56, 99, 52, 102, 80, -44, 62, -109, 115, -6, 48, -61, 102, -83, -1, -109, 45, -105, -17, 3, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -113, -6, 37, 107, 79, 91, -28, -92, 78, 39, 85, -85, 34, 21, 89, 60, -54, -75, 10, -44, 74, -37, -85, -35, -95, 95, 83, -59, -96, 87, 57, -62, -50, 71, 43, -66, 58, -56, 86, -65, -62, -39, 39, 16, 58, -79, 5, 60, -64, 119, 49, -69, 58, -45, 5, 123, 109, -102, 28, 48, -116, -128, -53, -109, -109, 42, -125, -85, 5, 81, -126, 2, 0, 17, 103, 107, -13, -120, 97, 71, 95, 3, -109, -43, 91, 13, -32, -15, -44, -95, 50, 53, -123, -78, 58, -37, -80, -126, -85, -47, -53, 10, -68, 79, -116, 91, -59, 75, 0, 59, 31, 42, -126, -90, 126, 54, -123, -36, 126, 60, 103, 0, -75, -28, 59, 82, -32, -88, -21, 93, 21, -7, -58, 109, -16, -83, 29, 14, -123, -73, -87, -102, 115, 20, 90, 91, -113, 65, 40, -64, -43, -24, 45, 77, -92, 94, -51, -86, -39, -19, -50, -36, -40, -43, 60, 66, 29, 23, -63, 18, 93, 69, 56, -61, 56, -13, -4, -123, 46, -125, 70, 72, -78, -41, 32, 95, -110, 54, -113, -25, 121, 15, -104, 94, -103, -24, -16, -48, -92, -69, -11, 83, -67, 42, -50, 89, -80, -81, 110, 127, 108, -69, -46, 30, 0, -80, 33, -19, -8, 65, 98, -126, -71, -40, -78, -60, -69, 70, 80, -13, 49, -59, -113, 1, -88, 116, -21, -11, 120, 39, -38, -25, -9, 102, 67, -13, -98, -125, 62, 32, -86, -61, 53, 96, -111, -50};
        return byArray;
    }

    private static byte[] getVeriSignClass1PublicPrimaryCAG2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 2, 48, -126, 2, 107, 2, 16, 76, -57, -22, -86, -104, 62, 113, -45, -109, 16, -8, 61, 58, -119, -111, -110, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -86, -48, -70, -66, 22, 45, -72, -125, -44, -54, -46, 15, -68, 118, 49, -54, -108, -40, 29, -109, -116, 86, 2, -68, -39, 111, 26, 111, 82, 54, 110, 117, 86, 10, 85, -45, -33, 67, -121, 33, 17, 101, -118, 126, -113, -67, 33, -34, 107, 50, 63, 27, -124, 52, -107, 5, -99, 65, 53, -21, -110, -21, -106, -35, -86, 89, 63, 1, 83, 109, -103, 79, -19, -27, -30, 42, 90, -112, -63, -71, -60, -90, 21, -49, -56, 69, -21, -90, 93, -114, -100, 62, -16, 100, 36, 118, -91, -51, -85, 26, 111, -74, -40, 123, 81, 97, 110, -90, 127, -121, -56, -30, -73, -27, 52, -36, 65, -120, -22, 9, 64, -66, 115, -110, 61, 107, -25, 117, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -87, 79, -61, 13, -57, 103, -66, 44, -53, -39, -88, -51, 45, 117, -25, 126, 21, -98, 59, 114, -21, 126, -21, 92, 45, 9, -121, -42, 107, 109, 96, 124, -27, -82, -59, -112, 35, 12, 92, 74, -48, -81, -79, 93, -13, -57, -74, 10, -37, -32, 21, -109, 13, -35, 3, -68, -57, 118, -118, -75, -35, 79, -61, -101, 19, 117, -72, 1, -64, -26, -55, 91, 107, -91, -72, -119, -36, -84, -92, -35, 114, -19, 78, -95, -9, 79, -68, 6, -45, -22, -56, 100, 116, 123, -62, -107, 65, -100, 101, 115, 88, -15, -112, -102, 60, 106, -79, -104, -55, -60, -121, -68, -49, 69, 109, 69, -30, 110, 34, 63, -2, -68, 15, 49, 92, -24, -14, -39};
        return byArray;
    }

    private static byte[] getVeriSignClass2PublicPrimaryCAG2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 3, 48, -126, 2, 108, 2, 17, 0, -71, 47, 96, -52, -120, -97, -95, 122, 70, 9, -72, 91, 112, 108, -118, -81, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -89, -120, 1, 33, 116, 44, -25, 26, 3, -16, -104, -31, -105, 60, 15, 33, 8, -15, -100, -37, -105, -23, -102, -4, -62, 4, 6, 19, -66, 95, 82, -56, -52, 30, 44, 18, 86, 44, -72, 1, 105, 44, -52, -103, 31, -83, -80, -106, -82, 121, 4, -14, 19, 57, -63, 123, -104, -70, 8, 44, -24, -62, -124, 19, 44, -86, 105, -23, 9, -12, -57, -87, 2, -92, 66, -62, 35, 79, 74, -40, -16, 14, -94, -5, 49, 108, -55, -26, 111, -103, 39, 7, -11, -26, -12, 76, 120, -98, 109, -21, 70, -122, -6, -71, -122, -55, 84, -14, -78, -60, -81, -44, 70, 28, 90, -55, 21, 48, -1, 13, 108, -11, 45, 14, 109, -50, 127, 119, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, 114, 46, -7, 127, -47, -15, 113, -5, -60, -98, -10, -59, 94, 81, -118, 64, -104, -72, 104, -8, -101, 28, -125, -40, -30, -99, -67, -1, -19, -95, -26, 102, -22, 47, 9, -12, -54, -41, -22, -91, 43, -107, -10, 36, 96, -122, 77, 68, 46, -125, -91, -60, 45, -96, -45, -82, 120, 105, 111, 114, -38, 108, -82, 8, -16, 99, -110, 55, -26, -69, -60, 48, 23, -83, 119, -52, 73, 53, -86, -49, -40, -113, -47, -66, -73, 24, -106, 71, 115, 106, 84, 34, 52, 100, 45, -74, 22, -101, 89, 91, -76, 81, 89, 58, -77, 11, 20, -12, 18, -33, 103, -96, -12, -83, 50, 100, 94, -79, 70, 114, 39, -116, 18, 123, -59, 68, -76, -82};
        return byArray;
    }

    private static byte[] getVeriSignClass3PublicPrimaryCAG2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 2, 48, -126, 2, 107, 2, 16, 125, -39, -2, 7, -49, -88, 30, -73, 16, 121, 103, -5, -89, -119, 52, -58, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -52, 94, -47, 17, 93, 92, 105, -48, -85, -45, -71, 106, 76, -103, 31, 89, -104, 48, -114, 22, -123, 32, 70, 109, 71, 63, -44, -123, 32, -124, -31, 109, -77, -8, -92, -19, 12, -15, 23, 15, 59, -7, -89, -7, 37, -41, -63, -49, -124, 99, -14, 124, 99, -49, -94, 71, -14, -58, 91, 51, -114, 100, 64, 4, 104, -63, -128, -71, 100, 28, 69, 119, -57, -40, 110, -11, -107, 41, 60, 80, -24, 52, -41, 120, 31, -88, -70, 109, 67, -111, -107, -113, 69, 87, 94, 126, -59, -5, -54, -92, 4, -21, -22, -105, 55, 84, 48, 111, -69, 1, 71, 50, 51, -51, -36, 87, -101, 100, 105, 97, -8, -101, 29, 28, -119, 79, 92, 103, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, 81, 77, -51, -66, 92, -53, -104, 25, -100, 21, -78, 1, 57, 120, 46, 77, 15, 103, 112, 112, -103, -58, 16, 90, -108, -92, 83, 77, 84, 109, 43, -81, 13, 93, 64, -117, 100, -45, -41, -18, -34, 86, 97, -110, 95, -90, -60, 29, 16, 97, 54, -45, 44, 39, 60, -24, 41, 9, -71, 17, 100, 116, -52, -75, 115, -97, 28, 72, -87, -68, 97, 1, -18, -30, 23, -90, 12, -29, 64, 8, 59, 14, -25, -21, 68, 115, 42, -102, -15, 105, -110, -17, 113, 20, -61, 57, -84, 113, -89, -111, 9, 111, -28, 113, 6, -77, -70, 89, 87, 38, 121, 0, -10, -8, 13, -94, 51, 48, 40, -44, -86, 88, -96, -99, -99, 105, -111, -3};
        return byArray;
    }

    private static byte[] getVeriSignClass4PublicPrimaryCAG2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 2, 48, -126, 2, 107, 2, 16, 50, -120, -114, -102, -46, -11, -21, 19, 71, -8, 127, -60, 32, 55, 37, -8, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 52, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 52, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -70, -16, -28, -49, -7, -60, -82, -123, 84, -71, 7, 87, -7, -113, -59, 127, 104, 17, -8, -60, 23, -80, 68, -36, -29, 48, 115, -43, 42, 98, 42, -72, -48, -52, 28, -19, 40, 91, 126, -67, 106, -36, -77, -111, 36, -54, 65, 98, 60, -4, 2, 1, -65, 28, 22, 49, -108, 5, -105, 118, 110, -94, -83, -67, 97, 23, 108, 78, 48, -122, -16, 81, 55, 42, 80, -57, -88, 98, -127, -36, 91, 74, -86, -63, -96, -76, 110, -21, 47, -27, 87, -59, -79, 43, 64, 112, -37, 90, 77, -95, -114, 31, -67, 3, 31, -40, 3, -44, -113, 76, -103, 113, -68, -30, -126, -52, 88, -24, -104, 58, -122, -45, -122, 56, -13, 0, 41, 31, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -123, -116, 18, -63, -89, -71, 80, 21, 122, -53, 62, -84, -72, 67, -118, -36, -86, -35, 20, -70, -119, -127, 126, 1, 60, 35, 113, 33, -120, 47, -126, -36, 99, -6, 2, 69, -84, 69, 89, -41, 42, 88, 68, 91, -73, -97, -127, 59, -110, 104, 61, -30, 55, 36, -11, 123, 108, -113, 118, 53, -106, 9, -88, 89, -99, -71, -50, 35, -85, 116, -42, -125, -3, 50, 115, 39, -40, 105, 62, 67, 116, -10, -82, -59, -119, -102, -25, 83, 124, -23, 123, -10, 75, -13, -63, 101, -125, -34, -115, -118, -100, 60, -120, -115, 57, 89, -4, -86, 63, 34, -115, -95, -63, 102, 80, -127, 114, 76, -19, 34, 100, 79, 79, -54, -128, -111, -74, 41};
        return byArray;
    }

    private static byte[] getVeriSignClass1PublicPrimaryCACert() {
        byte[] byArray = new byte[]{48, -126, 2, 61, 48, -126, 1, -90, 2, 17, 0, -51, -70, 127, 86, -16, -33, -28, -68, 84, -2, 34, -84, -77, 114, -86, 85, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -27, 25, -65, 109, -93, 86, 97, 45, -103, 72, 113, -10, 103, -34, -71, -115, -21, -73, -98, -122, -128, 10, -111, 14, -6, 56, 37, -81, 70, -120, -126, -27, 115, -88, -96, -101, 36, 93, 13, 31, -52, 101, 110, 12, -80, -48, 86, -124, 24, -121, -102, 6, -101, 16, -95, 115, -33, -76, 88, 57, 107, 110, -63, -10, 21, -43, -88, -88, 63, -86, 18, 6, -115, 49, -84, 127, -80, 52, -41, -113, 52, 103, -120, 9, -51, 20, 17, -30, 78, 69, 86, 105, 31, 120, 2, -128, -38, -36, 71, -111, 41, -69, 54, -55, 99, 92, -59, -32, -41, 45, -121, 123, -95, -73, 50, -80, 123, 48, -70, 42, 47, 49, -86, -18, -93, 103, -38, -37, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, 76, 63, -72, -117, -58, 104, -33, -18, 67, 51, 14, 93, -23, -90, -53, 7, -124, 77, 122, 51, -1, -110, 27, -12, 54, -83, -40, -107, 34, 54, 104, 17, 108, 124, 66, -52, -13, -100, 46, -60, 7, 63, 20, -80, 15, 79, -1, -112, -110, 118, -7, -30, -68, 74, -23, -113, -51, -96, -128, 10, -9, -59, 41, -15, -126, 34, 93, -72, -79, -35, -127, 35, -93, 123, 37, 21, 70, 48, 121, 22, -8, -22, 5, 75, -108, 127, 29, -62, 28, -56, -29, -73, -12, 16, 64, 60, 19, -61, 95, 31, 83, -24, 72, -28, -122, -76, 123, -95, 53, -80, 123, 37, -70, -72, -45, -114, -85, 63, 56, -99, 0, 52, 0, -104, -13, -47, 113, -108};
        return byArray;
    }

    private static byte[] getVeriSignClass2PublicPrimaryCACert() {
        byte[] byArray = new byte[]{48, -126, 2, 60, 48, -126, 1, -91, 2, 16, 45, 27, -4, 74, 23, -115, -93, -111, -21, -25, -1, -11, -117, 69, -66, 11, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -74, 90, -117, -93, 13, 106, 35, -125, -128, 107, -49, 57, -121, -12, 33, 19, 51, 6, 76, 37, -94, -19, 85, 18, -105, -59, -89, -128, -71, -6, -125, -63, 32, -96, -6, 47, 21, 13, 124, -95, 96, 107, 126, 121, 44, -6, 6, 15, 58, -82, -10, 27, 111, -79, -46, -1, 47, 40, 82, 95, -125, 125, 75, -60, 122, -73, -8, 102, 31, -128, 84, -4, -73, -62, -114, 89, 74, 20, 87, 70, -47, -102, -109, -66, 65, -111, 3, -69, 21, -128, -109, 92, -21, -25, -52, 8, 108, 63, 62, -77, 74, -4, -1, 75, 108, 35, -43, 80, -126, 38, 68, 25, -114, 35, -61, 113, -22, 25, 36, 71, 4, -98, 117, -65, -56, -90, 0, 31, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, -118, 27, 43, -6, 57, -63, 116, -41, 94, -40, 25, 100, -94, 88, 74, 45, 55, -32, 51, 71, 15, -84, -19, -9, -86, -37, 30, -28, -117, 6, 92, 96, 39, -54, 69, 82, -50, 22, -17, 63, 6, 100, -25, -108, 104, 124, 96, 51, 21, 17, 105, -81, -99, 98, -115, -93, 3, 84, 107, -90, -66, -27, -18, 5, 24, 96, 4, -65, 66, -128, -3, -48, -88, -88, 30, 1, 59, -9, -93, 92, -81, -93, -36, -26, 38, -128, 35, 60, -72, 68, 116, -9, 10, -82, 73, -117, 97, 120, -52, 36, -65, -120, -118, -89, 14, -22, 115, 25, 65, -3, 77, 3, -16, -120, -47, -27, 120, -115, -91, 42, 79, -10, -105, 13, 23, 119, -54, -40};
        return byArray;
    }

    private static byte[] getVeriSignClass3PublicPrimaryCACert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIICPDCCAaUCEDyRMcsf9tAbDpq40ES/Er4wDQYJKoZIhvcNAQEFBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTI4MDgwMjIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhEBarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/isI19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0GCSqGSIb3DQEBBQUAA4GBABByUqkFFBkyCEHwxWsKzH4PIRnN5GfcX6kb5sroc50i2JhucwNhkcV8sEVAbkSdjbCxlnRhLQ2pRdKkkirWmnWXbj9T/UWZYB2oK0z5XqcJ2HUw19JlYD1n1khVdWk/kfVIC0dpImmClr7JyDiGSnoscxlIaU5rfGW/D/xwzoiQ");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getEntrustSecureServerCACert() {
        byte[] byArray = new byte[]{48, -126, 4, -40, 48, -126, 4, 65, -96, 3, 2, 1, 2, 2, 4, 55, 74, -46, 67, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -61, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 59, 48, 57, 6, 3, 85, 4, 11, 19, 50, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 58, 48, 56, 6, 3, 85, 4, 3, 19, 49, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 57, 48, 53, 50, 53, 49, 54, 48, 57, 52, 48, 90, 23, 13, 49, 57, 48, 53, 50, 53, 49, 54, 51, 57, 52, 48, 90, 48, -127, -61, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 59, 48, 57, 6, 3, 85, 4, 11, 19, 50, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 58, 48, 56, 6, 3, 85, 4, 3, 19, 49, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -99, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -117, 0, 48, -127, -121, 2, -127, -127, 0, -51, 40, -125, 52, 84, 27, -119, -13, 15, -81, 55, -111, 49, -1, -81, 49, 96, -55, -88, -24, -78, 16, 104, -19, -97, -25, -109, 54, -15, 10, 100, -69, 71, -11, 4, 23, 63, 35, 71, 77, -59, 39, 25, -127, 38, 12, 84, 114, 13, -120, 45, -39, 31, -102, 18, -97, -68, -77, 113, -45, -128, 25, 63, 71, 102, 123, -116, 53, 40, -46, -71, 10, -33, 36, -38, -100, -42, 80, 121, -127, 122, 90, -45, 55, -9, -62, 74, -40, 41, -110, 38, 100, -47, -28, -104, 108, 58, 0, -118, -11, 52, -101, 101, -8, -19, -29, 16, -1, -3, -72, 73, 88, -36, -96, -34, -126, 57, 107, -127, -79, 22, 25, 97, -71, 84, -74, -26, 67, 2, 1, 3, -93, -126, 1, -41, 48, -126, 1, -45, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, -126, 1, 25, 6, 3, 85, 29, 31, 4, -126, 1, 16, 48, -126, 1, 12, 48, -127, -34, -96, -127, -37, -96, -127, -40, -92, -127, -43, 48, -127, -46, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 59, 48, 57, 6, 3, 85, 4, 11, 19, 50, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 58, 48, 56, 6, 3, 85, 4, 3, 19, 49, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 49, 13, 48, 11, 6, 3, 85, 4, 3, 19, 4, 67, 82, 76, 49, 48, 41, -96, 39, -96, 37, -122, 35, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 82, 76, 47, 110, 101, 116, 49, 46, 99, 114, 108, 48, 43, 6, 3, 85, 29, 16, 4, 36, 48, 34, -128, 15, 49, 57, 57, 57, 48, 53, 50, 53, 49, 54, 48, 57, 52, 48, 90, -127, 15, 50, 48, 49, 57, 48, 53, 50, 53, 49, 54, 48, 57, 52, 48, 90, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, -16, 23, 98, 19, 85, 61, -77, -1, 10, 0, 107, -5, 80, -124, -105, -13, -19, 98, -48, 26, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -16, 23, 98, 19, 85, 61, -77, -1, 10, 0, 107, -5, 80, -124, -105, -13, -19, 98, -48, 26, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 25, 6, 9, 42, -122, 72, -122, -10, 125, 7, 65, 0, 4, 12, 48, 10, 27, 4, 86, 52, 46, 48, 3, 2, 4, -112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -112, -36, 48, 2, -6, 100, 116, -62, -89, 10, -91, 124, 33, -115, 52, 23, -88, -5, 71, 14, -1, 37, 124, -115, 19, 10, -5, -28, -104, -75, -17, -116, -8, -59, 16, 13, -9, -110, -66, -15, -61, -43, -43, -107, 106, 4, -69, 44, -50, 38, 54, 101, -56, 49, -58, -25, -18, 63, -29, 87, 117, -124, 122, 17, -17, 70, 79, 24, -12, -45, -104, -69, -88, -121, 50, -70, 114, -10, 60, -30, 61, -97, -41, 29, -39, -61, 96, 67, -116, 88, 14, 34, -106, 47, 98, -93, 44, 31, -70, -83, 5, -17, -85, 50, 120, -121, -96, 84, 115, 25, -75, 92, 5, -7, 82, 62, 109, 45, 69, 11, -9, 10, -109, -22, -19, 6, -7, -78};
        return byArray;
    }

    private static byte[] getEntrustCA2048Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 92, 48, -126, 3, 68, -96, 3, 2, 1, 2, 2, 4, 56, 99, -71, 102, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -76, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 64, 48, 62, 6, 3, 85, 4, 11, 20, 55, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 95, 50, 48, 52, 56, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 40, 50, 48, 52, 56, 41, 48, 30, 23, 13, 57, 57, 49, 50, 50, 52, 49, 55, 53, 48, 53, 49, 90, 23, 13, 49, 57, 49, 50, 50, 52, 49, 56, 50, 48, 53, 49, 90, 48, -127, -76, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 64, 48, 62, 6, 3, 85, 4, 11, 20, 55, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 95, 50, 48, 52, 56, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 40, 50, 48, 52, 56, 41, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -83, 77, 75, -87, 18, -122, -78, -22, -93, 32, 7, 21, 22, 100, 42, 43, 75, -47, -65, 11, 74, 77, -114, -19, -128, 118, -91, 103, -73, 120, 64, -64, 115, 66, -56, 104, -64, -37, 83, 43, -35, 94, -72, 118, -104, 53, -109, -117, 26, -99, 124, 19, 58, 14, 31, 91, -73, 30, -49, -27, 36, 20, 30, -79, -127, -87, -115, 125, -72, -52, 107, 75, 3, -15, 2, 12, -36, -85, -91, 64, 36, 0, 127, 116, -108, -95, -99, 8, 41, -77, -120, 11, -11, -121, 119, -99, 85, -51, -28, -61, 126, -41, 106, 100, -85, -123, 20, -122, -107, 91, -105, 50, 80, 111, 61, -56, -70, 102, 12, -29, -4, -67, -72, 73, -63, 118, -119, 73, 25, -3, -64, -88, -67, -119, -93, 103, 47, -58, -97, -68, 113, 25, 96, -72, 45, -23, 44, -55, -112, 118, 102, 123, -108, -30, -81, 120, -42, 101, 83, 93, 60, -42, -100, -78, -49, 41, 3, -7, 47, -92, 80, -78, -44, 72, -50, 5, 50, 85, -118, -3, -78, 100, 76, 14, -28, -104, 7, 117, -37, 127, -33, -71, 8, 85, 96, -123, 48, 41, -7, 123, 72, -92, 105, -122, -29, 53, 63, 30, -122, 93, 122, 122, 21, -67, -17, 0, -114, 21, 34, 84, 23, 0, -112, 38, -109, -68, 14, 73, 104, -111, -65, -8, 71, -45, -99, -107, 66, -63, 14, 77, -33, 111, 38, -49, -61, 24, 33, 98, 102, 67, 112, -42, -43, -64, 7, -31, 2, 3, 1, 0, 1, -93, 116, 48, 114, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 85, -28, -127, -47, 17, -128, -66, -40, -119, -71, 8, -93, 49, -7, -95, 36, 9, 22, -71, 112, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 85, -28, -127, -47, 17, -128, -66, -40, -119, -71, 8, -93, 49, -7, -95, 36, 9, 22, -71, 112, 48, 29, 6, 9, 42, -122, 72, -122, -10, 125, 7, 65, 0, 4, 16, 48, 14, 27, 8, 86, 53, 46, 48, 58, 52, 46, 48, 3, 2, 4, -112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 89, 71, -84, 33, -124, -118, 23, -55, -100, -119, 83, 30, -70, -128, -123, 26, -58, 60, 78, 62, -79, -100, -74, 124, -58, -110, 93, 24, 100, 2, -29, -45, 6, 8, 17, 97, 124, 99, -29, 43, -99, 49, 3, 112, 118, -46, -93, 40, -96, -12, -69, -102, 99, 115, -19, 109, -27, 42, -37, -19, 20, -87, 43, -58, 54, 17, -48, 43, -21, 7, -117, -91, -38, -98, 92, 25, -99, 86, 18, -11, 84, 41, -56, 5, -19, -78, 18, 42, -115, -12, 3, 27, -1, -25, -110, 16, -121, -80, 58, -75, -61, -99, 5, 55, 18, -93, -57, -12, 21, -71, -43, -92, 57, 22, -101, 83, 58, 35, -111, -15, -88, -126, -94, 106, -120, 104, -63, 121, 2, 34, -68, -86, -90, -42, -82, -33, -80, 20, 95, -72, -121, -48, -35, 124, 127, 123, -1, -81, 28, -49, -26, -37, 7, -83, 94, -37, -123, -99, -48, 43, 13, 51, -37, 4, -47, -26, 73, 64, 19, 43, 118, -5, 62, -23, -100, -119, 15, 21, -50, 24, -80, -123, 120, 33, 79, 107, 79, 14, -6, 54, 103, -51, 7, -14, -1, 8, -48, -30, -34, -39, -65, 42, -81, -72, -121, -122, 33, 60, 4, -54, -73, -108, 104, 127, -49, 60, -23, -104, -41, 56, -1, -20, -64, -39, 80, -16, 46, 75, 88, -82, 70, 111, -48, 46, -61, 96, -38, 114, 85, 114, -67, 76, 69, -98, 97, -70, -65, -124, -127, -110, 3, -47, -46, 105, 124, -59};
        return byArray;
    }

    private static byte[] getEntrustClientCACert() {
        byte[] byArray = new byte[]{48, -126, 4, -19, 48, -126, 4, 86, -96, 3, 2, 1, 2, 2, 4, 56, 3, -111, -18, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -55, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 72, 48, 70, 6, 3, 85, 4, 11, 20, 63, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 108, 105, 101, 110, 116, 95, 67, 65, 95, 73, 110, 102, 111, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 108, 105, 101, 110, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 57, 49, 48, 49, 50, 49, 57, 50, 52, 51, 48, 90, 23, 13, 49, 57, 49, 48, 49, 50, 49, 57, 53, 52, 51, 48, 90, 48, -127, -55, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 72, 48, 70, 6, 3, 85, 4, 11, 20, 63, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 108, 105, 101, 110, 116, 95, 67, 65, 95, 73, 110, 102, 111, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 108, 105, 101, 110, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -99, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -117, 0, 48, -127, -121, 2, -127, -127, 0, -56, 58, -103, 94, 49, 23, -33, -84, 39, 111, -112, 123, -28, 25, -1, 69, -93, 52, -62, -37, -63, -88, 79, -16, 104, -22, -124, -3, -97, 117, 121, -49, -63, -118, 81, -108, -81, -57, 87, 3, 71, 100, -98, -83, -126, 27, 90, -38, 127, 55, 120, 71, -69, 55, -104, 18, -106, -50, -58, 19, 125, -17, -46, 12, 48, 81, -87, 57, -98, 85, -8, -5, -79, -25, 48, -34, -125, -78, -70, 62, -15, -43, -119, 59, 59, -123, -70, -86, 116, 44, -2, 63, 49, 110, -81, -111, -107, 110, 6, -44, 7, 77, 75, 44, 86, 71, 24, 4, 82, -38, 14, 16, -109, -65, 99, -112, -101, -31, -33, -116, -26, 2, -92, -26, 79, 94, -9, -117, 2, 1, 3, -93, -126, 1, -32, 48, -126, 1, -36, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, -126, 1, 34, 6, 3, 85, 29, 31, 4, -126, 1, 25, 48, -126, 1, 21, 48, -127, -28, -96, -127, -31, -96, -127, -34, -92, -127, -37, 48, -127, -40, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 72, 48, 70, 6, 3, 85, 4, 11, 20, 63, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 108, 105, 101, 110, 116, 95, 67, 65, 95, 73, 110, 102, 111, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 108, 105, 101, 110, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 49, 13, 48, 11, 6, 3, 85, 4, 3, 19, 4, 67, 82, 76, 49, 48, 44, -96, 42, -96, 40, -122, 38, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 82, 76, 47, 67, 108, 105, 101, 110, 116, 49, 46, 99, 114, 108, 48, 43, 6, 3, 85, 29, 16, 4, 36, 48, 34, -128, 15, 49, 57, 57, 57, 49, 48, 49, 50, 49, 57, 50, 52, 51, 48, 90, -127, 15, 50, 48, 49, 57, 49, 48, 49, 50, 49, 57, 50, 52, 51, 48, 90, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, -60, -5, -100, 41, 123, -105, -51, 76, -106, -4, -18, 91, -77, -54, -103, 116, -117, -107, -22, 76, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -60, -5, -100, 41, 123, -105, -51, 76, -106, -4, -18, 91, -77, -54, -103, 116, -117, -107, -22, 76, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 25, 6, 9, 42, -122, 72, -122, -10, 125, 7, 65, 0, 4, 12, 48, 10, 27, 4, 86, 52, 46, 48, 3, 2, 4, -112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 63, -82, -118, -15, -41, 102, 3, 5, -98, 62, -6, -22, 28, 70, -69, -92, 91, -113, 120, -102, 18, 72, -103, -7, -12, 53, -34, 12, 54, 7, 2, 107, 16, 58, -119, 20, -127, -100, 49, -90, 124, -78, 65, -78, 106, -25, 7, 1, -95, 75, -7, -97, 37, 59, -106, -54, -103, -61, 62, -95, 81, 28, -13, -61, 46, 68, -9, -80, 103, 70, -86, -110, -27, 59, -38, 28, 25, 20, 56, 48, -43, -30, -94, 49, 37, 46, -15, -20, 69, 56, -19, -8, 6, 88, 3, 115, 98, -80, 16, 49, -113, 64, -65, 100, -32, 92, 62, -59, 79, 31, -38, 18, 67, -1, 76, -26, 6, 38, -88, -101, 25, -86, 68, 60, 118, -78, 92, -20};
        return byArray;
    }

    private static byte[] getEntrustGlobalClientCACert() {
        byte[] byArray = new byte[]{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};
        return byArray;
    }

    private static byte[] getEntrustGlobalSecureServerCACert() {
        byte[] byArray = new byte[]{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};
        return byArray;
    }

    private static byte[] getEntrustCA2048_29Cert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIEKjCCAxKgAwIBAgIEOGPe+DANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0yOTA3MjQxNDE1MTJaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQqK0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQesYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuXMlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVTXTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH4QIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUVeSB0RGAvtiJuQijMfmhJAkWuXAwDQYJKoZIhvcNAQEFBQADggEBADubj1abMOdTmXx6eadNl9cZlZD7Bh/KM3xGY4+WZiT6QBshJ8rmcnPyT/4xmf3IDExoU8aAghOY+rat2l098c5u9hURlIIM7j+VrxGrD9cv3h8Dj1csHsm7mhpElesYT6YfzX1XEC+bBAlahLVu2B064dae0Wx5XnkcFMXj0EyTO2U87d89vqbllRrDtRnDvV5bu/8j72gZyxKTJ1wDLW8w0B62GqzeWvfRqqgnpv55gcR5mTNXuhKwqeBCbJPKVt7+bYQLCIt+jerXmCHG8+c8eS9enNFMFY3h7CI3zJpDC5fcgJCNs2ebb0gIFVbPv/ErfF6adulZkMV8gzURZVE=");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getEntrustCAEC1Cert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIC+TCCAoCgAwIBAgINAKaLeSkAAAAAUNCR+TAKBggqhkjOPQQDAzCBvzELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwtdGVybXMxOTA3BgNVBAsTMChjKSAyMDEyIEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0aG9yaXplZCB1c2Ugb25seTEzMDEGA1UEAxMqRW50cnVzdCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRUMxMB4XDTEyMTIxODE1MjUzNloXDTM3MTIxODE1NTUzNlowgb8xCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1FbnRydXN0LCBJbmMuMSgwJgYDVQQLEx9TZWUgd3d3LmVudHJ1c3QubmV0L2xlZ2FsLXRlcm1zMTkwNwYDVQQLEzAoYykgMjAxMiBFbnRydXN0LCBJbmMuIC0gZm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxMzAxBgNVBAMTKkVudHJ1c3QgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEVDMTB2MBAGByqGSM49AgEGBSuBBAAiA2IABIQTydC6bUF74mzQ61VfZgIaJPRbiWlH47jCffHyAsWfoPZb1YsGGYZPUxBtByQnoaD41UcZYUx9ypMn6nQM72+WCf5j7HBdNq1nd67JnXxVRDqiY1Ef9eNi1KlHBz7MIKNCMEAwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFLdj5xrdjekIplWDpOBqUEFlEUJJMAoGCCqGSM49BAMDA2cAMGQCMGF52OVCR98crlOZF7ZvHH3hvxGU0QOIdeSNiaSKd0bebWHvAvX7td/M/k7//qnmpwIwW5nXhTcGtXsI/esni0qU+eH6p44mCOh8kmhtc9hvJqwhAriZtyZBWyVgrtBIGu4G");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getEntrustCAEVCert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIEkTCCA3mgAwIBAgIERWtQVDANBgkqhkiG9w0BAQUFADCBsDELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xOTA3BgNVBAsTMHd3dy5lbnRydXN0Lm5ldC9DUFMgaXMgaW5jb3Jwb3JhdGVkIGJ5IHJlZmVyZW5jZTEfMB0GA1UECxMWKGMpIDIwMDYgRW50cnVzdCwgSW5jLjEtMCsGA1UEAxMkRW50cnVzdCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA2MTEyNzIwMjM0MloXDTI2MTEyNzIwNTM0MlowgbAxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1FbnRydXN0LCBJbmMuMTkwNwYDVQQLEzB3d3cuZW50cnVzdC5uZXQvQ1BTIGlzIGluY29ycG9yYXRlZCBieSByZWZlcmVuY2UxHzAdBgNVBAsTFihjKSAyMDA2IEVudHJ1c3QsIEluYy4xLTArBgNVBAMTJEVudHJ1c3QgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALaVtkNC+sZtKm9I35RMOVcF7sN5EUFoNu3s/poBj6E4KPz3EEZmLk0eGrEaTsbRwJWIsMn/MYszA9u3g3s+IIRe7bJWKKf44LlAcTfFy0cOlypowCKVYhXbR9n10Cv/gkvJrT7eTNuQgFA/CYqEAOwwCj0Yzfv9KlmaI5UXLEWeH25DeW0MXJj+SKfFI0dcXv1u5x609mhF0YaDW6KKjbHjKYD+JXGIrb68j6xSlkuqUY3kEzEZ6E5Nn9uss2rVvDlUccp6en+Q3X0dgNmBu1kmwhH+5pPi94DkZfs0Nw4pgHBNrziGLp5/V6+eF67rHMsoIV+2HNjnogQi+dPa2MsCAwEAAaOBsDCBrTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zArBgNVHRAEJDAigA8yMDA2MTEyNzIwMjM0MlqBDzIwMjYxMTI3MjA1MzQyWjAfBgNVHSMEGDAWgBRokORnpKZTgMeGZqTx90tD+4S9bTAdBgNVHQ4EFgQUaJDkZ6SmU4DHhmak8fdLQ/uEvW0wHQYJKoZIhvZ9B0EABBAwDhsIVjcuMTo0LjADAgSQMA0GCSqGSIb3DQEBBQUAA4IBAQCT1DCw1wMgKtD5Y+iRDAUgqV8ZyntyTtSx29CW+1RaGSwMCPeyvIWonX9tO1KzKtvn1ISMY/YPyyYBkVBs9F8U4pN0wBOeMDpQ47RgxRzwIkSNcUesyBrJ6ZuaAGAT/3B+XxFNSRuzFVJ7yVTav52Vr2ua2J7p8eRDjeIRRDq/r72DQnNSi6q7pynP9WQcCk3RvKqsnyrQ/39/2n3qse0wJcGE2jTSW3iDVuycNsMm4hH2Z0kdkquM++v/eu6FSqdQgPCnXEqULl8FmTxSQeDNtGPPAUO6nIPcj2A781q0tHuu2guQOHXvgR1m0vdXcDazv/wor3ElhVsT/h5/WrQ8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getEntrustCAG2Cert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIEPjCCAyagAwIBAgIESlOMKDANBgkqhkiG9w0BAQsFADCBvjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwtdGVybXMxOTA3BgNVBAsTMChjKSAyMDA5IEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0aG9yaXplZCB1c2Ugb25seTEyMDAGA1UEAxMpRW50cnVzdCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzIwHhcNMDkwNzA3MTcyNTU0WhcNMzAxMjA3MTc1NTU0WjCBvjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwtdGVybXMxOTA3BgNVBAsTMChjKSAyMDA5IEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0aG9yaXplZCB1c2Ugb25seTEyMDAGA1UEAxMpRW50cnVzdCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC6hLZy254Ma+KZ6TABp3bqMriVQRrJ2mFOWHLP/vaCeb9zYQYKpSfYs1/TRU4cctZOMvJyig/3gxnQaoCAAEUesMfnmr8SVycco2gvCoe9amsOXmXzHHfV1IWNcCG0szLni6LVhjkCsbjSR87kyUnEO6fe+1R9V77w6G7CebI6C1XiUJgWMhNcL3hWwcKUs/Ja5CeanyTXxuzQmyWC48zCxEXFjJd6BmsqEZ+pCm5IO2/b1BEZQvePB7/1U1+cPvQXLOZprE4yTGJ36rfo5bs0vBmLrpxR57d+tVOxMyLlbc9wPBr64ptntoP0jaWvYkxN4FisZDQSA/i2jZRjJKRxAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBRqciZ60B7vfec7aVHUbI2fkBJmqzANBgkqhkiG9w0BAQsFAAOCAQEAeZ8dlsa2eT8ijYfThwMEYGprmi5ZiXMRrEPR9RP/jTkrwPK9T3CMqS/qF8QLVJ7UG5aYMzyorWKiAHarWWluBh1+xLlEjZivEtRh2woZRkfz6/djwUAFQKXSt/S1mja/qYh2iARVBCuch38aNzx+LaUa2NSJXsq9rD1s2G2v1fN2D807iDginWyTmsQ9v4IbZT+mD12q/OWyFcq1rca8PdCE6OoGcrBNOTJ4vz4RnAuknZoh8/CbCzB428Hch0P+vGOaysXCHMnHjf87ElgI5rY97HosTvuDls4MPGmHVHOkc8KT/1EQrBVUAdj8BbGJoX90g5pJ19xOe4pIb4tF9g==");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getDigiCertGlobalRootCACert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIDrzCCApegAwIBAgIQCDvgVpBCRrGhdWrJWZHHSjANBgkqhkiG9w0BAQUFADBhMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBDQTAeFw0wNjExMTAwMDAwMDBaFw0zMTExMTAwMDAwMDBaMGExCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4jvhEXLeqKTTo1eqUKKPC3eQyaKl7hLOllsBCSDMAZOnTjC3U/dDxGkAV53ijSLdhwZAAIEJzs4bg7/fzTtxRuLWZscFs3YnFo97nh6Vfe63SKMI2tavegw5BmV/Sl0fvBf4q77uKNd0f3p4mVmFaG5cIzJLv07A6Fpt43C/dxC//AH2hdmoRBBYMql1GNXRor5H4idq9Joz+EkIYIvUX7Q6hL+hqkpMfT7PT19sdl6gSzeRntwi5m3OFBqOasv+zbMUZBfHWymeMr/y7vrTC0LUq7dBMtoM1O/4gdW7jVg/tRvoSSiicNoxBN33shbyTApOB6jtSj1etX+jkMOvJwIDAQABo2MwYTAOBgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUA95QNVbRTLtm8KPiGxvDl7I90VUwHwYDVR0jBBgwFoAUA95QNVbRTLtm8KPiGxvDl7I90VUwDQYJKoZIhvcNAQEFBQADggEBAMucN6pIExIK+t1EnE9SsPTfrgT1eXkIoyQY/EsrhMAtudXH/vTBH1jLuG2cenTnmCmrEbXjcKChzUyImZOMkXDiqw8cvpOp/2PV5Adg06O/nVsJ8dWO41P0jmP6P6fbtGbfYmbW0W5BjfIttep3Sp+dWOIrWcBAI+0tKIJFPnlUkiaY4IBIqDfv8NZ5YBberOgOzW6sRBc4L0na4UU+Krk2U886UAb3LujEV0lsYSEY1QSteDwsOoBrp+uvFRTp2InBuThs4pFsiv9kuXclVzDAGySj4dzp30d8tbQkCAUw7C29C79Fv1C5qfPrmAESrciIxpg0X40KPMbp1ZWVbd4=");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getDigiSha2SecureCACert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIElDCCA3ygAwIBAgIQAf2j627KdciIQ4tyS8+8kTANBgkqhkiG9w0BAQsFADBhMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBDQTAeFw0xMzAzMDgxMjAwMDBaFw0yMzAzMDgxMjAwMDBaME0xCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxJzAlBgNVBAMTHkRpZ2lDZXJ0IFNIQTIgU2VjdXJlIFNlcnZlciBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANyuWJBNwcQwFZA1W248ghX1LFy949v/cUP6ZCWA1O4Yok3wZtAKc24RmDYXZK83nf36QYSvx6+M/hpzTc8zl5CilodTgyu5pnVILR1WN3vaMTIa16yrBvSqXUu3R0bdKpPDkC55gIDvEwRqFDu1m5K+wgdlTvza/P96rtxcflUxDOg5B6TXvi/TC2rSsd9f/ld0Uzs1gN2ujkSYs58O09rg1/RrKatEp0tYhG2SS4HD2nOLEpdIkARFdRrdNzGXkujNVA075ME/OV4uuPNcfhCOhkEAjUVmR7ChZc6gqikJTvOX6+guqw9ypzAO+sf0/RR3w6RbKFfCs/mC/bdFWJsCAwEAAaOCAVowggFWMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMDQGCCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMHsGA1UdHwR0MHIwN6A1oDOGMWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEdsb2JhbFJvb3RDQS5jcmwwN6A1oDOGMWh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEdsb2JhbFJvb3RDQS5jcmwwPQYDVR0gBDYwNDAyBgRVHSAAMCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwHQYDVR0OBBYEFA+AYRyCMWHVLyjnjUY4tCzhxtniMB8GA1UdIwQYMBaAFAPeUDVW0Uy7ZvCj4hsbw5eyPdFVMA0GCSqGSIb3DQEBCwUAA4IBAQAjPt9L0jFCpbZ+QlwaRMxp0Wi0XUvgBCFsS+JtzLHgl4+mUwnNqipl5TlPHoOlblyYoiQm5vuh7ZPHLgLGTUq/sELfeNqzqPlt/yGFUzZgTHbO7Djc1lGA8MXW5dRNJ2Srm8c+cftIl7gzbckTB+6WohsYFfZcTEDts8Ls/3HB40f/1LkAtDdC2iDJ6m6K7hQGrn2iWZiIqBtvLfTyyRRfJs8sjX7tN8Cp1Tm5gr8ZDOo0rwAhaPitc+LJMto4JQtV05od8GiG7S5BNO98pVAdvzr508EIDObtHopYJeS4d60tbvVS3bR0j6tJLp07kzQoH3jOlOrHvdPJbRzeXDLz");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getIsrgRootX1CACert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIFazCCA1OgAwIBAgIRAIIQz7DSQONZRGPgu2OCiwAwDQYJKoZIhvcNAQELBQAwTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2VhcmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTUwNjA0MTEwNDM4WhcNMzUwNjA0MTEwNDM4WjBPMQswCQYDVQQGEwJVUzEpMCcGA1UEChMgSW50ZXJuZXQgU2VjdXJpdHkgUmVzZWFyY2ggR3JvdXAxFTATBgNVBAMTDElTUkcgUm9vdCBYMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK3oJHP0FDfzm54rVygch77ct984kIxuPOZXoHj3dcKi/vVqbvYATyjb3miGbESTtrFj/RQSa78f0uoxmyF+0TM8ukj13Xnfs7j/EvEhmkvBioZxaUpmZmyPfjxwv60pIgbz5MDmgK7iS4+3mX6UA5/TR5d8mUgjU+g4rk8Kb4Mu0UlXjIB0ttov0DiNewNwIRt18jA8+o+u3dpjq+sWT8KOEUt+zwvo/7V3LvSye0rgTBIlDHCNAymg4VMk7BPZ7hm/ELNKjD+Jo2FR3qyHB5T0Y3HsLuJvW5iB4YlcNHlsdu87kGJ55tukmi8mxdAQ4Q7e2RCOFvu396j3x+UCB5iPNgiV5+I3lg02dZ77DnKxHZu8A/lJBdiB3QW0KtZB6awBdpUKD9jf1b0SHzUvKBds0pjBqAlkd25HN7rOrFleaJ1/ctaJxQZBKT5ZPt0m9STJEadao0xAH0ahmbWnOlFuhjuefXKnEgV4We0+UXgVCwOPjdAvBbI+e0ocS3MFEvzG6uBQE3xDk3SzynTnjh8BCNAw1FtxNrQHusEwMFxIt4I7mKZ9YIqioymCzLq9gwQbooMDQaHWBfEbwrbwqHyGO0aoSCqI3Haadr8faqU9GY/rOPNk3sgrDQoo//fb4hVC1CLQJ13hef4Y53CIrU7m2Ys6xt0nUW7/vGT1M0NPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBR5tFnme7bl5AFzgAiIyBpY9umbbjANBgkqhkiG9w0BAQsFAAOCAgEAVR9YqbyyqFDQDLHYGmkgJykIrGF1XIpu+ILlaS/V9lZLubhzEFnTIZd+50xx+7LSYK05qAvqFyFWhfFQDlnrzuBZ6brJFe+GnY+EgPbk6ZGQ3BebYhtF8GaV0nxvwuo77x/Py9auJ/GpsMiu/X1+mvoiBOv/2X/qkSsisRcOj/KKNFtY2PwByVS5uCbMiogziUwthDyC3+6WVwW6LLv3xLfHTjuCvjHIInNzktHCgKQ5ORAzI4JMPJ+GslWYHb4phowim57iaztXOoJwTdwJx4nLCgdNbOhdjsnvzqvHu7UrTkXWStAmzOVyyghqpZXjFaH3pO3JLF+l+/+sKAIuvtd7u+Nxe5AW0wdeRlN8NwdCjNPElpzVmbUq4JUagEiuTDkHzsxHpFKVK7q4+63SM1N95R1NbdWhscdCb+ZAJzVcoyi3B43njTOQ5yOf+1CceWxG1bQVs5ZufpsMljq4Ui0/1lvh+wjChP4kqKOJ2qxq4RgqsahDYVvTH9w7jXbyLeiNdd8XM2w9U/t7y0Ff/9yi0GE44Za4rF2LN9d11TPAmRGunUHBcnWEvgJBQl9nJEiU0Zsnvgc/ubhPgXRR4Xq37Z0j4r7g1SgEEzwxA57demyPxgcYxn/eR44/KJ4EBs+lVDR3veyJm+kXQ99b21/+jh5Xos1AnX5iItreGCc=");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private static byte[] getLetsEncAuthCACert() {
        byte[] byArray = null;
        try {
            byArray = new BASE64Decoder().decodeBuffer("MIIFFjCCAv6gAwIBAgIRAJErCErPDBinU/bWLiWnX1owDQYJKoZIhvcNAQELBQAwTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2VhcmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMjAwOTA0MDAwMDAwWhcNMjUwOTE1MTYwMDAwWjAyMQswCQYDVQQGEwJVUzEWMBQGA1UEChMNTGV0J3MgRW5jcnlwdDELMAkGA1UEAxMCUjMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC7AhUozPaglNMPEuyNVZLD+ILxmaZ6QoinXSaqtSu5xUyxr45r+XXIo9cPR5QUVTVXjJ6oojkZ9YI8QqlObvU7wy7bjcCwXPNZOOftz2nwWgsbvsCUJCWH+jdxsxPnHKzhm+/b5DtFUkWWqcFTzjTIUu61ru2P3mBw4qVUq7ZtDpelQDRrK9O8ZutmNHz6a4uPVymZ+DAXXbpyb/uBxa3Shlg9F8fnCbvxK/eG3MHacV3URuPMrSXBiLxgZ3Vms/EY96Jc5lP/Ooi2R6X/ExjqmAl3P51T+c8B5fWmcBcUr2Ok/5mzk53cU6cG/kiFHaFpriV1uxPMUgP17VGhi9sVAgMBAAGjggEIMIIBBDAOBgNVHQ8BAf8EBAMCAYYwHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMBIGA1UdEwEB/wQIMAYBAf8CAQAwHQYDVR0OBBYEFBQusxe3WFbLrlAJQOYfr52LFMLGMB8GA1UdIwQYMBaAFHm0WeZ7tuXkAXOACIjIGlj26ZtuMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAoYWaHR0cDovL3gxLmkubGVuY3Iub3JnLzAnBgNVHR8EIDAeMBygGqAYhhZodHRwOi8veDEuYy5sZW5jci5vcmcvMCIGA1UdIAQbMBkwCAYGZ4EMAQIBMA0GCysGAQQBgt8TAQEBMA0GCSqGSIb3DQEBCwUAA4ICAQCFyk5HPqP3hUSFvNVneLKYY611TR6WPTNlclQtgaDqw+34IL9fzLdwALduO/ZelN7kIJ+m74uyA+eitRY8kc607TkC53wlikfmZW4/RvTZ8M6UK+5UzhK8jCdLuMGYL6KvzXGRSgi3yLgjewQtCPkIVz6D2QQzCkcheAmCJ8MqyJu5zlzyZMjAvnnAT45tRAxekrsu94sQ4egdRCnbWSDtY7kh+BImlJNXoB1lBMEKIq4QDUOXoRgffuDghje1WrG9ML+Hbisq/yFOGwXD9RiX8F6sw6W4avAuvDszue5L3sz85K+EC4Y/wFVDNvZo4TYXao6Z0f+lQKc0t8DQYzk1OXVu8rp2yJMC6alLbBfODALZvYH7n7do1AZls4I9d1P4jnkDrQoxB3UqQ9hVl3LEKQ73xF1OyK5GhDDX8oVfGKF5u+decIsH4YaTw7mP3GFxJSqv3+0lUFJoi5Lc5da149p90IdshCExroL1+7mryIkXPeFM5TgO9r0rvZaBFOvV2z0gp35Z0+L4WPlbuEjN/lxPFin+HlUjr8gRsI3qfJOQFy/9rKIJR0Y/8Omwt/8oTWgy1mdeHmmjk7j1nYsvC9JSQ6ZvMldlTTKB3zhThV1+XWYp6rjd5JW1zbVWEkLNxE7GJThEUG3szgBVGP7pSWTUTsqXnLRbwHOoq7hHwg==");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    static ByteSequence getDefaultCACertificateByteSequence(String string) {
        return (ByteSequence)DEFAULT_CACERTS.get(string);
    }

    public static Collection getCACertificates(String string) throws KeyManagerException {
        ArrayList<CertificateItem> arrayList = new ArrayList<CertificateItem>();
        if (FRIENDLY_LABEL_NAME_MAP.containsKey(string)) {
            string = (String)FRIENDLY_LABEL_NAME_MAP.get(string);
            arrayList.add(EntryFactory.newCertificateItem(string, CACertificates.getCACertificate(string)));
        } else if (!FRIENDLY_LABEL_NAME_MAP.containsValue(string)) {
            Collection collection = CACertificates.getGrouping(string);
            if (collection == null) {
                return null;
            }
            for (Pair pair : collection) {
                arrayList.add(EntryFactory.newCertificateItem((String)pair.getFirst(), CACertificates.getCACertificate((String)pair.getFirst())));
            }
        } else {
            arrayList.add(EntryFactory.newCertificateItem(string, CACertificates.getCACertificate(string)));
        }
        return arrayList;
    }

    public static Collection getDefaultCACertificates(String string) throws KeyManagerException {
        ArrayList<CertificateItem> arrayList = new ArrayList<CertificateItem>();
        if (DEFAULT_FRIENDLY_LABEL_NAME_MAP.containsKey(string)) {
            string = (String)DEFAULT_FRIENDLY_LABEL_NAME_MAP.get(string);
            arrayList.add(EntryFactory.newCertificateItem(string, CACertificates.getDefaultCACertificate(string)));
        } else if (!DEFAULT_FRIENDLY_LABEL_NAME_MAP.containsValue(string)) {
            Collection collection = CACertificates.getDefaultGrouping(string);
            if (collection == null) {
                return null;
            }
            for (Pair pair : collection) {
                arrayList.add(EntryFactory.newCertificateItem((String)pair.getFirst(), CACertificates.getDefaultCACertificate((String)pair.getFirst())));
            }
        } else {
            arrayList.add(EntryFactory.newCertificateItem(string, CACertificates.getDefaultCACertificate(string)));
        }
        return arrayList;
    }

    public static Collection getIBMCloudTrustCertificates(String string) throws KeyManagerException {
        ArrayList<CertificateItem> arrayList = new ArrayList<CertificateItem>();
        if (IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP.containsKey(string)) {
            string = (String)IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP.get(string);
            arrayList.add(EntryFactory.newCertificateItem(string, CACertificates.getIBMCloudTrustCertificate(string)));
        } else if (!IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP.containsValue(string)) {
            Collection collection = CACertificates.getIBMCloudTrustGrouping(string);
            if (collection == null) {
                return null;
            }
            for (Pair pair : collection) {
                arrayList.add(EntryFactory.newCertificateItem((String)pair.getFirst(), CACertificates.getIBMCloudTrustCertificate((String)pair.getFirst())));
            }
        } else {
            arrayList.add(EntryFactory.newCertificateItem(string, CACertificates.getIBMCloudTrustCertificate(string)));
        }
        return arrayList;
    }

    private static Collection getGrouping(String string) {
        for (Pair pair : CERTIFICATE_GROUPING.keySet()) {
            if (!((String)pair.getFirst()).equalsIgnoreCase(string) && !((String)pair.getSecond()).equalsIgnoreCase(string)) continue;
            return (Collection)CERTIFICATE_GROUPING.get(pair);
        }
        return null;
    }

    private static Collection getDefaultGrouping(String string) {
        for (Pair pair : DEFAULT_CERTIFICATE_GROUPING.keySet()) {
            if (!((String)pair.getFirst()).equalsIgnoreCase(string) && !((String)pair.getSecond()).equalsIgnoreCase(string)) continue;
            return (Collection)DEFAULT_CERTIFICATE_GROUPING.get(pair);
        }
        return null;
    }

    private static Collection getIBMCloudTrustGrouping(String string) {
        for (Pair pair : IBM_CLOUD_CERTIFICATE_GROUPING.keySet()) {
            if (!((String)pair.getFirst()).equalsIgnoreCase(string) && !((String)pair.getSecond()).equalsIgnoreCase(string)) continue;
            return (Collection)IBM_CLOUD_CERTIFICATE_GROUPING.get(pair);
        }
        return null;
    }

    private static X509Certificate getCACertificate(String string) {
        if (!FRIENDLY_LABEL_NAME_MAP.containsValue(string)) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            InputStream inputStream = ((ByteSequence)CACERTS.get(string)).getInputStream();
            return (X509Certificate)certificateFactory.generateCertificate(inputStream);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    private static X509Certificate getDefaultCACertificate(String string) {
        if (!DEFAULT_FRIENDLY_LABEL_NAME_MAP.containsValue(string)) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            InputStream inputStream = ((ByteSequence)DEFAULT_CACERTS.get(string)).getInputStream();
            return (X509Certificate)certificateFactory.generateCertificate(inputStream);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    private static X509Certificate getIBMCloudTrustCertificate(String string) {
        if (!IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP.containsValue(string)) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            InputStream inputStream = ((ByteSequence)IBM_CLOUD_CACERTS.get(string)).getInputStream();
            return (X509Certificate)certificateFactory.generateCertificate(inputStream);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public static KeymanTree getCertificateTree() {
        if (CERTIFICATE_TREE == null) {
            CERTIFICATE_TREE = new KeymanTree(KeymanTree.newNode(Messages.getString("Label.CACerts")));
            KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode = (KeymanTree$KeymanTreeNode)CERTIFICATE_TREE.getRoot();
            Set set = CERTIFICATE_GROUPING.keySet();
            for (Pair pair : set) {
                KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode2 = KeymanTree.newNode(CACertificates.extractLabel(pair, KeymanSettings.isCLI() ? 3 : 1), false);
                Collection collection = (Collection)CERTIFICATE_GROUPING.get(pair);
                for (Pair pair2 : collection) {
                    X509Certificate x509Certificate = CACertificates.getCACertificate((String)pair2.getFirst());
                    try {
                        x509Certificate.checkValidity();
                        keymanTree$KeymanTreeNode2.addChild(KeymanTree.newNode(CACertificates.extractLabel(pair2, KeymanSettings.isCLI() ? 3 : 1), false));
                    }
                    catch (Exception exception) {}
                }
                if (keymanTree$KeymanTreeNode2.getChildCount() <= 0) continue;
                keymanTree$KeymanTreeNode.addChild(keymanTree$KeymanTreeNode2);
            }
        }
        return CERTIFICATE_TREE;
    }

    public static KeymanTree getDefaultCertificateTree() {
        if (DEFAULT_CERTIFICATE_TREE == null) {
            DEFAULT_CERTIFICATE_TREE = new KeymanTree(KeymanTree.newNode(Messages.getString("Label.CACerts")));
            KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode = (KeymanTree$KeymanTreeNode)DEFAULT_CERTIFICATE_TREE.getRoot();
            Set set = DEFAULT_CERTIFICATE_GROUPING.keySet();
            for (Pair pair : set) {
                KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode2 = KeymanTree.newNode(CACertificates.extractLabel(pair, KeymanSettings.isCLI() ? 3 : 1), false);
                Collection collection = (Collection)DEFAULT_CERTIFICATE_GROUPING.get(pair);
                for (Pair pair2 : collection) {
                    X509Certificate x509Certificate = CACertificates.getDefaultCACertificate((String)pair2.getFirst());
                    try {
                        x509Certificate.checkValidity();
                        keymanTree$KeymanTreeNode2.addChild(KeymanTree.newNode(CACertificates.extractLabel(pair2, KeymanSettings.isCLI() ? 3 : 1), false));
                    }
                    catch (Exception exception) {}
                }
                if (keymanTree$KeymanTreeNode2.getChildCount() <= 0) continue;
                keymanTree$KeymanTreeNode.addChild(keymanTree$KeymanTreeNode2);
            }
        }
        return DEFAULT_CERTIFICATE_TREE;
    }

    public static KeymanTree getIBMCloudTrustCertificateTree() {
        if (IBM_CLOUD_CERTIFICATE_TREE == null) {
            IBM_CLOUD_CERTIFICATE_TREE = new KeymanTree(KeymanTree.newNode(Messages.getString("Label.CACerts")));
            KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode = (KeymanTree$KeymanTreeNode)IBM_CLOUD_CERTIFICATE_TREE.getRoot();
            Set set = IBM_CLOUD_CERTIFICATE_GROUPING.keySet();
            for (Pair pair : set) {
                KeymanTree$KeymanTreeNode keymanTree$KeymanTreeNode2 = KeymanTree.newNode(CACertificates.extractLabel(pair, KeymanSettings.isCLI() ? 3 : 1), false);
                Collection collection = (Collection)IBM_CLOUD_CERTIFICATE_GROUPING.get(pair);
                for (Pair pair2 : collection) {
                    X509Certificate x509Certificate = CACertificates.getIBMCloudTrustCertificate((String)pair2.getFirst());
                    try {
                        x509Certificate.checkValidity();
                        keymanTree$KeymanTreeNode2.addChild(KeymanTree.newNode(CACertificates.extractLabel(pair2, KeymanSettings.isCLI() ? 3 : 1), false));
                    }
                    catch (Exception exception) {}
                }
                if (keymanTree$KeymanTreeNode2.getChildCount() <= 0) continue;
                keymanTree$KeymanTreeNode.addChild(keymanTree$KeymanTreeNode2);
            }
        }
        return IBM_CLOUD_CERTIFICATE_TREE;
    }

    private static String extractLabel(Pair pair, int n) {
        switch (n) {
            case 1: {
                return (String)pair.getFirst();
            }
            case 2: {
                return (String)pair.getSecond();
            }
        }
        return (String)pair.getSecond() + " - " + (String)pair.getFirst();
    }

    public static Iterator getAliases() {
        return CACERTS.keySet().iterator();
    }

    static {
        DEFAULT_CACERTS.put(RSA_SECURE_SERVER_CA_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getRSASecureServerCASelfSignedCert()));
        DEFAULT_CACERTS.put(THAWTE_PRIMARY_ROOT_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getThawtePrimaryRootCert()));
        DEFAULT_CACERTS.put(THAWTE_PRIMARY_ROOT_CERT_G2_ECC_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getThawtePrimaryRootCertG2Ecc()));
        DEFAULT_CACERTS.put(THAWTE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getThawteRootSelfSignedCert()));
        DEFAULT_CACERTS.put(THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getThawteSPRRootSelfSignedCert()));
        DEFAULT_CACERTS.put(THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getThawtePBasicRootSelfSignedCert()));
        DEFAULT_CACERTS.put(THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getThawtePFreeRootSelfSignedCert()));
        DEFAULT_CACERTS.put(THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getThawtePPRRootSelfSignedCert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass1PublicPrimaryCAG3Cert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass2PublicPrimaryCAG3Cert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass3PublicPrimaryCAG3Cert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass4PublicPrimaryCAG3Cert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass1PublicPrimaryCAG2Cert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass2PublicPrimaryCAG2Cert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass3PublicPrimaryCAG2Cert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G5_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass3PublicPrimaryCAG5Cert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass4PublicPrimaryCAG2Cert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass1PublicPrimaryCACert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass2PublicPrimaryCACert()));
        DEFAULT_CACERTS.put(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getVeriSignClass3PublicPrimaryCACert()));
        DEFAULT_CACERTS.put(ENTRUST_SECURE_SERVER_CA_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getEntrustSecureServerCACert()));
        DEFAULT_CACERTS.put(ENTRUST_CA_2048_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getEntrustCA2048Cert()));
        DEFAULT_CACERTS.put(ENTRUST_CLIENT_CA_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getEntrustClientCACert()));
        DEFAULT_CACERTS.put(ENTRUST_GLOBAL_CLIENT_CA_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getEntrustGlobalClientCACert()));
        DEFAULT_CACERTS.put(ENTRUST_GLOBAL_SECURE_SERVER_CA_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getEntrustGlobalSecureServerCACert()));
        DEFAULT_CACERTS.put(ENTRUST_CA_2048_29_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getEntrustCA2048_29Cert()));
        DEFAULT_CACERTS.put(ENTRUST_CA_EC1_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getEntrustCAEC1Cert()));
        DEFAULT_CACERTS.put(ENTRUST_CA_EV_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getEntrustCAEVCert()));
        DEFAULT_CACERTS.put(ENTRUST_CA_G2_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getEntrustCAG2Cert()));
        IBM_CLOUD_CACERTS.put(DIGICERT_GLOBAL_ROOT_CA_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getDigiCertGlobalRootCACert()));
        IBM_CLOUD_CACERTS.put(DIGICERT_SHA2_SECURE_SERVER_CA_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getDigiSha2SecureCACert()));
        IBM_CLOUD_CACERTS.put(ISRG_ROOT_X1_CA_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getIsrgRootX1CACert()));
        IBM_CLOUD_CACERTS.put(LETS_ENC_AUTH_CA_CERT_LABEL_PAIR.getFirst(), ByteSequenceFactory.newByteSequence(CACertificates.getLetsEncAuthCACert()));
        CACERTS.putAll(DEFAULT_CACERTS);
        CACERTS.putAll(IBM_CLOUD_CACERTS);
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(RSA_SECURE_SERVER_CA_LABEL_PAIR.getSecond(), RSA_SECURE_SERVER_CA_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(THAWTE_PRIMARY_ROOT_CERT_LABEL_PAIR.getSecond(), THAWTE_PRIMARY_ROOT_CERT_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(THAWTE_PRIMARY_ROOT_CERT_G2_ECC_LABEL_PAIR.getSecond(), THAWTE_PRIMARY_ROOT_CERT_G2_ECC_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(THAWTE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getSecond(), THAWTE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getSecond(), THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getSecond(), THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getSecond(), THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getSecond(), THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getSecond(), VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getSecond(), VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getSecond(), VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G5_LABEL_PAIR.getSecond(), VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G5_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getSecond(), VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getSecond(), VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getSecond(), VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getSecond(), VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getSecond(), VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_LABEL_PAIR.getSecond(), VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_LABEL_PAIR.getSecond(), VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_LABEL_PAIR.getSecond(), VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(ENTRUST_SECURE_SERVER_CA_LABEL_PAIR.getSecond(), ENTRUST_SECURE_SERVER_CA_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(ENTRUST_CA_2048_LABEL_PAIR.getSecond(), ENTRUST_CA_2048_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(ENTRUST_CLIENT_CA_LABEL_PAIR.getSecond(), ENTRUST_CLIENT_CA_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(ENTRUST_GLOBAL_CLIENT_CA_LABEL_PAIR.getSecond(), ENTRUST_GLOBAL_CLIENT_CA_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(ENTRUST_GLOBAL_SECURE_SERVER_CA_LABEL_PAIR.getSecond(), ENTRUST_GLOBAL_SECURE_SERVER_CA_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(ENTRUST_CA_2048_29_LABEL_PAIR.getSecond(), ENTRUST_CA_2048_29_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(ENTRUST_CA_EC1_LABEL_PAIR.getSecond(), ENTRUST_CA_EC1_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(ENTRUST_CA_EV_LABEL_PAIR.getSecond(), ENTRUST_CA_EV_LABEL_PAIR.getFirst());
        DEFAULT_FRIENDLY_LABEL_NAME_MAP.put(ENTRUST_CA_G2_LABEL_PAIR.getSecond(), ENTRUST_CA_G2_LABEL_PAIR.getFirst());
        IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP.put(DIGICERT_GLOBAL_ROOT_CA_CERT_LABEL_PAIR.getSecond(), DIGICERT_GLOBAL_ROOT_CA_CERT_LABEL_PAIR.getFirst());
        IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP.put(DIGICERT_SHA2_SECURE_SERVER_CA_CERT_LABEL_PAIR.getSecond(), DIGICERT_SHA2_SECURE_SERVER_CA_CERT_LABEL_PAIR.getFirst());
        IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP.put(ISRG_ROOT_X1_CA_CERT_LABEL_PAIR.getSecond(), ISRG_ROOT_X1_CA_CERT_LABEL_PAIR.getFirst());
        IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP.put(LETS_ENC_AUTH_CA_CERT_LABEL_PAIR.getSecond(), LETS_ENC_AUTH_CA_CERT_LABEL_PAIR.getFirst());
        FRIENDLY_LABEL_NAME_MAP.putAll(DEFAULT_FRIENDLY_LABEL_NAME_MAP);
        FRIENDLY_LABEL_NAME_MAP.putAll(IBM_CLOUD_FRIENDLY_LABEL_NAME_MAP);
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        arrayList.add(ENTRUST_CA_2048_LABEL_PAIR);
        arrayList.add(ENTRUST_CLIENT_CA_LABEL_PAIR);
        arrayList.add(ENTRUST_GLOBAL_CLIENT_CA_LABEL_PAIR);
        arrayList.add(ENTRUST_GLOBAL_SECURE_SERVER_CA_LABEL_PAIR);
        arrayList.add(ENTRUST_SECURE_SERVER_CA_LABEL_PAIR);
        arrayList.add(ENTRUST_CA_2048_29_LABEL_PAIR);
        arrayList.add(ENTRUST_CA_EC1_LABEL_PAIR);
        arrayList.add(ENTRUST_CA_EV_LABEL_PAIR);
        arrayList.add(ENTRUST_CA_G2_LABEL_PAIR);
        DEFAULT_CERTIFICATE_GROUPING.put(ENTRUST_LABEL_PAIR, arrayList);
        arrayList = new ArrayList();
        arrayList.add(RSA_SECURE_SERVER_CA_LABEL_PAIR);
        DEFAULT_CERTIFICATE_GROUPING.put(RSA_LABEL_PAIR, arrayList);
        arrayList = new ArrayList();
        arrayList.add(THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL_PAIR);
        arrayList.add(THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR);
        arrayList.add(THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR);
        arrayList.add(THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL_PAIR);
        arrayList.add(THAWTE_ROOT_SELF_SIGNED_CERT_LABEL_PAIR);
        arrayList.add(THAWTE_PRIMARY_ROOT_CERT_G2_ECC_LABEL_PAIR);
        arrayList.add(THAWTE_PRIMARY_ROOT_CERT_LABEL_PAIR);
        DEFAULT_CERTIFICATE_GROUPING.put(THAWTE_LABEL_PAIR, arrayList);
        arrayList = new ArrayList();
        arrayList.add(VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G5_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G2_LABEL_PAIR);
        arrayList.add(VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G3_LABEL_PAIR);
        DEFAULT_CERTIFICATE_GROUPING.put(VERISIGN_LABEL_PAIR, arrayList);
        arrayList = new ArrayList();
        arrayList.add(DIGICERT_GLOBAL_ROOT_CA_CERT_LABEL_PAIR);
        arrayList.add(DIGICERT_SHA2_SECURE_SERVER_CA_CERT_LABEL_PAIR);
        IBM_CLOUD_CERTIFICATE_GROUPING.put(DIGICERT_LABEL_PAIR, arrayList);
        arrayList = new ArrayList();
        arrayList.add(ISRG_ROOT_X1_CA_CERT_LABEL_PAIR);
        arrayList.add(LETS_ENC_AUTH_CA_CERT_LABEL_PAIR);
        IBM_CLOUD_CERTIFICATE_GROUPING.put(LETS_ENC_LABEL_PAIR, arrayList);
        CERTIFICATE_GROUPING.putAll(DEFAULT_CERTIFICATE_GROUPING);
        CERTIFICATE_GROUPING.putAll(IBM_CLOUD_CERTIFICATE_GROUPING);
    }
}

