/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.LockedFileOutputStream;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;

public class BlankPKCS12File {
    private static final String KEYSTORE_NAME = "PKCS12";
    private KeyStore keyStore;

    public BlankPKCS12File() throws KeyManagerException {
        try {
            this.keyStore = KeyStore.getInstance(KEYSTORE_NAME);
            this.keyStore.load(null, null);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            String string = KeymanUtil.getJCEProviderName();
            X509Certificate x509Certificate = this.generateDummyCertificate("cn=dummyCert", keyPair, 7000);
            this.keyStore.setCertificateEntry("dummy", x509Certificate);
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.KEY_STORE_TYPE_NOT_FOUND, keyStoreException, new String[]{KEYSTORE_NAME});
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_LOAD_ERROR, (Throwable)certificateException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
    }

    public void store(char[] cArray, String string) throws KeyManagerException {
        try {
            LockedFileOutputStream lockedFileOutputStream = new LockedFileOutputStream(string);
            this.keyStore.store(lockedFileOutputStream, cArray);
            ((OutputStream)lockedFileOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_CREATION_ERROR, fileNotFoundException, new String[]{string});
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.BLANK_PKCS12_STORE_ERROR, keyStoreException, new String[]{keyStoreException.getMessage() != null ? keyStoreException.getMessage() : keyStoreException.toString()});
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{noSuchAlgorithmException.getMessage()});
        }
        catch (CertificateException certificateException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_STORE_ERROR, (Throwable)certificateException);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
    }

    private X509Certificate generateDummyCertificate(String string, KeyPair keyPair, int n) throws KeyManagerException {
        X509CertImpl x509CertImpl;
        block12: {
            String string2 = KeymanUtil.getJCEProviderName();
            X509CertInfo x509CertInfo = new X509CertInfo(string2);
            String string3 = KeymanSettings.DEFAULT_SIGNATURE_ALGORITHM;
            x509CertImpl = null;
            try {
                X500Name x500Name = new X500Name(string);
                PublicKey publicKey = keyPair.getPublic();
                PrivateKey privateKey = keyPair.getPrivate();
                Calendar calendar = Calendar.getInstance();
                Calendar calendar2 = Calendar.getInstance();
                calendar2.add(6, n);
                CertificateValidity certificateValidity = new CertificateValidity(calendar.getTime(), calendar2.getTime());
                x509CertInfo.set("validity", (Object)certificateValidity);
                x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber((int)(calendar.getTime().getTime() / 1000L)));
                x509CertInfo.set("subject", (Object)x500Name);
                x509CertInfo.set("issuer", (Object)x500Name);
                x509CertInfo.set("key", (Object)new CertificateX509Key(publicKey));
                x509CertInfo.set("version", (Object)KeymanSettings.DEFAULT_CERTIFICATE_VERSION);
                AlgorithmId algorithmId = AlgorithmId.get((String)string3);
                x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(algorithmId));
                CertificateExtensions certificateExtensions = new CertificateExtensions();
                certificateExtensions.set("BasicConstraints", (Object)new BasicConstraintsExtension(false, 0));
                byte[] byArray = EntryFactory.getKeyIdentifier(publicKey);
                KeyIdentifier keyIdentifier = new KeyIdentifier(byArray);
                SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(keyIdentifier.getIdentifier());
                certificateExtensions.set("SubjectKeyIdentifier", (Object)subjectKeyIdentifierExtension);
                AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension = new AuthorityKeyIdentifierExtension(keyIdentifier, null, null);
                certificateExtensions.set("AuthorityKeyIdentifier", (Object)authorityKeyIdentifierExtension);
                x509CertInfo.set("extensions", (Object)certificateExtensions);
                x509CertImpl = new X509CertImpl(x509CertInfo, string2);
                if (KeymanUtil.isIBMJCE()) {
                    try {
                        x509CertImpl.sign(privateKey, string3, string2);
                        break block12;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        String string4 = null;
                        if (KeymanUtil.isIBMJCEPlusModeOn() && (string4 = KeymanUtil.getJCEProviderNameLegacy()) != null) {
                            x509CertImpl.sign(privateKey, string3, string4);
                            break block12;
                        }
                        throw noSuchAlgorithmException;
                    }
                }
                x509CertImpl.sign(privateKey, string3);
            }
            catch (CertificateException certificateException) {
                if (certificateException.getMessage().contains("Invalid version")) {
                    throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_CERTIFICATE_VERSION, certificateException, new String[]{string});
                }
                throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_CREATE_ERROR, (Throwable)certificateException);
            }
            catch (IOException iOException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_ALGORITHM, noSuchAlgorithmException, new String[]{string3});
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_KEY_FOR_SIGNING, invalidKeyException, new String[]{string});
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{string2});
            }
            catch (SignatureException signatureException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.SIGNATURE_ERROR, signatureException, new String[]{string});
            }
        }
        return x509CertImpl;
    }
}

