/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants$Actions;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogMode;
import com.ibm.gsk.ikeyman.gui.GUIConstants$DialogResult;
import com.ibm.gsk.ikeyman.gui.controls.ButtonFactory;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.BrowseAction;
import com.ibm.gsk.ikeyman.gui.panels.InputPanelFactory;
import com.ibm.gsk.ikeyman.gui.panels.InputPanelFactory$InputDialogType;
import com.ibm.gsk.ikeyman.gui.panels.InputPanelFactory$InputJPanel;
import com.ibm.gsk.ikeyman.gui.panels.KeymanFileFilter;
import com.ibm.gsk.ikeyman.gui.panels.KeymanFileFilter$FilterType;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CertificateDataDialog
extends CenteredDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private InputPanelFactory$InputJPanel certificateDataPanel = null;
    private InputPanelFactory$InputDialogType inputDialogType = InputPanelFactory$InputDialogType.SelfsignedCertificate;
    private KeyStoreInfo database = null;
    private JPanel fileNamePanel = null;
    private JLabel jLabel1 = null;
    private JTextField fileNameField = null;
    private JButton browseBtn = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private JScrollPane jScrollPane = null;
    private BrowseAction browseAction = new BrowseAction(this);
    private static CertificateDataDialog dialog = null;

    public static void getData(Frame frame, InputPanelFactory$InputDialogType inputPanelFactory$InputDialogType, KeyStoreInfo keyStoreInfo, boolean bl, ParameterMap parameterMap) throws KeyManagerException, CancelledException {
        if (!bl) {
            if (dialog != null) {
                dialog.dispose();
            }
            dialog = new CertificateDataDialog(frame, inputPanelFactory$InputDialogType, keyStoreInfo);
        }
        dialog.setDialogResult(GUIConstants$DialogResult.Cancel);
        dialog.setVisible(true);
        if (dialog.getDialogResult() != GUIConstants$DialogResult.OK) {
            throw new CancelledException();
        }
        dialog.getParameters(parameterMap);
    }

    protected void getParameters(ParameterMap parameterMap) throws KeyManagerException {
        this.certificateDataPanel.getParameters(parameterMap);
        if (this.inputDialogType == InputPanelFactory$InputDialogType.CertificateRequest) {
            parameterMap.put(Constants$Parameter.File, this.getFile());
        }
    }

    private String getFile() {
        return this.fileNameField.getText();
    }

    public CertificateDataDialog(Frame frame, InputPanelFactory$InputDialogType inputPanelFactory$InputDialogType, KeyStoreInfo keyStoreInfo) {
        super(frame);
        this.inputDialogType = inputPanelFactory$InputDialogType;
        this.database = keyStoreInfo;
        this.initialize();
        if (inputPanelFactory$InputDialogType == InputPanelFactory$InputDialogType.SelfsignedCertificate) {
            this.setTitle(Messages.getString("GUI.Title.NewSelfSigned"));
        } else if (inputPanelFactory$InputDialogType == InputPanelFactory$InputDialogType.CertificateRequest) {
            this.setTitle(Messages.getString("GUI.Title.NewCertRequest"));
            this.fileNameField.setText(keyStoreInfo.getDescriptor().getFileName().getDirectory() + File.separator + KeymanSettings$Setting.DefaultCertReqName.getString());
        } else {
            this.setTitle(Messages.getString("GUI.Title.SecretKey"));
        }
    }

    private void initialize() {
        this.setSize(709, 510);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.getRootPane().setDefaultButton(this.getButtonPanel().getOkBtn());
        this.setName(ControlNames.CertificateDataDialog.toString());
        this.centerToParent();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.insets = new Insets(15, 0, 5, 0);
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.insets = new Insets(15, 10, 0, 10);
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(15, 10, 3, 0);
            gridBagConstraints4.gridx = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText(Messages.getString("Label.PleaseProvideTheFollowing"));
            this.jLabel.setName(ControlNames.CertificateDataDialogProvideTheFollowingLabel.toString());
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints4);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints);
            if (this.inputDialogType == InputPanelFactory$InputDialogType.CertificateRequest) {
                this.jContentPane.add((Component)this.getFileNamePanel(), gridBagConstraints3);
            }
        }
        return this.jContentPane;
    }

    private InputPanelFactory$InputJPanel getCertificateDataPanel() {
        if (this.certificateDataPanel == null) {
            this.certificateDataPanel = InputPanelFactory.getInputPanel(this.inputDialogType, this.database);
        }
        return this.certificateDataPanel;
    }

    private JPanel getFileNamePanel() {
        if (this.fileNamePanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(3, 0, 3, 5);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(3, 5, 3, 5);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(10, 5, 0, 0);
            gridBagConstraints3.gridx = 0;
            this.jLabel1 = new MnemonicLabel(Messages.getStringWithMnemonics("Label.EnterCertRequestFileName"));
            this.jLabel1.setName(ControlNames.CertificateDataDialogCertRequestFileNameLabel.toString());
            this.fileNamePanel = new JPanel();
            this.fileNamePanel.setLayout(new GridBagLayout());
            this.fileNamePanel.add((Component)this.jLabel1, gridBagConstraints3);
            this.fileNamePanel.add((Component)this.getFileNameField(), gridBagConstraints2);
            this.fileNamePanel.add((Component)this.getBrowseBtn(), gridBagConstraints);
            this.jLabel1.setLabelFor(this.getFileNameField());
        }
        return this.fileNamePanel;
    }

    private JTextField getFileNameField() {
        if (this.fileNameField == null) {
            this.fileNameField = new JTextField();
            this.fileNameField.setToolTipText(Messages.getString("Tooltip.CertreqFile"));
            this.fileNameField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.CertreqFile"));
            this.fileNameField.setName(ControlNames.CertificateDataDialogCertRequestFileNameField.toString());
        }
        return this.fileNameField;
    }

    private JButton getBrowseBtn() {
        if (this.browseBtn == null) {
            this.browseBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.Browse"), ControlNames.CertificateDataDialogBrowseButton);
            this.browseBtn.setActionCommand(GUIConstants$Actions.Browse.toString());
            this.browseBtn.addActionListener(this);
        }
        return this.browseBtn;
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(new GUIConstants$Actions[]{GUIConstants$Actions.OK, GUIConstants$Actions.Cancel, GUIConstants$Actions.Reset});
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getCertificateDataPanel());
        }
        return this.jScrollPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(GUIConstants$Actions.Browse.toString())) {
            this.browseHandler();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void browseHandler() {
        File file = this.browseAction.getFileName(new KeymanFileFilter(KeymanFileFilter$FilterType.CertRequest), new File(this.getFile()), GUIConstants$DialogMode.New);
        if (file != null) {
            this.fileNameField.setText(file.getAbsolutePath());
        }
    }

    private boolean isValidInput() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.certificateDataPanel.isValidInput(stringBuffer)) {
            JOptionPane.showMessageDialog(this, stringBuffer.toString(), Messages.getString("GUI.Title.Validation"), 0);
            return false;
        }
        return true;
    }

    protected void resetHandler() {
        this.certificateDataPanel.resetFields();
    }

    protected void okHandler() {
        if (this.isValidInput()) {
            this.setDialogResult(GUIConstants$DialogResult.OK);
            this.setVisible(false);
        }
    }
}

