/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.internal.tools.attach.target.IPC;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jmap {
    private static List<String> vmids;
    private static boolean histo;
    private static boolean live;
    private static String HELPTEXT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (!Jmap.parseArguments(args)) {
            System.exit(1);
        }
        AttacherDiagnosticsProvider diagProvider = new AttacherDiagnosticsProvider();
        String myId = AttachHandler.getVmId();
        for (String vmid : vmids) {
            long pid;
            if (vmid.equals(myId)) continue;
            if (vmid.matches("\\d+") && !IPC.processExists(pid = Long.parseLong(vmid))) {
                System.out.println("No such process: " + vmid);
                continue;
            }
            try {
                if (vmids.size() > 1) {
                    System.out.printf("Virtual machine: %s%n", vmid);
                }
                diagProvider.attach(vmid);
                if (!histo) continue;
                Util.runCommandAndPrintResult(diagProvider, DiagnosticUtils.makeHeapHistoCommand(live), "jmap");
            }
            catch (Exception e) {
                System.err.printf("Error getting data from %s", vmid);
                String msg = e.getMessage();
                if (null == msg) {
                    System.err.println();
                } else if (msg.matches("OPENJ9_INCOMPATIBLE_JAVA_VERSION")) {
                    System.err.println(": incompatible target JVM");
                } else {
                    System.err.printf(": %s%n", msg);
                }
                if (!DiagnosticProperties.isDebug) continue;
                e.printStackTrace();
            }
            finally {
                try {
                    diagProvider.detach();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean parseArguments(String[] args) {
        vmids = new ArrayList<String>();
        histo = false;
        live = false;
        int optionsSelected = 0;
        String errorMessage = null;
        vmids = new ArrayList<String>();
        for (String arg : args) {
            if (!arg.startsWith("-")) {
                vmids.add(arg);
                continue;
            }
            boolean invalidArg = false;
            String[] parts = arg.split(":");
            if (parts.length > 2) {
                invalidArg = true;
            } else if ("-histo".equalsIgnoreCase(parts[0])) {
                if (parts.length == 2) {
                    if ("live".equalsIgnoreCase(parts[1])) {
                        live = true;
                    } else {
                        invalidArg = true;
                    }
                }
                if (!invalidArg) {
                    histo = true;
                    ++optionsSelected;
                }
            } else {
                invalidArg = true;
            }
            if (!invalidArg) continue;
            errorMessage = "unrecognized option " + arg;
            break;
        }
        if (errorMessage == null && optionsSelected != 1) {
            errorMessage = "exactly one option must be selected";
        }
        if (null != errorMessage) {
            System.err.printf("%s%n" + HELPTEXT, errorMessage);
        } else if (vmids.isEmpty()) {
            vmids = Util.inStreamToStringList(System.in);
        }
        return null == errorMessage && !vmids.isEmpty();
    }

    static {
        HELPTEXT = "jmap: obtain heap information about a Java process%n Usage:%n    jmap <option>* <vmid>%n        <vmid>: Attach API VM ID as shown in jps or other Attach API-based tools%n        <vmid>s are read from stdin if none are supplied as arguments%n    -histo: print statistics about classes on the heap, including number of objects and aggregate size%n    -histo:live : Print only live objects%n    -J: supply arguments to the Java VM running jmap%nNOTE: this utility might significantly affect the performance of the target VM.%nAt least one option must be selected.%n";
    }
}

