/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.attacher;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.attacher.OpenJ9AttachProvider;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachine;
import com.sun.tools.attach.AttachNotSupportedException;
import java.io.IOException;
import java.util.Properties;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.IPC;

public class AttacherDiagnosticsProvider {
    private OpenJ9VirtualMachine vm;

    public Properties executeDiagnosticCommand(String diagnosticCommand) throws IOException {
        IPC.logMessage("AttacherDiagnosticsProvider enter executeDiagnosticCommand ", diagnosticCommand);
        this.checkAttached();
        Properties info = this.vm.executeDiagnosticCommand(diagnosticCommand);
        DiagnosticProperties.dumpPropertiesIfDebug("Properties from target:", info);
        IPC.logMessage("exit getRemoteThreadGroupInfo");
        return info;
    }

    public void attach(String vmid) throws IOException {
        OpenJ9AttachProvider attachProv = new OpenJ9AttachProvider();
        IPC.logMessage("DiagnosticsProviderImpl attaching to ", vmid);
        try {
            this.vm = attachProv.attachVirtualMachine(vmid);
        }
        catch (AttachNotSupportedException e) {
            throw new IOException(Msg.getString("K0809", vmid));
        }
        IPC.logMessage("DiagnosticsProviderImpl attached to ", vmid);
    }

    public void detach() throws IOException {
        if (null != this.vm) {
            this.vm.detach();
            this.vm = null;
        }
    }

    public Properties getSystemProperties() throws IOException {
        this.checkAttached();
        return this.vm.getSystemProperties();
    }

    public Properties getAgentProperties() throws IOException {
        this.checkAttached();
        return this.vm.getAgentProperties();
    }

    private void checkAttached() throws IOException {
        if (null == this.vm) {
            throw new IOException(Msg.getString("K0554"));
        }
    }
}

