/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.LockInfoUtil;
import com.ibm.java.lang.management.internal.ManagementAccessControl;
import com.ibm.java.lang.management.internal.MonitorInfoUtil;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import com.ibm.java.lang.management.internal.ThreadInfoUtil;
import com.ibm.oti.util.Msg;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfoAccessImpl;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import openj9.management.internal.LockInfoBase;
import openj9.management.internal.MonitorInfoBase;
import openj9.management.internal.ThreadInfoBase;

public class ThreadInfo {
    private static final MonitorInfo[] EMPTY_MONITORINFO_ARRAY = new MonitorInfo[0];
    private final ThreadInfoBase baseInfo;
    private static final LockInfo[] EMPTY_LOCKINFO_ARRAY;

    private ThreadInfo(long threadIdVal, String threadNameVal, Thread.State threadStateVal, boolean suspendedVal, boolean inNativeVal, long blockedCountVal, long blockedTimeVal, long waitedCountVal, long waitedTimeVal, String lockNameVal, long lockOwnerIdVal, String lockOwnerNameVal, StackTraceElement[] stackTraceVal, LockInfo lockInfo, MonitorInfo[] lockedMonitors, LockInfo[] lockedSynchronizers) {
        MonitorInfoBase[] monInfoBases = null;
        if (null != lockedMonitors) {
            monInfoBases = (MonitorInfoBase[])Arrays.stream(lockedMonitors).map(MonitorInfo::getBaseInfo).toArray(MonitorInfoBase[]::new);
        }
        LockInfoBase[] lockedSyncs = null;
        if (null != lockedSynchronizers) {
            lockedSyncs = (LockInfoBase[])Arrays.stream(lockedSynchronizers).map(LockInfo::getBaseInfo).toArray(LockInfoBase[]::new);
        }
        LockInfoBase lckInfo = null;
        if (null != lockInfo) {
            lckInfo = lockInfo.getBaseInfo();
        }
        this.baseInfo = new ThreadInfoBase(threadIdVal, threadNameVal, threadStateVal, suspendedVal, inNativeVal, blockedCountVal, blockedTimeVal, waitedCountVal, waitedTimeVal, lockNameVal, lockOwnerIdVal, lockOwnerNameVal, stackTraceVal, lckInfo, monInfoBases, lockedSyncs);
    }

    private ThreadInfo(ThreadInfoBase base) {
        this.baseInfo = base;
    }

    public long getBlockedCount() {
        return this.baseInfo.getBlockedCount();
    }

    public long getBlockedTime() {
        return this.baseInfo.getBlockedTime();
    }

    public String getLockName() {
        return this.baseInfo.getLockName();
    }

    public long getLockOwnerId() {
        return this.baseInfo.getLockOwnerId();
    }

    public String getLockOwnerName() {
        return this.baseInfo.getLockOwnerName();
    }

    public LockInfo getLockInfo() {
        LockInfoBase li = this.baseInfo.getBlockingLockInfo();
        return null == li ? null : new LockInfo(li);
    }

    long getNativeThreadId() {
        return this.baseInfo.getNativeTId();
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.baseInfo.getStackTrace().clone();
    }

    public long getThreadId() {
        return this.baseInfo.getThreadId();
    }

    public String getThreadName() {
        return this.baseInfo.getThreadName();
    }

    public Thread.State getThreadState() {
        return this.baseInfo.getThreadState();
    }

    public long getWaitedCount() {
        return this.baseInfo.getWaitedCount();
    }

    public long getWaitedTime() {
        return this.baseInfo.getWaitedTime();
    }

    public boolean isInNative() {
        return this.baseInfo.isInNative();
    }

    public boolean isSuspended() {
        return this.baseInfo.isSuspended();
    }

    public MonitorInfo[] getLockedMonitors() {
        MonitorInfo[] lockedMons = null;
        MonitorInfoBase[] lockedMonBases = this.baseInfo.getLockedMonitors();
        if (null != lockedMonBases) {
            lockedMons = (MonitorInfo[])Arrays.stream(lockedMonBases).map(MonitorInfo::new).toArray(MonitorInfo[]::new);
        }
        return lockedMons;
    }

    public LockInfo[] getLockedSynchronizers() {
        LockInfo[] lockedSyncs = null;
        LockInfoBase[] lockedSyncBases = this.baseInfo.getLockedSynchronizers();
        lockedSyncs = (LockInfo[])Arrays.stream(lockedSyncBases).map(LockInfo::new).toArray(LockInfo[]::new);
        return lockedSyncs;
    }

    public static ThreadInfo from(CompositeData cd) {
        ThreadInfo result = null;
        if (cd != null) {
            StackTraceElement[] stackTraceVals;
            String lockOwnerNameVal;
            long lockOwnerIdVal;
            String lockNameVal;
            long waitedTimeVal;
            long waitedCountVal;
            long blockedTimeVal;
            long blockedCountVal;
            boolean inNativeVal;
            boolean suspendedVal;
            Thread.State threadStateVal;
            String threadNameVal;
            long threadIdVal;
            if (!ThreadInfoUtil.getCompositeType().isValue(cd)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                threadIdVal = (Long)cd.get("threadId");
                threadNameVal = (String)cd.get("threadName");
                String threadStateStringVal = (String)cd.get("threadState");
                try {
                    threadStateVal = Thread.State.valueOf(threadStateStringVal);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(Msg.getString("K0612", e));
                }
                suspendedVal = (Boolean)cd.get("suspended");
                inNativeVal = (Boolean)cd.get("inNative");
                blockedCountVal = (Long)cd.get("blockedCount");
                blockedTimeVal = (Long)cd.get("blockedTime");
                waitedCountVal = (Long)cd.get("waitedCount");
                waitedTimeVal = (Long)cd.get("waitedTime");
                lockNameVal = (String)cd.get("lockName");
                lockOwnerIdVal = (Long)cd.get("lockOwnerId");
                lockOwnerNameVal = (String)cd.get("lockOwnerName");
                CompositeData[] stackTraceDataVal = (CompositeData[])cd.get("stackTrace");
                stackTraceVals = StackTraceElementUtil.fromArray(stackTraceDataVal);
            }
            catch (NullPointerException | InvalidKeyException e) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            LockInfo lockInfoVal = ThreadInfo.recoverLockInfoAttribute(cd, lockNameVal);
            MonitorInfo[] lockedMonitorVals = ThreadInfo.recoverLockedMonitors(cd);
            LockInfo[] lockedSynchronizerVals = ThreadInfo.recoverLockedSynchronizers(cd);
            result = new ThreadInfo(threadIdVal, threadNameVal, threadStateVal, suspendedVal, inNativeVal, blockedCountVal, blockedTimeVal, waitedCountVal, waitedTimeVal, lockNameVal, lockOwnerIdVal, lockOwnerNameVal, stackTraceVals, lockInfoVal, lockedMonitorVals, lockedSynchronizerVals);
        }
        return result;
    }

    private static LockInfo[] recoverLockedSynchronizers(CompositeData cd) {
        LockInfo[] result;
        try {
            CompositeData[] lockedSynchronizersDataVal = (CompositeData[])cd.get("lockedSynchronizers");
            result = LockInfoUtil.fromArray(lockedSynchronizersDataVal);
        }
        catch (InvalidKeyException e) {
            result = EMPTY_LOCKINFO_ARRAY;
        }
        return result;
    }

    private static MonitorInfo[] recoverLockedMonitors(CompositeData cd) {
        MonitorInfo[] result;
        try {
            CompositeData[] lockedMonitorsDataVal = (CompositeData[])cd.get("lockedMonitors");
            result = MonitorInfoUtil.fromArray(lockedMonitorsDataVal);
        }
        catch (InvalidKeyException e) {
            result = EMPTY_MONITORINFO_ARRAY;
        }
        return result;
    }

    private static LockInfo recoverLockInfoAttribute(CompositeData cd, String lockNameVal) {
        LockInfo result = null;
        try {
            CompositeData lockInfoCDVal;
            CompositeData compositeData = lockInfoCDVal = cd.get("lockInfo") != null ? (CompositeData)cd.get("lockInfo") : null;
            if (lockInfoCDVal != null) {
                if (!LockInfoUtil.getCompositeType().isValue(lockInfoCDVal)) {
                    throw new IllegalArgumentException(Msg.getString("K05E5"));
                }
                result = new LockInfo((String)lockInfoCDVal.get("className"), (Integer)lockInfoCDVal.get("identityHashCode"));
            }
        }
        catch (InvalidKeyException e) {
            result = ThreadInfo.createLockInfoFromLockName(lockNameVal);
        }
        return result;
    }

    public String toString() {
        return this.baseInfo.toString();
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && null != obj && obj instanceof ThreadInfo) {
            result = this.baseInfo.equals(((ThreadInfo)obj).baseInfo);
        }
        return result;
    }

    public int hashCode() {
        return this.baseInfo.hashCode();
    }

    private static LockInfo createLockInfoFromLockName(String lockString) {
        StringTokenizer strTok;
        LockInfo result = null;
        if (lockString != null && lockString.length() > 0 && (strTok = new StringTokenizer(lockString, "@")).countTokens() == 2) {
            try {
                result = new LockInfo(strTok.nextToken(), Integer.parseInt(strTok.nextToken(), 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    static {
        ManagementAccessControl.setThreadInfoAccess(new ThreadInfoAccessImpl());
        EMPTY_LOCKINFO_ARRAY = new LockInfo[0];
    }
}

