/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.IndirectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class VirtualHandle
extends IndirectHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();

    VirtualHandle(Method method) throws IllegalAccessException {
        super(VirtualHandle.indirectMethodType(method), method.getDeclaringClass(), method.getName(), (byte)5, method.getModifiers());
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException();
        }
        boolean succeed = VirtualHandle.setVMSlotAndRawModifiersFromMethod(this, this.referenceClass, method, this.kind, null);
        if (!succeed) {
            throw new IllegalAccessException();
        }
    }

    VirtualHandle(DirectHandle nonVirtualHandle) throws IllegalAccessException {
        super(nonVirtualHandle.type(), nonVirtualHandle.referenceClass, nonVirtualHandle.name, (byte)5, nonVirtualHandle.rawModifiers);
        this.defc = nonVirtualHandle.defc;
        boolean succeed = VirtualHandle.setVMSlotAndRawModifiersFromSpecialHandle(this, nonVirtualHandle);
        if (!succeed) {
            throw new IllegalAccessException();
        }
    }

    VirtualHandle(VirtualHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    @Override
    protected final long vtableOffset(Object receiver) {
        return this.vmSlot - INTRP_VTABLE_OFFSET;
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    protected static native void virtualCall_V(Object var0, int var1);

    protected static native int virtualCall_I(Object var0, int var1);

    protected static native long virtualCall_J(Object var0, int var1);

    protected static native float virtualCall_F(Object var0, int var1);

    protected static native double virtualCall_D(Object var0, int var1);

    protected static native Object virtualCall_L(Object var0, int var1);

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(Object receiver, int argPlaceholder) {
        if (ILGenMacros.isCustomThunk()) {
            VirtualHandle.virtualCall_V(receiver, argPlaceholder);
        } else {
            ComputedCalls.dispatchVirtual_V(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_I(Object receiver, int argPlaceholder) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_I(receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchVirtual_I(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final long invokeExact_thunkArchetype_J(Object receiver, int argPlaceholder) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_J(receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchVirtual_J(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final float invokeExact_thunkArchetype_F(Object receiver, int argPlaceholder) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_F(receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchVirtual_F(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final double invokeExact_thunkArchetype_D(Object receiver, int argPlaceholder) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_D(receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchVirtual_D(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.FrameIteratorSkip
    private final Object invokeExact_thunkArchetype_L(Object receiver, int argPlaceholder) {
        if (ILGenMacros.isCustomThunk()) {
            return VirtualHandle.virtualCall_L(receiver, argPlaceholder);
        }
        return ComputedCalls.dispatchVirtual_L(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new VirtualHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof VirtualHandle) {
            ((VirtualHandle)right).compareWithVirtual(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithVirtual(VirtualHandle left, Comparator c) {
        super.compareWithIndirect(left, c);
    }
}

