/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CacheKey;
import java.lang.invoke.MethodType;

final class MethodCacheKey
extends CacheKey {
    private final MethodType type;
    private final Class<?> specialCaller;

    public MethodCacheKey(String name, MethodType mt, Class<?> specialCaller) {
        super(name, MethodCacheKey.calculateHashcode(name, mt, specialCaller));
        this.type = mt;
        this.specialCaller = specialCaller;
    }

    private static int calculateHashcode(String name, MethodType mt, Class<?> specialCaller) {
        int hash = 31 + mt.hashCode();
        hash = 31 * hash + name.hashCode();
        if (specialCaller != null) {
            hash = 31 * hash + specialCaller.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MethodCacheKey)) {
            return false;
        }
        MethodCacheKey other = (MethodCacheKey)o;
        return other.type == this.type && other.name.equals(this.name) && other.specialCaller == this.specialCaller;
    }
}

