/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.RuntimePermissions;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import sun.nio.ch.Interruptible;
import sun.reflect.CallerSensitive;
import sun.security.util.SecurityConstants;

public class Thread
implements Runnable {
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    private static int createCount;
    private static Object tidLock;
    private static long tidCount;
    private static final int NANOS_MAX = 999999;
    private static final int INITIAL_LOCAL_STORAGE_CAPACITY = 5;
    static final long NO_REF = 0L;
    private long threadRef;
    long stackSize = 0L;
    private volatile boolean started;
    private String name;
    private int priority = 5;
    private boolean isDaemon;
    ThreadGroup group;
    private Runnable runnable;
    private boolean stopCalled = false;
    private ClassLoader contextClassLoader;
    ThreadLocal.ThreadLocalMap threadLocals;
    private AccessControlContext inheritedAccessControlContext;
    private Object lock = new ThreadLock();
    ThreadLocal.ThreadLocalMap inheritableThreadLocals;
    private volatile Interruptible blockOn;
    int threadLocalsIndex;
    int inheritableThreadLocalsIndex;
    private volatile UncaughtExceptionHandler exceptionHandler;
    private long tid;
    volatile Object parkBlocker;
    private static ThreadGroup systemThreadGroup;
    private static ThreadGroup mainGroup;
    private static volatile UncaughtExceptionHandler defaultExceptionHandler;
    long threadLocalRandomSeed;
    int threadLocalRandomProbe;
    int threadLocalRandomSecondarySeed;
    private static final StackTraceElement[] EMPTY_STACK_TRACE;

    public Thread() {
        this(null, null, Thread.newName(), null, true);
    }

    private Thread(String vmName, Object vmThreadGroup, int vmPriority, boolean vmIsDaemon) {
        String threadName = vmName == null ? Thread.newName() : vmName;
        this.setNameImpl(this.threadRef, threadName);
        this.name = threadName;
        this.isDaemon = vmIsDaemon;
        this.priority = vmPriority;
        ThreadGroup threadGroup = null;
        boolean booting = false;
        if (mainGroup == null) {
            booting = true;
            mainGroup = new ThreadGroup(systemThreadGroup);
        }
        threadGroup = vmThreadGroup == null ? mainGroup : (ThreadGroup)vmThreadGroup;
        this.initialize(booting, threadGroup, null, null, true);
        this.group.add(this);
        if (booting) {
            System.completeInitialization();
        }
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.newName(), null, true);
    }

    Thread(Runnable runnable, AccessControlContext acc) {
        this(null, runnable, Thread.newName(), acc, false);
    }

    public Thread(Runnable runnable, String threadName) {
        this(null, runnable, threadName, null, true);
    }

    public Thread(String threadName) {
        this(null, null, threadName, null, true);
    }

    public Thread(ThreadGroup group, Runnable runnable) {
        this(group, runnable, Thread.newName(), null, true);
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName, long stack) {
        this(group, runnable, threadName, null, true);
        this.stackSize = stack;
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName) {
        this(group, runnable, threadName, null, true);
    }

    Thread(Runnable runnable, String threadName, boolean isSystemThreadGroup, boolean inheritThreadLocals, boolean isDaemon, ClassLoader contextClassLoader) {
        this(isSystemThreadGroup ? systemThreadGroup : null, runnable, threadName, null, inheritThreadLocals);
        this.isDaemon = isDaemon;
        this.contextClassLoader = contextClassLoader;
    }

    private Thread(ThreadGroup group, Runnable runnable, String threadName, AccessControlContext acc, boolean inheritThreadLocals) {
        SecurityManager currentManager;
        if (threadName == null) {
            throw new NullPointerException();
        }
        this.name = threadName;
        this.runnable = runnable;
        Thread currentThread = Thread.currentThread();
        this.isDaemon = currentThread.isDaemon();
        if (group == null && (currentManager = System.getSecurityManager()) != null) {
            group = currentManager.getThreadGroup();
        }
        if (group == null) {
            group = currentThread.getThreadGroup();
        }
        this.initialize(false, group, currentThread, acc, inheritThreadLocals);
        this.setPriority(currentThread.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean booting, ThreadGroup threadGroup, Thread parentThread, AccessControlContext acc, boolean inheritThreadLocals) {
        Object object = tidLock;
        synchronized (object) {
            this.tid = tidCount++;
        }
        this.group = threadGroup;
        if (booting) {
            System.afterClinitInitialization();
        }
        if (parentThread != null) {
            boolean override;
            if (inheritThreadLocals && null != parentThread.inheritableThreadLocals) {
                this.inheritableThreadLocals = ThreadLocal.createInheritedMap(parentThread.inheritableThreadLocals);
            }
            SecurityManager sm = System.getSecurityManager();
            final Class<? extends Object> implClass = this.getClass();
            final Class<Thread> thisClass = Thread.class;
            if (sm != null && implClass != thisClass && (override = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    Method method2;
                    try {
                        method2 = implClass.getMethod("getContextClassLoader", new Class[0]);
                        if (method2.getDeclaringClass() != thisClass) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (NoSuchMethodException method2) {
                        // empty catch block
                    }
                    try {
                        method2 = implClass.getDeclaredMethod("setContextClassLoader", ClassLoader.class);
                        if (method2.getDeclaringClass() != thisClass) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    return Boolean.FALSE;
                }
            }).booleanValue())) {
                sm.checkPermission(RuntimePermissions.permissionEnableContextClassLoaderOverride);
            }
            this.contextClassLoader = parentThread.getContextClassLoader();
        } else {
            if (booting) {
                try {
                    Class.forName("com.ibm.jit.JITHelpers");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ClassLoader.initializeClassLoaders();
            }
            this.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        threadGroup.checkAccess();
        threadGroup.checkNewThread(this);
        this.inheritedAccessControlContext = acc == null ? AccessController.getContext() : acc;
    }

    public Thread(ThreadGroup group, String threadName) {
        this(group, null, threadName, null, true);
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkAccess(this);
        }
    }

    @Deprecated
    public int countStackFrames() {
        return 0;
    }

    public static native Thread currentThread();

    @Deprecated
    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Throwable().printStackTrace();
    }

    public static int enumerate(Thread[] threads) {
        return Thread.currentThread().getThreadGroup().enumerate(threads, true);
    }

    @CallerSensitive
    public ClassLoader getContextClassLoader() {
        ClassLoader callerClassLoader;
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null && ClassLoader.needsClassLoaderPermissionCheck(callerClassLoader = ClassLoader.callerClassLoader(), this.contextClassLoader)) {
            currentManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.contextClassLoader;
    }

    public final String getName() {
        return this.name;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null && Thread.currentThread() != this) {
            currentManager.checkAccess(this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.interruptImpl();
            Interruptible localBlockOn = this.blockOn;
            if (localBlockOn != null) {
                localBlockOn.interrupt(this);
            }
        }
    }

    public static boolean interrupted() {
        return Thread.interruptedImpl();
    }

    private static native boolean interruptedImpl();

    private native void interruptImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAlive() {
        Object object = this.lock;
        synchronized (object) {
            return this.threadRef != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDead() {
        Object object = this.lock;
        synchronized (object) {
            return this.started && this.threadRef == 0L;
        }
    }

    public final boolean isDaemon() {
        return this.isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterrupted() {
        Object object = this.lock;
        synchronized (object) {
            return this.isInterruptedImpl();
        }
    }

    private native boolean isInterruptedImpl();

    public final synchronized void join() throws InterruptedException {
        this.join(0L, 0);
    }

    public final void join(long timeoutInMilliseconds) throws InterruptedException {
        this.join(timeoutInMilliseconds, 0);
    }

    public final synchronized void join(long timeoutInMilliseconds, int nanos) throws InterruptedException {
        if (timeoutInMilliseconds < 0L || nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException();
        }
        if (!this.started || this.isDead()) {
            return;
        }
        if (timeoutInMilliseconds == 0L && nanos == 0) {
            while (!this.isDead()) {
                this.wait(0L);
            }
            return;
        }
        long toWaitNano = TimeUnit.MILLISECONDS.toNanos(timeoutInMilliseconds);
        toWaitNano = Long.MAX_VALUE - toWaitNano >= (long)nanos ? (toWaitNano += (long)nanos) : Long.MAX_VALUE;
        while (!this.isDead()) {
            long start = System.nanoTime();
            TimeUnit.NANOSECONDS.timedWait(this, toWaitNano);
            long waited = System.nanoTime() - start;
            if (waited >= toWaitNano) break;
            toWaitNano -= waited;
        }
    }

    private static synchronized String newName() {
        return "Thread-" + createCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            this.resumeImpl();
        }
    }

    private native void resumeImpl();

    @Override
    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public void setContextClassLoader(ClassLoader cl) {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkPermission(RuntimePermissions.permissionSetContextClassLoader);
        }
        this.contextClassLoader = cl;
    }

    void internalSetContextClassLoader(ClassLoader cl) {
        this.contextClassLoader = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDaemon(boolean isDaemon) {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                this.isDaemon = isDaemon;
            } else if (this.isAlive()) {
                throw new IllegalThreadStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setName(String threadName) {
        this.checkAccess();
        if (threadName == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.started && this.threadRef != 0L) {
                this.setNameImpl(this.threadRef, threadName);
            }
            this.name = threadName;
        }
    }

    private native void setNameImpl(long var1, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPriority(int requestedPriority) {
        this.checkAccess();
        if (1 <= requestedPriority && requestedPriority <= 10) {
            ThreadGroup myThreadGroup = this.getThreadGroup();
            if (null != myThreadGroup) {
                int finalPriority = requestedPriority;
                int threadGroupMaxPriority = myThreadGroup.getMaxPriority();
                if (threadGroupMaxPriority < requestedPriority) {
                    finalPriority = threadGroupMaxPriority;
                }
                this.priority = finalPriority;
                Object object = this.lock;
                synchronized (object) {
                    if (this.started && 0L != this.threadRef) {
                        this.setPriorityNoVMAccessImpl(this.threadRef, finalPriority);
                    }
                }
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private native void setPriorityNoVMAccessImpl(long var1, int var3);

    public static void sleep(long time) throws InterruptedException {
        Thread.sleep(time, 0);
    }

    public static void sleep(long time, int nanos) throws InterruptedException {
        Thread.sleepImpl(time, nanos);
    }

    private static native void sleepImpl(long var0, int var2) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        boolean success = false;
        if (this.started) {
            throw new IllegalThreadStateException(Msg.getString("K0341"));
        }
        this.group.add(this);
        try {
            Object object = this.lock;
            synchronized (object) {
                this.startImpl();
                success = true;
            }
        }
        finally {
            if (!success) {
                this.group.remove(this);
            }
        }
    }

    private native void startImpl();

    @Deprecated
    public final void stop() {
        if (!this.isDead()) {
            this.stopWithThrowable(new ThreadDeath());
        }
    }

    @Deprecated
    public final void stop(Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void stopWithThrowable(Throwable throwable) {
        SecurityManager currentManager;
        this.checkAccess();
        if (!(Thread.currentThread() == this && throwable instanceof ThreadDeath || (currentManager = System.getSecurityManager()) == null)) {
            currentManager.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
        }
        Object object = this.lock;
        synchronized (object) {
            if (throwable != null) {
                if (!this.started) {
                    this.stopCalled = true;
                } else {
                    this.stopImpl(throwable);
                }
            } else {
                throw new NullPointerException();
            }
        }
    }

    private native void stopImpl(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void suspend() {
        this.checkAccess();
        if (Thread.currentThread() == this) {
            this.suspendImpl();
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.suspendImpl();
            }
        }
    }

    private native void suspendImpl();

    public String toString() {
        ThreadGroup localGroup = this.getThreadGroup();
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + (null == localGroup ? "" : localGroup.getName()) + "]";
    }

    public static native void yield();

    public static native boolean holdsLock(Object var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockedOn(Interruptible interruptible) {
        Thread currentThread = this;
        Object object = currentThread.lock;
        synchronized (object) {
            currentThread.blockOn = interruptible;
        }
    }

    private native Throwable getStackTraceImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTraceElement[] getStackTrace() {
        Throwable t;
        SecurityManager security;
        if (Thread.currentThread() != this && (security = System.getSecurityManager()) != null) {
            security.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAlive()) {
                return EMPTY_STACK_TRACE;
            }
            t = this.getStackTraceImpl();
        }
        return J9VMInternals.getStackTrace(t, false);
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            security.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        int count = systemThreadGroup.activeCount() + 20;
        Thread[] threads = new Thread[count];
        count = systemThreadGroup.enumerate(threads);
        HashMap<Thread, StackTraceElement[]> result = new HashMap<Thread, StackTraceElement[]>(count * 4 / 3);
        for (int i = 0; i < count; ++i) {
            result.put(threads[i], threads[i].getStackTrace());
        }
        return result;
    }

    public long getId() {
        return this.tid;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (this.exceptionHandler == null) {
            return this.getThreadGroup();
        }
        return this.exceptionHandler;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultExceptionHandler;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermissions.permissionSetDefaultUncaughtExceptionHandler);
        }
        defaultExceptionHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.threadRef == 0L) {
                if (this.isDead()) {
                    return State.TERMINATED;
                }
                return State.NEW;
            }
            return State.values()[this.getStateImpl(this.threadRef)];
        }
    }

    private native int getStateImpl(long var1);

    void uncaughtException(Throwable e) {
        UncaughtExceptionHandler handler = this.getUncaughtExceptionHandler();
        if (handler != null) {
            handler.uncaughtException(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exit() {
        try {
            this.group = null;
            this.runnable = null;
            this.inheritedAccessControlContext = null;
            this.threadLocals = null;
            this.inheritableThreadLocals = null;
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.threadRef = 0L;
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    static {
        tidLock = new TidLock();
        tidCount = 1L;
        EMPTY_STACK_TRACE = new StackTraceElement[0];
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    @FunctionalInterface
    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    private static final class ThreadLock {
        private ThreadLock() {
        }
    }

    private static final class TidLock {
        TidLock() {
        }
    }
}

