/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.Properties;

public final class StringBuffer
extends AbstractStringBuilder
implements Serializable,
CharSequence,
Appendable {
    private static final long serialVersionUID = 3388685877147921107L;
    private static final int INITIAL_SIZE = 16;
    private static boolean TOSTRING_COPY_BUFFER_ENABLED = false;
    private static boolean growAggressively = false;
    private static final JITHelpers helpers = JITHelpers.getHelpers();
    private static final int uncompressedBit = Integer.MIN_VALUE;
    private static final int sharedBit = Integer.MIN_VALUE;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("count", Integer.TYPE), new ObjectStreamField("value", char[].class), new ObjectStreamField("shared", Boolean.TYPE)};
    private int count;
    private char[] value;
    private int capacity;

    private void decompress(int minCapacity, int length) {
        int twice;
        int currentCapacity = this.capacityInternal();
        char[] newValue = minCapacity > currentCapacity ? new char[minCapacity > (twice = (currentCapacity << 1) + 2) ? minCapacity : twice] : new char[currentCapacity];
        String.decompress(this.value, 0, newValue, 0, length > currentCapacity ? currentCapacity : length);
        this.count |= Integer.MIN_VALUE;
        this.value = newValue;
        this.capacity = newValue.length;
        String.initCompressionFlag();
    }

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int capacity) {
        if (capacity < 0) {
            throw new NegativeArraySizeException(String.valueOf(capacity));
        }
        int arraySize = capacity;
        if (String.COMPACT_STRINGS) {
            arraySize = capacity + 1 >>> 1;
        }
        this.value = new char[arraySize];
        this.capacity = capacity;
    }

    public StringBuffer(String string) {
        int stringLength = string.lengthInternal();
        int newLength = stringLength + 16;
        if (newLength < stringLength) {
            newLength = stringLength;
        }
        if (String.COMPACT_STRINGS) {
            if (string.isCompressed()) {
                this.value = new char[newLength + 1 >>> 1];
                string.getBytes(0, stringLength, this.value, 0);
                this.capacity = newLength;
                this.count = stringLength;
            } else {
                this.value = new char[newLength];
                string.getCharsNoBoundChecks(0, stringLength, this.value, 0);
                this.capacity = newLength;
                this.count = stringLength | Integer.MIN_VALUE;
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[newLength];
            string.getCharsNoBoundChecks(0, stringLength, this.value, 0);
            this.capacity = newLength;
            this.count = stringLength;
        }
    }

    public synchronized StringBuffer append(char[] chars) {
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        int newLength = currentLength + chars.length;
        if (newLength < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (String.COMPACT_STRINGS) {
            if (this.count >= 0 && String.canEncodeAsLatin1(chars, 0, chars.length)) {
                if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                String.compress(chars, 0, this.value, currentLength, chars.length);
                this.count = newLength;
            } else {
                if (this.count >= 0) {
                    this.decompress(newLength, currentLength);
                } else if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                String.decompressedArrayCopy(chars, 0, this.value, currentLength, chars.length);
                this.count = newLength | Integer.MIN_VALUE;
            }
        } else {
            if (newLength > currentCapacity) {
                this.ensureCapacityImpl(newLength);
            }
            String.decompressedArrayCopy(chars, 0, this.value, currentLength, chars.length);
            this.count = newLength;
        }
        return this;
    }

    public synchronized StringBuffer append(char[] chars, int start, int length) {
        if (start >= 0 && 0 <= length && length <= chars.length - start) {
            int currentLength = this.lengthInternalUnsynchronized();
            int currentCapacity = this.capacityInternal();
            int newLength = currentLength + length;
            if (newLength < 0) {
                throw new OutOfMemoryError(Msg.getString("K0D01"));
            }
            if (String.COMPACT_STRINGS) {
                if (this.count >= 0 && String.canEncodeAsLatin1(chars, start, length)) {
                    if (newLength > currentCapacity) {
                        this.ensureCapacityImpl(newLength);
                    }
                    String.compress(chars, start, this.value, currentLength, length);
                    this.count = newLength;
                } else {
                    if (this.count >= 0) {
                        this.decompress(newLength, currentLength);
                    } else if (newLength > currentCapacity) {
                        this.ensureCapacityImpl(newLength);
                    }
                    String.decompressedArrayCopy(chars, start, this.value, currentLength, length);
                    this.count = newLength | Integer.MIN_VALUE;
                }
            } else {
                if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                String.decompressedArrayCopy(chars, start, this.value, currentLength, length);
                this.count = newLength;
            }
            return this;
        }
        throw new StringIndexOutOfBoundsException();
    }

    synchronized StringBuffer append(char[] chars, int start, int length, boolean compressed) {
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        int newLength = currentLength + length;
        if (newLength < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (String.COMPACT_STRINGS) {
            if (this.count >= 0 && compressed) {
                if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                String.compressedArrayCopy(chars, start, this.value, currentLength, length);
                this.count = newLength;
            } else {
                if (this.count >= 0) {
                    this.decompress(newLength, currentLength);
                } else if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                if (compressed) {
                    String.decompress(chars, start, this.value, currentLength, length);
                } else {
                    String.decompressedArrayCopy(chars, start, this.value, currentLength, length);
                }
                this.count = newLength | Integer.MIN_VALUE;
            }
        } else {
            if (newLength > currentCapacity) {
                this.ensureCapacityImpl(newLength);
            }
            if (compressed) {
                String.decompress(chars, start, this.value, currentLength, length);
            } else {
                String.decompressedArrayCopy(chars, start, this.value, currentLength, length);
            }
            this.count = newLength;
        }
        return this;
    }

    @Override
    public synchronized StringBuffer append(char ch) {
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        int newLength = currentLength + 1;
        if (newLength < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (String.COMPACT_STRINGS) {
            if (this.count >= 0 && ch <= '\u00ff') {
                if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                helpers.putByteInArrayByIndex(this.value, currentLength, (byte)ch);
                this.count = newLength;
            } else {
                if (this.count >= 0) {
                    this.decompress(newLength, currentLength);
                } else if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                this.value[currentLength] = ch;
                this.count = newLength | Integer.MIN_VALUE;
            }
        } else {
            if (newLength > currentCapacity) {
                this.ensureCapacityImpl(newLength);
            }
            this.value[currentLength] = ch;
            this.count = newLength;
        }
        return this;
    }

    public StringBuffer append(double value) {
        return this.append(String.valueOf(value));
    }

    public StringBuffer append(float value) {
        return this.append(String.valueOf(value));
    }

    public synchronized StringBuffer append(int value) {
        if (value != Integer.MIN_VALUE) {
            if (String.COMPACT_STRINGS && this.count >= 0) {
                return this.append(Integer.toString(value));
            }
            int currentLength = this.lengthInternalUnsynchronized();
            int currentCapacity = this.capacityInternal();
            int valueLength = value < 0 ? Integer.stringSize(-value) + 1 : Integer.stringSize(value);
            int newLength = currentLength + valueLength;
            if (newLength < 0) {
                throw new OutOfMemoryError(Msg.getString("K0D01"));
            }
            if (newLength > currentCapacity) {
                this.ensureCapacityImpl(newLength);
            }
            Integer.getChars((int)value, (int)newLength, (char[])this.value);
            this.count = String.COMPACT_STRINGS ? newLength | Integer.MIN_VALUE : newLength;
            return this;
        }
        return this.append("-2147483648");
    }

    public synchronized StringBuffer append(long value) {
        if (value != Long.MIN_VALUE) {
            if (String.COMPACT_STRINGS && this.count >= 0) {
                return this.append(Long.toString(value));
            }
            int currentLength = this.lengthInternalUnsynchronized();
            int currentCapacity = this.capacityInternal();
            int valueLength = value < 0L ? Long.stringSize(-value) + 1 : Long.stringSize(value);
            int newLength = currentLength + valueLength;
            if (newLength < 0) {
                throw new OutOfMemoryError(Msg.getString("K0D01"));
            }
            if (newLength > currentCapacity) {
                this.ensureCapacityImpl(newLength);
            }
            Long.getChars((long)value, (int)newLength, (char[])this.value);
            this.count = String.COMPACT_STRINGS ? newLength | Integer.MIN_VALUE : newLength;
            return this;
        }
        return this.append("-9223372036854775808");
    }

    public StringBuffer append(Object value) {
        return this.append(String.valueOf(value));
    }

    public synchronized StringBuffer append(String string) {
        if (string == null) {
            string = "null";
        }
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        int stringLength = string.lengthInternal();
        int newLength = currentLength + stringLength;
        if (newLength < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (String.COMPACT_STRINGS) {
            if (this.count >= 0 && string.isCompressed()) {
                if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                string.getBytes(0, stringLength, this.value, currentLength);
                this.count = newLength;
            } else {
                if (this.count >= 0) {
                    this.decompress(newLength, currentLength);
                } else if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                string.getCharsNoBoundChecks(0, stringLength, this.value, currentLength);
                this.count = newLength | Integer.MIN_VALUE;
            }
        } else {
            if (newLength > currentCapacity) {
                this.ensureCapacityImpl(newLength);
            }
            string.getCharsNoBoundChecks(0, stringLength, this.value, currentLength);
            this.count = newLength;
        }
        return this;
    }

    public StringBuffer append(boolean value) {
        return this.append(String.valueOf(value));
    }

    public int capacity() {
        return this.capacityInternal();
    }

    int capacityInternal() {
        return this.capacity & Integer.MAX_VALUE;
    }

    @Override
    public synchronized char charAt(int index) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (index >= 0 && index < currentLength) {
            if (String.COMPACT_STRINGS && this.count >= 0) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, index));
            }
            return this.value[index];
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public synchronized StringBuffer delete(int start, int end) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (start >= 0) {
            if (end > currentLength) {
                end = currentLength;
            }
            if (end > start) {
                int numberOfTailChars = currentLength - end;
                try {
                    if (this.capacity >= 0) {
                        if (numberOfTailChars > 0) {
                            if (String.COMPACT_STRINGS && this.count >= 0) {
                                String.compressedArrayCopy(this.value, end, this.value, start, numberOfTailChars);
                            } else {
                                String.decompressedArrayCopy(this.value, end, this.value, start, numberOfTailChars);
                            }
                        }
                    } else {
                        char[] newData = new char[this.value.length];
                        if (String.COMPACT_STRINGS && this.count >= 0) {
                            if (start > 0) {
                                String.compressedArrayCopy(this.value, 0, newData, 0, start);
                            }
                            if (numberOfTailChars > 0) {
                                String.compressedArrayCopy(this.value, end, newData, start, numberOfTailChars);
                            }
                        } else {
                            if (start > 0) {
                                String.decompressedArrayCopy(this.value, 0, newData, 0, start);
                            }
                            if (numberOfTailChars > 0) {
                                String.decompressedArrayCopy(this.value, end, newData, start, numberOfTailChars);
                            }
                        }
                        this.value = newData;
                        this.capacity &= Integer.MAX_VALUE;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw new StringIndexOutOfBoundsException();
                }
                if (String.COMPACT_STRINGS) {
                    if (this.count >= 0) {
                        this.count = currentLength - (end - start);
                    } else {
                        this.count = currentLength - (end - start) | Integer.MIN_VALUE;
                        String.initCompressionFlag();
                    }
                } else {
                    this.count = currentLength - (end - start);
                }
                return this;
            }
            if (start == end) {
                return this;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer deleteCharAt(int location) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (0 <= location && location < currentLength) {
            return this.delete(location, location + 1);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized void ensureCapacity(int min) {
        int currentCapacity = this.capacityInternal();
        if (min > currentCapacity) {
            this.ensureCapacityImpl(min);
        }
    }

    private void ensureCapacityImpl(int min) {
        int newLength;
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        int newCapacity = (currentCapacity << 1) + 2;
        if (growAggressively && newCapacity < currentCapacity) {
            newCapacity = Integer.MAX_VALUE;
        }
        int n = newLength = min > newCapacity ? min : newCapacity;
        if (String.COMPACT_STRINGS && this.count >= 0) {
            char[] newData = new char[newLength + 1 >>> 1];
            String.compressedArrayCopy(this.value, 0, newData, 0, currentLength);
            this.value = newData;
        } else {
            char[] newData = new char[newLength];
            String.decompressedArrayCopy(this.value, 0, newData, 0, currentLength);
            this.value = newData;
        }
        this.capacity = newLength;
    }

    public synchronized void getChars(int start, int end, char[] buffer, int index) {
        try {
            int currentLength = this.lengthInternalUnsynchronized();
            if (start <= currentLength && end <= currentLength && start >= 0 && start <= end && index >= 0 && end - start <= buffer.length - index) {
                if (String.COMPACT_STRINGS && this.count >= 0) {
                    String.decompress(this.value, start, buffer, index, end - start);
                    return;
                }
                System.arraycopy((Object)this.value, start, (Object)buffer, index, end - start);
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer insert(int index, char[] chars) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (0 <= index && index <= currentLength) {
            int newLength = currentLength + chars.length;
            this.move(chars.length, index);
            if (String.COMPACT_STRINGS) {
                if (this.count >= 0 && String.canEncodeAsLatin1(chars, 0, chars.length)) {
                    String.compress(chars, 0, this.value, index, chars.length);
                    this.count = newLength;
                    return this;
                }
                if (this.count >= 0) {
                    this.decompress(newLength, newLength);
                }
                String.decompressedArrayCopy(chars, 0, this.value, index, chars.length);
                this.count = newLength | Integer.MIN_VALUE;
                return this;
            }
            String.decompressedArrayCopy(chars, 0, this.value, index, chars.length);
            this.count = newLength;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public synchronized StringBuffer insert(int index, char[] chars, int start, int length) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (0 <= index && index <= currentLength) {
            if (start >= 0 && 0 <= length && length <= chars.length - start) {
                int newLength = currentLength + length;
                this.move(length, index);
                if (String.COMPACT_STRINGS) {
                    if (this.count >= 0 && String.canEncodeAsLatin1(chars, start, length)) {
                        String.compress(chars, start, this.value, index, length);
                        this.count = newLength;
                        return this;
                    }
                    if (this.count >= 0) {
                        this.decompress(newLength, newLength);
                    }
                    String.decompressedArrayCopy(chars, start, this.value, index, length);
                    this.count = newLength | Integer.MIN_VALUE;
                    return this;
                }
                String.decompressedArrayCopy(chars, start, this.value, index, length);
                this.count = newLength;
                return this;
            }
            throw new StringIndexOutOfBoundsException();
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    synchronized StringBuffer insert(int index, char[] chars, int start, int length, boolean compressed) {
        int currentLength = this.lengthInternalUnsynchronized();
        int newLength = currentLength + length;
        this.move(length, index);
        if (String.COMPACT_STRINGS) {
            if (this.count >= 0 && compressed) {
                String.compressedArrayCopy(chars, start, this.value, index, length);
                this.count = newLength;
                return this;
            }
            if (this.count >= 0) {
                this.decompress(newLength, newLength);
            }
            String.decompressedArrayCopy(chars, start, this.value, index, length);
            this.count = newLength | Integer.MIN_VALUE;
            return this;
        }
        String.decompressedArrayCopy(chars, start, this.value, index, length);
        this.count = newLength;
        return this;
    }

    public synchronized StringBuffer insert(int index, char ch) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (0 <= index && index <= currentLength) {
            int newLength = currentLength + 1;
            this.move(1, index);
            if (String.COMPACT_STRINGS) {
                if (this.count >= 0 && ch <= '\u00ff') {
                    helpers.putByteInArrayByIndex(this.value, index, (byte)ch);
                    this.count = newLength;
                    return this;
                }
                if (this.count >= 0) {
                    this.decompress(newLength, newLength);
                }
                this.value[index] = ch;
                this.count = newLength | Integer.MIN_VALUE;
                return this;
            }
            this.value[index] = ch;
            this.count = newLength;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuffer insert(int index, double value) {
        return this.insert(index, String.valueOf(value));
    }

    public StringBuffer insert(int index, float value) {
        return this.insert(index, String.valueOf(value));
    }

    public StringBuffer insert(int index, int value) {
        return this.insert(index, Integer.toString(value));
    }

    public StringBuffer insert(int index, long value) {
        return this.insert(index, Long.toString(value));
    }

    public StringBuffer insert(int index, Object value) {
        return this.insert(index, String.valueOf(value));
    }

    public synchronized StringBuffer insert(int index, String string) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (0 <= index && index <= currentLength) {
            if (string == null) {
                string = "null";
            }
            int stringLength = string.lengthInternal();
            int newLength = currentLength + stringLength;
            this.move(stringLength, index);
            if (String.COMPACT_STRINGS) {
                if (this.count >= 0 && string.isCompressed()) {
                    string.getBytes(0, stringLength, this.value, index);
                    this.count = newLength;
                    return this;
                }
                if (this.count >= 0) {
                    this.decompress(newLength, newLength);
                }
                string.getCharsNoBoundChecks(0, stringLength, this.value, index);
                this.count = newLength | Integer.MIN_VALUE;
                return this;
            }
            string.getCharsNoBoundChecks(0, stringLength, this.value, index);
            this.count = newLength;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuffer insert(int index, boolean value) {
        return this.insert(index, String.valueOf(value));
    }

    @Override
    public synchronized int length() {
        return this.lengthInternalUnsynchronized();
    }

    private int lengthInternalUnsynchronized() {
        if (String.COMPACT_STRINGS) {
            if (this.count >= 0) {
                return this.count;
            }
            return this.count & Integer.MAX_VALUE;
        }
        return this.count;
    }

    private void move(int size, int index) {
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        if (String.COMPACT_STRINGS && this.count >= 0) {
            int newLength;
            if (currentCapacity - currentLength >= size) {
                if (this.capacity >= 0) {
                    String.compressedArrayCopy(this.value, index, this.value, index + size, currentLength - index);
                    return;
                }
                newLength = currentCapacity;
            } else {
                newLength = Integer.max(currentLength + size, (currentCapacity << 1) + 2);
                if (newLength < 0) {
                    throw new OutOfMemoryError(Msg.getString("K0D01"));
                }
            }
            char[] newData = new char[newLength + 1 >>> 1];
            String.compressedArrayCopy(this.value, 0, newData, 0, index);
            String.compressedArrayCopy(this.value, index, newData, index + size, currentLength - index);
            this.value = newData;
            this.capacity = newLength;
        } else {
            int newLength;
            if (currentCapacity - currentLength >= size) {
                if (this.capacity >= 0) {
                    String.decompressedArrayCopy(this.value, index, this.value, index + size, currentLength - index);
                    return;
                }
                newLength = currentCapacity;
            } else {
                newLength = Integer.max(currentLength + size, (currentCapacity << 1) + 2);
                if (newLength < 0) {
                    throw new OutOfMemoryError(Msg.getString("K0D01"));
                }
            }
            char[] newData = new char[newLength];
            String.decompressedArrayCopy(this.value, 0, newData, 0, index);
            String.decompressedArrayCopy(this.value, index, newData, index + size, currentLength - index);
            this.value = newData;
            this.capacity = newLength;
        }
    }

    public synchronized StringBuffer replace(int start, int end, String string) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (end > currentLength) {
            end = currentLength;
        }
        if (String.COMPACT_STRINGS) {
            if (this.count >= 0 && string.isCompressed()) {
                if (start >= 0) {
                    if (end > start) {
                        int size = string.lengthInternal();
                        int difference = end - start - size;
                        if (difference > 0) {
                            if (this.capacity >= 0) {
                                String.compressedArrayCopy(this.value, end, this.value, start + size, currentLength - end);
                            } else {
                                char[] newData = new char[this.value.length];
                                String.compressedArrayCopy(this.value, 0, newData, 0, start);
                                String.compressedArrayCopy(this.value, end, newData, start + size, currentLength - end);
                                this.value = newData;
                                this.capacity &= Integer.MAX_VALUE;
                            }
                        } else if (difference < 0) {
                            this.move(-difference, end);
                        } else if (this.capacity < 0) {
                            this.value = (char[])this.value.clone();
                            this.capacity &= Integer.MAX_VALUE;
                        }
                        string.getBytes(0, size, this.value, start);
                        this.count = currentLength - difference;
                        return this;
                    }
                    if (start == end) {
                        return this.insert(start, string);
                    }
                }
            } else if (start >= 0) {
                int size = string.lengthInternal();
                int difference = end - start - size;
                if (this.count >= 0) {
                    this.decompress(currentLength - difference, currentLength);
                }
                if (end > start) {
                    if (difference > 0) {
                        if (this.capacity >= 0) {
                            String.decompressedArrayCopy(this.value, end, this.value, start + size, currentLength - end);
                        } else {
                            char[] newData = new char[this.value.length];
                            String.decompressedArrayCopy(this.value, 0, newData, 0, start);
                            String.decompressedArrayCopy(this.value, end, newData, start + size, currentLength - end);
                            this.value = newData;
                            this.capacity &= Integer.MAX_VALUE;
                        }
                    } else if (difference < 0) {
                        this.move(-difference, end);
                    } else if (this.capacity < 0) {
                        this.value = (char[])this.value.clone();
                        this.capacity &= Integer.MAX_VALUE;
                    }
                    string.getCharsNoBoundChecks(0, size, this.value, start);
                    this.count = currentLength - difference | Integer.MIN_VALUE;
                    return this;
                }
                if (start == end) {
                    string.getClass();
                    return this.insert(start, string);
                }
            }
        } else if (start >= 0) {
            if (end > start) {
                int size = string.lengthInternal();
                int difference = end - start - size;
                if (difference > 0) {
                    if (this.capacity >= 0) {
                        String.decompressedArrayCopy(this.value, end, this.value, start + size, currentLength - end);
                    } else {
                        char[] newData = new char[this.value.length];
                        String.decompressedArrayCopy(this.value, 0, newData, 0, start);
                        String.decompressedArrayCopy(this.value, end, newData, start + size, currentLength - end);
                        this.value = newData;
                        this.capacity &= Integer.MAX_VALUE;
                    }
                } else if (difference < 0) {
                    this.move(-difference, end);
                } else if (this.capacity < 0) {
                    this.value = (char[])this.value.clone();
                    this.capacity &= Integer.MAX_VALUE;
                }
                string.getCharsNoBoundChecks(0, size, this.value, start);
                this.count = currentLength - difference;
                return this;
            }
            if (start == end) {
                string.getClass();
                return this.insert(start, string);
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer reverse() {
        int currentLength = this.lengthInternalUnsynchronized();
        if (currentLength < 2) {
            return this;
        }
        if (String.COMPACT_STRINGS && this.count >= 0) {
            if (this.capacity >= 0) {
                int i = 0;
                int mid = currentLength / 2;
                int j = currentLength - 1;
                while (i < mid) {
                    byte a = helpers.getByteFromArrayByIndex(this.value, i);
                    byte b = helpers.getByteFromArrayByIndex(this.value, j);
                    helpers.putByteInArrayByIndex(this.value, i, b);
                    helpers.putByteInArrayByIndex(this.value, j, a);
                    ++i;
                    --j;
                }
                return this;
            }
            char[] newData = new char[this.value.length];
            int i = 0;
            int j = currentLength - 1;
            while (i < currentLength) {
                helpers.putByteInArrayByIndex(newData, j, helpers.getByteFromArrayByIndex(this.value, i));
                ++i;
                --j;
            }
            this.value = newData;
            this.capacity &= Integer.MAX_VALUE;
            return this;
        }
        if (this.capacity >= 0) {
            int end = currentLength - 1;
            char frontHigh = this.value[0];
            char endLow = this.value[end];
            boolean allowFrontSur = true;
            boolean allowEndSur = true;
            int i = 0;
            int mid = currentLength / 2;
            while (i < mid) {
                char frontLow = this.value[i + 1];
                char endHigh = this.value[end - 1];
                boolean surAtFront = false;
                boolean surAtEnd = false;
                if (allowFrontSur && frontLow >= '\udc00' && frontLow <= '\udfff' && frontHigh >= '\ud800' && frontHigh <= '\udbff') {
                    surAtFront = true;
                    if (currentLength < 3) {
                        return this;
                    }
                }
                if (allowEndSur && endHigh >= '\ud800' && endHigh <= '\udbff' && endLow >= '\udc00' && endLow <= '\udfff') {
                    surAtEnd = true;
                }
                allowFrontSur = true;
                allowEndSur = true;
                if (surAtFront == surAtEnd) {
                    if (surAtFront) {
                        this.value[end] = frontLow;
                        this.value[end - 1] = frontHigh;
                        this.value[i] = endHigh;
                        this.value[i + 1] = endLow;
                        frontHigh = this.value[i + 2];
                        endLow = this.value[end - 2];
                        ++i;
                        --end;
                    } else {
                        this.value[end] = frontHigh;
                        this.value[i] = endLow;
                        frontHigh = frontLow;
                        endLow = endHigh;
                    }
                } else if (surAtFront) {
                    this.value[end] = frontLow;
                    this.value[i] = endLow;
                    endLow = endHigh;
                    allowFrontSur = false;
                } else {
                    this.value[end] = frontHigh;
                    this.value[i] = endHigh;
                    frontHigh = frontLow;
                    allowEndSur = false;
                }
                ++i;
                --end;
            }
            if (!((currentLength & 1) != 1 || allowFrontSur && allowEndSur)) {
                this.value[end] = allowFrontSur ? endLow : frontHigh;
            }
        } else {
            char[] newData = new char[this.value.length];
            int end = currentLength;
            for (int i = 0; i < currentLength; ++i) {
                char low;
                char high = this.value[i];
                if (i + 1 < currentLength && high >= '\ud800' && high <= '\udbff' && (low = this.value[i + 1]) >= '\udc00' && low <= '\udfff') {
                    newData[--end] = low;
                    ++i;
                }
                newData[--end] = high;
            }
            this.value = newData;
            this.capacity &= Integer.MAX_VALUE;
        }
        return this;
    }

    public synchronized void setCharAt(int index, char ch) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (0 <= index && index < currentLength) {
            if (String.COMPACT_STRINGS) {
                if (this.count >= 0 && ch <= '\u00ff') {
                    if (this.capacity < 0) {
                        this.value = (char[])this.value.clone();
                        this.capacity &= Integer.MAX_VALUE;
                    }
                    helpers.putByteInArrayByIndex(this.value, index, (byte)ch);
                } else {
                    if (this.count >= 0) {
                        this.decompress(currentLength, currentLength);
                    }
                    if (this.capacity < 0) {
                        this.value = (char[])this.value.clone();
                        this.capacity &= Integer.MAX_VALUE;
                    }
                    this.value[index] = ch;
                }
            } else {
                if (this.capacity < 0) {
                    this.value = (char[])this.value.clone();
                    this.capacity &= Integer.MAX_VALUE;
                }
                this.value[index] = ch;
            }
        } else {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    public synchronized void setLength(int length) {
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        if (String.COMPACT_STRINGS && this.count >= 0) {
            if (length > currentCapacity) {
                this.ensureCapacityImpl(length);
            } else if (length > currentLength) {
                for (int i = currentLength; i < length; ++i) {
                    helpers.putByteInArrayByIndex(this.value, i, (byte)0);
                }
            } else if (this.capacity < 0) {
                if (length < 0) {
                    throw new IndexOutOfBoundsException();
                }
                char[] newData = new char[this.value.length];
                if (length > 0) {
                    String.compressedArrayCopy(this.value, 0, newData, 0, length);
                }
                this.value = newData;
                this.capacity &= Integer.MAX_VALUE;
            } else if (length < 0) {
                throw new IndexOutOfBoundsException();
            }
        } else if (length > currentCapacity) {
            this.ensureCapacityImpl(length);
        } else if (length > currentLength) {
            Arrays.fill(this.value, currentLength, length, '\u0000');
        } else if (this.capacity < 0) {
            if (length < 0) {
                throw new IndexOutOfBoundsException();
            }
            char[] newData = new char[this.value.length];
            if (length > 0) {
                String.decompressedArrayCopy(this.value, 0, newData, 0, length);
            }
            this.value = newData;
            this.capacity &= Integer.MAX_VALUE;
        } else if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.count = String.COMPACT_STRINGS ? (this.count >= 0 ? length : length | Integer.MIN_VALUE) : length;
    }

    public synchronized String substring(int start) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (String.COMPACT_STRINGS && this.count >= 0) {
            if (0 <= start && start <= currentLength) {
                return new String(this.value, start, currentLength - start, true, false);
            }
        } else if (0 <= start && start <= currentLength) {
            return new String(this.value, start, currentLength - start, false, false);
        }
        throw new StringIndexOutOfBoundsException(start);
    }

    public synchronized String substring(int start, int end) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (String.COMPACT_STRINGS && this.count >= 0) {
            if (0 <= start && start <= end && end <= currentLength) {
                return new String(this.value, start, end - start, true, false);
            }
        } else if (0 <= start && start <= end && end <= currentLength) {
            return new String(this.value, start, end - start, false, false);
        }
        throw new StringIndexOutOfBoundsException();
    }

    static void initFromSystemProperties(Properties props) {
        String prop = props.getProperty("java.lang.string.create.unique");
        TOSTRING_COPY_BUFFER_ENABLED = "true".equals(prop) || "StringBuffer".equals(prop);
        String growAggressivelyProperty = props.getProperty("java.lang.stringBuffer.growAggressively", "");
        growAggressively = "".equals(growAggressivelyProperty) || Boolean.parseBoolean(growAggressivelyProperty);
    }

    @Override
    public synchronized String toString() {
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        if (!TOSTRING_COPY_BUFFER_ENABLED) {
            int wasted = currentCapacity - currentLength;
            if (wasted >= 768 || wasted >= 16 && wasted >= currentCapacity >> 1) {
                if (String.COMPACT_STRINGS && this.count >= 0) {
                    return new String(this.value, 0, currentLength, true, false);
                }
                return new String(this.value, 0, currentLength, false, false);
            }
        } else {
            int roundedCount = currentLength + 3 & 0xFFFFFFFC;
            if (roundedCount < currentCapacity) {
                if (String.COMPACT_STRINGS && this.count >= 0) {
                    return new String(this.value, 0, currentLength, true, false);
                }
                return new String(this.value, 0, currentLength, false, false);
            }
        }
        this.capacity |= Integer.MIN_VALUE;
        if (String.COMPACT_STRINGS && this.count >= 0) {
            return new String(this.value, 0, currentLength, true);
        }
        return new String(this.value, 0, currentLength, false);
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        int currentLength = this.lengthInternalUnsynchronized();
        ObjectOutputStream.PutField pf = stream.putFields();
        pf.put("count", currentLength);
        if (String.COMPACT_STRINGS && this.count >= 0) {
            char[] newData = new char[currentLength];
            String.decompress(this.value, 0, newData, 0, currentLength);
            pf.put("value", newData);
        } else {
            pf.put("value", this.value);
        }
        pf.put("shared", false);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = stream.readFields();
        int streamCount = gf.get("count", 0);
        char[] streamValue = (char[])gf.get("value", null);
        if (streamCount < 0 || streamCount > streamValue.length) {
            throw new StreamCorruptedException(Msg.getString("K0199"));
        }
        if (String.COMPACT_STRINGS) {
            if (String.canEncodeAsLatin1(streamValue, 0, streamValue.length)) {
                this.value = new char[streamValue.length + 1 >>> 1];
                String.compress(streamValue, 0, this.value, 0, streamValue.length);
                this.count = streamCount;
                this.capacity = streamValue.length;
            } else {
                this.value = new char[streamValue.length];
                System.arraycopy((Object)streamValue, 0, (Object)this.value, 0, streamValue.length);
                this.count = streamCount | Integer.MIN_VALUE;
                this.capacity = streamValue.length;
                String.initCompressionFlag();
            }
        } else {
            this.value = new char[streamValue.length];
            System.arraycopy((Object)streamValue, 0, (Object)this.value, 0, streamValue.length);
            this.count = streamCount;
            this.capacity = streamValue.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer append(StringBuffer buffer) {
        if (buffer == null) {
            return this.append((String)null);
        }
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            if (String.COMPACT_STRINGS && buffer.count >= 0) {
                return this.append(buffer.value, 0, buffer.lengthInternalUnsynchronized(), true);
            }
            return this.append(buffer.value, 0, buffer.lengthInternalUnsynchronized(), false);
        }
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public synchronized int indexOf(String subString, int start) {
        int subStringLength;
        int currentLength = this.lengthInternalUnsynchronized();
        if (start < 0) {
            start = 0;
        }
        if ((subStringLength = subString.lengthInternal()) > 0) {
            if (subStringLength + start > currentLength) {
                return -1;
            }
            char firstChar = subString.charAtInternal(0);
            if (String.COMPACT_STRINGS && this.count >= 0) {
                if (!subString.isCompressed()) {
                    return -1;
                }
                while (true) {
                    int i;
                    boolean found = false;
                    for (i = start; i < currentLength; ++i) {
                        if (helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, i)) != firstChar) continue;
                        found = true;
                        break;
                    }
                    if (!found || subStringLength + i > currentLength) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < subStringLength && helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, ++o1)) == subString.charAtInternal(o2)) {
                    }
                    if (o2 == subStringLength) {
                        return i;
                    }
                    start = i + 1;
                }
            }
            while (true) {
                int i;
                boolean found = false;
                for (i = start; i < currentLength; ++i) {
                    if (this.value[i] != firstChar) continue;
                    found = true;
                    break;
                }
                if (!found || subStringLength + i > currentLength) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subStringLength && this.value[++o1] == subString.charAtInternal(o2)) {
                }
                if (o2 == subStringLength) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < currentLength || start == 0 ? start : currentLength;
    }

    public synchronized int lastIndexOf(String string) {
        int currentLength = this.lengthInternalUnsynchronized();
        return this.lastIndexOf(string, currentLength);
    }

    public synchronized int lastIndexOf(String subString, int start) {
        int currentLength = this.lengthInternalUnsynchronized();
        int subStringLength = subString.lengthInternal();
        if (subStringLength <= currentLength && start >= 0) {
            if (subStringLength > 0) {
                if (start > currentLength - subStringLength) {
                    start = currentLength - subStringLength;
                }
                char firstChar = subString.charAtInternal(0);
                if (String.COMPACT_STRINGS && this.count >= 0) {
                    if (!subString.isCompressed()) {
                        return -1;
                    }
                    while (true) {
                        int i;
                        boolean found = false;
                        for (i = start; i >= 0; --i) {
                            if (helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, i)) != firstChar) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            return -1;
                        }
                        int o1 = i;
                        int o2 = 0;
                        while (++o2 < subStringLength && helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, ++o1)) == subString.charAtInternal(o2)) {
                        }
                        if (o2 == subStringLength) {
                            return i;
                        }
                        start = i - 1;
                    }
                }
                while (true) {
                    int i;
                    boolean found = false;
                    for (i = start; i >= 0; --i) {
                        if (this.value[i] != firstChar) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < subStringLength && this.value[++o1] == subString.charAtInternal(o2)) {
                    }
                    if (o2 == subStringLength) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < currentLength ? start : currentLength;
        }
        return -1;
    }

    char[] shareValue() {
        this.capacity |= Integer.MIN_VALUE;
        return this.value;
    }

    boolean isCompressed() {
        return String.COMPACT_STRINGS && this.count >= 0;
    }

    public StringBuffer(CharSequence sequence) {
        int newLength;
        int size = sequence.length();
        if (size < 0) {
            size = 0;
        }
        if ((newLength = 16 + size) < size) {
            newLength = size;
        }
        this.value = String.COMPACT_STRINGS ? new char[newLength + 1 >>> 1] : new char[newLength];
        this.capacity = newLength;
        if (sequence instanceof String) {
            this.append((String)sequence);
        } else if (sequence instanceof StringBuffer) {
            this.append((StringBuffer)sequence);
        } else if (String.COMPACT_STRINGS) {
            int i;
            boolean isCompressed = true;
            for (i = 0; i < size; ++i) {
                if (sequence.charAt(i) <= '\u00ff') continue;
                isCompressed = false;
                break;
            }
            if (isCompressed) {
                this.count = size;
                for (i = 0; i < size; ++i) {
                    helpers.putByteInArrayByIndex(this.value, i, (byte)sequence.charAt(i));
                }
            } else {
                this.value = new char[newLength];
                this.count = size | Integer.MIN_VALUE;
                for (i = 0; i < size; ++i) {
                    this.value[i] = sequence.charAt(i);
                }
                String.initCompressionFlag();
            }
        } else {
            this.count = size;
            for (int i = 0; i < size; ++i) {
                this.value[i] = sequence.charAt(i);
            }
        }
    }

    @Override
    public synchronized StringBuffer append(CharSequence sequence) {
        if (sequence == null) {
            return this.append(String.valueOf(sequence));
        }
        if (sequence instanceof String) {
            return this.append((String)sequence);
        }
        if (sequence instanceof StringBuffer) {
            return this.append((StringBuffer)sequence);
        }
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        int sequenceLength = sequence.length();
        int newLength = currentLength + sequenceLength;
        if (newLength < 0) {
            throw new OutOfMemoryError(Msg.getString("K0D01"));
        }
        if (String.COMPACT_STRINGS) {
            int i;
            boolean isCompressed = true;
            if (this.count >= 0) {
                for (i = 0; i < sequence.length(); ++i) {
                    if (sequence.charAt(i) <= '\u00ff') continue;
                    isCompressed = false;
                    break;
                }
            }
            if (this.count >= 0 && isCompressed) {
                if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                for (i = 0; i < sequence.length(); ++i) {
                    helpers.putByteInArrayByIndex(this.value, currentLength + i, (byte)sequence.charAt(i));
                }
                this.count = newLength;
            } else {
                if (this.count >= 0) {
                    this.decompress(newLength, currentLength);
                } else if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                for (i = 0; i < sequence.length(); ++i) {
                    this.value[currentLength + i] = sequence.charAt(i);
                }
                this.count = newLength | Integer.MIN_VALUE;
            }
        } else {
            if (newLength > currentCapacity) {
                this.ensureCapacityImpl(newLength);
            }
            for (int i = 0; i < sequence.length(); ++i) {
                this.value[currentLength + i] = sequence.charAt(i);
            }
            this.count = newLength;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized StringBuffer append(CharSequence sequence, int start, int end) {
        if (sequence == null) {
            return this.append(String.valueOf(sequence), start, end);
        }
        if (sequence instanceof String) {
            return this.append(((String)sequence).substring(start, end));
        }
        if (start >= 0 && end >= 0 && start <= end && end <= sequence.length()) {
            if (sequence instanceof StringBuffer) {
                CharSequence charSequence = sequence;
                synchronized (charSequence) {
                    StringBuffer buffer = (StringBuffer)sequence;
                    if (String.COMPACT_STRINGS && buffer.count >= 0) {
                        return this.append(buffer.value, start, end - start, true);
                    }
                    return this.append(buffer.value, start, end - start, false);
                }
            }
            if (sequence instanceof StringBuilder) {
                CharSequence charSequence = sequence;
                synchronized (charSequence) {
                    StringBuilder builder = (StringBuilder)sequence;
                    if (String.COMPACT_STRINGS && builder.isCompressed()) {
                        return this.append(builder.getValue(), start, end - start, true);
                    }
                    return this.append(builder.getValue(), start, end - start, false);
                }
            }
            int currentLength = this.lengthInternalUnsynchronized();
            int currentCapacity = this.capacityInternal();
            int newLength = currentLength + end - start;
            if (newLength < 0) {
                throw new OutOfMemoryError(Msg.getString("K0D01"));
            }
            if (String.COMPACT_STRINGS) {
                int i;
                boolean isCompressed = true;
                if (this.count >= 0) {
                    for (i = 0; i < sequence.length(); ++i) {
                        if (sequence.charAt(i) <= '\u00ff') continue;
                        isCompressed = false;
                        break;
                    }
                }
                if (this.count >= 0 && isCompressed) {
                    if (newLength > currentCapacity) {
                        this.ensureCapacityImpl(newLength);
                    }
                    for (i = 0; i < end - start; ++i) {
                        helpers.putByteInArrayByIndex(this.value, currentLength + i, (byte)sequence.charAt(start + i));
                    }
                    this.count = newLength;
                } else {
                    if (this.count >= 0) {
                        this.decompress(newLength, currentLength);
                    }
                    if (newLength > currentCapacity) {
                        this.ensureCapacityImpl(newLength);
                    }
                    for (i = 0; i < end - start; ++i) {
                        this.value[currentLength + i] = sequence.charAt(start + i);
                    }
                    this.count = newLength | Integer.MIN_VALUE;
                }
            } else {
                if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                for (int i = 0; i < end - start; ++i) {
                    this.value[currentLength + i] = sequence.charAt(start + i);
                }
                this.count = newLength;
            }
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer insert(int index, CharSequence sequence) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (index >= 0 && index <= currentLength) {
            if (sequence == null) {
                return this.insert(index, String.valueOf(sequence));
            }
            if (sequence instanceof String) {
                return this.insert(index, (String)sequence);
            }
            if (sequence instanceof StringBuffer) {
                CharSequence charSequence = sequence;
                synchronized (charSequence) {
                    StringBuffer buffer = (StringBuffer)sequence;
                    if (String.COMPACT_STRINGS && buffer.count >= 0) {
                        return this.insert(index, buffer.value, 0, buffer.lengthInternalUnsynchronized(), true);
                    }
                    return this.insert(index, buffer.value, 0, buffer.lengthInternalUnsynchronized(), false);
                }
            }
            if (sequence instanceof StringBuilder) {
                CharSequence charSequence = sequence;
                synchronized (charSequence) {
                    StringBuilder builder = (StringBuilder)sequence;
                    if (String.COMPACT_STRINGS && builder.isCompressed()) {
                        return this.insert(index, builder.getValue(), 0, builder.lengthInternal(), true);
                    }
                    return this.insert(index, builder.getValue(), 0, builder.lengthInternal(), false);
                }
            }
            int sequenceLength = sequence.length();
            if (sequenceLength > 0) {
                this.move(sequenceLength, index);
                int newLength = currentLength + sequenceLength;
                if (String.COMPACT_STRINGS) {
                    int i;
                    boolean isCompressed = true;
                    for (i = 0; i < sequenceLength; ++i) {
                        if (sequence.charAt(i) <= '\u00ff') continue;
                        isCompressed = false;
                        break;
                    }
                    if (this.count >= 0 && isCompressed) {
                        for (i = 0; i < sequenceLength; ++i) {
                            helpers.putByteInArrayByIndex(this.value, index + i, (byte)sequence.charAt(i));
                        }
                        this.count = newLength;
                        return this;
                    }
                    if (this.count >= 0) {
                        this.decompress(newLength, newLength);
                    }
                    for (i = 0; i < sequenceLength; ++i) {
                        this.value[index + i] = sequence.charAt(i);
                    }
                    this.count = newLength | Integer.MIN_VALUE;
                } else {
                    for (int i = 0; i < sequenceLength; ++i) {
                        this.value[index + i] = sequence.charAt(i);
                    }
                    this.count = newLength;
                }
            }
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer insert(int index, CharSequence sequence, int start, int end) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (index >= 0 && index <= currentLength) {
            if (sequence == null) {
                return this.insert(index, String.valueOf(sequence), start, end);
            }
            if (sequence instanceof String) {
                return this.insert(index, ((String)sequence).substring(start, end));
            }
            if (start >= 0 && end >= 0 && start <= end && end <= sequence.length()) {
                if (sequence instanceof StringBuffer) {
                    CharSequence charSequence = sequence;
                    synchronized (charSequence) {
                        StringBuffer buffer = (StringBuffer)sequence;
                        if (String.COMPACT_STRINGS && buffer.count >= 0) {
                            return this.insert(index, buffer.value, start, end - start, true);
                        }
                        return this.insert(index, buffer.value, start, end - start, false);
                    }
                }
                if (sequence instanceof StringBuilder) {
                    CharSequence charSequence = sequence;
                    synchronized (charSequence) {
                        StringBuilder builder = (StringBuilder)sequence;
                        if (String.COMPACT_STRINGS && builder.isCompressed()) {
                            return this.insert(index, builder.getValue(), start, end - start, true);
                        }
                        return this.insert(index, builder.getValue(), start, end - start, false);
                    }
                }
                int sequenceLength = end - start;
                if (sequenceLength > 0) {
                    this.move(sequenceLength, index);
                    int newLength = currentLength + sequenceLength;
                    if (String.COMPACT_STRINGS) {
                        int i;
                        boolean isCompressed = true;
                        for (i = 0; i < sequenceLength; ++i) {
                            if (sequence.charAt(start + i) <= '\u00ff') continue;
                            isCompressed = false;
                            break;
                        }
                        if (this.count >= 0 && isCompressed) {
                            for (i = 0; i < sequenceLength; ++i) {
                                helpers.putByteInArrayByIndex(this.value, index + i, (byte)sequence.charAt(start + i));
                            }
                            this.count = newLength;
                            return this;
                        }
                        if (this.count >= 0) {
                            this.decompress(newLength, newLength);
                        }
                        for (i = 0; i < sequenceLength; ++i) {
                            this.value[index + i] = sequence.charAt(start + i);
                        }
                        this.count = newLength | Integer.MIN_VALUE;
                    } else {
                        for (int i = 0; i < sequenceLength; ++i) {
                            this.value[index + i] = sequence.charAt(start + i);
                        }
                        this.count = newLength;
                    }
                }
                return this;
            }
            throw new IndexOutOfBoundsException();
        }
        throw new IndexOutOfBoundsException();
    }

    public synchronized void trimToSize() {
        int currentLength = this.lengthInternalUnsynchronized();
        int currentCapacity = this.capacityInternal();
        if (String.COMPACT_STRINGS && this.count >= 0) {
            if (this.capacity >= 0 && currentCapacity != currentLength) {
                char[] newData = new char[(currentLength + 1) / 2];
                String.compressedArrayCopy(this.value, 0, newData, 0, currentLength);
                this.value = newData;
                this.capacity = currentLength;
            }
        } else if (this.capacity >= 0 && currentCapacity != currentLength) {
            char[] newData = new char[currentLength];
            String.decompressedArrayCopy(this.value, 0, newData, 0, currentLength);
            this.value = newData;
            this.capacity = currentLength;
        }
    }

    public synchronized int codePointAt(int index) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (index >= 0 && index < currentLength) {
            char low;
            if (String.COMPACT_STRINGS && this.count >= 0) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, index));
            }
            char high = this.value[index];
            if (index + 1 < currentLength && high >= '\ud800' && high <= '\udbff' && (low = this.value[index + 1]) >= '\udc00' && low <= '\udfff') {
                return 65536 + (high - 55296 << 10) + (low - 56320);
            }
            return high;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public synchronized int codePointBefore(int index) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (index > 0 && index <= currentLength) {
            char high;
            if (String.COMPACT_STRINGS && this.count >= 0) {
                return helpers.byteToCharUnsigned(helpers.getByteFromArrayByIndex(this.value, index - 1));
            }
            char low = this.value[index - 1];
            if (index > 1 && low >= '\udc00' && low <= '\udfff' && (high = this.value[index - 2]) >= '\ud800' && high <= '\udbff') {
                return 65536 + (high - 55296 << 10) + (low - 56320);
            }
            return low;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public synchronized int codePointCount(int start, int end) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (start >= 0 && start <= end && end <= currentLength) {
            if (String.COMPACT_STRINGS && this.count >= 0) {
                return end - start;
            }
            int count = 0;
            for (int i = start; i < end; ++i) {
                char low;
                char high = this.value[i];
                if (i + 1 < end && high >= '\ud800' && high <= '\udbff' && (low = this.value[i + 1]) >= '\udc00' && low <= '\udfff') {
                    ++i;
                }
                ++count;
            }
            return count;
        }
        throw new IndexOutOfBoundsException();
    }

    public synchronized int offsetByCodePoints(int start, int codePointCount) {
        int currentLength = this.lengthInternalUnsynchronized();
        if (start >= 0 && start <= currentLength) {
            if (String.COMPACT_STRINGS && this.count >= 0) {
                int index = start + codePointCount;
                if (index > currentLength || index < 0) {
                    throw new IndexOutOfBoundsException();
                }
                return index;
            }
            int index = start;
            if (codePointCount == 0) {
                return start;
            }
            if (codePointCount > 0) {
                for (int i = 0; i < codePointCount; ++i) {
                    char low;
                    if (index == currentLength) {
                        throw new IndexOutOfBoundsException();
                    }
                    char high = this.value[index];
                    if (index + 1 < currentLength && high >= '\ud800' && high <= '\udbff' && (low = this.value[index + 1]) >= '\udc00' && low <= '\udfff') {
                        ++index;
                    }
                    ++index;
                }
            } else {
                for (int i = codePointCount; i < 0; ++i) {
                    char high;
                    if (index < 1) {
                        throw new IndexOutOfBoundsException();
                    }
                    char low = this.value[index - 1];
                    if (index > 1 && low >= '\udc00' && low <= '\udfff' && (high = this.value[index - 2]) >= '\ud800' && high <= '\udbff') {
                        --index;
                    }
                    --index;
                }
            }
            return index;
        }
        throw new IndexOutOfBoundsException();
    }

    public synchronized StringBuffer appendCodePoint(int codePoint) {
        if (codePoint >= 0) {
            if (codePoint < 65536) {
                return this.append((char)codePoint);
            }
            if (codePoint < 0x110000) {
                int currentLength = this.lengthInternalUnsynchronized();
                int currentCapacity = this.capacityInternal();
                int newLength = currentLength + 2;
                if (newLength < 0) {
                    throw new OutOfMemoryError(Msg.getString("K0D01"));
                }
                if (String.COMPACT_STRINGS && this.count >= 0) {
                    this.decompress(newLength, currentLength);
                } else if (newLength > currentCapacity) {
                    this.ensureCapacityImpl(newLength);
                }
                this.value[currentLength] = (char)(55296 + ((codePoint -= 65536) >> 10));
                this.value[currentLength + 1] = (char)(56320 + (codePoint & 0x3FF));
                this.count = String.COMPACT_STRINGS ? newLength | Integer.MIN_VALUE : newLength;
                return this;
            }
        }
        throw new IllegalArgumentException();
    }

    char[] getValue() {
        return this.value;
    }
}

