/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementUtils;
import java.lang.management.MemoryUsage;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public final class MemoryUsageUtil {
    private static CompositeType compositeType;
    private static CompositeType tabularRowType;
    private static TabularType tabularType;

    public static CompositeType getCompositeType() {
        block3: {
            if (compositeType == null) {
                String[] names = new String[]{"init", "used", "committed", "max"};
                String[] descs = new String[]{"init", "used", "committed", "max"};
                OpenType[] types = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
                try {
                    compositeType = new CompositeType(MemoryUsage.class.getName(), MemoryUsage.class.getName(), names, descs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    private static CompositeType getTabularRowType() {
        block3: {
            if (null == tabularRowType) {
                String[] names = new String[]{"key", "value"};
                String[] descs = new String[]{"key", "value"};
                OpenType[] types = new OpenType[]{SimpleType.STRING, MemoryUsageUtil.getCompositeType()};
                try {
                    tabularRowType = new CompositeType("MemoryUsageKeyValue", "MemoryUsageKeyValue", names, descs, types);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return tabularRowType;
    }

    public static TabularType getTabularType() {
        block3: {
            if (null == tabularType) {
                CompositeType rowType = MemoryUsageUtil.getTabularRowType();
                try {
                    tabularType = new TabularType("Memory Usage Map", "Memory Usage Map", rowType, new String[]{"key"});
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return tabularType;
    }

    public static CompositeData toCompositeData(MemoryUsage usage) {
        CompositeDataSupport result;
        block3: {
            result = null;
            if (usage != null) {
                CompositeType type = MemoryUsageUtil.getCompositeType();
                String[] names = new String[]{"init", "used", "committed", "max"};
                Object[] values = new Object[]{usage.getInit(), usage.getUsed(), usage.getCommitted(), usage.getMax()};
                try {
                    result = new CompositeDataSupport(type, names, values);
                }
                catch (OpenDataException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return result;
    }

    public static TabularData toTabularData(Map<String, MemoryUsage> map) {
        TabularDataSupport table = null;
        if (null != map) {
            CompositeType type = MemoryUsageUtil.getTabularRowType();
            String[] names = new String[]{"key", "value"};
            table = new TabularDataSupport(MemoryUsageUtil.getTabularType());
            for (Map.Entry<String, MemoryUsage> entry : map.entrySet()) {
                CompositeDataSupport row;
                block4: {
                    Object[] values = new Object[]{entry.getKey(), MemoryUsageUtil.toCompositeData(entry.getValue())};
                    row = null;
                    try {
                        row = new CompositeDataSupport(type, names, values);
                    }
                    catch (OpenDataException e) {
                        if (!ManagementUtils.VERBOSE_MODE) break block4;
                        e.printStackTrace(System.err);
                    }
                }
                table.put(row);
            }
        }
        return table;
    }

    private MemoryUsageUtil() {
    }
}

