/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.MessageDigest;
import java.security.spec.KeySpec;
import java.util.Locale;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private static final long serialVersionUID = 6577238317307289933L;
    private byte[] key;
    private String algorithm;
    private static final String[] z;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecretKeySpec(byte[] byArray, String string) {
        if (byArray == null) throw new IllegalArgumentException(z[1]);
        if (string == null) {
            throw new IllegalArgumentException(z[1]);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException(z[0]);
        }
        this.key = (byte[])byArray.clone();
        this.algorithm = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecretKeySpec(byte[] byArray, int n, int n2, String string) {
        if (byArray == null) throw new IllegalArgumentException(z[12]);
        if (string == null) {
            throw new IllegalArgumentException(z[12]);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException(z[13]);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(z[10]);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(z[11]);
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException(z[9]);
        }
        this.key = new byte[n2];
        System.arraycopy(byArray, n, this.key, 0, n2);
        this.algorithm = string;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return z[6];
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.key.length; ++i) {
            n += this.key[i] * i;
        }
        if (this.algorithm.equalsIgnoreCase(z[14])) {
            return n ^= z[15].hashCode();
        }
        return n ^= this.algorithm.toLowerCase(Locale.ENGLISH).hashCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string = ((SecretKey)object).getAlgorithm();
        if (!(string.equalsIgnoreCase(this.algorithm) || string.equalsIgnoreCase(z[4]) && this.algorithm.equalsIgnoreCase(z[5]) || string.equalsIgnoreCase(z[3]) && this.algorithm.equalsIgnoreCase(z[2]))) {
            return false;
        }
        byte[] byArray = ((SecretKey)object).getEncoded();
        return MessageDigest.isEqual(this.key, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.key == null || this.algorithm == null) {
            throw new InvalidObjectException(z[7]);
        }
        this.key = (byte[])this.key.clone();
        if (this.key.length == 0) {
            throw new InvalidObjectException(z[8]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[16];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "]\u007f,J.8y9G";
        int n2 = -1;
        block23: while (true) {
            char[] cArray;
            block28: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block27: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block27;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block28;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 24;
                                break;
                            }
                            case 1: {
                                n8 = 18;
                                break;
                            }
                            case 2: {
                                n8 = 92;
                                break;
                            }
                            case 3: {
                                n8 = 62;
                                break;
                            }
                            default: {
                                n8 = 87;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "U{/M>vu|_%\u007fg1[9l";
                    n2 = 0;
                    continue block23;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\\W\u000f[3}";
                    n2 = 1;
                    continue block23;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "L`5N;}V\u0019m";
                    n2 = 2;
                    continue block23;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\\W\u000f[3}";
                    n2 = 3;
                    continue block23;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "L`5N;}V\u0019m";
                    n2 = 4;
                    continue block23;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "JS\u000b";
                    n2 = 5;
                    continue block23;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "U{/M>vu|_%\u007fg1[9l";
                    n2 = 6;
                    continue block23;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "Q|*_;qv|U2a20[9\u007ff4";
                    n2 = 7;
                    continue block23;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "Q|*_;qv|Q1~a9Jxtw2Y#p2?Q:z{2_#q}2";
                    n2 = 8;
                    continue block23;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "wt:M2l25Mwvw;_#qd9";
                    n2 = 9;
                    continue block23;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "tw2\u001e>k22[0yf5H2";
                    n2 = 10;
                    continue block23;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "U{/M>vu|_%\u007fg1[9l";
                    n2 = 11;
                    continue block23;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "]\u007f,J.8y9G";
                    n2 = 12;
                    continue block23;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "L`5N;}V\u0019m";
                    n2 = 13;
                    continue block23;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "|w/[3}";
                    n2 = 14;
                    continue block23;
                }
                case 14: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        z = stringArray3;
    }
}

