/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig;

import com.ibm.xml.crypto.spi.SignatureEngine;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAKey;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureEngineDSA
implements SignatureEngine {
    private Signature signature;
    private String uri;
    private int size;

    public SignatureEngineDSA(String u, Provider provider) throws NoSuchAlgorithmException {
        String alg = "SHA2withDSA";
        if (u.endsWith("sha1")) {
            alg = "SHA1withDSA";
        } else if (u.endsWith("256")) {
            alg = "SHA2withDSA";
        } else {
            throw new NoSuchAlgorithmException(u);
        }
        this.signature = provider == null ? Signature.getInstance(alg) : Signature.getInstance(alg, provider);
        this.uri = u;
    }

    @Override
    public void setParameter(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec != null) {
            throw new InvalidAlgorithmParameterException("This algorithm supports  no AlgorithmParameterSpec.");
        }
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public void initSign(Key key) throws InvalidKeyException {
        this.signature.initSign((PrivateKey)key);
        try {
            this.size = ((DSAKey)((Object)key)).getParams().getQ().bitLength();
        }
        catch (Exception e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    public void initVerify(Key key) throws InvalidKeyException {
        this.signature.initVerify((PublicKey)key);
        try {
            this.size = ((DSAKey)((Object)key)).getParams().getQ().bitLength();
        }
        catch (Exception e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    public void update(byte[] data) throws SignatureException {
        this.signature.update(data);
    }

    @Override
    public void update(byte[] data, int off, int len) throws SignatureException {
        this.signature.update(data, off, len);
    }

    @Override
    public byte[] sign() throws SignatureException {
        try {
            return JavaUtils.convertDsaASN1toXMLDSIG(this.signature.sign(), this.size / 8);
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public boolean verify(byte[] signature) throws SignatureException {
        try {
            return this.signature.verify(JavaUtils.convertDsaXMLDSIGtoASN1(signature, this.size / 8));
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }
}

