/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.orb;

import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.rmi.channel.orb.ORBChannelHelper;
import com.ibm.rmi.channel.orb.ORBServerCallLink;
import com.ibm.rmi.iiop.ORB;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundApplicationChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.HashMap;
import java.util.Map;

public class ORBServerChannel
extends InboundApplicationChannel
implements Discriminator {
    private ORBChannelHelper orbHelper = null;
    private ORB orb = null;
    private boolean isFVDChannel = false;

    public ORBServerChannel(ChannelData channelData) {
        super(channelData);
    }

    public ORBServerChannel(ORB oRB) {
        super(null);
        this.isFVDChannel = true;
        this.orb = oRB;
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof GIOPMessageContext) {
            return 1;
        }
        return 0;
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
    }

    public Class getDiscriminatoryDataType() {
        return GIOPMessageContext.class;
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.config.getDiscriminatorWeight();
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        return new ORBServerCallLink(virtualConnection, this.orbHelper);
    }

    public Class getDeviceInterface() {
        return GIOPConnectionContext.class;
    }

    public void update(ChannelData channelData) {
        Map map = channelData.getPropertyBag();
        map.put(ORBChannelHelper.ORB, this.orb);
        this.orbHelper = new ORBChannelHelper(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ChannelException {
        HashMap<String, ORB> hashMap = null;
        if (!this.isFVDChannel) {
            hashMap = this.getConfig().getPropertyBag();
            if (this.orb == null) {
                this.orb = (ORB)hashMap.get(ORBChannelHelper.ORB);
                GIOPChannelPlugin gIOPChannelPlugin = (GIOPChannelPlugin)this.orb.getPlugin(GIOPChannelPlugin.class.getName());
                gIOPChannelPlugin.registerAppChannel((Channel)this);
            } else {
                hashMap.put(ORBChannelHelper.ORB, this.orb);
            }
            this.orbHelper = new ORBChannelHelper(hashMap);
        } else {
            ORBServerChannel oRBServerChannel = this;
            synchronized (oRBServerChannel) {
                if (this.orbHelper == null) {
                    hashMap = new HashMap<String, ORB>();
                    hashMap.put(ORBChannelHelper.ORB, this.orb);
                    this.orbHelper = new ORBChannelHelper(hashMap);
                }
            }
        }
    }

    public void stop(long l) throws ChannelException {
    }

    public void init() throws ChannelException {
    }

    public void destroy() throws ChannelException {
    }
}

