/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.ras;

import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.PrintWriter;
import java.io.StringWriter;

public class HexFormatter {
    private static final String BUFFER_BREAK = ">>>>>>>>>>>>>>>> B U F F E R    B R E A K <<<<<<<<<<<<<<<<\n";
    private static final String CURSOR_BREAK = ">>>>>>>>>>>>>>>>>>>>>> C U R S O R <<<<<<<<<<<<<<<<<<<<<<<\n";
    private static final char[] HEX_LC = "0123456789abcdef".toCharArray();
    private static final char[] HEX_UC = "0123456789ABCDEF".toCharArray();
    private static final String WORD_SPACER = " ";
    private static final String SPACES = "                                    ";

    private static void writeByte(byte by, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        stringBuilder.append(HEX_LC[by >> 4 & 0xF]);
        stringBuilder.append(HEX_LC[by >> 0 & 0xF]);
        stringBuilder2.append(32 <= by && by < 127 ? (char)by : (char)'.');
    }

    private static void writeIndex(int n, StringBuilder stringBuilder) {
        stringBuilder.append(HEX_UC[n >> 12 & 0xF]);
        stringBuilder.append(HEX_UC[n >> 8 & 0xF]);
        stringBuilder.append(HEX_UC[n >> 4 & 0xF]);
        stringBuilder.append(HEX_UC[n >> 0 & 0xF]);
        stringBuilder.append(":").append(WORD_SPACER);
    }

    private static void writeLeadingSpaces(int n, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        stringBuilder.append(SPACES, 0, HexFormatter.hexCol(n &= 0xF));
        stringBuilder2.append(SPACES, 0, n);
    }

    private static void writeTrailingSpaces(int n, StringBuilder stringBuilder) {
        if ((n &= 0xF) != 0) {
            stringBuilder.append(SPACES, HexFormatter.hexCol(n), SPACES.length());
        }
    }

    private static int hexCol(int n) {
        assert (n > 0 && n < 16);
        return (n >> 2) * WORD_SPACER.length() + (n << 1);
    }

    private static void writeBytesAsHexBlock(byte[] byArray, int n, int n2, int n3, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder(20);
        if (n2 <= n) {
            return;
        }
        HexFormatter.writeIndex(n3, stringBuilder);
        HexFormatter.writeLeadingSpaces(n3, stringBuilder, stringBuilder2);
        HexFormatter.writeByte(byArray[n], stringBuilder, stringBuilder2);
        ++n;
        if ((++n3 & 3) == 0) {
            stringBuilder.append(WORD_SPACER);
        }
        while (n < n2) {
            if ((n3 & 0xF) == 0) {
                stringBuilder.append((CharSequence)stringBuilder2).append('\n');
                stringBuilder2.setLength(0);
                HexFormatter.writeIndex(n3, stringBuilder);
            }
            HexFormatter.writeByte(byArray[n], stringBuilder, stringBuilder2);
            ++n;
            if ((++n3 & 3) != 0) continue;
            stringBuilder.append(WORD_SPACER);
        }
        HexFormatter.writeTrailingSpaces(n3, stringBuilder);
        stringBuilder.append((CharSequence)stringBuilder2).append('\n');
    }

    private static void writeWsbbAsHexBlock(WsByteBuffer wsByteBuffer, int n, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder(20);
        if (wsByteBuffer.limit() == 0) {
            return;
        }
        HexFormatter.writeIndex(n, stringBuilder);
        HexFormatter.writeLeadingSpaces(n, stringBuilder, stringBuilder2);
        HexFormatter.writeByte(wsByteBuffer.get(), stringBuilder, stringBuilder2);
        if ((++n & 3) == 0) {
            stringBuilder.append(WORD_SPACER);
        }
        while (wsByteBuffer.remaining() > 0) {
            if ((n & 0xF) == 0) {
                stringBuilder.append((CharSequence)stringBuilder2).append('\n');
                stringBuilder2.setLength(0);
                HexFormatter.writeIndex(n, stringBuilder);
            }
            HexFormatter.writeByte(wsByteBuffer.get(), stringBuilder, stringBuilder2);
            if ((++n & 3) != 0) continue;
            stringBuilder.append(WORD_SPACER);
        }
        HexFormatter.writeTrailingSpaces(n, stringBuilder);
        stringBuilder.append((CharSequence)stringBuilder2).append('\n');
    }

    public static String format(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        try {
            stringBuilder.setLength(0);
            HexFormatter.writeBytesAsHexBlock(byArray, 0, byArray.length, 0, stringBuilder);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(exception.toString());
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            return stringWriter.toString();
        }
    }

    public static String format(byte[] byArray, int n, int n2, int n3) {
        return HexFormatter.format(byArray, n, n2, n3, 0);
    }

    public static String format(byte[] byArray, int n, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        try {
            HexFormatter.writeBytesAsHexBlock(byArray, n, n2, n4, stringBuilder);
            stringBuilder.append(CURSOR_BREAK);
            HexFormatter.writeBytesAsHexBlock(byArray, n2, n3, n4 += n2 - n, stringBuilder);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(exception.toString());
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            return stringWriter.toString();
        }
    }

    public static String format(WsByteBuffer[] wsByteBufferArray) {
        return HexFormatter.format(wsByteBufferArray, null);
    }

    public static String format(WsByteBuffer[] wsByteBufferArray, WsByteBuffer wsByteBuffer) {
        return HexFormatter.format(wsByteBufferArray, wsByteBuffer, 0);
    }

    public static String format(WsByteBuffer[] wsByteBufferArray, WsByteBuffer wsByteBuffer, int n) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(BUFFER_BREAK);
            }
            WsByteBuffer wsByteBuffer2 = wsByteBufferArray[i].duplicate();
            if (wsByteBuffer == null || wsByteBufferArray[i] == wsByteBuffer) {
                WsByteBuffer wsByteBuffer3 = wsByteBuffer2.slice();
                WsByteBuffer wsByteBuffer4 = wsByteBuffer2.flip();
                HexFormatter.writeWsbbAsHexBlock(wsByteBuffer4, n, stringBuilder);
                stringBuilder.append(CURSOR_BREAK);
                HexFormatter.writeWsbbAsHexBlock(wsByteBuffer3, n += wsByteBuffer4.limit(), stringBuilder);
                n += wsByteBuffer3.limit();
                wsByteBuffer4.release();
                wsByteBuffer3.release();
                continue;
            }
            wsByteBuffer2.rewind();
            HexFormatter.writeWsbbAsHexBlock(wsByteBuffer2, n, stringBuilder);
            n += wsByteBuffer2.limit();
            wsByteBuffer2.release();
        }
        return stringBuilder.toString();
    }

    public static String format(WsByteBuffer wsByteBuffer) {
        return HexFormatter.format(wsByteBuffer, 0);
    }

    public static String format(WsByteBuffer wsByteBuffer, int n) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        WsByteBuffer wsByteBuffer2 = wsByteBuffer.slice();
        WsByteBuffer wsByteBuffer3 = wsByteBuffer.duplicate().flip();
        HexFormatter.writeWsbbAsHexBlock(wsByteBuffer3, n, stringBuilder);
        stringBuilder.append(CURSOR_BREAK);
        HexFormatter.writeWsbbAsHexBlock(wsByteBuffer2, n += wsByteBuffer3.limit(), stringBuilder);
        n += wsByteBuffer2.limit();
        wsByteBuffer3.release();
        wsByteBuffer2.release();
        return stringBuilder.toString();
    }
}

