/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.InputStream;
import org.ietf.jgss.GSSException;

public class Oid {
    private ObjectIdentifier oid;
    private byte[] derEncoding;

    public Oid(String string) throws GSSException {
        try {
            this.oid = new ObjectIdentifier(string);
            this.derEncoding = null;
        }
        catch (Exception exception) {
            I18NException.throwGSSException((int)11, (int)0, (String)"BadOidString", (Object[])new String[]{exception.toString()});
        }
    }

    public Oid(InputStream inputStream) throws GSSException {
        try {
            DerValue derValue = new DerValue(inputStream);
            this.derEncoding = derValue.toByteArray();
            this.oid = derValue.getOID();
        }
        catch (Exception exception) {
            I18NException.throwGSSException((int)11, (int)0, (String)"BadOidDer", (Object[])new String[]{exception.toString()});
        }
    }

    public Oid(byte[] byArray) throws GSSException {
        try {
            DerValue derValue = new DerValue(byArray);
            this.derEncoding = derValue.toByteArray();
            this.oid = derValue.getOID();
        }
        catch (Exception exception) {
            I18NException.throwGSSException((int)11, (int)0, (String)"BadOidDer", (Object[])new String[]{exception.toString()});
        }
    }

    static Oid getInstance(String string) {
        Oid oid = null;
        try {
            oid = new Oid(string);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return oid;
    }

    public String toString() {
        return this.oid.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Oid) {
            return this.oid.equals(((Oid)object).oid);
        }
        if (object instanceof ObjectIdentifier) {
            return this.oid.equals(object);
        }
        return false;
    }

    public byte[] getDER() throws GSSException {
        if (this.derEncoding == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            try {
                derOutputStream.putOID(this.oid);
            }
            catch (Exception exception) {
                throw new GSSException(11, 0, exception.toString());
            }
            this.derEncoding = derOutputStream.toByteArray();
        }
        return this.derEncoding;
    }

    public boolean containedIn(Oid[] oidArray) {
        for (int i = 0; i < oidArray.length; ++i) {
            if (!oidArray[i].equals(this)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }
}

