/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.jzos.ZFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;

public class MVSImageInputStream
extends ImageInputStreamImpl {
    private ZFile destFile;
    private final int recordLength;
    private final long fileLength;

    public MVSImageInputStream(String filename) throws FileNotFoundException {
        try {
            this.destFile = new ZFile("//'" + filename + "'", "rb,type=record");
            this.recordLength = this.destFile.getLrecl();
            this.fileLength = this.destFile.getRecordCount() * (long)this.recordLength;
        }
        catch (IllegalArgumentException e) {
            FileNotFoundException e1 = new FileNotFoundException("Could not find: " + filename);
            e1.initCause(e);
            throw e1;
        }
        catch (IOException e) {
            FileNotFoundException e1 = new FileNotFoundException("Could not find: " + filename);
            e1.initCause(e);
            throw e1;
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        long blockNumber = this.streamPos / (long)this.recordLength;
        this.destFile.seek(blockNumber, 0);
        int recordOffset = (int)(this.streamPos % (long)this.recordLength);
        int n = 0;
        if (recordOffset != 0) {
            byte[] buf2;
            if (recordOffset + len > this.recordLength) {
                len = this.recordLength - recordOffset;
            }
            if ((n = this.destFile.read(buf2 = new byte[recordOffset + len]) - recordOffset) > 0) {
                System.arraycopy(buf2, recordOffset, buf, off, n);
            }
        } else {
            n = this.destFile.read(buf, off, len);
        }
        if (n < 0 || n == 0 && len > 0) {
            this.seek(this.streamPos);
            return -1;
        }
        this.seek(this.streamPos + (long)n);
        return n;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int n = this.read(b);
        return n < 0 ? -1 : b[1] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        if (this.destFile != null) {
            this.destFile.close();
        }
        super.close();
    }

    public long size() {
        return this.fileLength;
    }
}

