/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.addressspace.LayeredAddressSpace;
import com.ibm.dtfj.binaryreaders.ARReader;
import com.ibm.dtfj.binaryreaders.XCOFFReader;
import com.ibm.dtfj.corereaders.Aix32Dump;
import com.ibm.dtfj.corereaders.Aix64Dump;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CoreReaderSupport;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.stream.ImageInputStream;

public abstract class NewAixDump
extends CoreReaderSupport {
    private static final long FAULTING_THREAD_OFFSET = 216L;
    private static final int S64BIT = 1;
    private static final long CORE_FILE_VERSION_OFFSET = 4L;
    private static final int CORE_DUMP_XX_VERSION = 267312562;
    private static final int CORE_DUMP_X_VERSION = 267312561;
    private static final long CORE_DUMP_X_PI_FLAGS_2_OFFSET = 1056L;
    private static final int POWER_RS1 = 1;
    private static final int POWER_RSC = 2;
    private static final int POWER_RS2 = 4;
    private static final int POWER_601 = 8;
    private static final int POWER_603 = 32;
    private static final int POWER_604 = 16;
    private static final int POWER_620 = 64;
    private static final int POWER_630 = 128;
    private static final int POWER_A35 = 256;
    private static final int POWER_RS64II = 512;
    private static final int POWER_RS64III = 1024;
    private static final int POWER_4 = 2048;
    private static final int POWER_MPC7450 = 4096;
    private static final int POWER_5 = 8192;
    private List _memoryRanges = new ArrayList();
    private Set _additionalFileNames = new TreeSet();
    private int _implementation;
    private int _threadCount;
    private long _threadOffset;
    private long _lastModified;
    private long _loaderOffset;
    private long _loaderSize;
    private LayeredAddressSpace _addressSpace;
    private MemoryRange _stackRange = null;
    private long _structTopOfStackVirtualAddress;
    private boolean _isTruncated = false;

    protected NewAixDump(DumpReader reader) {
        super(reader);
    }

    public static boolean isSupportedDump(ImageInputStream stream) throws IOException {
        stream.seek(8L);
        long fdsinfox = stream.readLong();
        long loader = stream.readLong();
        long filesize = stream.length();
        return fdsinfox > 0L && loader > 0L && loader > fdsinfox && fdsinfox < filesize && loader < filesize;
    }

    public static ICoreFileReader dumpFromFile(ImageInputStream stream) throws IOException {
        assert (NewAixDump.isSupportedDump(stream));
        stream.seek(4L);
        int version = stream.readInt();
        boolean is64Bit = false;
        if (version == 267312561) {
            stream.seek(1056L);
            int flags = stream.readInt();
            is64Bit = (1 & flags) != 0;
        } else if (version == 267312562) {
            is64Bit = true;
        } else {
            throw new IOException("Unrecognised core file version: " + Long.toHexString(version));
        }
        DumpReader reader = new DumpReader(stream, is64Bit);
        if (is64Bit) {
            return new Aix64Dump(reader);
        }
        return new Aix32Dump(reader);
    }

    protected void readCore() throws IOException {
        this.coreSeek(0L);
        this.coreReadByte();
        byte flags = this.coreReadByte();
        if ((flags & 0x80) != 0) {
            this._isTruncated = true;
        }
        this.coreReadShort();
        this.coreReadInt();
        this.coreReadLong();
        this._loaderOffset = this.coreReadLong();
        this._loaderSize = this.coreReadLong();
        this._threadCount = this.coreReadInt();
        this.coreReadInt();
        this._threadOffset = this.coreReadLong();
        long segmentCount = this.coreReadLong();
        long segmentOffset = this.coreReadLong();
        long stackOffset = this.coreReadLong();
        long stackVirtualAddress = this.coreReadLong();
        long stackSize = this.coreReadLong();
        this._structTopOfStackVirtualAddress = stackVirtualAddress + stackSize - (long)this.sizeofTopOfStack();
        MemoryRange memoryRange1 = new MemoryRange(stackVirtualAddress, stackOffset, stackSize);
        this._memoryRanges.add(memoryRange1);
        this._stackRange = memoryRange1;
        long dataOffset = this.coreReadLong();
        long dataVirtualAddress = this.coreReadLong();
        long dataSize = this.coreReadLong();
        MemoryRange memoryRange = new MemoryRange(dataVirtualAddress, dataOffset, dataSize);
        this._memoryRanges.add(memoryRange);
        this.coreReadLong();
        this.coreReadLong();
        long vmRegionCount = this.coreReadLong();
        long vmRegionOffset = this.coreReadLong();
        this._implementation = this.coreReadInt();
        this.coreReadInt();
        this.coreReadLong();
        this.coreReadLong();
        this.coreReadBytes(48);
        this.readVMRegions(vmRegionOffset, vmRegionCount);
        this.readSegments(segmentOffset, segmentCount);
        this.readLoaderInfoAsMemoryRanges();
        MemoryRange highestRange = this.getHighestRange();
        if (null != highestRange) {
            this._isTruncated |= !this.coreCheckOffset(highestRange.getFileOffset());
        }
    }

    private MemoryRange getHighestRange() {
        long highestOffset = -1L;
        MemoryRange highestRange = null;
        for (MemoryRange range : this._memoryRanges) {
            if (range.getFileOffset() <= highestOffset) continue;
            highestOffset = range.getFileOffset();
            highestRange = range;
        }
        return highestRange;
    }

    private void readVMRegions(long offset, long count) throws IOException {
        this.coreSeek(offset);
        int i = 0;
        while ((long)i < count) {
            long address = this.coreReadLong();
            long size = this.coreReadLong();
            long off = this.coreReadLong();
            MemoryRange memoryRange = new MemoryRange(address, off, size);
            this._memoryRanges.add(memoryRange);
            ++i;
        }
    }

    private void readSegments(long offset, long count) throws IOException {
        this.coreSeek(offset);
        int i = 0;
        while ((long)i < count) {
            long address = this.coreReadLong();
            long size = this.coreReadLong();
            long off = this.coreReadLong();
            this.coreReadInt();
            this.coreReadInt();
            MemoryRange memoryRange = new MemoryRange(address, off, size);
            this._memoryRanges.add(memoryRange);
            ++i;
        }
    }

    private void readLoaderInfoAsMemoryRanges() throws IOException {
        int next = 0;
        long current = this._loaderOffset;
        do {
            this.coreSeek(current += (long)next);
            next = this.coreReadInt();
            this.readLoaderInfoFlags();
            long dataOffset = this.coreReadAddress();
            this.coreReadAddress();
            this.coreReadAddress();
            long dataVirtualAddress = this.coreReadAddress();
            long dataSize = this.coreReadAddress();
            if (0L == dataOffset) continue;
            MemoryRange memoryRange = new MemoryRange(dataVirtualAddress, dataOffset, dataSize);
            this._memoryRanges.add(memoryRange);
        } while (0 != next && current + (long)next < this._loaderOffset + this._loaderSize);
    }

    private List readLoaderInfoAsModules(Builder builder, Object addressSpace) throws IOException {
        ArrayList<Object> modules = new ArrayList<Object>();
        int next = 0;
        long current = this._loaderOffset;
        do {
            this.coreSeek(current += (long)next);
            next = this.coreReadInt();
            this.readLoaderInfoFlags();
            this.coreReadAddress();
            long textVirtualAddress = this.coreReadAddress();
            long textSize = this.coreReadAddress();
            long dataVirtualAddress = this.coreReadAddress();
            long dataSize = this.coreReadAddress();
            String fileName = this.readString();
            String objectName = this.readString();
            String moduleName = fileName;
            if (0 < objectName.length()) {
                moduleName = moduleName + "(" + objectName + ")";
            }
            Object text = builder.buildModuleSection(addressSpace, ".text", textVirtualAddress, textVirtualAddress + textSize);
            Object data = builder.buildModuleSection(addressSpace, ".data", dataVirtualAddress, dataVirtualAddress + dataSize);
            ArrayList<Object> sections = new ArrayList<Object>();
            sections.add(text);
            sections.add(data);
            XCOFFReader libraryReader = this._openLibrary(builder, fileName, objectName);
            this._additionalFileNames.add(fileName);
            if (null != libraryReader) {
                Properties properties = libraryReader.moduleProperties();
                List symbols = libraryReader.buildSymbols(builder, addressSpace, textVirtualAddress);
                modules.add(builder.buildModule(moduleName, properties, sections.iterator(), symbols.iterator(), textVirtualAddress));
                this.internalAddressSpace().mapRegion(textVirtualAddress, libraryReader.underlyingFile(), libraryReader.baseFileOffset(), textSize);
                continue;
            }
            List<Object> symbols = Collections.singletonList(builder.buildCorruptData(addressSpace, "unable to find module " + moduleName, textVirtualAddress));
            modules.add(builder.buildModule(moduleName, null, sections.iterator(), symbols.iterator(), textVirtualAddress));
        } while (0 != next && current + (long)next < this._loaderOffset + this._loaderSize);
        return modules;
    }

    private XCOFFReader _openLibrary(Builder builder, String fileName, String objectName) {
        XCOFFReader libraryReader = null;
        ClosingFileReader library = null;
        try {
            library = builder.openFile(fileName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != library) {
            long fileOffset = 0L;
            long fileSize = 0L;
            try {
                try {
                    libraryReader = new XCOFFReader(library);
                    fileSize = library.length();
                }
                catch (IllegalArgumentException e) {
                    try {
                        ARReader archive = new ARReader(library);
                        fileSize = archive.sizeOfModule(objectName);
                        fileOffset = archive.offsetOfModule(objectName);
                        libraryReader = new XCOFFReader(library, fileOffset, fileSize);
                    }
                    catch (IllegalArgumentException e2) {
                        libraryReader = null;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return libraryReader;
    }

    private void readUserInfo(Builder builder, Object addressSpace) throws IOException {
        this.coreSeek(this.userInfoOffset());
        int pid = this.coreReadInt();
        String commandLine = "";
        try {
            this.coreSeekVirtual(this._structTopOfStackVirtualAddress);
        }
        catch (MemoryAccessException e) {
            return;
        }
        this.coreReadAddress();
        this.coreReadAddress();
        this.coreReadAddress();
        long reg3 = this.coreReadAddress();
        long reg4 = this.coreReadAddress();
        long reg5 = this.coreReadAddress();
        int argc = (int)reg3;
        if (argc > 0) {
            long[] addresses = new long[argc];
            try {
                this.coreSeekVirtual(reg4);
                int i = 0;
                while ((long)i < reg3) {
                    addresses[i] = this.coreReadAddress();
                    ++i;
                }
                i = 0;
                while ((long)i < reg3) {
                    try {
                        this.coreSeekVirtual(addresses[i]);
                        commandLine = commandLine + this.readString() + " ";
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (MemoryAccessException e1) {
                commandLine = null;
            }
        } else {
            commandLine = null;
        }
        List modules = this.readLoaderInfoAsModules(builder, addressSpace);
        Object executable = null;
        Iterator libraries = modules.iterator();
        if (libraries.hasNext()) {
            executable = libraries.next();
        }
        List threads = this.readThreads(builder, addressSpace);
        Object currentThread = threads.get(0);
        Properties environment = new Properties();
        environment = this.getEnvironmentVariables(reg5);
        builder.buildProcess(addressSpace, String.valueOf(pid), commandLine, environment, currentThread, threads.iterator(), executable, libraries, this.pointerSize());
    }

    private Properties getEnvironmentVariables(long environmentAddress) throws IOException {
        if (0L == environmentAddress) {
            return null;
        }
        ArrayList<Long> addresses = new ArrayList<Long>();
        try {
            this.coreSeekVirtual(environmentAddress);
        }
        catch (MemoryAccessException e1) {
            return null;
        }
        long address = this.coreReadAddress();
        while (address != 0L) {
            addresses.add(address);
            address = this.coreReadAddress();
        }
        Properties environment = new Properties();
        for (Long varAddress : addresses) {
            int equalSignIndex;
            String pair = null;
            try {
                this.coreSeekVirtual(varAddress);
                pair = this.readString();
            }
            catch (MemoryAccessException e) {
                continue;
            }
            if (null == pair || (equalSignIndex = pair.indexOf(61)) < 0) continue;
            String key = pair.substring(0, equalSignIndex);
            String value = pair.substring(equalSignIndex + 1);
            environment.put(key, value);
        }
        return environment;
    }

    private List readThreads(Builder builder, Object addressSpace) throws IOException {
        ArrayList<Object> threads = new ArrayList<Object>();
        long sizeofThread = this.threadSize(216L);
        threads.add(this.readThread(builder, addressSpace, 216L));
        for (int i = 0; i < this._threadCount; ++i) {
            threads.add(this.readThread(builder, addressSpace, this._threadOffset + (long)i * sizeofThread));
        }
        return threads;
    }

    private Object readThread(Builder builder, Object addressSpace, long offset) throws IOException {
        this.coreSeek(offset);
        long tid = this.coreReadAddress();
        this.coreReadInt();
        int ti_policy = this.coreReadInt();
        int ti_pri = this.coreReadInt();
        int ti_state = this.coreReadInt();
        int ti_flag = this.coreReadInt();
        int ti_scount = this.coreReadInt();
        int ti_wtype = this.coreReadInt();
        int ti_wchan = this.coreReadInt();
        int ti_cpu = this.coreReadInt();
        int ti_cpuid = this.coreReadInt();
        this.coreReadSigset();
        this.coreReadSigset();
        this.coreReadInt();
        this.coreReadAddress();
        int signalNumber = 0xFF & this.coreReadByte();
        Map registers = this.readRegisters(offset);
        Properties properties = new Properties();
        properties.put("scheduling policy", Integer.toHexString(ti_policy));
        properties.put("current effective priority", Integer.toHexString(ti_pri));
        properties.put("thread state", Integer.toHexString(ti_state));
        properties.put("thread flags", Integer.toHexString(ti_flag));
        properties.put("suspend count", Integer.toHexString(ti_scount));
        properties.put("type of thread wait", Integer.toHexString(ti_wtype));
        properties.put("wait channel", Integer.toHexString(ti_wchan));
        properties.put("processor usage", Integer.toHexString(ti_cpu));
        properties.put("processor on which I'm bound", Integer.toHexString(ti_cpuid));
        properties.put("current/last signal taken", Integer.toHexString(signalNumber));
        ArrayList<Object> sections = new ArrayList<Object>();
        ArrayList<Object> frames = new ArrayList<Object>();
        long stackPointer = this.getStackPointerFrom(registers);
        long instructionPointer = this.getInstructionPointerFrom(registers);
        if (0L == instructionPointer || !this.isValidAddress(instructionPointer)) {
            instructionPointer = this.getLinkRegisterFrom(registers);
        }
        try {
            if (0L != instructionPointer && 0L != stackPointer && this.isValidAddress(instructionPointer) && this.isValidAddress(stackPointer)) {
                MemoryRange range = this.memoryRangeFor(stackPointer);
                if (range != null) {
                    sections.add(builder.buildStackSection(addressSpace, range.getVirtualAddress(), range.getVirtualAddress() + range.getSize()));
                    frames.add(builder.buildStackFrame(addressSpace, stackPointer, instructionPointer));
                    IAbstractAddressSpace memory = this.getAddressSpace();
                    long previousStackPointer = -1L;
                    while (range.contains(stackPointer) && previousStackPointer != stackPointer && frames.size() < 1024) {
                        previousStackPointer = stackPointer;
                        stackPointer = memory.getPointerAt(0, stackPointer);
                        long stepping = 64 == this.pointerSize() ? 8 : 4;
                        long addressToRead = stackPointer + stepping;
                        instructionPointer = memory.getPointerAt(0, addressToRead += stepping);
                        frames.add(builder.buildStackFrame(addressSpace, stackPointer, instructionPointer));
                    }
                }
            } else {
                sections.add(builder.buildStackSection(addressSpace, this._stackRange.getVirtualAddress(), this._stackRange.getVirtualAddress() + this._stackRange.getSize()));
            }
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return builder.buildThread(String.valueOf(tid), this.registersAsList(builder, registers).iterator(), sections.iterator(), frames.iterator(), properties, signalNumber);
    }

    private void coreReadSigset() throws IOException {
        this.coreReadBytes(this.is64Bit() ? 32 : 8);
    }

    private boolean isValidAddress(long address) {
        try {
            this.getAddressSpace().getByteAt(0, address);
            return true;
        }
        catch (MemoryAccessException e) {
            return false;
        }
    }

    protected MemoryRange memoryRangeFor(long address) {
        Iterator ranges = this._memoryRanges.iterator();
        MemoryRange match = null;
        while (null == match && ranges.hasNext()) {
            MemoryRange range = (MemoryRange)ranges.next();
            if (!range.contains(address)) continue;
            match = range;
        }
        return match;
    }

    private String readString() throws IOException {
        StringBuffer buffer = new StringBuffer();
        byte b = this.coreReadByte();
        while (0 != b) {
            buffer.append(new String(new byte[]{b}, "ASCII"));
            b = this.coreReadByte();
        }
        return buffer.toString();
    }

    private List registersAsList(Builder builder, Map registers) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map.Entry entry : registers.entrySet()) {
            list.add(builder.buildRegister((String)entry.getKey(), (Number)entry.getValue()));
        }
        return list;
    }

    protected abstract Map readRegisters(long var1) throws IOException;

    protected abstract int readLoaderInfoFlags() throws IOException;

    protected abstract long userInfoOffset();

    protected abstract long threadSize(long var1);

    protected abstract int pointerSize();

    protected abstract long getStackPointerFrom(Map var1);

    protected abstract long getInstructionPointerFrom(Map var1);

    protected abstract long getLinkRegisterFrom(Map var1);

    protected abstract int sizeofTopOfStack();

    public Iterator getMemoryRanges() {
        return this._memoryRanges.iterator();
    }

    @Override
    public void extract(Builder builder) {
        try {
            Object addressSpace = builder.buildAddressSpace("AIX Address Space", 0);
            this.readUserInfo(builder, addressSpace);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        builder.setOSType("AIX");
        builder.setCPUType("PowerPC");
        builder.setCPUSubType(this.getProcessorSubtype());
        builder.setCreationTime(this.getCreationTime());
    }

    public String getProcessorSubtype() {
        switch (this._implementation) {
            case 1: {
                return "RS1";
            }
            case 2: {
                return "RSC";
            }
            case 4: {
                return "RS2";
            }
            case 8: {
                return "601";
            }
            case 32: {
                return "603";
            }
            case 16: {
                return "604";
            }
            case 64: {
                return "620";
            }
            case 128: {
                return "630";
            }
            case 256: {
                return "A35";
            }
            case 512: {
                return "RS64-II";
            }
            case 1024: {
                return "RS64-III";
            }
            case 2048: {
                return "POWER 4";
            }
            case 4096: {
                return "MPC7450";
            }
            case 8192: {
                return "POWER 5";
            }
        }
        return "";
    }

    public long getCreationTime() {
        return this._lastModified;
    }

    @Override
    public Iterator getAdditionalFileNames() {
        return this._additionalFileNames.iterator();
    }

    @Override
    protected MemoryRange[] getMemoryRangesAsArray() {
        return this._memoryRanges.toArray(new MemoryRange[this._memoryRanges.size()]);
    }

    private LayeredAddressSpace internalAddressSpace() {
        if (null == this._addressSpace) {
            IAbstractAddressSpace base = super.getAddressSpace();
            this._addressSpace = new LayeredAddressSpace(base, false, 64 == this.pointerSize());
        }
        return this._addressSpace;
    }

    @Override
    public IAbstractAddressSpace getAddressSpace() {
        return this.internalAddressSpace();
    }

    @Override
    protected boolean is64Bit() {
        return 64 == this.pointerSize();
    }

    @Override
    protected boolean isLittleEndian() {
        return false;
    }

    private void coreSeekVirtual(long virtualAddress) throws MemoryAccessException, IOException {
        MemoryRange range = this.memoryRangeFor(virtualAddress);
        if (null == range) {
            throw new MemoryAccessException(0, virtualAddress);
        }
        long onDisk = range.getFileOffset() + (virtualAddress - range.getVirtualAddress());
        this.coreSeek(onDisk);
    }

    @Override
    public boolean isTruncated() {
        return this._isTruncated;
    }
}

