/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPrivateKey;
import com.ibm.crypto.provider.RSAPublicKey;
import com.ibm.security.rsa.RSAUtil;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;

public class RSAKeyFactory
extends KeyFactorySpi {
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    private static final BigInteger a;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private RSAUtil.KeyType b = RSAUtil.KeyType.RSA;
    static RSAKeyFactory c;
    private static final boolean d;
    private static final RSAKeyFactory e;
    private static final RSAKeyFactory f;
    private static final String[] z;

    private RSAKeyFactory() {
        this.b = RSAUtil.KeyType.RSA;
    }

    public RSAKeyFactory(RSAUtil.KeyType keyType) {
        this.b = keyType;
    }

    public static RSAKeyFactory getInstance(RSAUtil.KeyType keyType) {
        return new RSAKeyFactory(keyType);
    }

    public static RSAKey toRSAKey(Key key) throws InvalidKeyException {
        java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey;
        block20: {
            block19: {
                block18: {
                    if (!(key instanceof RSAPrivateCrtKey) && !(key instanceof java.security.interfaces.RSAPrivateCrtKey)) break block18;
                    rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                    if (rSAPrivateCrtKey.getCrtCoefficient() == null) {
                        return new RSAPrivateKey(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent());
                    }
                }
                if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) break block19;
                if (!(key instanceof RSAPublicKey)) break block20;
            }
            return (RSAKey)((Object)key);
        }
        try {
            rSAPrivateCrtKey = RSAUtil.KeyType.lookup((String)key.getAlgorithm());
            if (rSAPrivateCrtKey == RSAUtil.KeyType.RSA) {
                return (RSAKey)((Object)e.engineTranslateKey(key));
            }
            if (rSAPrivateCrtKey == RSAUtil.KeyType.PSS) {
                return (RSAKey)((Object)f.engineTranslateKey(key));
            }
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
        RSAKeyFactory rSAKeyFactory = RSAKeyFactory.getInstance((RSAUtil.KeyType)rSAPrivateCrtKey);
        return (RSAKey)((Object)rSAKeyFactory.engineTranslateKey(key));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkKeyLengths(int n2, BigInteger bigInteger, int n3, int n4) throws InvalidKeyException {
        if (n3 > 0 && n2 < n3) {
            throw new InvalidKeyException(z[11] + n3 + z[10]);
        }
        int n5 = Math.min(n4, 16384);
        if (n2 > n5) {
            throw new InvalidKeyException(z[12] + n5 + z[8]);
        }
        if (d && bigInteger != null && n2 > 3072 && bigInteger.bitLength() > 64) {
            throw new InvalidKeyException(z[9]);
        }
        RSAKeyFactory.a(n2, bigInteger);
    }

    private static void a(int n2, BigInteger bigInteger) throws InvalidKeyException {
        if (bigInteger == null) {
            return;
        }
        if ((bigInteger.bitLength() + 7 & 0xFFFFFFF8) > n2) {
            throw new InvalidKeyException(z[7]);
        }
        if (bigInteger.compareTo(a) < 0) {
            throw new InvalidKeyException(z[6]);
        }
    }

    static void b(int n2, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n2 + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[4] + invalidKeyException.getMessage());
        }
        throw new InvalidKeySpecException(z[5]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec var1_1) throws InvalidKeySpecException {
        if (!(var1_1 instanceof PKCS8EncodedKeySpec)) ** GOTO lbl10
        return new RSAPrivateCrtKey(((PKCS8EncodedKeySpec)var1_1).getEncoded());
        catch (InvalidKeyException var2_2) {
            try {
                return new RSAPrivateKey(((PKCS8EncodedKeySpec)var1_1).getEncoded());
lbl10:
                // 1 sources

                if (var1_1 instanceof RSAPrivateCrtKeySpec) {
                    var2_3 = (RSAPrivateCrtKeySpec)var1_1;
                    var3_6 = var2_3.getParams();
                    if (var3_6 != null && var3_6 instanceof PSSParameterSpec) {
                        this.b = RSAUtil.KeyType.PSS;
                        return RSAPrivateCrtKey.newKey(this.b, var3_6, var2_3.getModulus(), var2_3.getPrivateExponent(), var2_3.getPublicExponent(), var2_3.getPrimeP(), var2_3.getPrimeQ(), var2_3.getPrimeExponentP(), var2_3.getPrimeExponentQ(), var2_3.getCrtCoefficient());
                    }
                    this.b = RSAUtil.KeyType.RSA;
                    return RSAPrivateCrtKey.newKey(this.b, var3_6, var2_3.getModulus(), var2_3.getPrivateExponent(), var2_3.getPublicExponent(), var2_3.getPrimeP(), var2_3.getPrimeQ(), var2_3.getPrimeExponentP(), var2_3.getPrimeExponentQ(), var2_3.getCrtCoefficient());
                }
                if (var1_1 instanceof RSAPrivateKeySpec == false) throw new InvalidKeySpecException(RSAKeyFactory.z[26]);
                var2_4 = (RSAPrivateKeySpec)var1_1;
                var3_7 = ((RSAPrivateKeySpec)var1_1).getParams();
                if (var3_7 != null && var3_7 instanceof PSSParameterSpec) {
                    this.b = RSAUtil.KeyType.PSS;
                    return RSAPrivateKey.newKey(var2_4.getModulus(), var2_4.getPrivateExponent());
                }
                this.b = RSAUtil.KeyType.RSA;
                return RSAPrivateKey.newKey(var2_4.getModulus(), var2_4.getPrivateExponent());
            }
            catch (InvalidKeyException var2_5) {
                throw new InvalidKeySpecException(RSAKeyFactory.z[25] + var2_5.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        block14: {
            try {
                Class<T> clazz2;
                if (key instanceof java.security.interfaces.RSAPublicKey) {
                    clazz2 = Class.forName(z[27]);
                    Class<T> clazz3 = Class.forName(z[38]);
                    if (clazz2.isAssignableFrom(clazz)) {
                        java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                        return (T)((KeySpec)clazz.cast(new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent())));
                    }
                    if (!clazz3.isAssignableFrom(clazz)) throw new InvalidKeySpecException(z[36]);
                    return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
                }
                if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                    clazz2 = Class.forName(z[32]);
                    Class<T> clazz4 = Class.forName(z[28]);
                    Class<T> clazz5 = Class.forName(z[37]);
                    if (clazz2.isAssignableFrom(clazz)) {
                        java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                        return (T)((KeySpec)clazz.cast(new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient())));
                    }
                    if (clazz4.isAssignableFrom(clazz)) {
                        return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
                    }
                    if (!clazz5.isAssignableFrom(clazz)) throw new InvalidKeySpecException(z[35]);
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return (T)((KeySpec)clazz.cast(new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getParams())));
                }
                if (!(key instanceof java.security.interfaces.RSAPrivateKey)) throw new InvalidKeySpecException(z[33]);
                clazz2 = Class.forName(z[29]);
                Class<T> clazz6 = Class.forName(z[34]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return (T)((KeySpec)clazz.cast(new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getParams())));
                }
                if (!clazz6.isAssignableFrom(clazz)) break block14;
                return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InvalidKeySpecException(z[31] + classNotFoundException.getMessage());
            }
        }
        throw new InvalidKeySpecException(z[30]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException(z[41]);
        }
        RSAKeyFactory.a(key, this.b.keyAlgo());
        if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey || key instanceof RSAPublicKey) {
            return key;
        }
        if (!(key instanceof PublicKey)) {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
            }
            if (!(key instanceof PrivateKey) && !(key instanceof java.security.interfaces.RSAPrivateKey)) {
                if (!(key instanceof java.security.interfaces.RSAPrivateCrtKey)) throw new InvalidKeyException(z[39]);
            }
        } else {
            try {}
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException(z[40]);
            }
            return this.a((PublicKey)key);
            catch (InvalidKeyException invalidKeyException) {
                throw invalidKeyException;
            }
        }
        try {}
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[42]);
        }
        return this.a((PrivateKey)key);
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
    }

    private PublicKey a(PublicKey publicKey) throws InvalidKeyException, InvalidKeySpecException {
        block8: {
            block9: {
                if (!(publicKey instanceof java.security.interfaces.RSAPublicKey)) break block8;
                if (!(publicKey instanceof RSAPublicKey)) break block9;
                return publicKey;
            }
            RSAPublicKeySpec rSAPublicKeySpec = this.engineGetKeySpec(publicKey, RSAPublicKeySpec.class);
            return this.engineGeneratePublic(rSAPublicKeySpec);
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            try {
                return new RSAPublicKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)this.b, (AlgorithmParameterSpec)rSAPublicKey.getParams()), rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeyException(z[24], providerException);
            }
        }
        if (z[22].equals(publicKey.getFormat())) {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(publicKey.getEncoded());
            RSAKeyFactory.a(rSAPublicKey, this.b.keyAlgo());
            return rSAPublicKey;
        }
        throw new InvalidKeyException(z[23]);
    }

    private PrivateKey a(PrivateKey privateKey) throws InvalidKeyException, InvalidKeySpecException {
        block17: {
            block18: {
                block15: {
                    block16: {
                        if (!(privateKey instanceof java.security.interfaces.RSAPrivateCrtKey)) break block15;
                        if (!(privateKey instanceof RSAPrivateCrtKey)) break block16;
                        return privateKey;
                    }
                    RSAPrivateKeySpec rSAPrivateKeySpec = this.engineGetKeySpec(privateKey, RSAPrivateCrtKeySpec.class);
                    return this.engineGeneratePrivate(rSAPrivateKeySpec);
                }
                if (privateKey instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                    try {
                        return new RSAPrivateCrtKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)this.b, (AlgorithmParameterSpec)rSAPrivateCrtKey.getParams()), rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                    }
                    catch (ProviderException providerException) {
                        throw new InvalidKeyException(z[1], providerException);
                    }
                }
                if (!(privateKey instanceof java.security.interfaces.RSAPrivateKey)) break block17;
                if (!(privateKey instanceof RSAPrivateKey)) break block18;
                return privateKey;
            }
            RSAPrivateKeySpec rSAPrivateKeySpec = this.engineGetKeySpec(privateKey, RSAPrivateKeySpec.class);
            return this.engineGeneratePrivate(rSAPrivateKeySpec);
        }
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            try {
                return new RSAPrivateKey(RSAUtil.createAlgorithmId((RSAUtil.KeyType)this.b, (AlgorithmParameterSpec)rSAPrivateKey.getParams()), rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            catch (ProviderException providerException) {
                throw new InvalidKeyException(z[0], providerException);
            }
        }
        if (z[3].equals(privateKey.getFormat())) {
            RSAPrivateCrtKey rSAPrivateCrtKey = RSAPrivateCrtKey.newKey(privateKey.getEncoded());
            RSAKeyFactory.a(rSAPrivateCrtKey, this.b.keyAlgo());
            return rSAPrivateCrtKey;
        }
        throw new InvalidKeyException(z[2]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(Key key, String string) throws InvalidKeyException {
        String string2 = key.getAlgorithm();
        if (string2 == null) {
            throw new InvalidKeyException(z[21] + string + z[18] + string2);
        }
        if (key.getAlgorithm().equalsIgnoreCase(z[16])) {
            if (!string.equalsIgnoreCase(z[20]) && !string.equalsIgnoreCase(z[17])) return;
            return;
        } else {
            if (key.getAlgorithm().equalsIgnoreCase(z[14]) && string.equalsIgnoreCase(z[13])) {
                return;
            }
            if (key.getAlgorithm().equalsIgnoreCase(string)) return;
            throw new InvalidKeyException(z[19] + string + z[15] + string2);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block66: {
            int n2;
            int n3;
            block65: {
                String string;
                String[] stringArray = new String[45];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n4 = 0;
                String string2 = "\u0007)s[\f'#%Q\u00057";
                int n5 = -1;
                block58: while (true) {
                    char[] cArray2;
                    block64: {
                        int n6;
                        block63: {
                            char[] cArray3 = string2.toCharArray();
                            cArray2 = cArray3;
                            n6 = cArray3.length;
                            n3 = 0;
                            if (!true) break block63;
                            n6 = n6;
                            if (n6 <= n3) break block64;
                        }
                        do {
                            int n7;
                            cArray2 = cArray2;
                            int n8 = n3;
                            char c2 = cArray2[n8];
                            switch (n3 % 5) {
                                case 0: {
                                    n7 = 78;
                                    break;
                                }
                                case 1: {
                                    n7 = 71;
                                    break;
                                }
                                case 2: {
                                    n7 = 5;
                                    break;
                                }
                                case 3: {
                                    n7 = 58;
                                    break;
                                }
                                default: {
                                    n7 = 96;
                                }
                            }
                            cArray2[n8] = (char)(c2 ^ n7);
                            ++n3;
                            n6 = n6;
                        } while (n6 > n3);
                    }
                    string = new String(cArray2);
                    switch (n5) {
                        default: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 1;
                            string2 = "\u0007)s[\f'#%Q\u00057";
                            n5 = 0;
                            continue block58;
                        }
                        case 0: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 2;
                            string2 = "\u001e5lL\u0001:\"%Q\u000574%W\u0015=3%X\u0005n.kI\u0014/)f_@!!%h3\u000f\u0017wS\u0016/3`\u0012#<3,q\u00057gjH@&&s_@\u001e\fFiCvg`T\u0003!#lT\u0007";
                            n5 = 1;
                            continue block58;
                        }
                        case 1: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 3;
                            string2 = "\u001e\fFiCv";
                            n5 = 2;
                            continue block58;
                        }
                        case 2: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 4;
                            string2 = "\u0007)dJ\u0010<(uH\t/3`\u001a\u000b+>%I\u0010+$l\\\t-&qS\u000f }%";
                            n5 = 3;
                            continue block58;
                        }
                        case 3: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 5;
                            string2 = "\u0007)dJ\u0010<(uH\t/3`\u001a\u000b+>%I\u0010+$l\\\t-&qS\u000f ";
                            n5 = 4;
                            continue block58;
                        }
                        case 4: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 6;
                            string2 = "+?uU\u000e+)q\u001a\t=gvW\u0001\"+`H@:/dT@}";
                            n5 = 5;
                            continue block58;
                        }
                        case 5: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 7;
                            string2 = "+?uU\u000e+)q\u001a\t=gi[\u0012)\"w\u001a\u0014&&k\u001a\r!#pV\u0015=";
                            n5 = 6;
                            continue block58;
                        }
                        case 6: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 8;
                            string2 = "n%lN\u0013";
                            n5 = 7;
                            continue block58;
                        }
                        case 7: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 9;
                            string2 = "\u001c\u0014D\u001a\u000567jT\u0005 3v\u001a\u0003/)%X\u0005n)j\u001a\f!)b_\u0012n3m[\u000enq1\u001a\u0002'3v\u001a@'!%W\u000f*2iO\u0013n.v\u001a\u0007<\"dN\u0005<gqR\u0001 g6\nW|ggS\u0014=";
                            n5 = 8;
                            continue block58;
                        }
                        case 8: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 10;
                            string2 = "n%lN\u0013n+jT\u0007";
                            n5 = 9;
                            continue block58;
                        }
                        case 9: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 11;
                            string2 = "\u001c\u0014D\u001a\u000b+>v\u001a\r;4q\u001a\u0002+gdN@\"\"dI\u0014n";
                            n5 = 10;
                            continue block58;
                        }
                        case 10: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 12;
                            string2 = "\u001c\u0014D\u001a\u000b+>v\u001a\r;4q\u001a\u0002+gkU@\"(k]\u0005<gqR\u0001 g";
                            n5 = 11;
                            continue block58;
                        }
                        case 11: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 13;
                            string2 = "\u001c\u0014Dj3\u001d";
                            n5 = 12;
                            continue block58;
                        }
                        case 12: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 14;
                            string2 = "\u001c\u0014D";
                            n5 = 13;
                            continue block58;
                        }
                        case 13: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 15;
                            string2 = "n,`CLn%pN@)(q\u001a";
                            n5 = 14;
                            continue block58;
                        }
                        case 14: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 16;
                            string2 = "\u001c\u0014Dj3\u001d";
                            n5 = 15;
                            continue block58;
                        }
                        case 15: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 17;
                            string2 = "\u001c\u0014D";
                            n5 = 16;
                            continue block58;
                        }
                        case 16: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 18;
                            string2 = "n,`CLn%pN@)(q\u001a";
                            n5 = 17;
                            continue block58;
                        }
                        case 17: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 19;
                            string2 = "\u000b?u_\u0003:\"a\u001a\u0001n";
                            n5 = 18;
                            continue block58;
                        }
                        case 18: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 20;
                            string2 = "\u001c\u0014Dj3\u001d";
                            n5 = 19;
                            continue block58;
                        }
                        case 19: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 21;
                            string2 = "\u000b?u_\u0003:\"a\u001a\u0001n";
                            n5 = 20;
                            continue block58;
                        }
                        case 20: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 22;
                            string2 = "\u0016i0\nY";
                            n5 = 21;
                            continue block58;
                        }
                        case 21: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 23;
                            string2 = "\u001e2gV\t-gn_\u0019=ghO\u0013:gg_@')vN\u0001 $`\u001a\u000f(gWi!\u001e2gV\t-\f`C@!5%R\u00018\"%bN{w<\u001a\u0005 $j^\t  ";
                            n5 = 22;
                            continue block58;
                        }
                        case 22: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 24;
                            string2 = "\u0007)s[\f'#%Q\u00057";
                            n5 = 23;
                            continue block58;
                        }
                        case 23: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 25;
                            string2 = "\u0007)dJ\u0010<(uH\t/3`\u001a\u000b+>%I\u0010+$l\\\t-&qS\u000f }%";
                            n5 = 24;
                            continue block58;
                        }
                        case 24: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 26;
                            string2 = "\u0007)dJ\u0010<(uH\t/3`\u001a\u000b+>%I\u0010+$l\\\t-&qS\u000f ";
                            n5 = 25;
                            continue block58;
                        }
                        case 25: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 27;
                            string2 = "$&s[N=\"fO\u0012'3|\u0014\u0013>\"f\u00142\u001d\u0006UO\u0002\".fq\u00057\u0014u_\u0003";
                            n5 = 26;
                            continue block58;
                        }
                        case 26: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 28;
                            string2 = "$&s[N=\"fO\u0012'3|\u0014\u0013>\"f\u00140\u0005\u0004V\u0002% $j^\u0005*\f`C3>\"f";
                            n5 = 27;
                            continue block58;
                        }
                        case 27: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 29;
                            string2 = "$&s[N=\"fO\u0012'3|\u0014\u0013>\"f\u00142\u001d\u0006UH\t8&q_++>VJ\u0005-";
                            n5 = 28;
                            continue block58;
                        }
                        case 28: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 30;
                            string2 = "\u0007)dJ\u0010<(uH\t/3`\u001a\u000b+>%I\u0010+$l\\\t-&qS\u000f guH\t8&q_++>";
                            n5 = 29;
                            continue block58;
                        }
                        case 29: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 31;
                            string2 = "\u001b)vO\u0010>(wN\u0005*gn_\u0019n4u_\u0003'!lY\u0001:.jTZn";
                            n5 = 30;
                            continue block58;
                        }
                        case 30: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 32;
                            string2 = "$&s[N=\"fO\u0012'3|\u0014\u0013>\"f\u00142\u001d\u0006UH\t8&q_#<3N_\u0019\u001d7`Y";
                            n5 = 31;
                            continue block58;
                        }
                        case 31: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 33;
                            string2 = "\u0007)dJ\u0010<(uH\t/3`\u001a\u000b+>%N\u0019>\"";
                            n5 = 32;
                            continue block58;
                        }
                        case 32: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 34;
                            string2 = "$&s[N=\"fO\u0012'3|\u0014\u0013>\"f\u00140\u0005\u0004V\u0002% $j^\u0005*\f`C3>\"f";
                            n5 = 33;
                            continue block58;
                        }
                        case 33: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 35;
                            string2 = "\u0007)dJ\u0010<(uH\t/3`\u001a\u000b+>%I\u0010+$l\\\t-&qS\u000f gWi!\u001e5lL\u0001:\"FH\u0014\u0005\"|i\u0010+$";
                            n5 = 34;
                            continue block58;
                        }
                        case 34: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 36;
                            string2 = "\u0007)dJ\u0010<(uH\t/3`\u001a\u000b+>%I\u0010+$l\\\t-&qS\u000f ";
                            n5 = 35;
                            continue block58;
                        }
                        case 35: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 37;
                            string2 = "$&s[N=\"fO\u0012'3|\u0014\u0013>\"f\u00142\u001d\u0006UH\t8&q_++>VJ\u0005-";
                            n5 = 36;
                            continue block58;
                        }
                        case 36: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 38;
                            string2 = "$&s[N=\"fO\u0012'3|\u0014\u0013>\"f\u00148{w<\u007f\u000e-(a_\u0004\u0005\"|i\u0010+$";
                            n5 = 37;
                            continue block58;
                        }
                        case 37: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 39;
                            string2 = "\u0000\"lN\b+5%[@>2gV\t-gkU\u0012n&%J\u0012'1dN\u0005n,`C";
                            n5 = 38;
                            continue block58;
                        }
                        case 38: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 40;
                            string2 = "\u001b)dX\f+gqU@>5jY\u0005=4%N\b+>%j\u0015,+lY++>";
                            n5 = 39;
                            continue block58;
                        }
                        case 39: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 41;
                            string2 = "\u0005\"|\u001a\r;4q\u001a\u000e!3%X\u0005n)pV\f";
                            n5 = 40;
                            continue block58;
                        }
                        case 40: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 42;
                            string2 = "\u001b)dX\f+gqU@>5jY\u0005=4%N\b+>%j\u0012'1dN\u0005\u0005\"|";
                            n5 = 41;
                            continue block58;
                        }
                        case 41: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 43;
                            string2 = "-(h\u0014\t,*+Y\u001277qUN>5jL\t*\"w\u0014\u0012+4qH\t-3Wi!\u000b?uU\u000e+)q";
                            n5 = 42;
                            continue block58;
                        }
                        case 42: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 44;
                            string2 = ":5p_";
                            n5 = 43;
                            continue block58;
                        }
                        case 43: 
                    }
                    break;
                }
                stringArray2[n4] = string.intern();
                z = stringArray3;
                a = BigInteger.valueOf(3L);
                c = null;
                char[] cArray4 = ":5p_".toCharArray();
                cArray = cArray4;
                n2 = cArray4.length;
                n3 = 0;
                if (!true) break block65;
                n2 = n2;
                if (n2 <= n3) break block66;
            }
            do {
                int n9;
                cArray = cArray;
                int n10 = n3;
                char c3 = cArray[n10];
                switch (n3 % 5) {
                    case 0: {
                        n9 = 78;
                        break;
                    }
                    case 1: {
                        n9 = 71;
                        break;
                    }
                    case 2: {
                        n9 = 5;
                        break;
                    }
                    case 3: {
                        n9 = 58;
                        break;
                    }
                    default: {
                        n9 = 96;
                    }
                }
                cArray[n10] = (char)(c3 ^ n9);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        d = new String(cArray).intern().equalsIgnoreCase(AccessController.doPrivileged(new GetPropertyAction(z[43], z[44])));
        e = new RSAKeyFactory(RSAUtil.KeyType.RSA);
        f = new RSAKeyFactory(RSAUtil.KeyType.PSS);
    }
}

