/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.PKCS5KeySpec;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

class PBEKey
implements SecretKey {
    private static final long serialVersionUID = 6550714301310581595L;
    private byte[] key;
    private final String type;
    private static final String[] z;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PBEKey(KeySpec keySpec, String string) throws InvalidKeySpecException {
        int n2;
        KeySpec keySpec2;
        if (!(keySpec instanceof PBEKeySpec || keySpec instanceof PKCS5KeySpec || keySpec instanceof SecretKeySpec)) {
            throw new InvalidKeySpecException(z[8]);
        }
        char[] cArray = null;
        if (keySpec instanceof PBEKeySpec) {
            keySpec2 = (PBEKeySpec)keySpec;
            cArray = ((PBEKeySpec)keySpec2).getPassword();
        }
        if (keySpec instanceof PKCS5KeySpec) {
            keySpec2 = (PKCS5KeySpec)keySpec;
            cArray = ((PKCS5KeySpec)keySpec2).getPassword();
        }
        if (keySpec instanceof SecretKeySpec) {
            String string2;
            keySpec2 = (SecretKeySpec)keySpec;
            byte[] byArray = ((SecretKeySpec)keySpec2).getEncoded();
            try {
                string2 = new String(byArray, z[5]);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = new String(byArray);
            }
            cArray = string2.toCharArray();
        }
        if (cArray == null) {
            throw new InvalidKeySpecException(z[6]);
        }
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (cArray[n2] >= ' ' && cArray[n2] <= '~') continue;
            throw new InvalidKeySpecException(z[7]);
        }
        this.key = new byte[cArray.length];
        n2 = 0;
        while (true) {
            if (n2 >= cArray.length) {
                Arrays.fill(cArray, ' ');
                this.type = string;
                return;
            }
            this.key[n2] = (byte)(cArray[n2] & 0x7F);
            ++n2;
        }
    }

    @Override
    public synchronized byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return this.type;
    }

    @Override
    public String getFormat() {
        return z[9];
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return n2 ^ this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!(secretKey.getAlgorithm().equalsIgnoreCase(this.type) || secretKey.getAlgorithm().toUpperCase().equals(z[0]) || this.type.equals(z[1]) && secretKey.getAlgorithm().toUpperCase().startsWith(z[2]))) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl2 = MessageDigest.isEqual(this.key, byArray);
        Arrays.fill(byArray, (byte)0);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.key == null) {
            throw new InvalidObjectException(z[4]);
        }
        this.key = (byte[])this.key.clone();
        if (this.key.length != 1 || this.key[0] != 0) {
            for (int n2 = 0; n2 < this.key.length; ++n2) {
                if (this.key[n2] >= 32 && this.key[n2] <= 126) continue;
                throw new InvalidObjectException(z[3]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            PBEKey pBEKey = this;
            synchronized (pBEKey) {
                if (this.key != null) {
                    Arrays.fill(this.key, (byte)0);
                    this.key = null;
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\r\u001c\u0004";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                block20: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block20;
                    n5 = n5;
                    if (n5 <= n4) break block21;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 93;
                            break;
                        }
                        case 1: {
                            n6 = 94;
                            break;
                        }
                        case 2: {
                            n6 = 65;
                            break;
                        }
                        case 3: {
                            n6 = 48;
                            break;
                        }
                        default: {
                            n6 = 61;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\r\u001c\u0004";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\r\u001c\u0004";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\r\u001c\u0004{X$~)QY}0.^\u0010\u001c\r\u0002yt}=)QO.";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\r\u001c\u0004{X$~\"_H1:/\u0017I}<$\u0010Y8-$BT<2(JX9";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "eft\tbl";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001831DD}. CN*13T";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\r?2CJ2,%\u0010T.~/_I}\u001f\u0012st\u0014";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u00140 @M/11BT<*$\u0010V8'aCM8=(VT>?5YR3";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u000f\u001f\u0016";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

