/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class HCSslRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private final String keystoreName;
    private final String keystorePassword;
    private final String certificatePassword;

    public HCSslRMIServerSocketFactory(String keystoreName, String keystorePassword, String certificatePassword) {
        this.keystoreName = keystoreName;
        this.keystorePassword = keystorePassword;
        this.certificatePassword = certificatePassword;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket serverSocket = null;
        FileInputStream keystoreStream = new FileInputStream(new File(this.keystoreName));
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("IBMX509");
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(keystoreStream, this.keystorePassword.toCharArray());
            kmf.init(keystore, this.certificatePassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("IBMX509");
            tmf.init(keystore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            SSLServerSocketFactory sslServerSocketFactory = context.getServerSocketFactory();
            serverSocket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(port);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException(e);
        }
        catch (KeyManagementException e) {
            throw new IOException(e);
        }
        finally {
            ((InputStream)keystoreStream).close();
        }
        return serverSocket;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

