/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.SecureRandom;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SSLHashingwithDSA
extends SignatureSpi {
    private Signature sig;
    private byte[] hashData;
    private int count = 0;
    private SessionManager sessionManager;
    private Session session;
    private boolean isSign;
    private Key sigKey;

    public PKCS11SSLHashingwithDSA(Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.sig = new Signature(17, provider);
        this.hashData = new byte[128];
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
    }

    public PKCS11SSLHashingwithDSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    @Override
    protected void engineSetParameter(String key, Object param) {
    }

    @Override
    protected Object engineGetParameter(String key) {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.count = 0;
        if (this.session != null) {
            this.cancelOperation();
        }
        if (this.session == null) {
            this.session = this.sessionManager.getOpSession();
        }
        try {
            this.sig.engineInitSign(this.session, privateKey);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
            throw new InvalidKeyException(ex);
        }
        catch (InvalidKeyException ex) {
            this.sessionManager.releaseSession(this.session);
            this.session = null;
            throw ex;
        }
        this.isSign = true;
        this.sigKey = privateKey;
    }

    private void cancelOperation() {
        if (this.session == null) {
            return;
        }
        if (this.session.hasObjects()) {
            if (this.isSign) {
                try {
                    this.sig.engineSign(this.session, this.hashData, this.count);
                }
                catch (Exception exception) {}
            } else {
                this.sig.engineDummyVerify(this.session, "DSA");
            }
        } else {
            this.sessionManager.closeSession(this.session);
            this.session = null;
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.count = 0;
        if (this.session != null) {
            this.cancelOperation();
        }
        if (this.session == null) {
            this.session = this.sessionManager.getOpSession();
        }
        try {
            this.sig.engineInitVerify(this.session, publicKey);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
            throw new InvalidKeyException(ex);
        }
        catch (InvalidKeyException ex) {
            this.sessionManager.releaseSession(this.session);
            this.session = null;
            throw ex;
        }
        this.isSign = false;
        this.sigKey = publicKey;
    }

    protected void engineInitVerify(PublicKey publicKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
    }

    @Override
    protected void engineUpdate(byte b) {
        if (this.session == null) {
            if (this.sigKey == null) {
                throw new RuntimeException("Signature is not initialized");
            }
            try {
                if (this.isSign) {
                    this.engineInitSign((PrivateKey)this.sigKey);
                } else {
                    this.engineInitVerify((PublicKey)this.sigKey);
                }
            }
            catch (InvalidKeyException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.count + 1 > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        this.hashData[this.count] = b;
        ++this.count;
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) {
        if (data.length < off + len) {
            throw new IllegalArgumentException("invalid parameter");
        }
        if (this.session == null) {
            if (this.sigKey == null) {
                throw new RuntimeException("Signature is not initialized");
            }
            try {
                if (this.isSign) {
                    this.engineInitSign((PrivateKey)this.sigKey);
                } else {
                    this.engineInitVerify((PublicKey)this.sigKey);
                }
            }
            catch (InvalidKeyException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.count + len > this.hashData.length) {
            byte[] temp = new byte[this.hashData.length + 128 + len];
            System.arraycopy(this.hashData, 0, temp, 0, this.hashData.length);
            this.hashData = temp;
        }
        System.arraycopy(data, off, this.hashData, this.count, len);
        this.count += len;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] signature = null;
        if (!this.isSign || this.sigKey == null) {
            throw new SignatureException("Signature object was not properly initialized");
        }
        if (this.session == null) {
            try {
                this.engineInitSign((PrivateKey)this.sigKey);
            }
            catch (InvalidKeyException ex) {
                throw new SignatureException(ex);
            }
        }
        try {
            signature = this.sig.engineSign(this.session, this.hashData, this.count);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        finally {
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
        }
        this.count = 0;
        try {
            byte[] r = new byte[20];
            byte[] s = new byte[20];
            System.arraycopy(signature, 0, r, 0, 20);
            System.arraycopy(signature, 20, s, 0, 20);
            DerOutputStream out = new DerOutputStream(100);
            out.putInteger(new BigInteger(1, r));
            out.putInteger(new BigInteger(1, s));
            DerValue result = new DerValue(48, out.toByteArray());
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new SignatureException("error encoding signature");
        }
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        byte[] signingBytes = new byte[40];
        if (this.isSign || this.sigKey == null) {
            throw new SignatureException("Signature object was not properly initialized");
        }
        if (this.session == null) {
            try {
                this.engineInitVerify((PublicKey)this.sigKey);
            }
            catch (InvalidKeyException ex) {
                throw new SignatureException(ex);
            }
        }
        boolean rtn = false;
        try {
            DerInputStream in = new DerInputStream(signature);
            DerValue[] integers = in.getSequence(2);
            byte[] rPrime = integers[0].getInteger().toByteArray();
            byte[] sPrime = integers[1].getInteger().toByteArray();
            int length = rPrime.length;
            if (length > 20) {
                System.arraycopy(rPrime, length - 20, signingBytes, 0, 20);
            } else {
                System.arraycopy(rPrime, 0, signingBytes, 20 - length, length);
            }
            length = sPrime.length;
            if (length > 20) {
                System.arraycopy(sPrime, length - 20, signingBytes, 20, 20);
            } else {
                System.arraycopy(sPrime, 0, signingBytes, 40 - length, length);
            }
            rtn = this.sig.engineVerify(this.session, signingBytes, this.hashData, this.count);
        }
        catch (PKCS11Exception ex) {
            this.cancelOperation();
            throw ex;
        }
        catch (Exception e) {
            throw new SignatureException("invalid encoding for signature :" + e);
        }
        finally {
            if (this.session != null) {
                this.sessionManager.releaseSession(this.session);
                this.session = null;
            }
        }
        this.count = 0;
        return rtn;
    }
}

