/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.Base64;
import com.ibm.xml.enc.dom.DOMStructure;
import com.ibm.xml.enc.dom.DOMUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMPGPData
extends DOMStructure
implements PGPData {
    private final byte[] keyId;
    private final byte[] keyPacket;
    private final List externalElements;

    public DOMPGPData(byte[] keyPacket, List other) {
        if (keyPacket == null) {
            throw new NullPointerException("keyPacket cannot be null");
        }
        if (other == null || other.isEmpty()) {
            this.externalElements = Collections.EMPTY_LIST;
        } else {
            ArrayList otherCopy = new ArrayList(other);
            for (int i = 0; i < otherCopy.size(); ++i) {
                if (otherCopy.get(i) instanceof XMLStructure) continue;
                throw new ClassCastException("other[" + i + "] is not a valid PGPData type");
            }
            this.externalElements = Collections.unmodifiableList(otherCopy);
        }
        this.keyPacket = (byte[])keyPacket.clone();
        this.checkKeyPacket(keyPacket);
        this.keyId = null;
    }

    public DOMPGPData(byte[] keyId, byte[] keyPacket, List other) {
        if (keyId == null) {
            throw new NullPointerException("keyId cannot be null");
        }
        if (keyId.length != 8) {
            throw new IllegalArgumentException("keyId must be 8 bytes long");
        }
        if (other == null || other.isEmpty()) {
            this.externalElements = Collections.EMPTY_LIST;
        } else {
            ArrayList otherCopy = new ArrayList(other);
            for (int i = 0; i < otherCopy.size(); ++i) {
                if (otherCopy.get(i) instanceof XMLStructure) continue;
                throw new ClassCastException("other[" + i + "] is not a valid PGPData type");
            }
            this.externalElements = Collections.unmodifiableList(otherCopy);
        }
        this.keyId = (byte[])keyId.clone();
        byte[] byArray = this.keyPacket = keyPacket == null ? null : (byte[])keyPacket.clone();
        if (keyPacket != null) {
            this.checkKeyPacket(keyPacket);
        }
    }

    public DOMPGPData(Element pdElem) throws MarshalException {
        byte[] keyId = null;
        byte[] keyPacket = null;
        NodeList nl = pdElem.getChildNodes();
        ArrayList<javax.xml.crypto.dom.DOMStructure> other = new ArrayList<javax.xml.crypto.dom.DOMStructure>(nl.getLength());
        for (int x = 0; x < nl.getLength(); ++x) {
            Node n = nl.item(x);
            if (n.getNodeType() != 1) continue;
            Element childElem = (Element)n;
            try {
                if (childElem.getLocalName().equals("PGPKeyID")) {
                    keyId = Base64.decode(childElem);
                    continue;
                }
                if (childElem.getLocalName().equals("PGPKeyPacket")) {
                    keyPacket = Base64.decode(childElem);
                    continue;
                }
                other.add(new javax.xml.crypto.dom.DOMStructure(childElem));
                continue;
            }
            catch (IOException bde) {
                throw new MarshalException(bde);
            }
        }
        this.keyId = keyId;
        this.keyPacket = keyPacket;
        this.externalElements = Collections.unmodifiableList(other);
    }

    @Override
    public byte[] getKeyId() {
        return this.keyId == null ? null : (byte[])this.keyId.clone();
    }

    @Override
    public byte[] getKeyPacket() {
        return this.keyPacket == null ? null : (byte[])this.keyPacket.clone();
    }

    public List getExternalElements() {
        return this.externalElements;
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element pdElem = DOMUtils.createElement(ownerDoc, "PGPData", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        if (this.keyId != null) {
            Element keyIdElem = DOMUtils.createElement(ownerDoc, "PGPKeyID", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
            keyIdElem.appendChild(ownerDoc.createTextNode(Base64.encode(this.keyId)));
            pdElem.appendChild(keyIdElem);
        }
        if (this.keyPacket != null) {
            Element keyPktElem = DOMUtils.createElement(ownerDoc, "PGPKeyPacket", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
            keyPktElem.appendChild(ownerDoc.createTextNode(Base64.encode(this.keyPacket)));
            pdElem.appendChild(keyPktElem);
        }
        Iterator i = this.externalElements.iterator();
        while (i.hasNext()) {
            DOMUtils.appendChild(pdElem, ((javax.xml.crypto.dom.DOMStructure)i.next()).getNode());
        }
        parent.appendChild(pdElem);
    }

    private void checkKeyPacket(byte[] keyPacket) {
        if (keyPacket.length < 3) {
            throw new IllegalArgumentException("keypacket must be at least 3 bytes long");
        }
        byte tag = keyPacket[0];
        if ((tag & 0x80) != 128) {
            throw new IllegalArgumentException("keypacket tag is invalid: bit 7 is not set");
        }
        if ((tag & 0x40) != 64) {
            throw new IllegalArgumentException("old keypacket tag format is unsupported");
        }
        if ((tag & 6) != 6 && (tag & 0xE) != 14 && (tag & 5) != 5 && (tag & 7) != 7) {
            throw new IllegalArgumentException("keypacket tag is invalid: must be 6, 14, 5, or 7");
        }
    }
}

