/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Attribute
implements DerEncoder {
    ObjectIdentifier oid;
    DerValue value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.Attribute";
    private static final String specialChars = ",+=\n<>#;";
    private static final String digits = "0123456789ABCDEF";

    public Attribute(ObjectIdentifier type, DerValue val) {
        if (debug != null) {
            debug.entry(16384L, className, "Attribute", type, val);
        }
        this.oid = type;
        this.value = val;
        if (debug != null) {
            debug.exit(16384L, className, "Attribute");
        }
    }

    Attribute(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Attribute", in);
        }
        AVA ava = new AVA(in);
        this.oid = ava.getOID();
        this.value = ava.getDerValue();
        if (debug != null) {
            debug.exit(16384L, className, "Attribute");
        }
    }

    public Attribute(DerInputStream in) throws IOException {
        DerValue assertion;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Attribute", in);
        }
        if ((assertion = in.getDerValue()).getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "Attribute", "X500 Attribute, not a sequence");
            }
            throw new IOException("X500 Attribute, not a sequence");
        }
        this.oid = assertion.getData().getOID();
        this.value = assertion.getData().getDerValue();
        if (assertion.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "Attribute", "Attribute, extra bytes = " + assertion.getData().available());
            }
            throw new IOException("Attribute, extra bytes = " + assertion.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "Attribute");
        }
    }

    boolean equals(Attribute other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
            debug.exit(16384L, (Object)className, "equals", this.oid.equals(other.oid) && this.value.equals(other.value));
        }
        return this.oid.equals(other.oid) && this.value.equals(other.value);
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            return true;
        }
        if (other instanceof Attribute) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((Attribute)other));
            }
            return this.equals((Attribute)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode() + this.value.hashCode();
    }

    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.derEncode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream tmp2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", out);
        }
        tmp.putOID(this.oid);
        this.value.encode(tmp);
        tmp2.write((byte)48, tmp);
        out.write(tmp2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        AVA ava = new AVA(this.oid, this.value);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", ava.toString());
        }
        return ava.toString();
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.oid);
        }
        return this.oid;
    }

    public DerValue getDerValue() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDerValue");
        }
        if (this.value != null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDerValue_1", new DerValue(this.value.toByteArray()));
            }
            return new DerValue(this.value.toByteArray());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDerValue_2", this.value);
        }
        return this.value;
    }
}

