/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import java.io.FileInputStream;

public class epki2pki {
    public static void main(String[] argv) {
        if (argv.length < 3) {
            System.out.println("Usage: epki2pki <src_key_file> <passwd> <outfile>");
            System.out.println("  where <key_file> contains the DER-encoding of an EncryptedPrivateKeyInfo ");
            System.out.println("        <passwd> is the password the key is encrypted with");
            System.out.println("        <outfile> is the file to write the PrivateKeyInfo to");
            System.exit(1);
        }
        char[] passwd = argv[1].toCharArray();
        try {
            System.out.println("Creating an EncryptedPrivateKeyInfo from EPKI encoding in  " + argv[0]);
            FileInputStream fis = new FileInputStream(argv[0]);
            FileInputStream fis2 = new FileInputStream(argv[0]);
            HexDumpEncoder hd = new HexDumpEncoder();
            int avail = fis.available();
            byte[] data = new byte[avail];
            fis.read(data, 0, avail);
            fis.close();
            System.out.println("EncryptedPrivateKey:");
            System.out.println(hd.encodeBuffer(data));
            byte[] encoding = new byte[fis2.available()];
            fis2.read(encoding);
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(encoding);
            System.out.println("Decrypting the EncryptedPrivateKeyInfo into a PrivateKeyInfo");
            byte[] keyBytes = epki.decrypt(passwd);
            System.out.println("Creating a new PrivateKeyInfo object");
            PrivateKeyInfo pki = new PrivateKeyInfo(keyBytes);
            System.out.println("The PrivateKeyInfo: ");
            System.out.println(pki.toString());
            fis2.close();
            System.out.println("Writing the PrivateKeyInfo to file " + argv[2]);
            pki.write(argv[2], false);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.toString());
            e.printStackTrace();
        }
    }
}

