/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Info;
import com.ibm.pkcs11.PKCS11Slot;

public abstract class PKCS11 {
    protected PKCS11() {
    }

    public void libInitialize() throws PKCS11Exception {
    }

    public void libFinalize() throws PKCS11Exception {
    }

    public abstract PKCS11Info getInfo() throws PKCS11Exception;

    public abstract PKCS11Slot[] getSlotList(boolean var1) throws PKCS11Exception;

    public PKCS11Slot getFirstTokenSlot() throws PKCS11Exception {
        PKCS11Slot[] slots = this.getSlotList(true);
        return slots.length > 0 ? slots[0] : null;
    }

    public abstract PKCS11Slot waitForSlotEvent(boolean var1) throws PKCS11Exception;

    public String toString() {
        try {
            return this.getInfo().toString();
        }
        catch (PKCS11Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    protected void finalize() {
        try {
            this.libFinalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String flagsToString(int f, int[] flagList, String[] flagNames, String separator) {
        if (f == 0) {
            return "0x0";
        }
        StringBuilder buf = new StringBuilder(64);
        String sep = "";
        for (int i = 0; i < flagList.length; ++i) {
            if ((flagList[i] & f) == 0) continue;
            buf.append(sep);
            buf.append(flagNames[i]);
            f &= ~flagList[i];
            sep = separator;
        }
        if (f != 0) {
            buf.append(sep);
            buf.append("0x");
            buf.append(Integer.toString(f, 16));
        }
        return buf.toString();
    }

    static String versionString(int version) {
        StringBuilder b = new StringBuilder();
        int major = version >> 8;
        int minor = version & 0xFF;
        b.append(major);
        b.append(".");
        b.append(minor / 10);
        if (minor % 10 != 0) {
            b.append(minor % 10);
        }
        return b.toString();
    }
}

