/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.Message;
import com.ibm.jvm.trace.format.api.MessageFile;
import com.ibm.jvm.trace.format.api.NameValueTuple;
import com.ibm.jvm.trace.format.api.TraceFileHeader;
import com.ibm.jvm.trace.format.api.TracePoint;
import com.ibm.jvm.trace.format.api.TraceRecord;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class TraceContext {
    protected static final int traceFormatMajorVersion = 2;
    protected static final int traceFormatMinorVersion = 0;
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final int BYTE = 1;
    public static final int INT = 4;
    public static final int LONG = 8;
    public static final int SIZE_T = -1;
    protected static final BigInteger MILLIS2SECONDS = BigInteger.valueOf(1000L);
    protected static final BigInteger SECONDS2MINUTES = BigInteger.valueOf(60L);
    protected static final BigInteger MINUTES2HOURS = BigInteger.valueOf(60L);
    protected static final BigInteger HOURS2DAYS = BigInteger.valueOf(24L);
    protected static final BigInteger MILLION = BigInteger.valueOf(1000000L);
    float version;
    BigInteger highPrecisionTicksPerMillisecond = BigInteger.valueOf(1000L);
    BigInteger lastWritePlatform = BigInteger.ZERO;
    BigInteger lastWriteSystem = BigInteger.ZERO;
    long totalTracePoints = 0L;
    long totalRecords = 0L;
    protected MessageFile messageFile;
    protected Vector auxiliaryMessageFiles;
    TraceFileHeader metadata;
    PrintStream errorStream = System.out;
    long errorCount = 0L;
    PrintStream warningStream = System.out;
    long warningCount = 0L;
    PrintStream messageStream = System.out;
    PrintStream debugStream = System.out;
    int debugLevel = 0;
    List threads = new ArrayList();
    Map threadMap = new HashMap();
    boolean sorted = false;
    Map knownThreads = new HashMap();
    Set filteredThreads;
    int timezoneOffset = 0;

    TraceContext(int recordSize, ByteOrder endian) {
        this.metadata = new TraceFileHeader(recordSize, endian);
    }

    private TraceContext(ByteBuffer data, PrintStream message, PrintStream error, PrintStream warning, PrintStream debug) throws IOException {
        TraceFileHeader header;
        this.auxiliaryMessageFiles = new Vector();
        this.messageStream = message;
        this.warningStream = warning;
        this.errorStream = error;
        this.debugStream = debug;
        this.metadata = header = new TraceFileHeader(this, data);
    }

    private TraceContext(ByteBuffer data, InputStream messageFile, PrintStream message, PrintStream error, PrintStream warning, PrintStream debug) throws IOException {
        this(data, message, error, warning, debug);
        this.messageFile = MessageFile.getMessageFile(messageFile, this);
    }

    private TraceContext(ByteBuffer data, File messageFile, PrintStream message, PrintStream error, PrintStream warning, PrintStream debug) throws IOException {
        this(data, message, error, warning, debug);
        this.messageFile = MessageFile.getMessageFile(messageFile, this);
    }

    public void warning(Object source, Object message) {
        ++this.warningCount;
        if (this.warningStream != null) {
            this.warningStream.println(message);
        }
    }

    public void error(Object source, Object message) {
        ++this.errorCount;
        if (this.errorStream != null) {
            this.errorStream.println("Error: " + message);
        }
    }

    public void message(Object source, Object message) {
        if (this.messageStream != null) {
            this.messageStream.println(message);
        }
    }

    public void debug(Object source, int level, Object message) {
        if (this.debugStream != null && this.debugLevel >= level) {
            this.debugStream.println(message);
        }
    }

    public void setErrorStream(PrintStream stream) {
        this.errorStream = stream;
    }

    public void setWarningStream(PrintStream stream) {
        this.warningStream = stream;
    }

    public void setDebugStream(PrintStream stream) {
        this.debugStream = stream;
    }

    public void setMessageStream(PrintStream stream) {
        this.messageStream = stream;
    }

    public float getVersion() {
        return this.version;
    }

    public String getVmVersionString() {
        return this.metadata.serviceSection.serviceString;
    }

    public BigInteger getHighPrecisionResolution() {
        return this.highPrecisionTicksPerMillisecond;
    }

    public int getRecordSize() {
        return this.metadata.recordSize;
    }

    public int getHeaderSize() {
        return this.metadata.dataHeader.length;
    }

    public int getHeaderSize(ByteBuffer data) {
        data.order(this.metadata.byteOrder);
        DataHeader header = new DataHeader(this, data, "UTTH", false);
        return header.length;
    }

    public ByteOrder order() {
        return this.metadata.byteOrder;
    }

    public int getTraceType() {
        return this.metadata.traceSection.type;
    }

    public void setTraceType(int type) {
        boolean validType = true;
        if (this.debugStream != null) {
            String typeName;
            switch (type) {
                case 1: {
                    typeName = "External";
                    break;
                }
                case 0: {
                    typeName = "External";
                    break;
                }
                default: {
                    typeName = "<" + type + " is an invalid trace type>";
                    validType = false;
                }
            }
            this.debug(this, 1, "Forcing trace type to " + typeName + " at user request");
        }
        if (this.metadata != null && this.metadata.traceSection != null && validType) {
            this.metadata.traceSection.type = type;
        } else if (this.metadata == null || this.metadata.traceSection == null) {
            this.error(this, "Unable to set trace type due to incomplete trace context");
        } else {
            this.error(this, "Unable to set trace type to invalid type " + type);
        }
    }

    public long getTotalTracePoints() {
        return this.totalTracePoints;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getWarningCount() {
        return this.warningCount;
    }

    public void addMessageData(File file) throws IOException {
        this.auxiliaryMessageFiles.add(MessageFile.getMessageFile(new FileInputStream(file), this));
    }

    public void addMessageData(InputStream stream) throws IOException {
        this.auxiliaryMessageFiles.add(MessageFile.getMessageFile(stream, this));
    }

    public int getPointerSize() {
        return this.metadata.traceSection.pointerSize;
    }

    public static TraceContext getContext(ByteBuffer data, File messageFile) throws IOException {
        return TraceContext.getContext(data, messageFile, System.out, System.err, System.out, null);
    }

    public static TraceContext getContext(byte[] data, int length, File messageFile) throws IOException {
        return TraceContext.getContext(data, length, messageFile, System.out, System.err, System.out, null);
    }

    public static TraceContext getContext(byte[] data, int length, File messageFile, PrintStream message, PrintStream error, PrintStream warning, PrintStream debug) throws IOException {
        return TraceContext.getContext(ByteBuffer.wrap(data, 0, length), messageFile, message, error, warning, debug);
    }

    public static TraceContext getContext(ByteBuffer data, InputStream messageFile) throws IOException {
        return TraceContext.getContext(data, messageFile, System.out, System.err, System.out, null);
    }

    public static TraceContext getContext(byte[] data, int length, InputStream messageFile) throws IOException {
        return TraceContext.getContext(data, length, messageFile, System.out, System.err, System.out, null);
    }

    public static TraceContext getContext(byte[] data, int length, InputStream messageFile, PrintStream message, PrintStream error, PrintStream warning, PrintStream debug) throws IOException {
        return TraceContext.getContext(ByteBuffer.wrap(data, 0, length), messageFile, message, error, warning, debug);
    }

    public static TraceContext getContext(ByteBuffer data, File messageFile, PrintStream message, PrintStream error, PrintStream warning, PrintStream debug) throws IOException {
        return new TraceContext(data, messageFile, message, warning, error, debug);
    }

    public static TraceContext getContext(ByteBuffer data, InputStream messageFile, PrintStream message, PrintStream error, PrintStream warning, PrintStream debug) throws IOException {
        return new TraceContext(data, messageFile, message, warning, error, debug);
    }

    ByteStream createByteStream() {
        ByteStream stream = new ByteStream();
        stream.order(this.metadata.byteOrder);
        return stream;
    }

    ByteStream createByteStream(byte[] data) {
        return this.createByteStream(data, 0);
    }

    ByteStream createByteStream(byte[] data, int offset) {
        return this.createByteStream(data, offset, data.length - offset);
    }

    ByteStream createByteStream(byte[] data, int offset, int length) {
        ByteStream stream = new ByteStream(data);
        stream.order(this.metadata.byteOrder);
        return stream;
    }

    synchronized void threadTerminated(TraceThread thread, boolean moreData) {
        if (this.debugStream != null) {
            this.debug(this, 2, "Thread " + thread + " terminated, removing thread from thread list? " + moreData);
        }
        if (!moreData) {
            this.threadMap.remove(thread.getThreadID());
            this.threads.remove(thread);
        }
    }

    private synchronized TraceThread addData(TraceRecord record) {
        Set<String> names;
        Long ident = record.threadID;
        if (record.threadName.equals("Exception trace pseudo-thread")) {
            // empty if block
        }
        if (this.knownThreads.containsKey(ident)) {
            names = (Set)this.knownThreads.get(ident);
            names.add(record.threadName);
        } else {
            names = new HashSet<String>();
            names.add(record.threadName);
            this.knownThreads.put(ident, names);
        }
        TraceThread thread = (TraceThread)this.threadMap.get(ident);
        if (thread == null || thread.stream == null) {
            thread = new TraceThread(this, record.threadID, record.threadSyn1, record.threadName);
            this.threads.add(thread);
            this.threadMap.put(ident, thread);
            this.sorted = false;
        } else {
            this.metadata.traceSection.type = 1;
        }
        if (record.writePlatform.compareTo(this.lastWritePlatform) > 0) {
            this.lastWritePlatform = record.writePlatform;
        }
        if (record.writeSystem.compareTo(this.lastWriteSystem) > 0) {
            this.lastWriteSystem = record.writeSystem;
        }
        if (this.metadata.traceSection.startPlatform.compareTo(BigInteger.ZERO) != 0 && this.metadata.traceSection.startSystem != this.lastWriteSystem) {
            BigInteger uptime = this.lastWriteSystem.subtract(this.metadata.traceSection.startSystem);
            this.highPrecisionTicksPerMillisecond = uptime.compareTo(BigInteger.ZERO) == 0 ? this.lastWritePlatform.subtract(this.metadata.traceSection.startPlatform) : this.lastWritePlatform.subtract(this.metadata.traceSection.startPlatform).divide(uptime);
        }
        if (this.filteredThreads == null || this.filteredThreads.contains(record.threadID)) {
            thread.addRecord(record);
        }
        return thread;
    }

    public TraceThread addData(RandomAccessFile file, long offset) throws IOException {
        return this.addData(new TraceRecord(this, file, offset));
    }

    public TraceThread addData(byte[] data) {
        return this.addData(new TraceRecord(this, data));
    }

    public synchronized void discardedData() {
        for (TraceThread thread : this.threads) {
            thread.userDiscardedData();
        }
    }

    public BigInteger getStartPlatform() {
        return this.metadata.traceSection.startPlatform;
    }

    public BigInteger getStartSystem() {
        return this.metadata.traceSection.startSystem;
    }

    public Iterator getThreads() {
        return new ThreadListIterator(this.threads);
    }

    public Iterator getTracepoints() {
        return new SortedTracepointIterator();
    }

    public void addThreadToFilter(Long threadID) {
        if (this.filteredThreads == null) {
            this.filteredThreads = new TreeSet();
        }
        this.filteredThreads.add(threadID);
    }

    public void setTimeZoneOffset(int minutes) {
        this.timezoneOffset = minutes;
    }

    final String getFormattedTime(BigInteger time) {
        switch (this.metadata.processorSection.counter) {
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                if ((double)this.version >= 1.1) {
                    long timeRaw = time.subtract(this.metadata.traceSection.startPlatform).longValue();
                    long hiprec = this.highPrecisionTicksPerMillisecond.longValue();
                    long millis = timeRaw / hiprec + this.metadata.traceSection.startSystem.longValue() + (long)(this.timezoneOffset * 60 * 1000);
                    long nanos = millis % 1000L * 1000000L + timeRaw % hiprec * 1000000L / hiprec;
                    long seconds = millis / 1000L % 60L;
                    long minutes = millis / 1000L / 60L % 60L;
                    long hours = millis / 1000L / 60L / 60L % 24L;
                    return (hours < 10L ? "0" : "") + hours + ":" + (minutes < 10L ? "0" : "") + minutes + ":" + (seconds < 10L ? "0" : "") + seconds + "." + "000000000".substring((nanos + "").length()) + nanos;
                }
                return "0000000000000000".substring(time.toString(16).length()) + time.toString(16);
            }
            case 3: {
                long seconds = (time.shiftRight(32).longValue() & 0xFFFFFFFFL) + (long)(this.timezoneOffset * 60);
                long nanos = time.longValue() & 0xFFFFFFFFL;
                long ss = seconds % 60L;
                long mm = seconds / 60L % 60L;
                long hh = seconds / 3600L % 24L;
                try {
                    return "00".substring(Long.toString(hh).length()) + Long.toString(hh) + ":" + "00".substring(Long.toString(mm).length()) + Long.toString(mm) + ":" + "00".substring(Long.toString(ss).length()) + Long.toString(ss) + "." + "000000000".substring(Long.toString(nanos).length()) + Long.toString(nanos);
                }
                catch (Exception e) {
                    this.debug(this, 1, "hh: " + Long.toString(hh) + " mm: " + Long.toString(mm) + " ss: " + Long.toString(ss) + " Nanos: " + Long.toString(nanos));
                    return "Bad Time: " + time.toString(16);
                }
            }
            case 6: {
                long micros = (time.shiftRight(12).longValue() & 0xFFFFFFFFFFFFFL) + (long)(this.timezoneOffset * 60 * 1000000);
                long ss = micros / 1000000L % 60L;
                long mm = micros / 60000000L % 60L;
                long hh = (micros / 3600000000L + (long)this.timezoneOffset) % 24L;
                long picos = (time.longValue() & 0xFFFL | (micros %= 1000000L) << 12) * 244140625L / 1000000L;
                try {
                    return "00".substring(Long.toString(hh).length()) + Long.toString(hh) + ":" + "00".substring(Long.toString(mm).length()) + Long.toString(mm) + ":" + "00".substring(Long.toString(ss).length()) + Long.toString(ss) + "." + "000000000000".substring(Long.toString(picos).length()) + Long.toString(picos);
                }
                catch (Exception e) {
                    this.debug(this, 1, "hh: " + Long.toString(hh) + " mm: " + Long.toString(mm) + " ss: " + Long.toString(ss) + " Picos: " + Long.toString(picos));
                    return "Bad Time: " + time.toString(16);
                }
            }
        }
        return "0000000000000000".substring(time.toString(16).length()) + time.toString(16);
    }

    public String formatPointer(long value) {
        String template = "0x0000000000000000";
        StringBuilder sb = new StringBuilder();
        int end = Long.numberOfLeadingZeros(value) / 4;
        if (this.getPointerSize() == 4) {
            end -= 8;
        }
        sb.append("0x0000000000000000".substring(0, end + 2));
        if (value > 0L) {
            sb.append(Long.toHexString(value));
        }
        return sb.toString();
    }

    public String summary() {
        StringBuilder sb = new StringBuilder("                Trace Summary" + System.getProperty("line.separator") + System.getProperty("line.separator"));
        sb.append(this.metadata.serviceSection.summary());
        sb.append(System.getProperty("line.separator"));
        sb.append(this.metadata.startupSection.summary());
        sb.append(this.metadata.processorSection.summary());
        sb.append(System.getProperty("line.separator"));
        sb.append(this.metadata.activeSection.summary());
        sb.append(System.getProperty("line.separator"));
        sb.append(this.metadata.traceSection.summary());
        sb.append(System.getProperty("line.separator"));
        sb.append("Active threads" + System.getProperty("line.separator"));
        for (Long key : this.knownThreads.keySet()) {
            Set names = (Set)this.knownThreads.get(key);
            int size = names.size();
            sb.append("        " + this.formatPointer(key));
            if (size > 1) {
                sb.append("  (id reused)" + System.getProperty("line.separator"));
                for (String name : names) {
                    sb.append("        ");
                    if (this.getPointerSize() == 4) {
                        sb.append("            " + name + System.getProperty("line.separator"));
                        continue;
                    }
                    sb.append("                    " + name + System.getProperty("line.separator"));
                }
                continue;
            }
            for (String name : names) {
                sb.append("  " + name + System.getProperty("line.separator"));
            }
        }
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    public void setDebugLevel(int level) {
        this.debugLevel = level;
    }

    public String statistics() {
        int nameWidth = 0;
        long hitMax = 0L;
        long bytesMax = 0L;
        HashMap stats = this.messageFile.getStatistics();
        for (int i = 0; i < this.auxiliaryMessageFiles.size(); ++i) {
            stats.putAll(((MessageFile)this.auxiliaryMessageFiles.get(i)).getStatistics());
        }
        TreeMap<String, Long> componentByteTotals = new TreeMap<String, Long>();
        Vector<NameValueTuple> componentTotals = new Vector<NameValueTuple>();
        TreeMap<String, Long> hitCount = new TreeMap<String, Long>();
        Vector<NameValueTuple> tracePointCounts = new Vector<NameValueTuple>();
        Vector<NameValueTuple> tracePointBytes = new Vector<NameValueTuple>();
        Iterator<Object> itr = stats.keySet().iterator();
        long totalBytes = 0L;
        while (itr.hasNext()) {
            Long l;
            String tp = (String)itr.next();
            Properties props = (Properties)stats.get(tp);
            String component = props.getProperty("component", "");
            int width = tp.length();
            if (width > nameWidth) {
                nameWidth = width;
            }
            if (props.containsKey("count")) {
                long count = (Long)props.get("count");
                if (count > hitMax) {
                    hitMax = count;
                }
                hitCount.put(tp, count);
                tracePointCounts.add(new NameValueTuple(tp, (Long)props.get("count")));
            }
            if (!props.containsKey("bytes") || (l = (Long)props.get("bytes")) == null) continue;
            long bytes = l;
            if (bytes > bytesMax) {
                bytesMax = bytes;
            }
            totalBytes += bytes;
            tracePointBytes.add(new NameValueTuple(tp, (Long)props.get("bytes")));
            long total = 0L;
            if (componentByteTotals.containsKey(component)) {
                total = (Long)componentByteTotals.get(component);
            }
            componentByteTotals.put(component, total + bytes);
        }
        StringBuffer sb = new StringBuffer();
        String nl = System.getProperty("line.separator");
        sb.append("Component totals (bytes)" + nl);
        for (String component : componentByteTotals.keySet()) {
            componentTotals.add(new NameValueTuple(component, (Long)componentByteTotals.get(component)));
        }
        Collections.sort(componentTotals);
        for (NameValueTuple tuple : componentTotals) {
            sb.append(String.format("%-" + nameWidth + "s %d%n", tuple.name() + ":", tuple.value()));
        }
        sb.append("Total bytes: " + totalBytes).append(nl);
        sb.append(nl);
        sb.append("Trace point counts:" + nl);
        Collections.sort(tracePointCounts);
        for (NameValueTuple tuple : tracePointCounts) {
            String name = tuple.name();
            Message msg = this.messageFile.getMessageFromID(name.substring(0, name.indexOf(46)), Integer.parseInt(name.substring(name.indexOf(46) + 1)));
            sb.append(String.format("%-" + nameWidth + "s %d (level: %2d)%n", tuple.name() + ":", tuple.value(), msg.getLevel()));
        }
        sb.append(nl);
        sb.append("Trace point totals (bytes):" + nl);
        Collections.sort(tracePointBytes);
        for (NameValueTuple tuple : tracePointBytes) {
            String name = tuple.name();
            Message msg = this.messageFile.getMessageFromID(name.substring(0, name.indexOf(46)), Integer.parseInt(name.substring(name.indexOf(46) + 1)));
            sb.append(String.format("%-" + nameWidth + "s %-" + (Math.log10(bytesMax) + 1.0) + "d (%6.2f%%, level: %2d, hit count: %-" + (Math.log10(hitMax) + 1.0) + "d)%n", tuple.name() + ":", tuple.value(), ((Long)tuple.value()).doubleValue() * 100.0 / (double)totalBytes, msg.getLevel(), hitCount.get(tuple.name())));
        }
        return sb.toString();
    }

    class SortedTracepointIterator
    implements Iterator {
        SortedTracepointIterator() {
        }

        public boolean hasNext() {
            this.sort();
            if (TraceContext.this.threads.size() > 0) {
                return ((TraceThread)TraceContext.this.threads.get(0)).getIterator().hasNext();
            }
            return false;
        }

        public Object next() {
            this.sort();
            TracePoint tp = (TracePoint)((TraceThread)TraceContext.this.threads.get(0)).getIterator().next();
            TraceContext.this.sorted = true;
            return tp;
        }

        private void sort() {
            if (!TraceContext.this.sorted) {
                for (int i = 0; i < TraceContext.this.threads.size(); ++i) {
                    ((TraceThread)TraceContext.this.threads.get(i)).refresh();
                }
                Collections.sort(TraceContext.this.threads);
                TraceContext.this.sorted = true;
            } else if (TraceContext.this.threads.size() > 1 && ((TraceThread)TraceContext.this.threads.get(0)).compareTo(TraceContext.this.threads.get(1)) > 0) {
                TraceThread bubble = (TraceThread)TraceContext.this.threads.get(0);
                TraceContext.this.threads.remove(0);
                Iterator itr = TraceContext.this.threads.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    if (bubble.compareTo(itr.next()) <= 0) {
                        TraceContext.this.threads.add(i, bubble);
                        bubble = null;
                        break;
                    }
                    ++i;
                }
                if (bubble != null) {
                    TraceContext.this.threads.add(bubble);
                }
                TraceContext.this.sorted = true;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ThreadListIterator
    implements Iterator {
        Object threadCursor = null;
        List threads = null;
        Iterator iterator;

        ThreadListIterator(List list) {
            this.threads = list;
            this.iterator = this.threads.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext() || this.threadCursor != null;
        }

        public Object next() {
            Object obj = null;
            List list = this.threads;
            synchronized (list) {
                try {
                    if (this.threadCursor == null) {
                        this.threadCursor = this.iterator.next();
                    }
                    obj = this.threadCursor;
                    this.threadCursor = this.iterator.next();
                    return obj;
                }
                catch (ConcurrentModificationException e) {
                    if (this.threadCursor != null) {
                        Iterator itr = this.threads.iterator();
                        while (itr.hasNext() && itr.next() != this.threadCursor) {
                        }
                        this.iterator = itr;
                        return this.next();
                    }
                    throw e;
                }
                catch (NoSuchElementException e) {
                    this.threadCursor = null;
                    if (obj != null) {
                        return obj;
                    }
                    throw e;
                }
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

