/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.marshalling.data.events;

import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.GCInternalEvent;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ObjectAllocationInternalObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ObjectAllocationEventHandler
extends Thread {
    List<GCInternalEvent> listeners = new ArrayList<GCInternalEvent>();
    Queue<ObjectAllocationInternalObject> events = new ConcurrentLinkedQueue<ObjectAllocationInternalObject>();
    private boolean flushData = false;
    private static int eventQueueSize = 0;
    private static final int maxEventQueueSize = 15;
    protected volatile boolean run = true;
    private static ObjectAllocationInternalObject cachedObject = null;
    private static boolean stackTraceDetected = false;

    public ObjectAllocationEventHandler() {
        super("Object Allocation Event Handler");
        this.setDaemon(true);
    }

    public void addObjectAllocationEventListener(GCInternalEvent gCInternalEvent) {
        this.listeners.add(gCInternalEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(ObjectAllocationInternalObject objectAllocationInternalObject) {
        Queue<ObjectAllocationInternalObject> queue = this.events;
        synchronized (queue) {
            if (eventQueueSize < 15 && !this.flushData) {
                this.events.add(objectAllocationInternalObject);
                ++eventQueueSize;
            } else {
                this.flushData = true;
            }
            this.events.notify();
        }
    }

    private void triggerObjectAllocation(ObjectAllocationInternalObject objectAllocationInternalObject) {
        for (GCInternalEvent gCInternalEvent : this.listeners) {
            gCInternalEvent.objectAllocationEvent(objectAllocationInternalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.run) {
            try {
                if (!this.events.isEmpty()) {
                    if (this.flushData) {
                        while (this.flushData) {
                            this.triggerObjectAllocation(this.events.poll());
                            --eventQueueSize;
                            if (!this.events.isEmpty()) continue;
                            this.flushData = false;
                        }
                    } else {
                        this.triggerObjectAllocation(this.events.poll());
                        --eventQueueSize;
                    }
                }
                Queue<ObjectAllocationInternalObject> queue = this.events;
                synchronized (queue) {
                    try {
                        if (this.events.isEmpty()) {
                            this.events.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static ObjectAllocationInternalObject getCachedObject() {
        return cachedObject;
    }

    public static void setCachedObject(ObjectAllocationInternalObject objectAllocationInternalObject) {
        cachedObject = objectAllocationInternalObject;
    }

    public static boolean isStackTraceDetected() {
        return stackTraceDetected;
    }

    public static void setStackTraceDetected(boolean bl) {
        stackTraceDetected = bl;
    }

    public void terminate() {
        this.run = false;
        this.interrupt();
    }
}

