/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace;

import com.ibm.java.diagnostics.common.datamodel.data.axes.LinearUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AbstractUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import java.math.BigInteger;
import java.text.NumberFormat;

public abstract class AbstractClockCyclesConverter
extends AbstractUnitConverter
implements LinearUnitConverter {
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private static final int UNSET = -1;
    private TraceMetaData meta;
    private boolean normalised;
    private boolean isDelta;
    private double normalisationOffset = -1.0;
    private double overallStartPlatform;
    private BigInteger startSystem;
    private double startSystemValue;
    private BigInteger highPrecisionResolution;
    private double highPrecisionResolutionValue;

    public AbstractClockCyclesConverter(TraceMetaData traceMetaData, boolean bl) {
        this(traceMetaData, bl, !bl);
    }

    public AbstractClockCyclesConverter(TraceMetaData traceMetaData, boolean bl, boolean bl2) {
        this.meta = traceMetaData;
        this.normalised = bl;
        this.isDelta = bl2;
    }

    protected abstract double getConversionConstant();

    @Override
    public double convert(double d, int n) {
        return this.convert(d);
    }

    protected final double convertToMilliseconds(double d) {
        double d2 = this.getHighPrecisionResolution();
        double d3 = d;
        d3 = this.isDelta ? d : (this.normalised ? d - this.normalisationOffset : d - this.overallStartPlatform);
        double d4 = d3 / d2;
        if (!this.normalised && !this.isDelta) {
            d4 += this.getStartSystem();
        }
        return d4;
    }

    private double getHighPrecisionResolution() {
        BigInteger bigInteger = this.meta.getTraceContext().getHighPrecisionResolution();
        if (bigInteger != this.highPrecisionResolution) {
            this.highPrecisionResolution = bigInteger;
            this.highPrecisionResolutionValue = this.highPrecisionResolution.doubleValue();
        }
        return this.highPrecisionResolutionValue;
    }

    private double getStartSystem() {
        BigInteger bigInteger = this.meta.getTraceContext().getStartSystem();
        if (bigInteger != this.startSystem) {
            this.startSystem = bigInteger;
            this.startSystemValue = this.startSystem.doubleValue();
        }
        return this.startSystemValue;
    }

    protected final double convertFromMilliseconds(double d) {
        double d2 = this.getHighPrecisionResolution();
        double d3 = d;
        if (!this.normalised && !this.isDelta) {
            d3 -= this.getStartSystem();
        }
        d3 *= d2;
        if (!this.isDelta) {
            d3 = this.normalised ? (d3 += this.normalisationOffset) : (d3 += this.overallStartPlatform);
        }
        return d3;
    }

    @Override
    public String unconvertedFormat(double d) {
        return NumberFormatter.prettyString(d);
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        this.numberFormat.setMinimumFractionDigits(n);
        this.numberFormat.setMaximumFractionDigits(n);
        this.numberFormat.setGroupingUsed(false);
        return this.numberFormat.format(d);
    }

    @Override
    public void setOffset(double d) {
        if (this.meta != null && this.meta.getTraceContext() != null) {
            this.overallStartPlatform = this.meta.getTraceContext().getStartPlatform().doubleValue();
            double d2 = this.overallStartPlatform / 2.0;
            double d3 = 3.0 * this.overallStartPlatform / 2.0;
            this.normalisationOffset = d > d2 && d < d3 ? d : this.overallStartPlatform;
        } else {
            this.normalisationOffset = d;
        }
    }

    @Override
    public double convert(double d) {
        return this.convertToMilliseconds(d) / this.getConversionConstant();
    }

    @Override
    public double reverseConvert(double d) {
        return this.convertFromMilliseconds(d * this.getConversionConstant());
    }
}

