/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jit;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemData;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.EventDataPoint;
import com.ibm.java.diagnostics.common.datamodel.impl.data.FullDataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.FullEventDataPoint;
import com.ibm.java.diagnostics.common.datamodel.impl.data.JavaMethod;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.jit.JITCompileDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.jit.JITDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.jit.JITLabels;
import com.ibm.java.diagnostics.healthcenter.jit.JITMethodDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.jit.Messages;
import com.ibm.java.diagnostics.healthcenter.jit.SharedCacheDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.jit.SharedCacheDisabledReason;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePointHandler;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracedThread;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JITTracePointHandler
implements TracePointHandler {
    private static final Logger TRACE = LogFactory.getTrace(JITTracePointHandler.class);
    private static final String CLASSNAME = JITTracePointHandler.class.getName();
    private static final DataFactory factory = DataFactory.getFactory();
    private static final String L_BRACKET = "(";
    private static final String DOT = ".";
    private static final String F_SLASH = "/";
    private static String EMTPY_STRING = "";
    private OutputProperties props;
    private AxisPair axisPair = null;
    private AxisPair numberAxisPair = null;
    private AxisPair amountAxisPair = null;
    private AxisPair timeAxisPair = null;
    private AxisPair percentAxisPair = null;
    private XDataAxis xAxis = null;

    @Override
    public void handleTraceStart(DynamicSource dynamicSource, TraceMetaData traceMetaData, DataBuilder dataBuilder, OutputProperties outputProperties) {
        Object object;
        Object object2;
        TRACE.entering(CLASSNAME, "handleTraceStart");
        this.props = outputProperties;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.JIT);
        if (dataBuilder2 instanceof SubsystemData && (object2 = (object = (SubsystemData)((Object)dataBuilder2)).getPerspectiveID()) == null) {
            dataBuilder.removeData(JVMLabels.JIT);
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine("Internal error: Postprocessed data was not cleared properly - deleting existing data.");
            }
        }
        if (this.xAxis != null) {
            TRACE.logp(Level.WARNING, CLASSNAME, "handleTraceStart", "xAxis already exists");
        }
        this.xAxis = AxisUtil.prepareXAxis(this.props);
        object = AxisUtil.prepareTimeAxis(outputProperties);
        object2 = AxisUtil.prepareBinaryAxis(this.props);
        YDataAxis yDataAxis = AxisUtil.prepareNumberAxis(this.props);
        YDataAxis yDataAxis2 = AxisUtil.prepareAmountAxis(this.props);
        YDataAxis yDataAxis3 = AxisUtil.PERCENT_AXIS.createDataAxis(outputProperties, UnitLabels.PERCENT_SIGN);
        if (this.axisPair != null) {
            TRACE.logp(Level.WARNING, CLASSNAME, "handleTraceStart", Messages.getString("JITTracePointHandler.axis.pair.already.exists"));
        }
        this.axisPair = factory.createAxisPair(this.xAxis, (YDataAxis)object2);
        this.numberAxisPair = factory.createAxisPair(this.xAxis, yDataAxis);
        this.amountAxisPair = factory.createAxisPair(this.xAxis, yDataAxis2);
        this.timeAxisPair = factory.createAxisPair(this.xAxis, (YDataAxis)object);
        this.percentAxisPair = factory.createAxisPair(this.xAxis, yDataAxis3);
        TRACE.exiting(CLASSNAME, "handleTraceStart");
    }

    private SubsystemDataBuilder getJITSubsystemData(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(JVMLabels.JIT);
        if (dataBuilder2 instanceof SubsystemDataBuilder) {
            subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createJITSubsystemData();
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private SubsystemDataBuilder createJITSubsystemData() {
        SubsystemDataBuilder subsystemDataBuilder = factory.createSubsystemData(JVMLabels.JIT, "com.ibm.java.diagnostics.healthcenter.jit.perspective.JITPerspective");
        return subsystemDataBuilder;
    }

    @Override
    public void handleTracePoint(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracePoint tracePoint, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "handleTracePoint");
        String string = tracePoint.getComponent();
        if ("j9jit".equals(string)) {
            switch (tracePoint.getID()) {
                case 1: {
                    this.handleCacheFull(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 2: {
                    break;
                }
                case 18: {
                    this.handleCompileEnd(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 20: {
                    this.handleMethodPrexInvalidated(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 21: {
                    this.handleIProfilerCapReached(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 22: {
                    this.handleIncompatibleAOTHeader(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 23: {
                    this.handleManyCompFailures(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 24: {
                    this.handleLowUserVirtualMemory(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 28: {
                    this.handleDataCacheFull(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 29: {
                    this.handleCodeCacheAllocated(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 43: {
                    this.handleCompRequest(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 44: {
                    this.handleCompileEnd15(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 45: {
                    this.handleAotLoadEnd(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 46: {
                    this.handleOverallCompCPU(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 47: {
                    this.handleSCCInfo(tracePoint, this.getJITSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
            }
        }
        TRACE.exiting(CLASSNAME, "handleTracePoint");
    }

    private void handleSCCInfo(TracePoint tracePoint, SubsystemDataBuilder subsystemDataBuilder, TraceMetaData traceMetaData) {
        Object[] objectArray;
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        String string = JITLabels.SCC_INFO;
        Data data = subsystemDataBuilder.getData(string);
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        if (data == null) {
            data = new TwoDimensionalDataImpl(string, this.axisPair);
            subsystemDataBuilder.addData((DataBuilder)data);
        }
        if ((objectArray = tracePoint.getParameters()) == null) {
            return;
        }
        SharedCacheDataPointImpl sharedCacheDataPointImpl = new SharedCacheDataPointImpl(0, d, this.axisPair);
        sharedCacheDataPointImpl.cacheName = (String)objectArray[0];
        sharedCacheDataPointImpl.cacheDir = (String)objectArray[1];
        sharedCacheDataPointImpl.cacheSize = (Long)objectArray[2];
        sharedCacheDataPointImpl.freeBytes = (Long)objectArray[3];
        sharedCacheDataPointImpl.softMaxBytes = (Long)objectArray[4];
        sharedCacheDataPointImpl.ROMClassBytes = (Long)objectArray[5];
        sharedCacheDataPointImpl.AOTBytes = (Long)objectArray[6];
        sharedCacheDataPointImpl.AOTDataBytes = (Long)objectArray[7];
        sharedCacheDataPointImpl.JITHintDataBytes = (Long)objectArray[8];
        sharedCacheDataPointImpl.JITProfileDataBytes = (Long)objectArray[9];
        sharedCacheDataPointImpl.numROMClasses = (Long)objectArray[10];
        sharedCacheDataPointImpl.numAOTMethods = (Long)objectArray[11];
        long l = (Long)objectArray[12];
        sharedCacheDataPointImpl.disabledReason = SharedCacheDisabledReason.values()[(int)l];
        ((TwoDimensionalDataBuilder)data).addDataPointBuilder(sharedCacheDataPointImpl);
    }

    private void handleOverallCompCPU(TracePoint tracePoint, SubsystemDataBuilder subsystemDataBuilder, TraceMetaData traceMetaData) {
        Object[] objectArray;
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        String string = JITLabels.COMP_CPU;
        Data data = subsystemDataBuilder.getData(string);
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        if (data == null) {
            data = new TwoDimensionalDataImpl(string, this.percentAxisPair);
            subsystemDataBuilder.addData((DataBuilder)data);
        }
        if ((objectArray = tracePoint.getParameters()) == null) {
            return;
        }
        long l = (Long)objectArray[0];
        FullDataPointImpl fullDataPointImpl = new FullDataPointImpl(0, d, l, "", this.percentAxisPair);
        ((TwoDimensionalDataBuilder)data).addDataPointBuilder(fullDataPointImpl);
    }

    @Override
    public void handleMissingData(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracedThread tracedThread, double d, int n, DataBuilder dataBuilder, OutputProperties outputProperties) {
    }

    private void handleCacheFull(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        String string = JITLabels.CACHE_FULL;
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.axisPair);
            dataBuilder.addData(dataBuilder2);
        }
        EventDataPoint eventDataPoint = new EventDataPoint(0, d, this.axisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(eventDataPoint);
    }

    private void handleCompileEnd(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        String string = (String)objectArray[1];
        String string2 = (String)objectArray[2];
        double d2 = (double)((Long)objectArray[9]).longValue() / 1000.0;
        long l = (Long)objectArray[4] - (Long)objectArray[3];
        if ((Long)objectArray[5] != 0L) {
            l += (Long)objectArray[6] - (Long)objectArray[5];
        }
        String string3 = (String)objectArray[0];
        long l2 = (Long)objectArray[3];
        long l3 = (Long)objectArray[4];
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        String string4 = JITLabels.COMPILE_END;
        DataBuilder dataBuilder2 = dataBuilder.getData(string4);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string4, this.timeAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        String string5 = this.generateMethodName(string2);
        JITCompileDataPointImpl jITCompileDataPointImpl = new JITCompileDataPointImpl(0, d, d2, string5, this.timeAxisPair, this.convertHotnessToInt(string), l2, l3);
        for (DataPointBuilder dataPointBuilder : ((TwoDimensionalDataBuilder)dataBuilder2).getAllDataPoints()) {
            JITCompileDataPointImpl jITCompileDataPointImpl2;
            if (dataPointBuilder.getRawX() >= jITCompileDataPointImpl.getRawX()) break;
            if (!(dataPointBuilder instanceof JITCompileDataPointImpl) || (jITCompileDataPointImpl2 = (JITCompileDataPointImpl)dataPointBuilder).isExpired() || !jITCompileDataPointImpl2.pcInRange(jITCompileDataPointImpl.getStartPC()) && !jITCompileDataPointImpl2.pcInRange(jITCompileDataPointImpl.getEndPC()) && !jITCompileDataPointImpl.pcInRange(jITCompileDataPointImpl2.getStartPC())) continue;
            jITCompileDataPointImpl2.setExpireTime(jITCompileDataPointImpl.getRawX());
            System.out.printf("Expired jitted method %s %f\t replaced by %s %f\n", jITCompileDataPointImpl2.getComment(), jITCompileDataPointImpl2.getRawX(), string2, d);
        }
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(jITCompileDataPointImpl);
        this.addCompiledMethodDataPoint(tracePoint, dataBuilder, traceMetaData, new Object[]{string, string5, d - d2, d2, null, l, string3});
    }

    private void handleCompileEnd15(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        String string = (String)objectArray[1];
        String string2 = (String)objectArray[2];
        double d2 = (double)((Long)objectArray[7]).longValue() / 1000.0;
        long l = (Long)objectArray[11];
        long l2 = (Long)objectArray[13];
        long l3 = (Long)objectArray[4] - (Long)objectArray[3];
        if ((Long)objectArray[5] != 0L) {
            l3 += (Long)objectArray[6] - (Long)objectArray[5];
        }
        String string3 = ((String)objectArray[14] + " " + objectArray[0]).trim().replaceAll("[ ]+", ", ");
        long l4 = (Long)objectArray[3];
        long l5 = (Long)objectArray[4];
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        String string4 = JITLabels.COMPILE_END;
        DataBuilder dataBuilder2 = dataBuilder.getData(string4);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string4, this.timeAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        String string5 = this.generateMethodName(string2);
        JITCompileDataPointImpl jITCompileDataPointImpl = new JITCompileDataPointImpl(0, d, d2, string5, this.timeAxisPair, this.convertHotnessToInt(string), l4, l5);
        for (DataPointBuilder dataPointBuilder : ((TwoDimensionalDataBuilder)dataBuilder2).getAllDataPoints()) {
            JITCompileDataPointImpl jITCompileDataPointImpl2;
            if (dataPointBuilder.getRawX() >= jITCompileDataPointImpl.getRawX()) break;
            if (!(dataPointBuilder instanceof JITCompileDataPointImpl) || (jITCompileDataPointImpl2 = (JITCompileDataPointImpl)dataPointBuilder).isExpired() || !jITCompileDataPointImpl2.pcInRange(jITCompileDataPointImpl.getStartPC()) && !jITCompileDataPointImpl2.pcInRange(jITCompileDataPointImpl.getEndPC()) && !jITCompileDataPointImpl.pcInRange(jITCompileDataPointImpl2.getStartPC())) continue;
            jITCompileDataPointImpl2.setExpireTime(jITCompileDataPointImpl.getRawX());
            System.out.printf("Expired jitted method %s %f\t replaced by %s %f\n", jITCompileDataPointImpl2.getComment(), jITCompileDataPointImpl2.getRawX(), string2, d);
        }
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(jITCompileDataPointImpl);
        this.addQueueSizePoint(dataBuilder, d, l);
        this.addCompiledMethodDataPoint(tracePoint, dataBuilder, traceMetaData, new Object[]{string, string5, d - d2, d2, l2, l3, string3});
    }

    private void addCompiledMethodDataPoint(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData, Object[] objectArray) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        String string = JITLabels.COMPILED_METHODS;
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.axisPair);
            dataBuilder.addData(dataBuilder2);
        }
        JITMethodDataPointImpl jITMethodDataPointImpl = new JITMethodDataPointImpl(0, d, this.axisPair, objectArray);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(jITMethodDataPointImpl);
    }

    private void handleCompRequest(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l = (Long)objectArray[5];
        this.addQueueSizePoint(dataBuilder, d, l);
    }

    private void handleAotLoadEnd(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l = (Long)objectArray[8];
        this.addQueueSizePoint(dataBuilder, d, l);
    }

    private void addQueueSizePoint(DataBuilder dataBuilder, double d, long l) {
        String string = JITLabels.QUEUE_SIZE;
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        FullDataPointImpl fullDataPointImpl = new FullDataPointImpl(0, d, l, "", this.numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(fullDataPointImpl);
    }

    private String generateMethodName(String string) {
        JavaMethod javaMethod = new JavaMethod(1L);
        int n = string.indexOf(L_BRACKET);
        int n2 = string.lastIndexOf(DOT, n);
        string = string.replace(F_SLASH, DOT);
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1, n);
        String string4 = string.substring(n);
        javaMethod.setName(string2, string3, string4);
        return javaMethod.getName();
    }

    private int convertHotnessToInt(String string) {
        if (string.equals("cold")) {
            return 1;
        }
        if (string.equals("hot")) {
            return 3;
        }
        if (string.equals("scorching")) {
            return 5;
        }
        if (string.contains("very-hot")) {
            return 4;
        }
        if (string.equals("warm")) {
            return 2;
        }
        if (string.equals("no-opt")) {
            return 0;
        }
        return -1;
    }

    public static String convertHotnessToString(int n) {
        if (n == 1) {
            return "cold";
        }
        if (n == 3) {
            return "hot";
        }
        if (n == 5) {
            return "scorching";
        }
        if (n == 4) {
            return "very-hot";
        }
        if (n == 2) {
            return "warm";
        }
        if (n == 0) {
            return "no-opt";
        }
        return EMTPY_STRING;
    }

    private void handleDataCacheFull(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        String string = JITLabels.DATA_CACHE_FULL;
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.axisPair);
            dataBuilder.addData(dataBuilder2);
        }
        EventDataPoint eventDataPoint = new EventDataPoint(0, d, this.axisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(eventDataPoint);
    }

    private void handleIncompatibleAOTHeader(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        String string = JITLabels.INCOMPATIBLE_HEADER;
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.axisPair);
            dataBuilder.addData(dataBuilder2);
        }
        EventDataPoint eventDataPoint = new EventDataPoint(0, d, this.axisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(eventDataPoint);
    }

    private void handleMethodPrexInvalidated(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        Long l = (Long)objectArray[0];
        String string = Long.toHexString(l);
        String string2 = JITLabels.METHOD_PREX_INVALIDATED;
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        DataBuilder dataBuilder2 = dataBuilder.getData(string2);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string2, this.axisPair);
            dataBuilder.addData(dataBuilder2);
        }
        FullEventDataPoint fullEventDataPoint = new FullEventDataPoint(0, d, string, this.axisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(fullEventDataPoint);
    }

    private void handleLowUserVirtualMemory(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        Long l = (Long)objectArray[0] * 1024L * 1024L;
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        String string = JITLabels.LOW_VIRTUAL_MEMORY;
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        DataPointImpl dataPointImpl = new DataPointImpl(0, d, l.longValue(), this.numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(dataPointImpl);
    }

    private void handleIProfilerCapReached(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        Long l = (Long)objectArray[0] * 1024L;
        String string = JITLabels.PROFILER_CAP_REACHED;
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        DataPointImpl dataPointImpl = new DataPointImpl(0, d, l.longValue(), this.numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(dataPointImpl);
    }

    private void handleManyCompFailures(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        Long l = (Long)objectArray[0];
        String string = JITLabels.MANY_COMPILATION_FAILURES;
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        DataBuilder dataBuilder2 = dataBuilder.getData(string);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string, this.numberAxisPair);
            dataBuilder.addData(dataBuilder2);
        }
        DataPointImpl dataPointImpl = new DataPointImpl(0, d, l.longValue(), this.numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(dataPointImpl);
    }

    private void handleCodeCacheAllocated(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        long l = (Long)objectArray[0];
        String string = Long.toHexString(l);
        Long l2 = (Long)objectArray[1];
        Long l3 = (Long)objectArray[2];
        String string2 = JITLabels.CODE_CACHE_ALLOCATED;
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        DataBuilder dataBuilder2 = dataBuilder.getData(string2);
        if (dataBuilder2 == null) {
            dataBuilder2 = new TwoDimensionalDataImpl(string2, this.axisPair);
            dataBuilder.addData(dataBuilder2);
        }
        JITDataPointImpl jITDataPointImpl = new JITDataPointImpl(0, d, string, l2, l3, this.axisPair);
        ((TwoDimensionalDataBuilder)dataBuilder2).addDataPointBuilder(jITDataPointImpl);
    }
}

