/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.source;

import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.healthcenter.connection.ConnectionDataBuilder;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.source.SourceImpl;
import com.ibm.java.diagnostics.healthcenter.sources.SourceListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StreamSourceImpl
extends SourceImpl {
    private InputStream stream;
    long lastAvailable = 0L;

    public StreamSourceImpl(String string, InputStream inputStream, ConnectionDataBuilder connectionDataBuilder) {
        super(string, connectionDataBuilder);
        this.stream = inputStream;
    }

    public String getText() throws JavaDiagnosticsException {
        try {
            this.stream.reset();
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.stream));
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                stringBuffer.append(NEWLINE);
                string = bufferedReader.readLine();
            }
            this.lastAvailable = this.stream.available();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new JavaDiagnosticsException(iOException);
        }
    }

    protected InputStream getRawStream() throws JavaDiagnosticsException {
        try {
            this.stream.reset();
            return this.stream;
        }
        catch (IOException iOException) {
            throw new JavaDiagnosticsException(iOException);
        }
    }

    public boolean hasChangedSinceLastGet() {
        try {
            boolean bl = (long)this.stream.available() > this.lastAvailable;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public long getApproximateSize() throws JavaDiagnosticsException {
        try {
            return this.stream.available();
        }
        catch (IOException iOException) {
            throw new JavaDiagnosticsException(iOException);
        }
    }

    @Override
    protected void tellNewSlicerAboutExistingData(SourceListener sourceListener) {
    }

    @Override
    public InputStream getBackingStream() {
        return this.stream;
    }
}

