/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.gc.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.gc.GCData;
import com.ibm.java.diagnostics.healthcenter.api.gc.GCEventListener;
import com.ibm.java.diagnostics.healthcenter.api.gc.GCPreferences;
import com.ibm.java.diagnostics.healthcenter.api.gc.HeapData;
import com.ibm.java.diagnostics.healthcenter.api.gc.ObjectAllocationEvent;
import com.ibm.java.diagnostics.healthcenter.api.gc.ObjectAllocationEventListener;
import com.ibm.java.diagnostics.healthcenter.api.gc.OutOfLineAllocationEvent;
import com.ibm.java.diagnostics.healthcenter.api.gc.PauseData;
import com.ibm.java.diagnostics.healthcenter.api.gc.impl.GCInternalEventListener;
import com.ibm.java.diagnostics.healthcenter.api.gc.impl.HeapDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.gc.impl.ObjectAllocationEventImpl;
import com.ibm.java.diagnostics.healthcenter.api.gc.impl.OutOfLineAllocationEventImpl;
import com.ibm.java.diagnostics.healthcenter.api.gc.impl.PauseDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCLabels;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.AllocationThresholdDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.gc.parser.j9.OutOfLineAllocationDataPoint;
import com.ibm.java.diagnostics.healthcenter.gc.postprocessor.analysis.Summariser;
import com.ibm.java.diagnostics.healthcenter.gc.postprocessor.analysis.SummarisingPostProcessorLabels;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.GCEventHandler;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ObjectAllocationEventHandler;
import java.util.Date;
import java.util.List;
import javax.management.Notification;

public class GCDataImpl
extends HealthCenterDataImpl
implements GCData {
    private static final String EQUALS = "=";
    public static final String SET_LOW_ALLOCATION_THRESHOLD = "lowallocationthreshold=";
    public static final String SET_HIGH_ALLOCATION_THRESHOLD = "highallocationthreshold=";
    private static final String DASH = " - ";
    private GCPreferences prefs;
    private Notification heapSizeNotify;
    private Notification usedHeapNotify;
    private Notification pauseNotify;
    private GCInternalEventListener internalGC = new GCInternalEventListener();

    public GCDataImpl(Data data) {
        super(data);
        GCEventHandler gCEventHandler = MarshallerImpl.getMarshaller().getGCEventHandler();
        ObjectAllocationEventHandler objectAllocationEventHandler = MarshallerImpl.getMarshaller().getObjectAllocationEventHandler();
        if (!gCEventHandler.isAlive()) {
            gCEventHandler.start();
        }
        if (!objectAllocationEventHandler.isAlive()) {
            objectAllocationEventHandler.start();
        }
        gCEventHandler.addGCEventListener(this.internalGC);
        objectAllocationEventHandler.addObjectAllocationEventListener(this.internalGC);
        this.prefs = new GCPreferences();
    }

    @Override
    public HeapData[] getHeapSizeData() {
        return this.getHeapData(GCLabels.FLAT_HEAP_SIZE);
    }

    @Override
    public HeapData[] getUsedHeapData() {
        return this.getHeapData(GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
    }

    @Override
    public PauseData[] getGCPauseTimeData() {
        return this.getPauseData(GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
    }

    @Override
    public int getConcurrentCollectionCount() {
        int n = this.UNSET;
        String string = this.getGCSummaryData(SummarisingPostProcessorLabels.CONCURRENT_COLLECTION_COUNT);
        if (string != null) {
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public Enum<GCData.GCmodes> getGCMode() {
        String string = this.getGCSummaryData(SummarisingPostProcessorLabels.GC_MODE);
        if (string != null) {
            if (string.contains("gencon")) {
                return GCData.GCmodes.GENCON;
            }
            if (string.contains("optavgpause")) {
                return GCData.GCmodes.OPTAVGPAUSE;
            }
            if (string.contains("optthruput")) {
                return GCData.GCmodes.OPTTHRUPUT;
            }
            if (string.contains("balanced")) {
                return GCData.GCmodes.BALANCED;
            }
            if (string.contains("metronome")) {
                return GCData.GCmodes.METRONOME;
            }
        }
        return GCData.GCmodes.UNKNOWN;
    }

    @Override
    public double getGlobalAverageGCPauseTime() {
        return this.convertSummaryToDouble(this.getGCSummaryData(SummarisingPostProcessorLabels.GLOBAL_COLLECTIONS + DASH + SummarisingPostProcessorLabels.MEAN_GC_PAUSE_TIME));
    }

    @Override
    public double getGlobalAverageCollectionInterval() {
        return this.convertSummaryToDouble(this.getGCSummaryData(SummarisingPostProcessorLabels.GLOBAL_COLLECTIONS + DASH + SummarisingPostProcessorLabels.MEAN_INTERVAL_COLLECTIONS));
    }

    @Override
    public int getGlobalGCCount() {
        int n = 0;
        String string = this.getGCSummaryData(SummarisingPostProcessorLabels.GLOBAL_COLLECTIONS + DASH + SummarisingPostProcessorLabels.NUMBER_OF_COLLECTIONS);
        if (string != null) {
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public long getLargestMemoryRequest() {
        return this.convertSummaryToLong(this.getGCSummaryData(SummarisingPostProcessorLabels.LARGEST_MEMORY_REQUEST));
    }

    @Override
    public double getNurseryAverageGCPauseTime() {
        return this.convertSummaryToDouble(this.getGCSummaryData(SummarisingPostProcessorLabels.MINOR_COLLECTIONS + DASH + SummarisingPostProcessorLabels.MEAN_GC_PAUSE_TIME));
    }

    @Override
    public double getNurseryAverageCollectionInterval() {
        return this.convertSummaryToDouble(this.getGCSummaryData(SummarisingPostProcessorLabels.MINOR_COLLECTIONS + DASH + SummarisingPostProcessorLabels.MEAN_INTERVAL_COLLECTIONS));
    }

    @Override
    public int getNurseryGCCount() {
        int n = 0;
        String string = this.getGCSummaryData(SummarisingPostProcessorLabels.MINOR_COLLECTIONS + DASH + SummarisingPostProcessorLabels.NUMBER_OF_COLLECTIONS);
        if (string != null) {
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public long getNurseryTotalAmountFlipped() {
        return this.convertSummaryToLong(this.getGCSummaryData(SummarisingPostProcessorLabels.MINOR_COLLECTIONS + DASH + SummarisingPostProcessorLabels.AMOUNT_FLIPPED));
    }

    @Override
    public int getGMPCycleCount() {
        return this.convertSummaryToInt(this.getGCSummaryData(SummarisingPostProcessorLabels.GMP_CYCLE_COUNT));
    }

    @Override
    public int getAverageGMPCollections() {
        return this.convertSummaryToInt(this.getGCSummaryData(SummarisingPostProcessorLabels.GMP_MEAN_COLLECTIONS));
    }

    @Override
    public int getQuantumCollectionCount() {
        return this.convertSummaryToInt(this.getGCSummaryData(SummarisingPostProcessorLabels.TOTAL_NUMBER_OF_QUANTUM_COLLECTIONS));
    }

    @Override
    public int getSynchGCCount() {
        return this.convertSummaryToInt(this.getGCSummaryData(Summariser.TOTAL_NUMBER_OF_SYNCHGC_COLLECTIONS));
    }

    @Override
    public int getNumberOfAllocationFailures() {
        return this.convertSummaryToInt(this.getGCSummaryData(SummarisingPostProcessorLabels.ALLOCATION_FAILURE_COUNT));
    }

    @Override
    public double getProportionTimeSpentInGCPause() {
        return this.stripPercentSymbol(this.getGCSummaryData(SummarisingPostProcessorLabels.PROPORTION_OF_TIME_SPENT_IN_GARBAGE_COLLECTION_PAUSES));
    }

    @Override
    public double getProportionTimeSpentUnpaused() {
        return this.stripPercentSymbol(this.getGCSummaryData(SummarisingPostProcessorLabels.PROPORTION_OF_TIME_SPENT_UNPAUSED));
    }

    @Override
    public double getRateOfGarbageCollection() {
        return this.extractRate(this.getGCSummaryData(SummarisingPostProcessorLabels.RATE_OF_GARBAGE_COLLECTION));
    }

    @Override
    public int getNumberSystemGC() {
        int n = 0;
        String string = this.getGCSummaryData(SummarisingPostProcessorLabels.FORCED_COLLECTION_COUNT);
        if (string != null) {
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private HeapData[] getHeapData(String string) {
        HeapData[] heapDataArray = new HeapData[]{};
        DataPointBuilder[] dataPointBuilderArray = null;
        Data data = this.getJvmData().getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        if (data != null && (dataPointBuilderArray = this.getEventData(data, string)) != null) {
            heapDataArray = new HeapData[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                heapDataArray[n] = new HeapDataImpl(dataPointBuilder.getRawX(), dataPointBuilder.getRawY());
                ++n;
            }
        }
        return heapDataArray;
    }

    private PauseData[] getPauseData(String string) {
        PauseData[] pauseDataArray = new PauseData[]{};
        Data data = this.getJvmData().getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        DataPointBuilder[] dataPointBuilderArray = null;
        if (data != null && (dataPointBuilderArray = this.getEventData(data, string)) != null) {
            pauseDataArray = new PauseData[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                pauseDataArray[n] = new PauseDataImpl((long)dataPointBuilder.getRawX(), dataPointBuilder.getRawY());
                ++n;
            }
        }
        return pauseDataArray;
    }

    private String getGCSummaryData(String string) {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        TableData tableData = (TableData)data.getData(SummarisingPostProcessorLabels.SUMMARY);
        if (tableData == null) {
            return null;
        }
        if (tableData.get(string) != null) {
            return tableData.get(string).get(1).toString();
        }
        return null;
    }

    @Override
    protected String getRecommendationLabel() {
        return SummarisingPostProcessorLabels.TUNING_RECOMMENDATION;
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.GARBAGE_COLLECTION;
    }

    @Override
    public GCPreferences getPreferences() {
        return this.prefs;
    }

    @Override
    public ObjectAllocationEvent[] getObjectAllocationEvents() {
        ObjectAllocationEvent[] objectAllocationEventArray = new ObjectAllocationEvent[]{};
        Data data = this.getJvmData().getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        TwoDimensionalData twoDimensionalData = (TwoDimensionalData)data.getData(GCLabels.OBJECT_ALLOCATION_THRESHOLD);
        if (twoDimensionalData != null) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalData.getDataPoints();
            int n = dataPointBuilderArray.length;
            objectAllocationEventArray = new ObjectAllocationEvent[n];
            for (int i = 0; i < n; ++i) {
                AllocationThresholdDataPointImpl allocationThresholdDataPointImpl = (AllocationThresholdDataPointImpl)dataPointBuilderArray[i];
                objectAllocationEventArray[i] = new ObjectAllocationEventImpl(allocationThresholdDataPointImpl.getStackTop(), allocationThresholdDataPointImpl.getRawX(), allocationThresholdDataPointImpl.getFullStack(), (long)allocationThresholdDataPointImpl.getRawY());
            }
        }
        return objectAllocationEventArray;
    }

    @Override
    public OutOfLineAllocationEvent[] getOutOfLineAllocationEvents() {
        OutOfLineAllocationEvent[] outOfLineAllocationEventArray = new OutOfLineAllocationEvent[]{};
        Data data = this.getJvmData().getTopLevelData(JVMLabels.GARBAGE_COLLECTION);
        TwoDimensionalData twoDimensionalData = (TwoDimensionalData)data.getData(GCLabels.OUT_OF_LINE_OBJECT_ALLOCATION);
        if (twoDimensionalData != null) {
            DataPointBuilder[] dataPointBuilderArray = twoDimensionalData.getDataPoints();
            int n = dataPointBuilderArray.length;
            outOfLineAllocationEventArray = new OutOfLineAllocationEvent[n];
            for (int i = 0; i < n; ++i) {
                OutOfLineAllocationDataPoint outOfLineAllocationDataPoint = (OutOfLineAllocationDataPoint)dataPointBuilderArray[i];
                outOfLineAllocationEventArray[i] = new OutOfLineAllocationEventImpl(outOfLineAllocationDataPoint.getRawX(), outOfLineAllocationDataPoint.getFullStack(), (long)outOfLineAllocationDataPoint.getRawY(), outOfLineAllocationDataPoint.getClassName(), outOfLineAllocationDataPoint.getClassAddress());
            }
        }
        return outOfLineAllocationEventArray;
    }

    @Override
    public double getAverageCollectionInterval() {
        return this.convertSummaryToDouble(this.getGCSummaryData(SummarisingPostProcessorLabels.MEAN_INTERVAL_COLLECTIONS));
    }

    @Override
    public double getAverageGCPauseTime() {
        return this.convertSummaryToDouble(this.getGCSummaryData(SummarisingPostProcessorLabels.MEAN_GC_PAUSE_TIME));
    }

    @Override
    public int getGCCount() {
        int n = 0;
        String string = this.getGCSummaryData(SummarisingPostProcessorLabels.NUMBER_OF_COLLECTIONS);
        if (string != null) {
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n == this.UNSET) {
            n = this.getGlobalGCCount() + this.getNurseryGCCount();
        }
        return n;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    @Override
    public long getMaxHeapSize() {
        return (long)this.getMaxData(JVMLabels.GARBAGE_COLLECTION, GCLabels.FLAT_HEAP_SIZE);
    }

    @Override
    public double getMeanHeapSize() {
        return this.getMeanData(JVMLabels.GARBAGE_COLLECTION, GCLabels.FLAT_HEAP_SIZE);
    }

    @Override
    public long getMinHeapSize() {
        return (long)this.getMinData(JVMLabels.GARBAGE_COLLECTION, GCLabels.FLAT_HEAP_SIZE);
    }

    @Override
    public long getMaxUsedHeap() {
        return (long)this.getMaxData(JVMLabels.GARBAGE_COLLECTION, GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
    }

    @Override
    public double getMeanUsedHeap() {
        return this.getMeanData(JVMLabels.GARBAGE_COLLECTION, GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
    }

    @Override
    public long getMinUsedHeap() {
        return (long)this.getMinData(JVMLabels.GARBAGE_COLLECTION, GCLabels.LIVE_FLAT_HEAP_AFTER_GC);
    }

    @Override
    public long getMaxPauseTime() {
        return (long)this.getMaxData(JVMLabels.GARBAGE_COLLECTION, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
    }

    @Override
    public double getMeanPauseTime() {
        return this.getMeanData(JVMLabels.GARBAGE_COLLECTION, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
    }

    @Override
    public long getMinPauseTime() {
        return (long)this.getMinData(JVMLabels.GARBAGE_COLLECTION, GCLabels.PAUSE_TIMES_WITHOUT_EXCLUSIVE_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGCListener(GCEventListener gCEventListener) {
        List<GCEventListener> list = this.internalGC.getListeners();
        synchronized (list) {
            this.internalGC.getListeners().add(gCEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGCListener(GCEventListener gCEventListener) {
        List<GCEventListener> list = this.internalGC.getListeners();
        synchronized (list) {
            this.internalGC.getListeners().remove(gCEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObjectAllocationListener(ObjectAllocationEventListener objectAllocationEventListener) {
        List<ObjectAllocationEventListener> list = this.internalGC.getObjectAllocationListeners();
        synchronized (list) {
            this.internalGC.getObjectAllocationListeners().add(objectAllocationEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObjectAllocationListener(ObjectAllocationEventListener objectAllocationEventListener) {
        List<ObjectAllocationEventListener> list = this.internalGC.getObjectAllocationListeners();
        synchronized (list) {
            this.internalGC.getObjectAllocationListeners().remove(objectAllocationEventListener);
        }
    }

    static /* synthetic */ long access$000(GCDataImpl gCDataImpl) {
        return gCDataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        Date heapTime;
        Date usedHeapTime;
        Date pauseTime;
        long count = 0L;
        long delay = GCDataImpl.access$000(GCDataImpl.this);

        public Updater(long l) {
            if (l >= GCDataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.heapTime = new Date();
                        this.usedHeapTime = new Date();
                        this.pauseTime = new Date();
                        if (GCDataImpl.this.getHeapSizeData() != null && GCDataImpl.this.getHeapSizeData().length > 0 && GCDataImpl.this.getHeapSizeData()[GCDataImpl.this.getHeapSizeData().length - 1].getTime() != this.heapTime.getTime()) {
                            GCDataImpl.this.heapSizeNotify = new Notification(null, GCDataImpl.this, this.count++);
                            GCDataImpl.this.heapSizeNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.gc.HeapSizeData");
                            GCDataImpl.this.sendNotification(GCDataImpl.this.heapSizeNotify);
                        }
                        if (GCDataImpl.this.getUsedHeapData() != null && GCDataImpl.this.getUsedHeapData().length > 0 && GCDataImpl.this.getUsedHeapData()[GCDataImpl.this.getUsedHeapData().length - 1].getTime() != this.usedHeapTime.getTime()) {
                            GCDataImpl.this.usedHeapNotify = new Notification(null, (Object)GCDataImpl.this, this.count++, "UsedHeapData");
                            GCDataImpl.this.usedHeapNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.gc.UsedHeapData");
                            GCDataImpl.this.sendNotification(GCDataImpl.this.usedHeapNotify);
                        }
                        if (GCDataImpl.this.getGCPauseTimeData() != null && GCDataImpl.this.getGCPauseTimeData().length > 0 && GCDataImpl.this.getGCPauseTimeData()[GCDataImpl.this.getGCPauseTimeData().length - 1].getTime() != this.pauseTime.getTime()) {
                            GCDataImpl.this.pauseNotify = new Notification(null, (Object)GCDataImpl.this, this.count++, "PauseData");
                            GCDataImpl.this.pauseNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.gc.PauseTimeData");
                            GCDataImpl.this.sendNotification(GCDataImpl.this.pauseNotify);
                        }
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

