/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.EventCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.TransportType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HealthCenterOptionHandler {
    private static final String KEEP_DEFAULT_TRACE = "keepDefaultTrace";
    private static final String KEEP_ALIVE = "keepAlive";
    private static final String DYNAMIC_TRACE = "dynamicTrace";
    public static final String HEALTH_CENTER_PROPERTY_PREFIX = "com.ibm.java.diagnostics.healthcenter.";
    public static final String CAPABILITY_PROPERTY_PREFIX = "com.ibm.diagnostics.healthcenter.capability.";
    private static final String DEFAULT_TRACE_OVERRIDE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.leave.default.trace";
    private static final String NODYNAMIC_TRACE_OVERRIDE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.leave.dynamic.trace";
    private static final String DATA_COLLECTION_LEVEL_PROPERTY = "com.ibm.java.diagnostics.healthcenter.data.collection.level";
    public static final String AGENT_PATH_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.path";
    public static final String CONFIG_OVERRIDE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.config";
    private final Logger logger;
    private static final String HEALTHCENTER_PROPERTIES_FILE_NAME = "healthcenter.properties";
    private static final String MAX_CIRCULAR_BUFFER_SIZE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.bufferSize";
    private static final String STACK_TRACE_DEPTH = "com.ibm.java.diagnostics.healthcenter.stack.trace.depth";
    private static final String ALLOCATION_THRESHOLD_LOW = "com.ibm.java.diagnostics.healthcenter.allocation.threshold.low";
    private static final String ALLOCATION_THRESHOLD_HIGH = "com.ibm.java.diagnostics.healthcenter.allocation.threshold.high";
    private static final String THREAD_COLLECTION_INTERVAL = "com.ibm.java.diagnostics.healthcenter.thread.collection.interval";
    private static final String THREAD_STACK_DEPTH = "com.ibm.java.diagnostics.healthcenter.thread.stack.depth";
    public static final String JRE = "jre";
    public static final String LIB = "lib";
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String JAVA_HOME = "java.home";
    private static final String PORT_ARGUMENT = "port";
    private static final String LEVEL_ARGUMENT = "level";
    private static final String TRANSPORT_ARGUMENT = "transport";
    public static final String PATH_ARGUMENT = "path";
    private static final int MAX_PORT = 65535;
    public static final String CONFIG_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.properties.file";
    public static final String AUTHENTICATION_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.authentication.file";
    private String autheFile = null;
    public static final String AUTHORIZATION_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.authorization.file";
    private String authoFile = null;
    public static final String SSL_KEYSTORE_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStore";
    private String sslKeystore = null;
    public static final String SSL_KEYSTORE_PASSWORD_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStorePassword";
    private String sslKeystorePassword = null;
    public static final String SSL_KEYSTORE_CERTIFICATE_PASSWORD_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStoreCertificatePassword";
    private String sslKeystoreCertificatePassword = null;
    public static final String SSL_TRUSTSTORE_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStore";
    private String sslTruststore = null;
    public static final String SSL_TRUSTSTORE_PASSWORD_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStorePassword";
    private String sslTruststorePassword = null;
    public static final String SSL_TRUSTSTORE_CERTIFICATE_PASSWORD_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStoreCertificatePassword";
    private String sslTruststoreCertificatePassword = null;
    public static final String START_DELAY_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.start.delay.seconds";
    private int startDelaySeconds = 0;
    public static final String ORB_HOSTNAME_PROPERTY = "com.ibm.CORBA.LocalHost";
    public static final String ORB_PORT_PROPERTY = "com.ibm.CORBA.ListenerPort";
    public static final String RMI_HOSTNAME_PROPERTY = "java.rmi.server.hostname";
    public static final String JMX_BUILDER_PROPERTY = "javax.management.builder.initial";
    public static final String CLEAR_BUILDER_PROPERTY = "com.ibm.java.diagnostics.healthcenter.clear.jmx.initial.builder";
    private boolean tryOverrideBuilder = false;
    public static final String USE_PLATFORM_MBEANSERVER_PROPERTY = "com.ibm.java.diagnostics.healthcenter.use.platformmbeanserver";
    private boolean usePlatformMBeanServer = false;
    public static final String AGENT_PORT_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.port";
    private int startPort = 1972;
    private static final String OUTPUT_DIRECTORY_PROPERTY = "com.ibm.java.diagnostics.healthcenter.output.directory";
    private static final String HEADLESS_OUTPUT_DIRECTORY_PROPERTY = "com.ibm.java.diagnostics.healthcenter.headless.output.directory";
    private static final String HEADLESS_USER_FILE_NAME = "com.ibm.java.diagnostics.healthcenter.headless.filename";
    private static final String AGENT_TRANSPORT_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.transport";
    public static final String AGENT_IIOP_PORT_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.iiop.port";
    private static final String HEADLESS_START_DELAY = "com.ibm.java.diagnostics.healthcenter.headless.delay.start";
    private static final String HEADLESS_RUN_DURATION = "com.ibm.java.diagnostics.healthcenter.headless.run.duration";
    private static final String HEADLESS_RUN_PAUSE_DURATION = "com.ibm.java.diagnostics.healthcenter.headless.run.pause.duration";
    private static final String HEADLESS_RUN_NUMBER_OF_RUNS = "com.ibm.java.diagnostics.healthcenter.headless.run.number.of.runs";
    private static final String HEADLESS_RUN_FILES_TO_KEEP = "com.ibm.java.diagnostics.healthcenter.headless.files.to.keep";
    private static final String HEADLESS_MAX_FILE_SIZE = "com.ibm.java.diagnostics.healthcenter.headless.files.max.size";
    private int pid = 0;
    private Set<String> agentArguments = new HashSet<String>();
    private static final String[] hcUnitaryOptions = new String[]{"keepDefaultTrace", "keepAlive", "dynamicTrace"};
    private static final String[] hcPropertyKeys = new String[]{"com.ibm.java.diagnostics.healthcenter.agent.debug", "com.ibm.java.diagnostics.healthcenter.leave.default.trace", "com.ibm.java.diagnostics.healthcenter.leave.dynamic.trace", "com.ibm.java.diagnostics.healthcenter.data.collection.level", "com.ibm.java.diagnostics.healthcenter.agent.bufferSize", "com.ibm.java.diagnostics.healthcenter.stack.trace.depth", "com.ibm.java.diagnostics.healthcenter.allocation.threshold.low", "com.ibm.java.diagnostics.healthcenter.allocation.threshold.high", "com.ibm.java.diagnostics.healthcenter.agent.properties.file", "com.ibm.java.diagnostics.healthcenter.agent.authentication.file", "com.ibm.java.diagnostics.healthcenter.agent.authorization.file", "com.ibm.java.diagnostics.healthcenter.agent.start.delay.seconds", "com.ibm.java.diagnostics.healthcenter.clear.jmx.initial.builder", "com.ibm.java.diagnostics.healthcenter.use.platformmbeanserver", "com.ibm.java.diagnostics.healthcenter.agent.port", "com.ibm.java.diagnostics.healthcenter.headless.output.directory", "com.ibm.java.diagnostics.healthcenter.agent.transport", "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStore", "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStorePassword", "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStoreCertificatePassword", "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStore", "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStorePassword", "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStoreCertificatePassword", "com.ibm.java.diagnostics.healthcenter.headless.delay.start", "com.ibm.java.diagnostics.healthcenter.headless.run.duration", "com.ibm.java.diagnostics.healthcenter.headless.run.pause.duration", "com.ibm.java.diagnostics.healthcenter.headless.run.number.of.runs", "com.ibm.java.diagnostics.healthcenter.thread.collection.interval", "com.ibm.java.diagnostics.healthcenter.headless.files.to.keep", "com.ibm.java.diagnostics.healthcenter.agent.iiop.port", "com.ibm.java.diagnostics.healthcenter.headless.files.max.size", "com.ibm.java.diagnostics.healthcenter.headless.filename", "com.ibm.java.diagnostics.healthcenter.config", "com.ibm.java.diagnostics.healthcenter.agent.path"};
    private static final Set<String> hcPropertyKeySet = new HashSet<String>();
    private Properties props = null;
    private DataCollectionLevel level = null;
    private String agentPath = null;

    public HealthCenterOptionHandler(Logger logger) {
        this.logger = logger;
    }

    public HealthCenterOptionHandler(String[] stringArray) {
        this.logger = AgentLogFactory.setUpLogging(this.getClass());
        String string = stringArray != null && stringArray.length > 0 ? stringArray[0] : System.getProperty("sun.java.launcher.pid");
        try {
            this.pid = Integer.parseInt(string);
            AgentLogFactory.setPid(this.pid);
        }
        catch (Throwable throwable) {
            this.logger.fine(MessageFormat.format(Messages.getString("HCLaunchMBean.invalid.process.id"), string));
        }
        if (stringArray != null && stringArray.length > 1) {
            this.processArg(stringArray[1]);
        }
        this.populateProperties();
    }

    private void processArg(String string) {
        int n = string.indexOf("<?xml");
        if (n < 0) {
            this.processOptions(string);
        } else {
            this.processOptions(string.substring(0, n));
            Properties properties = this.processProperties(string.substring(n));
            this.setSystemProperties(properties);
        }
    }

    private void setSystemProperties(Properties properties) {
        if (null == properties) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.setProperty(string, properties.getProperty(string));
        }
    }

    private void processOptions(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            if ((string2 = string2.trim()).length() == 0) continue;
            this.agentArguments.add(string2);
        }
    }

    public static String processOption(String string, String string2) {
        String[] stringArray = string.split("[:=]", 2);
        if (stringArray.length == 2 && stringArray[0].equals(string2) && stringArray[1].length() != 0) {
            return stringArray[1];
        }
        return null;
    }

    public boolean validateOptions(String string) {
        this.processOptions(string);
        boolean bl = true;
        for (String string2 : this.agentArguments) {
            boolean bl2 = true;
            String[] stringArray = string2.split("[:=]", 2);
            if (stringArray.length == 1) {
                bl2 = false;
                for (String string3 : hcUnitaryOptions) {
                    if (!string2.equals(string3)) continue;
                    bl2 = true;
                    break;
                }
            } else if (stringArray[1].length() != 0) {
                String string4 = stringArray[0];
                String string5 = stringArray[1];
                String string6 = string5.toUpperCase();
                if (string4.equals(PORT_ARGUMENT)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string5, 0, 65535);
                } else if (string4.equals(LEVEL_ARGUMENT)) {
                    try {
                        DataCollectionLevel.valueOf(string6);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bl2 = false;
                    }
                } else if (string4.equals(TRANSPORT_ARGUMENT)) {
                    try {
                        TransportType.valueOf(string6);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bl2 = false;
                    }
                } else {
                    bl2 = string4.equals(PATH_ARGUMENT) ? HealthCenterOptionHandler.checkDir(string5) : false;
                }
            } else {
                bl2 = false;
            }
            if (bl2) continue;
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", string2);
            bl = false;
        }
        return bl;
    }

    private Properties processProperties(String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            Properties properties = new Properties();
            properties.loadFromXML(byteArrayInputStream);
            return properties;
        }
        catch (Exception exception) {
            HealthCenterOptionHandler.logSevere(this.logger, "HCLaunchMBean.error.exception", exception.toString());
            return null;
        }
    }

    public static boolean validateHCProperties(Properties properties, Logger logger) {
        boolean bl = true;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl2 = false;
            if (string.startsWith("com.ibm.diagnostics.healthcenter") || string.startsWith("com.ibm.java.diagnostics.healthcenter")) {
                bl2 = true;
                continue;
            }
            if (hcPropertyKeySet.contains(string)) {
                String string2 = properties.getProperty(string);
                String string3 = string2.toUpperCase();
                if (string.equals("com.ibm.java.diagnostics.healthcenter.agent.debug")) {
                    bl2 = HealthCenterOptionHandler.checkTrue(string3);
                } else if (string.equals(DEFAULT_TRACE_OVERRIDE_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkTrue(string3);
                } else if (string.equals(NODYNAMIC_TRACE_OVERRIDE_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkTrue(string3);
                } else if (string.equals(DATA_COLLECTION_LEVEL_PROPERTY)) {
                    try {
                        DataCollectionLevel.valueOf(string3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bl2 = false;
                    }
                } else if (string.equals(MAX_CIRCULAR_BUFFER_SIZE_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(STACK_TRACE_DEPTH)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(ALLOCATION_THRESHOLD_LOW)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(ALLOCATION_THRESHOLD_HIGH)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(CONFIG_LOCATION_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkFile(string2);
                } else if (string.equals(AUTHENTICATION_LOCATION_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkFile(string2);
                } else if (string.equals(AUTHORIZATION_LOCATION_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkFile(string2);
                } else if (string.equals(START_DELAY_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(CLEAR_BUILDER_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkTrue(string3);
                } else if (string.equals(USE_PLATFORM_MBEANSERVER_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkTrue(string3);
                } else if (string.equals(AGENT_PORT_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, 65535);
                } else if (string.equals(HEADLESS_OUTPUT_DIRECTORY_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkDir(string2);
                } else if (string.equals(HealthCenterOptionHandler.getAgentTransportProperty())) {
                    try {
                        TransportType.valueOf(string3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bl2 = false;
                    }
                } else if (string.equals(SSL_KEYSTORE_LOCATION_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkFile(string2);
                } else if (string.equals(SSL_KEYSTORE_PASSWORD_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkPassword(string2);
                } else if (string.equals(SSL_KEYSTORE_CERTIFICATE_PASSWORD_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkPassword(string2);
                } else if (string.equals(SSL_TRUSTSTORE_LOCATION_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkFile(string2);
                } else if (string.equals(SSL_TRUSTSTORE_PASSWORD_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkPassword(string2);
                } else if (string.equals(SSL_TRUSTSTORE_CERTIFICATE_PASSWORD_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkPassword(string2);
                } else if (string.equals(HEADLESS_START_DELAY)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(HEADLESS_RUN_DURATION)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(HEADLESS_RUN_PAUSE_DURATION)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(HEADLESS_RUN_NUMBER_OF_RUNS)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(THREAD_COLLECTION_INTERVAL)) {
                    bl2 = HealthCenterOptionHandler.checkNumberRange(string2, 0, -1);
                } else if (string.equals(CONFIG_OVERRIDE_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkDir(string2);
                } else if (string.equals(AGENT_PATH_PROPERTY)) {
                    bl2 = HealthCenterOptionHandler.checkDir(string2);
                }
                if (bl2) continue;
                if (logger != null) {
                    HealthCenterOptionHandler.logWarning(logger, "HCLaunchMBean.invalid.value", string2, string);
                }
                bl = false;
                continue;
            }
            if (logger != null) {
                HealthCenterOptionHandler.logWarning(logger, "HCLaunchMBean.unknown.property", string);
            }
            bl = false;
        }
        return bl;
    }

    private static boolean checkNumberRange(String string, int n, int n2) {
        boolean bl = true;
        try {
            Integer n3 = Integer.parseInt(string);
            int n4 = n3;
            if (n4 < n) {
                bl = false;
            }
            if (n2 >= n && n4 > n2) {
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private static boolean checkTrue(String string) {
        return string.equals(TRUE.toUpperCase());
    }

    private static boolean checkFile(String string) {
        return HealthCenterOptionHandler.checkFileDir(string, true);
    }

    private static boolean checkDir(String string) {
        return HealthCenterOptionHandler.checkFileDir(string, false);
    }

    private static boolean checkFileDir(String string, boolean bl) {
        try {
            File file = new File(string);
            if (file.exists() && (bl ? file.isFile() : file.isDirectory())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean checkPassword(String string) {
        return true;
    }

    public int getPid() {
        return this.pid;
    }

    public boolean isDynamicOverride() {
        String string2;
        for (String string2 : this.agentArguments) {
            if (!string2.trim().equals(DYNAMIC_TRACE)) continue;
            this.setProperty(NODYNAMIC_TRACE_OVERRIDE_PROPERTY, TRUE);
            return true;
        }
        string2 = this.findProperty(NODYNAMIC_TRACE_OVERRIDE_PROPERTY);
        return string2 != null;
    }

    public String getAgentPath() {
        File file;
        if (this.agentPath != null) {
            return this.agentPath;
        }
        for (String object : this.agentArguments) {
            this.agentPath = HealthCenterOptionHandler.processOption(object, PATH_ARGUMENT);
            if (this.agentPath == null) continue;
            file = new File(this.agentPath);
            File file2 = new File(this.agentPath, JRE);
            if (HealthCenterOptionHandler.checkDir(file2.getAbsolutePath())) {
                this.agentPath = file2.getAbsolutePath();
                this.setProperty(AGENT_PATH_PROPERTY, this.agentPath);
                return this.agentPath;
            }
            if (HealthCenterOptionHandler.checkDir(file.getAbsolutePath())) {
                this.agentPath = file.getAbsolutePath();
                this.setProperty(AGENT_PATH_PROPERTY, this.agentPath);
                return this.agentPath;
            }
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", "path=" + this.agentPath);
            this.agentPath = null;
        }
        this.agentPath = System.getProperty(AGENT_PATH_PROPERTY);
        if (this.agentPath != null) {
            File file3 = new File(this.agentPath);
            file = new File(this.agentPath, JRE);
            if (HealthCenterOptionHandler.checkDir(file.getAbsolutePath())) {
                this.agentPath = file.getAbsolutePath();
                this.setProperty(AGENT_PATH_PROPERTY, this.agentPath);
                return this.agentPath;
            }
            if (HealthCenterOptionHandler.checkDir(file3.getAbsolutePath())) {
                this.agentPath = file3.getAbsolutePath();
                this.setProperty(AGENT_PATH_PROPERTY, this.agentPath);
                return this.agentPath;
            }
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", "path=" + this.agentPath);
            this.agentPath = null;
        }
        return this.agentPath;
    }

    public DataCollectionLevel getDataCollectionLevel() {
        String string2;
        if (this.level != null) {
            return this.level;
        }
        for (String string2 : this.agentArguments) {
            String string3 = HealthCenterOptionHandler.processOption(string2, LEVEL_ARGUMENT);
            if (string3 == null) continue;
            this.level = this.getLevelFromString(string3);
            this.setProperty(DATA_COLLECTION_LEVEL_PROPERTY, this.level.name());
            return this.level;
        }
        string2 = this.findProperty(DATA_COLLECTION_LEVEL_PROPERTY);
        if (string2 != null) {
            this.level = this.getLevelFromString(string2);
            return this.level;
        }
        this.level = DataCollectionLevel.FULL;
        this.setProperty(DATA_COLLECTION_LEVEL_PROPERTY, this.level.name());
        return this.level;
    }

    private DataCollectionLevel getLevelFromString(String string) {
        DataCollectionLevel dataCollectionLevel;
        String string2 = string.toUpperCase();
        try {
            dataCollectionLevel = DataCollectionLevel.valueOf(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.level", string);
            dataCollectionLevel = DataCollectionLevel.FULL;
        }
        return dataCollectionLevel;
    }

    private EventCollectionLevel getEventFromString(String string) {
        EventCollectionLevel eventCollectionLevel;
        String string2 = string.toUpperCase();
        try {
            eventCollectionLevel = EventCollectionLevel.valueOf(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.event", string);
            eventCollectionLevel = null;
        }
        return eventCollectionLevel;
    }

    private void populateProperties() {
        String string;
        String string2;
        String string3 = this.findProperty(START_DELAY_PROPERTY);
        if (string3 != null) {
            try {
                this.startDelaySeconds = new Integer(string3);
                string2 = Messages.getString("HCLaunchMBean.start.delay.overridden");
                string = MessageFormat.format(string2, START_DELAY_PROPERTY, this.startDelaySeconds);
                this.logger.config(string);
            }
            catch (Throwable throwable) {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.integer", START_DELAY_PROPERTY, string3);
            }
        }
        if ((string2 = this.findProperty(CLEAR_BUILDER_PROPERTY)) != null && string2.equals(TRUE)) {
            this.tryOverrideBuilder = true;
            this.logger.config(MessageFormat.format(Messages.getString("HCLaunchMBean.override"), CLEAR_BUILDER_PROPERTY, JMX_BUILDER_PROPERTY));
        }
        if ((string = this.findProperty(USE_PLATFORM_MBEANSERVER_PROPERTY)) != null && string.equals(TRUE)) {
            this.usePlatformMBeanServer = true;
            String string4 = MessageFormat.format(Messages.getString("HCLaunchMBean.using.platform.mbean.server"), USE_PLATFORM_MBEANSERVER_PROPERTY);
            this.logger.config(string4);
        }
        this.workOutStartPort();
        this.autheFile = this.findProperty(AUTHENTICATION_LOCATION_PROPERTY);
        this.authoFile = this.findProperty(AUTHORIZATION_LOCATION_PROPERTY);
        this.sslKeystore = this.findProperty(SSL_KEYSTORE_LOCATION_PROPERTY);
        this.sslKeystorePassword = this.findProperty(SSL_KEYSTORE_PASSWORD_PROPERTY);
        this.sslKeystoreCertificatePassword = this.findProperty(SSL_KEYSTORE_CERTIFICATE_PASSWORD_PROPERTY);
        this.sslTruststore = this.findProperty(SSL_TRUSTSTORE_LOCATION_PROPERTY);
        this.sslTruststorePassword = this.findProperty(SSL_TRUSTSTORE_PASSWORD_PROPERTY);
        this.sslTruststoreCertificatePassword = this.findProperty(SSL_TRUSTSTORE_CERTIFICATE_PASSWORD_PROPERTY);
    }

    private void workOutStartPort() {
        String string;
        Iterator<String> iterator = this.agentArguments.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            string = iterator.next();
            String string2 = HealthCenterOptionHandler.processOption(string, PORT_ARGUMENT);
            if (string2 == null) continue;
            try {
                if (HealthCenterOptionHandler.checkNumberRange(string2, 0, 65535)) {
                    this.startPort = Integer.parseInt(string2);
                    bl = true;
                    continue;
                }
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", string);
            }
            catch (Throwable throwable) {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.integer", PORT_ARGUMENT, string2);
            }
        }
        if (bl) {
            this.setProperty(AGENT_PORT_PROPERTY, Integer.toString(this.startPort));
        } else {
            string = this.findProperty(AGENT_PORT_PROPERTY);
            if (string != null) {
                try {
                    if (HealthCenterOptionHandler.checkNumberRange(string, 0, 65535)) {
                        this.startPort = Integer.parseInt(string);
                        this.logger.config(MessageFormat.format(Messages.getString("HCLaunchMBean.overriding.start.port"), AGENT_PORT_PROPERTY, this.startPort));
                    } else {
                        HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.value", string, AGENT_PORT_PROPERTY);
                    }
                }
                catch (Throwable throwable) {
                    HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.integer", AGENT_PORT_PROPERTY, string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getHealthCenterProperties() {
        Object object;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Requested health center properties.");
        }
        if (this.props == null) {
            File file;
            Object object2;
            object = null;
            String string = System.getProperty(CONFIG_LOCATION_PROPERTY);
            if (string != null) {
                object = new File(string);
            }
            if (object == null || !((File)object).exists()) {
                object = new File(HEALTHCENTER_PROPERTIES_FILE_NAME);
            }
            if (!(object != null && ((File)object).exists() || (object2 = this.getAgentPath()) == null)) {
                file = new File((String)object2, LIB);
                object = new File(file, HEALTHCENTER_PROPERTIES_FILE_NAME);
            }
            if (object == null || !((File)object).exists()) {
                object2 = System.getProperty(JAVA_HOME);
                file = new File((String)object2, LIB);
                object = new File(file, HEALTHCENTER_PROPERTIES_FILE_NAME);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, MessageFormat.format("Loading health center properties from {0}.", ((File)object).getAbsolutePath()));
            }
            if (((File)object).exists() && ((File)object).canRead()) {
                object2 = null;
                try {
                    object2 = new FileInputStream((File)object);
                    this.props = new Properties();
                    this.props.load((InputStream)object2);
                }
                catch (Exception exception) {
                    HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.could.not.load.properties", ((File)object).getAbsolutePath());
                }
                finally {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.properties.file", ((File)object).getAbsolutePath());
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            object = MessageFormat.format("Returning health center properties {0}", this.props);
            this.logger.log(Level.FINER, (String)object);
        }
        return this.props;
    }

    private String findProperty(String string) {
        String string2;
        if (this.logger.isLoggable(Level.FINER)) {
            string2 = MessageFormat.format("Requested {0} property.", string);
            this.logger.log(Level.FINER, string2);
        }
        string2 = System.getProperty(string);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, MessageFormat.format("{0} property is {1} in system properties.", string, string2));
        }
        if (string2 == null) {
            Properties properties;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, MessageFormat.format("Requesting {0} from health center properties.", string));
            }
            if ((properties = this.getHealthCenterProperties()) != null) {
                string2 = properties.getProperty(string);
                if (this.logger.isLoggable(Level.FINEST)) {
                    String string3 = MessageFormat.format("Health center properties existed and {0} was {1}.", string, string2);
                    this.logger.log(Level.FINEST, string3);
                }
                if (string2 != null && string2.length() != 0) {
                    this.setProperty(string, string2);
                }
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            String string4 = MessageFormat.format("Returning {0} for {1} property.", string2, string);
            this.logger.log(Level.FINER, string4);
        }
        return string2;
    }

    private void setProperty(String string, String string2) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, MessageFormat.format("Setting Health Center System property {0} with value {1}.", string, string2));
        }
        System.setProperty(string, string2);
    }

    public String getAutheFile() {
        return this.autheFile;
    }

    public String getAuthoFile() {
        return this.authoFile;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public String getSslKeystoreCertificatePassword() {
        if (this.sslKeystoreCertificatePassword == null) {
            return this.getSslKeystorePassword();
        }
        return this.sslKeystoreCertificatePassword;
    }

    public String getSslTruststore() {
        if (this.sslTruststore == null) {
            return this.getSslKeystore();
        }
        return this.sslTruststore;
    }

    public String getSslTruststorePassword() {
        if (this.sslTruststorePassword == null) {
            return this.getSslKeystorePassword();
        }
        return this.sslTruststorePassword;
    }

    public String getSslTruststoreCertificatePassword() {
        if (this.sslTruststoreCertificatePassword == null) {
            if (this.sslTruststorePassword == null) {
                return this.getSslKeystoreCertificatePassword();
            }
            return this.getSslTruststorePassword();
        }
        return this.sslTruststoreCertificatePassword;
    }

    public int getStartDelaySeconds() {
        return this.startDelaySeconds;
    }

    public boolean isTryOverrideBuilder() {
        return this.tryOverrideBuilder;
    }

    public boolean isUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public String getMaxCircularBufferSize() {
        return this.findProperty(MAX_CIRCULAR_BUFFER_SIZE_PROPERTY);
    }

    public boolean isKeepAlive() {
        for (String string : this.agentArguments) {
            if (!KEEP_ALIVE.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String[] getVMArgs() {
        String[] stringArray = null;
        if (!System.getProperty("java.vm.vendor").contains("IBM")) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            stringArray = (String[])runtimeMXBean.getInputArguments().toArray();
        } else {
            try {
                Class[] classArray = new Class[]{};
                Class<?> clazz = Class.forName("com.ibm.oti.vm.VM");
                Object obj = clazz.newInstance();
                Method method = clazz.getDeclaredMethod("getVMArgs", classArray);
                stringArray = (String[])method.invoke(obj, (Object[])null);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        return stringArray;
    }

    public boolean shouldDisableDefaultTrace() {
        String string2;
        for (String string2 : this.agentArguments) {
            if (!KEEP_DEFAULT_TRACE.equals(string2)) continue;
            this.setProperty(DEFAULT_TRACE_OVERRIDE_PROPERTY, TRUE);
            return false;
        }
        string2 = this.findProperty(DEFAULT_TRACE_OVERRIDE_PROPERTY);
        return string2 == null;
    }

    public void setDataCollectionLevel(DataCollectionLevel dataCollectionLevel) {
        this.level = dataCollectionLevel;
    }

    public String getStackTraceDepth() {
        return this.findProperty(STACK_TRACE_DEPTH);
    }

    public int getThreadStackDepth() {
        try {
            int n = new Integer(this.findProperty(THREAD_STACK_DEPTH));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public String getLowAllocationThreshold() {
        return this.findProperty(ALLOCATION_THRESHOLD_LOW);
    }

    public String getHighAllocationThreshold() {
        return this.findProperty(ALLOCATION_THRESHOLD_HIGH);
    }

    public String getHeadlessOutputDirectory() {
        String string = this.findProperty(HEADLESS_OUTPUT_DIRECTORY_PROPERTY);
        if (string == null || string.length() == 0) {
            string = this.findProperty(OUTPUT_DIRECTORY_PROPERTY);
        }
        return string;
    }

    public String getHeadlessFileName() {
        return this.findProperty(HEADLESS_USER_FILE_NAME);
    }

    public String getOutputDirectory() {
        String string = this.findProperty(OUTPUT_DIRECTORY_PROPERTY);
        if (string == null || string.length() == 0) {
            string = this.findProperty(HEADLESS_OUTPUT_DIRECTORY_PROPERTY);
        }
        return string;
    }

    public int getHeadlessStartDelay() {
        try {
            int n = new Integer(this.findProperty(HEADLESS_START_DELAY));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getHeadlessRunPauseDuration() {
        try {
            int n = new Integer(this.findProperty(HEADLESS_RUN_PAUSE_DURATION));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getHeadlessRunDuration() {
        try {
            int n = new Integer(this.findProperty(HEADLESS_RUN_DURATION));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getHeadlessRunCount() {
        try {
            int n = new Integer(this.findProperty(HEADLESS_RUN_NUMBER_OF_RUNS));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getFilesToKeep() {
        try {
            int n = new Integer(this.findProperty(HEADLESS_RUN_FILES_TO_KEEP));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getMaxHeadlessFileSize() {
        try {
            int n = new Integer(this.findProperty(HEADLESS_MAX_FILE_SIZE));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getTheadCollectionInterval() {
        try {
            int n = new Integer(this.findProperty(THREAD_COLLECTION_INTERVAL));
            if (n == 0) {
                n = 30;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 30;
        }
    }

    public TransportType getTransportType() {
        for (String string : this.agentArguments) {
            String string2 = HealthCenterOptionHandler.processOption(string, TRANSPORT_ARGUMENT);
            if (string2 == null) continue;
            try {
                TransportType transportType = TransportType.valueOf(string2.toUpperCase());
                this.setProperty(HealthCenterOptionHandler.getAgentTransportProperty(), transportType.name());
                return transportType;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", string);
            }
        }
        String string = this.findProperty(HealthCenterOptionHandler.getAgentTransportProperty());
        if (string != null) {
            try {
                TransportType transportType = TransportType.valueOf(string.toUpperCase());
                return transportType;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.value", string, HealthCenterOptionHandler.getAgentTransportProperty());
            }
        }
        TransportType transportType = TransportType.IIOP;
        this.setProperty(HealthCenterOptionHandler.getAgentTransportProperty(), transportType.name());
        return transportType;
    }

    private static void logWarning(Logger logger, String string, Object ... objectArray) {
        HealthCenterOptionHandler.logMessage(logger, Level.WARNING, string, objectArray);
    }

    private static void logSevere(Logger logger, String string, Object ... objectArray) {
        HealthCenterOptionHandler.logMessage(logger, Level.SEVERE, string, objectArray);
    }

    private static void logMessage(Logger logger, Level level, String string, Object ... objectArray) {
        if (logger.isLoggable(level)) {
            String string2 = Messages.getString(string);
            String string3 = MessageFormat.format(string2, objectArray);
            logger.log(level, string3);
        }
    }

    public void setAgentPort(int n) {
        if (n >= 0) {
            this.startPort = n;
            this.setProperty(AGENT_PORT_PROPERTY, Integer.toString(n));
        }
    }

    public static String getAgentTransportProperty() {
        return AGENT_TRANSPORT_PROPERTY;
    }

    public String getAgentIIOPPort() {
        return this.findProperty(AGENT_IIOP_PORT_PROPERTY);
    }

    public static String[] getProperties(String[] stringArray) {
        HealthCenterOptionHandler healthCenterOptionHandler = new HealthCenterOptionHandler(stringArray);
        healthCenterOptionHandler.getDataCollectionLevel();
        healthCenterOptionHandler.getTransportType();
        healthCenterOptionHandler.isDynamicOverride();
        healthCenterOptionHandler.shouldDisableDefaultTrace();
        healthCenterOptionHandler.getAgentPath();
        Properties properties = new Properties();
        Properties properties2 = healthCenterOptionHandler.getHealthCenterProperties();
        if (properties2 != null) {
            properties.putAll((Map<?, ?>)healthCenterOptionHandler.getHealthCenterProperties());
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.put("com.ibm.diagnostics.healthcenter.capability.isRealTimeVM", String.valueOf(Util.isRealTimeVM()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.canGetThreads", String.valueOf(Util.canGetThreads()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.is26VMOrLater", String.valueOf(Util.is26VMOrLater()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.JavaLevel", String.valueOf(Util.getJavaLevel()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.ServiceRefreshNumber", String.valueOf(Util.getServiceRefreshNumber()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.FixpackNumber", String.valueOf(Util.getFixpackNumber()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.VMVersion", Util.getVMVersionString());
        properties.put("com.ibm.diagnostics.healthcenter.capability.is26VMOrLater", String.valueOf(Util.is26VMOrLater()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.is27VMOrLater", String.valueOf(Util.is27VMOrLater()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.isHardRealTimeVM", String.valueOf(Util.isHardRealTimeVM()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.isRealTimeVM", String.valueOf(Util.isRealTimeVM()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.j9DmpTrcAvailable", String.valueOf(Util.j9DmpTrcAvailable()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.vmHasJ9MethodLookup", String.valueOf(Util.vmHasJ9MethodLookup()));
        properties.put("com.ibm.diagnostics.healthcenter.capability.vmHasLOATracePoints", String.valueOf(Util.vmHasLOATracePoints()));
        Enumeration<?> enumeration = properties.propertyNames();
        String[] stringArray2 = new String[properties.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            stringArray2[n] = string = string2 + "=" + properties.getProperty(string2);
            ++n;
        }
        return stringArray2;
    }

    static {
        for (String string : hcPropertyKeys) {
            hcPropertyKeySet.add(string);
        }
    }
}

