/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class HCSslSocketFactory {
    private static HCSslSocketFactory defaultSocketFactory = null;
    private static String keystoreName = "";
    private static String keystorePassword = "";
    private static String certificatePassword = "";

    public static void setSSLValues(String string, String string2, String string3) {
        keystoreName = string;
        keystorePassword = string2;
        certificatePassword = string3;
    }

    public static synchronized HCSslSocketFactory getDefaultSocketFactory() {
        if (defaultSocketFactory == null) {
            defaultSocketFactory = new HCSslSocketFactory();
        }
        return defaultSocketFactory;
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = null;
        try (FileInputStream fileInputStream = new FileInputStream(new File(keystoreName));){
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("IBMX509");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(fileInputStream, keystorePassword.toCharArray());
            keyManagerFactory.init(keyStore, certificatePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("IBMX509");
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
        }
        return sSLSocket;
    }
}

