/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.threads;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Iterator;

public class ThreadDataProvider {
    public static final String CAPABILITY_THREAD_SUBSYSTEM = "threads_subsystem";
    private static final String DELIMITER = "@#";
    private static final String START_THREAD_REPORT = "startThreads";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String EMPTY_STRING = "";
    private static final String REPORT_VERSION = "3.0.7";
    public static final String SET_STACK_DEPTH = "setStack";
    private static final String REALTIME_IDENTIFIER = "real-time";
    private static final String SOFT_REALTIME_IDENTIFER = "srt";
    public static final String TAG = "ThreadsSource";
    private static ThreadMXBean threadBean = null;
    private static boolean isObjectMonitorUsageSupported = false;
    private static boolean isSynchronizerUsageSupported = false;

    public static String getJMXData() {
        ThreadDataProvider.providerInitialisation();
        return ThreadDataProvider.getThreadReport();
    }

    private static void providerInitialisation() {
        if (threadBean != null) {
            return;
        }
        threadBean = ManagementFactory.getThreadMXBean();
        try {
            isObjectMonitorUsageSupported = threadBean.isObjectMonitorUsageSupported();
            isSynchronizerUsageSupported = threadBean.isSynchronizerUsageSupported();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized String getThreadReport() {
        String string;
        if (!Util.isHardRealTimeVM()) {
            String string2 = EMPTY_STRING;
            long[] lArray = threadBean.getAllThreadIds();
            ThreadInfo[] threadInfoArray = null;
            long l = System.currentTimeMillis();
            try {
                threadInfoArray = threadBean.getThreadInfo(lArray, isObjectMonitorUsageSupported, isSynchronizerUsageSupported);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                threadInfoArray = threadBean.getThreadInfo(lArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                long[] lArray2 = lArray;
                int n = lArray2.length;
                for (int i = 0; i < n; ++i) {
                    long l2 = lArray2[i];
                    if (l2 <= 0L) continue;
                    arrayList.add(l2);
                }
                lArray = new long[arrayList.toArray().length];
                int n2 = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    long l3;
                    lArray[n2] = l3 = ((Long)iterator.next()).longValue();
                    ++n2;
                }
            }
            catch (InternalError internalError) {
                if (internalError.getMessage().contains("JVM_GetThreadStateValues")) {
                    return EMPTY_STRING;
                }
                throw internalError;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            for (ThreadInfo threadInfo : threadInfoArray) {
                void n5;
                Object object3;
                CharSequence charSequence;
                Object object2;
                if (threadInfo == null) continue;
                String string3 = threadInfo.getThreadName();
                long l4 = threadInfo.getThreadId();
                Thread.State state = threadInfo.getThreadState();
                String string4 = EMPTY_STRING;
                int n3 = 0;
                String string5 = EMPTY_STRING;
                int n4 = 0;
                try {
                    object2 = threadInfo.getLockedMonitors();
                    n3 = ((MonitorInfo[])object2).length;
                    charSequence = new StringBuffer();
                    for (Object object3 : object2) {
                        if (object3 != null) {
                            ((StringBuffer)charSequence).append(((LockInfo)object3).getClassName().length());
                            ((StringBuffer)charSequence).append(DELIMITER);
                            ((StringBuffer)charSequence).append(((LockInfo)object3).getClassName());
                            ((StringBuffer)charSequence).append(((LockInfo)object3).getIdentityHashCode());
                            ((StringBuffer)charSequence).append(DELIMITER);
                            ((StringBuffer)charSequence).append(((MonitorInfo)object3).getLockedStackDepth());
                            ((StringBuffer)charSequence).append(DELIMITER);
                            continue;
                        }
                        --n3;
                    }
                    string4 = ((StringBuffer)charSequence).toString();
                    LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
                    n4 = lockInfoArray.length;
                    charSequence = new StringBuffer();
                    for (LockInfo lockInfo : lockInfoArray) {
                        ((StringBuffer)charSequence).append(lockInfo.getClassName().length());
                        ((StringBuffer)charSequence).append(DELIMITER);
                        ((StringBuffer)charSequence).append(lockInfo.getClassName());
                        ((StringBuffer)charSequence).append(lockInfo.getIdentityHashCode());
                        ((StringBuffer)charSequence).append(DELIMITER);
                    }
                    string5 = ((StringBuffer)charSequence).toString();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                object2 = EMPTY_STRING;
                object2 = threadInfo.getLockName();
                if (object2 == null) {
                    object2 = EMPTY_STRING;
                }
                charSequence = EMPTY_STRING;
                boolean bl = false;
                StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
                StringBuffer stringBuffer2 = new StringBuffer();
                object3 = stackTraceElementArray;
                int n2 = ((StackTraceElement[])object3).length;
                for (int i = 0; i < n2; ++i) {
                    Object object4 = object3[i];
                    String string6 = ((StackTraceElement)object4).getClassName();
                    String string7 = ((StackTraceElement)object4).getFileName();
                    if (string7 == null) {
                        string7 = EMPTY_STRING;
                    }
                    String string8 = ((StackTraceElement)object4).getMethodName();
                    int n6 = ((StackTraceElement)object4).getLineNumber();
                    stringBuffer2.append(string6.length()).append(DELIMITER).append(string6).append(string8.length()).append(DELIMITER).append(string8).append(string7.length()).append(DELIMITER).append(string7).append(n6).append(DELIMITER);
                    ++n5;
                }
                charSequence = stringBuffer2.toString();
                n = 6 + n3 * 2 + 1 + n5 * 2 + 1;
                stringBuffer.append(START_THREAD_REPORT);
                stringBuffer.append(REPORT_VERSION);
                stringBuffer.append(DELIMITER).append(l);
                stringBuffer.append(DELIMITER).append(lArray.length);
                stringBuffer.append(DELIMITER).append(n);
                stringBuffer.append(DELIMITER).append(l4);
                stringBuffer.append(DELIMITER).append(string3.length());
                stringBuffer.append(DELIMITER);
                stringBuffer.append(string3);
                stringBuffer.append(state.toString().length());
                stringBuffer.append(DELIMITER);
                stringBuffer.append(state.toString());
                stringBuffer.append((int)n5);
                stringBuffer.append(DELIMITER);
                if (n5 > 0) {
                    stringBuffer.append((String)charSequence);
                }
                stringBuffer.append(n3);
                stringBuffer.append(DELIMITER);
                if (n3 > 0) {
                    stringBuffer.append(string4);
                }
                stringBuffer.append(n4);
                stringBuffer.append(DELIMITER);
                if (n4 > 0) {
                    stringBuffer.append(string5);
                }
                stringBuffer.append(((String)object2).length());
                stringBuffer.append(DELIMITER);
                stringBuffer.append((String)object2);
                stringBuffer.append(NEW_LINE);
            }
            string2 = stringBuffer.toString();
            string = string2 != null ? string2 : EMPTY_STRING;
        } else {
            string = EMPTY_STRING;
        }
        return string;
    }
}

