/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.XDataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.YDataAxisImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Messages;
import java.text.MessageFormat;

public class EventDataPoint
implements DataPointBuilder {
    private static final String TO_STRING_TEMPLATE = "({0}, {1})";
    protected static final String TO_RAW_STRING_TEMPLATE = Messages.getString("DataPointImpl.raw.tostring.template");
    private static final MessageFormat toStringFormatter = new MessageFormat("({0}, {1})");
    private static final String SPACE = " ";
    private static final String comment = " ";
    private int x;
    private int sequenceUID = 0;
    private final XDataAxisImpl xAxis;
    private final YDataAxisImpl yAxis;
    private static final int UNSET = -1;

    public EventDataPoint(int n, double d, AxisPair axisPair) {
        int n2;
        this.sequenceUID = n;
        this.xAxis = (XDataAxisImpl)axisPair.getXAxis();
        this.yAxis = (YDataAxisImpl)axisPair.getYAxis();
        if (this.getSeed() == -1.0) {
            this.xAxis.setSeed((long)d);
            n2 = 0;
        } else {
            n2 = (int)(d - this.getSeed());
        }
        this.x = n2;
    }

    @Override
    public double getX() {
        return this.xAxis.convert((double)this.x + this.getSeed(), this.sequenceUID);
    }

    @Override
    public double getY() {
        return 1.0;
    }

    @Override
    public double getX(String string) {
        return this.xAxis.convert((double)this.x + this.getSeed(), this.sequenceUID, string);
    }

    @Override
    public double getY(String string) {
        return 1.0;
    }

    @Override
    public String formatX() {
        return this.xAxis.format((double)this.x + this.getSeed(), this.sequenceUID);
    }

    @Override
    public String formatX(int n) {
        return this.xAxis.format((double)this.x + this.getSeed(), this.sequenceUID, n);
    }

    @Override
    public String formatY() {
        return "1";
    }

    @Override
    public double getRawX() {
        return (double)this.x + this.getSeed();
    }

    @Override
    public double getRawY() {
        return 1.0;
    }

    @Override
    public void setRawX(double d) {
        int n;
        if (this.getSeed() == -1.0) {
            this.getXAxis().setSeed((long)d);
            n = 0;
        } else {
            n = (int)(d - this.getSeed());
        }
        this.x = n;
    }

    @Override
    public void setRawY(double d) {
    }

    @Override
    public String getComment() {
        return " ";
    }

    @Override
    public void setComment(String string) {
    }

    public String toString() {
        if (this.yAxis.getAxis().getType() != 1) {
            Object[] objectArray = new Object[]{this.formatXWithUnits(), this.formatYWithUnits()};
            return toStringFormatter.format(objectArray);
        }
        return this.formatXWithUnits();
    }

    public String toRawString() {
        Object[] objectArray = new Object[]{new Double(this.getRawX()), new Double(this.getRawY())};
        return MessageFormat.format(TO_RAW_STRING_TEMPLATE, objectArray);
    }

    private double getSeed() {
        return this.getXAxis().getSeed();
    }

    @Override
    public int getSequenceUID() {
        return this.sequenceUID;
    }

    @Override
    public XDataAxis getXAxis() {
        return this.xAxis;
    }

    @Override
    public YDataAxis getYAxis() {
        return this.yAxis;
    }

    @Override
    public String formatXWithUnits() {
        if (this.xAxis.shouldFormatWithUnits()) {
            return this.formatX() + " " + this.xAxis.getUnits();
        }
        return this.formatX();
    }

    @Override
    public String formatYWithUnits() {
        if (this.yAxis.shouldFormatWithUnits()) {
            return this.formatY() + " " + this.yAxis.getUnits();
        }
        return this.formatY();
    }

    @Override
    public int getDataPointSize() {
        return 128;
    }
}

