/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.axes;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NumberFormatter {
    private static final NumberFormat format = new DecimalFormat();

    public static String prettyString(double d) {
        String string;
        if (d == 0.0) {
            return String.valueOf(d);
        }
        if (d > 0.0) {
            if (d < 1.0) {
                long l = (long)Math.log10(d);
                double d2 = NumberFormatter.roundToPrecision(d, -1L * l + 2L);
                string = format.format(d2);
            } else if (d < 100.0) {
                double d3 = NumberFormatter.roundToPrecision(d, 2L);
                string = String.valueOf(d3);
            } else {
                long l = (long)NumberFormatter.roundToPrecision(d, 0L);
                string = String.valueOf(l);
            }
        } else if (d > -1.0) {
            long l = (long)Math.log10(d);
            double d4 = NumberFormatter.roundToPrecision(d, -1L * l + 2L);
            string = format.format(d4);
        } else if (d > -100.0) {
            double d5 = NumberFormatter.roundToPrecision(d, 2L);
            string = String.valueOf(d5);
        } else {
            long l = (long)NumberFormatter.roundToPrecision(d, 0L);
            string = String.valueOf(l);
        }
        return string;
    }

    private static double roundToPrecision(double d, long l) {
        double d2 = Math.pow(10.0, l);
        long l2 = Math.round(d * d2);
        return (double)l2 / d2;
    }

    public static String prettyString(double d, int n) {
        String string;
        if (n == 0) {
            long l = Math.round(d);
            string = String.valueOf(l);
        } else {
            double d2 = NumberFormatter.roundToPrecision(d, n);
            string = String.valueOf(d2);
        }
        return string;
    }

    static {
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(10);
    }
}

