/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.NioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.NioTCPChannel;
import com.ibm.ws.tcp.channel.impl.SimpleSync;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;

public class NioTCPWriteRequestContextImpl
extends TCPWriteRequestContextImpl {
    private static final TraceComponent tc = Tr.register(NioTCPWriteRequestContextImpl.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    protected NioTCPWriteRequestContextImpl(TCPConnLink tCPConnLink) {
        super(tCPConnLink);
    }

    public long processSyncWriteRequest(long l, int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processSyncRequest(" + l + "," + n + ")");
        }
        long l2 = 0L;
        if (l != 0L) {
            if (!this.config.isDispatchWorkToThreads()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Can't perform write. Dispatch to Worker threads = false");
                }
                throw new IOException("Can't perform write. Dispatch to Worker threads = false");
            }
            if (this.blockWait == null) {
                this.blockWait = new SimpleSync();
            }
            this.blockingIOError = null;
            VirtualConnection virtualConnection = null;
            this.blockedThread = true;
            virtualConnection = this.writeInternal(l, null, false, n);
            while (virtualConnection == null) {
                this.blockWait.simpleWait();
                if (this.blockingIOError != null) break;
                virtualConnection = ((NioTCPChannel)this.oTCPConnLink.getTCPChannel()).getWorkQueueManager().processWork(this, 1);
            }
            this.blockedThread = false;
            if (this.blockingIOError != null) {
                throw this.blockingIOError;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getIOCompleteAmount() -->" + String.valueOf(this.getIOCompleteAmount()));
            }
            l2 = this.getIOCompleteAmount();
        } else {
            long l3 = 0L;
            WsByteBuffer[] wsByteBufferArray = this.getBuffers();
            SocketIOChannel socketIOChannel = this.oTCPConnLink.getSocketIOChannel();
            l3 = wsByteBufferArray.length == 1 ? (long)((NioSocketIOChannel)socketIOChannel).write(wsByteBufferArray[0].getWrappedByteBufferNonSafe()) : ((NioSocketIOChannel)socketIOChannel).write(this.getByteBufferArray());
            l2 = l3;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "blocking write returned " + String.valueOf(l2));
        }
        return l2;
    }

    public VirtualConnection processAsyncWriteRequest() {
        return ((NioTCPChannel)this.oTCPConnLink.getTCPChannel()).getWorkQueueManager().processWork(this, 0);
    }

    protected void immediateTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "immediateTimeout");
        }
        this.timeoutTime = System.currentTimeMillis() - 2000L;
        ((NioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).getChannelSelectorWrite().resetTimeout(this.timeoutTime);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "immediateTimeout");
        }
    }
}

