/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.ChannelTermination;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.NioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.NioTCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.NioTCPWriteRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.SyncWorkQueueManager;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPChannelFactory;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;

public class NioTCPChannel
extends TCPChannel {
    private static WorkQueueManager workQueueManager = null;
    private static SyncWorkQueueManager syncWorkQueueManager = null;
    private static final TraceComponent tc = Tr.register(NioTCPChannel.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected ChannelFramework oChannelFramework;
    int connectionCount = 0;
    Object connectionCountSync = new Object();

    public ChannelTermination setup(ChannelData channelData, TCPChannelConfiguration tCPChannelConfiguration, TCPChannelFactory tCPChannelFactory) throws ChannelException {
        super.setup(channelData, tCPChannelConfiguration, tCPChannelFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "NioTCPChannel");
        }
        if (this.config.isDispatchWorkToThreads()) {
            if (workQueueManager == null && this.config.getBlockingChannel() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating TCPChannel with WORKER WorkQueueManager");
                }
                workQueueManager = new WorkQueueManager();
            }
        } else if (syncWorkQueueManager == null && this.config.getBlockingChannel() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating TCPChannel with NON-WORKER WorkQueueManager");
            }
            syncWorkQueueManager = new SyncWorkQueueManager(TCPFactoryConfiguration.getMaxSelectorThreads(), TCPFactoryConfiguration.getNewSelectorConnectionThreshold(), this.channelFactory);
        }
        if (!this.config.isInbound()) {
            this.connectionManager = !this.config.isDispatchWorkToThreads() && syncWorkQueueManager != null ? new ConnectionManager(this, syncWorkQueueManager) : new ConnectionManager(this, workQueueManager);
        }
        if (!this.config.isDispatchWorkToThreads() && syncWorkQueueManager != null) {
            syncWorkQueueManager.startSelectors(this.config.isInbound());
        } else if (workQueueManager != null) {
            workQueueManager.startSelectors(this.config.isInbound());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "NioTCPChannel");
        }
        if (!this.config.isDispatchWorkToThreads() && syncWorkQueueManager != null) {
            return syncWorkQueueManager;
        }
        return workQueueManager;
    }

    protected WorkQueueManager getWorkQueueManager() {
        if (!this.config.isDispatchWorkToThreads() && syncWorkQueueManager != null) {
            return syncWorkQueueManager;
        }
        return workQueueManager;
    }

    public SocketIOChannel createOutboundSocketIOChannel() throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        Socket socket = socketChannel.socket();
        return NioSocketIOChannel.createIOChannel(socket, this);
    }

    public SocketIOChannel createInboundSocketIOChannel(SocketChannel socketChannel) {
        return NioSocketIOChannel.createIOChannel(socketChannel.socket(), this);
    }

    public TCPReadRequestContextImpl createReadInterface(TCPConnLink tCPConnLink) {
        return new NioTCPReadRequestContextImpl(tCPConnLink);
    }

    public TCPWriteRequestContextImpl createWriteInterface(TCPConnLink tCPConnLink) {
        return new NioTCPWriteRequestContextImpl(tCPConnLink);
    }
}

