/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.DiscriminationProcessException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class NewConnectionInitialReadCallback
implements TCPReadCompletedCallback {
    TCPChannel tcpChannel;
    private static final TraceComponent tc = Tr.register(NewConnectionInitialReadCallback.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public NewConnectionInitialReadCallback(TCPChannel tCPChannel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "NewConnectionInitialReadCallback");
        }
        this.tcpChannel = tCPChannel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "NewConnectionInitialReadCallback");
        }
    }

    private boolean requestFull(TCPReadRequestContext tCPReadRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "requestFull");
        }
        WsByteBuffer[] wsByteBufferArray = tCPReadRequestContext.getBuffers();
        WsByteBuffer wsByteBuffer = wsByteBufferArray[wsByteBufferArray.length - 1];
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "requestFull");
        }
        return !wsByteBuffer.hasRemaining();
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "complete");
        }
        this.sendToDiscriminators(virtualConnection, tCPReadRequestContext, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "complete");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        WsByteBuffer[] wsByteBufferArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "error");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Error occurred during initial read of request from client: " + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort() + " : " + iOException);
        }
        if ((wsByteBufferArray = tCPReadRequestContext.getBuffers()) != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].release();
            }
        }
        tCPReadRequestContext.setBuffers(null);
        if (iOException != null && iOException instanceof SocketTimeoutException) {
            this.sendToDiscriminators(virtualConnection, tCPReadRequestContext, true);
        } else {
            ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, iOException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "error");
        }
    }

    private void sendToDiscriminators(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, boolean bl) {
        boolean bl2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendToDiscriminators");
        }
        tCPReadRequestContext.setJITAllocateSize(0);
        TCPConnLink tCPConnLink = ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink();
        do {
            int n;
            bl2 = false;
            try {
                n = this.tcpChannel.getDiscriminationProcess().discriminate(virtualConnection, tCPReadRequestContext.getBuffers(), tCPConnLink);
            }
            catch (DiscriminationProcessException discriminationProcessException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Exception occurred while discriminating data received from client " + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort());
                }
                ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, new IOException("Discrimination failed " + discriminationProcessException.getMessage()));
                break;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Discrimination returned " + n);
            }
            if (n == 1) {
                ConnectionReadyCallback connectionReadyCallback = tCPConnLink.getApplicationCallback();
                if (connectionReadyCallback != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Calling application callback.ready method");
                    }
                    connectionReadyCallback.ready(virtualConnection);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "No application callback found, closing connection");
                }
                ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, null);
                continue;
            }
            if (n == 2) {
                if (bl) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "First read timed out, and more than one discriminator asked for more data" + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort());
                    }
                    ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, null);
                    continue;
                }
                if (this.requestFull(tCPReadRequestContext)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Discrimination failed, no one claimed data even after 1 complete buffer presented - probably garbage passed in" + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort());
                    }
                    ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, null);
                    continue;
                }
                virtualConnection = tCPReadRequestContext.read(1L, this, false, 0);
                if (virtualConnection == null) continue;
                bl2 = true;
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Error occurred while discriminating data received from client " + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort());
            }
            ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, null);
        } while (bl2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendToDiscriminators");
        }
    }
}

