/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.vm29_00.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29_00.tools.ddrinteractive.structureformat.base.ScalarFormatter;
import com.ibm.j9ddr.vm29_00.types.Scalar;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.logging.Level;

public class U64ScalarFormatter
extends ScalarFormatter {
    public U64ScalarFormatter(int typeCode, Class<? extends AbstractPointer> pointerClass) {
        super(typeCode, pointerClass);
    }

    @Override
    protected void formatShortScalar(Scalar value, PrintStream out) {
        String hex = value.getHexValue();
        out.print(hex);
        out.print(" (");
        try {
            if (hex.toLowerCase().startsWith("0x")) {
                hex = hex.substring(2);
            }
            BigInteger bi = new BigInteger(hex, 16);
            out.print(bi.toString());
        }
        catch (Exception e) {
            out.print("Error - see log");
            logger.log(Level.FINE, "Error displaying U64 as decimal", e);
        }
        out.print(")");
    }
}

