/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_OwnableSynchronizerObjectListPointer;
import com.ibm.j9ddr.vm29_00.structure.J9Consts;
import com.ibm.j9ddr.vm29_00.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29_00.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckOwnableSynchronizerList
extends Check {
    CheckOwnableSynchronizerList() {
    }

    @Override
    public void check() {
        try {
            MM_HeapRegionManagerPointer heapRegionManager = this.getGCExtensions().heapRegionManager();
            long maximumOwnableSynchronizerCountOnHeap = heapRegionManager._totalHeapSize().longValue() / J9Consts.J9_GC_MINIMUM_OBJECT_SIZE;
            MM_OwnableSynchronizerObjectListPointer ownableSynchronizerObjectList = this.getGCExtensions().ownableSynchronizerObjectLists();
            while (ownableSynchronizerObjectList.notNull()) {
                J9ObjectPointer object = ownableSynchronizerObjectList._head();
                long ownableSynchronizerCount = 0L;
                this._engine.clearPreviousObjects();
                while (object.notNull() && this._engine.checkSlotOwnableSynchronizerList(object, ownableSynchronizerObjectList) == 0) {
                    if (++ownableSynchronizerCount > maximumOwnableSynchronizerCountOnHeap) {
                        this._engine.reportOwnableSynchronizerCircularReferenceError(object, ownableSynchronizerObjectList);
                        break;
                    }
                    this._engine.pushPreviousObject(object);
                    object = ObjectAccessBarrier.getOwnableSynchronizerLink(object);
                }
                ownableSynchronizerObjectList = ownableSynchronizerObjectList._nextList();
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (this._engine.needVerifyOwnableSynchronizerConsistency()) {
            this._engine.verifyOwnableSynchronizerObjectCounts();
        }
    }

    @Override
    public String getCheckName() {
        return "OWNABLE_SYNCHRONIZER";
    }

    @Override
    public void print() {
        try {
            MM_OwnableSynchronizerObjectListPointer ownableSynchronizerObjectList = this.getGCExtensions().ownableSynchronizerObjectLists();
            ScanFormatter formatter = new ScanFormatter(this, "ownableSynchronizerObjectList");
            while (ownableSynchronizerObjectList.notNull()) {
                formatter.section("list", ownableSynchronizerObjectList);
                J9ObjectPointer object = ownableSynchronizerObjectList._head();
                while (object.notNull()) {
                    formatter.entry(object);
                    object = ObjectAccessBarrier.getOwnableSynchronizerLink(object);
                }
                formatter.endSection();
                ownableSynchronizerObjectList = ownableSynchronizerObjectList._nextList();
            }
            formatter.end("ownableSynchronizerObjectList");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

