/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm29_00.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29_00.j9.DataType;
import com.ibm.j9ddr.vm29_00.j9.LiveSetWalker;
import com.ibm.j9ddr.vm29_00.j9.RootSet;
import com.ibm.j9ddr.vm29_00.j9.gc.GCClassIterator;
import com.ibm.j9ddr.vm29_00.j9.gc.GCClassIteratorClassSlots;
import com.ibm.j9ddr.vm29_00.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm29_00.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29_00.pointer.StructurePointer;
import com.ibm.j9ddr.vm29_00.pointer.VoidPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_AllocationContextPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_AllocationContextTarokPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_HeapRegionDescriptorVLHGCPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class ACCommand
extends Command {
    private GCHeapRegionManager heapRegionManager;

    public ACCommand() {
        this.addCommand("ac", "<address> [ xrefs | ownedRegions ]", "Dump allocation context details");
        this.addCommand("acforobject", "<address>", "Find allocation context which owns the specified object");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (command.equalsIgnoreCase("!acforobject")) {
                if (null == this.heapRegionManager) {
                    MM_HeapRegionManagerPointer hrmPointer = MM_GCExtensionsPointer.cast(vm.gcExtensions()).heapRegionManager();
                    this.heapRegionManager = GCHeapRegionManager.fromHeapRegionManager(hrmPointer);
                }
                if (args.length < 1) {
                    throw new DDRInteractiveCommandException("Invalid number of arguments specified.");
                }
                long addr = Long.decode(args[0]);
                J9ObjectPointer objectPointer = J9ObjectPointer.cast(addr);
                this.dumpACForObject(vm, objectPointer, out);
            } else {
                MM_GCExtensionsPointer gcExtensions = MM_GCExtensionsPointer.cast(vm.gcExtensions());
                if (args.length < 1) {
                    throw new DDRInteractiveCommandException("Invalid number of arguments specified.");
                }
                boolean dumpACExternalReferences = false;
                boolean dumpOwnedRegions = false;
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.equalsIgnoreCase("xrefs")) {
                        dumpACExternalReferences = true;
                        continue;
                    }
                    if (arg.equalsIgnoreCase("ownedRegions")) {
                        dumpOwnedRegions = true;
                        continue;
                    }
                    throw new DDRInteractiveCommandException("Unrecognized acforobject subcommand -->" + arg);
                }
                long addr = Long.decode(args[0]);
                MM_AllocationContextPointer ac = MM_AllocationContextPointer.cast(addr);
                if (dumpACExternalReferences) {
                    if (GCExtensions.isVLHGC()) {
                        context.execute("!mm_allocationcontexttarok", new String[]{args[0]}, out);
                    }
                    this.dumpLiveReferences(vm, ac, out);
                }
                if (dumpOwnedRegions) {
                    this.dumpOwnedRegions(vm, ac, out);
                }
            }
        }
        catch (DDRInteractiveCommandException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace(out);
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void dumpOwnedRegions(J9JavaVMPointer vm, MM_AllocationContextPointer allocationContext, PrintStream out) throws CorruptDataException {
        if (GCExtensions.isVLHGC()) {
            Table table = new Table("Regions Owned by AC " + allocationContext.getHexAddress());
            table.row("Region", "containsObjects");
            GCHeapRegionIterator regionIterator = GCHeapRegionIterator.from();
            while (regionIterator.hasNext()) {
                GCHeapRegionDescriptor region = regionIterator.next();
                MM_HeapRegionDescriptorVLHGCPointer vlhgcRegion = MM_HeapRegionDescriptorVLHGCPointer.cast(region.getHeapRegionDescriptorPointer());
                MM_AllocationContextTarokPointer currentAllocationContextTarok = vlhgcRegion._allocateData()._owningContext();
                if (!currentAllocationContextTarok.eq(allocationContext)) continue;
                table.row("!mm_heapregiondescriptorvlhgc " + vlhgcRegion.getHexAddress(), Boolean.toString(region.containsObjects()));
            }
            table.render(out);
        }
    }

    private void dumpLiveReferences(J9JavaVMPointer vm, MM_AllocationContextPointer allocationContext, PrintStream out) throws CorruptDataException {
        if (GCExtensions.isVLHGC()) {
            MM_AllocationContextTarokPointer act = MM_AllocationContextTarokPointer.cast(allocationContext);
            MM_HeapRegionManagerPointer hrmPointer = MM_GCExtensionsPointer.cast(vm.gcExtensions()).heapRegionManager();
            GCHeapRegionManager heapRegionManager = GCHeapRegionManager.fromHeapRegionManager(hrmPointer);
            Table table = new Table("Live References into AC " + allocationContext.getHexAddress());
            table.row("Object", "Field");
            out.println("Walking live set in search of external references into ac: " + allocationContext.getHexAddress());
            long totalMillis = System.currentTimeMillis();
            LiveReferenceVisitor visitor = new LiveReferenceVisitor(heapRegionManager, act, table);
            LiveSetWalker.walkLiveSet(visitor, RootSet.RootSetType.ALL);
            totalMillis = System.currentTimeMillis() - totalMillis;
            table.render(out);
            out.println("\nFinished live reference walk in " + totalMillis + "ms");
            out.println("Found " + visitor.getNumExternalReferencesFound() + " external references.");
        }
    }

    public void dumpACForObject(J9JavaVMPointer vm, StructurePointer objectPointer, PrintStream out) throws CorruptDataException {
        GCHeapRegionDescriptor region;
        if (GCExtensions.isVLHGC() && null != objectPointer && !objectPointer.isNull() && null != (region = this.heapRegionManager.regionDescriptorForAddress(objectPointer))) {
            MM_HeapRegionDescriptorVLHGCPointer vlhgcRegionPointer = MM_HeapRegionDescriptorVLHGCPointer.cast(region.getHeapRegionDescriptorPointer());
            StructurePointer act = vlhgcRegionPointer._allocateData()._owningContext().getAsRuntimeType();
            out.println("Object's owning context: " + act.formatShortInteractive());
        }
    }

    static class LiveReferenceVisitor
    implements LiveSetWalker.ObjectVisitor {
        GCHeapRegionManager heapRegionManager;
        MM_AllocationContextTarokPointer allocationContext;
        Table table;
        int numExternalReferences = 0;

        public LiveReferenceVisitor(GCHeapRegionManager heapRegionManager, MM_AllocationContextTarokPointer allocationContext, Table table) {
            this.heapRegionManager = heapRegionManager;
            this.allocationContext = allocationContext;
            this.table = table;
        }

        @Override
        public boolean visit(J9ObjectPointer object, VoidPointer address) {
            try {
                GCHeapRegionDescriptor objectRegion = this.heapRegionManager.regionDescriptorForAddress(object);
                MM_HeapRegionDescriptorVLHGCPointer vlhgcObjectRegion = MM_HeapRegionDescriptorVLHGCPointer.cast(objectRegion.getHeapRegionDescriptorPointer());
                MM_AllocationContextTarokPointer objectAllocationContext = vlhgcObjectRegion._allocateData()._owningContext();
                if (!objectAllocationContext.eq(this.allocationContext)) {
                    GCObjectIterator fieldIterator = GCObjectIterator.fromJ9Object(object, false);
                    while (fieldIterator.hasNext()) {
                        J9ObjectPointer field = fieldIterator.next();
                        if (!field.notNull()) continue;
                        this.checkField(object, field);
                    }
                    if (J9ObjectHelper.getClassName(object).equals("java/lang/Class")) {
                        J9ClassPointer clazz = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(object);
                        GCClassIterator classIterator = GCClassIterator.fromJ9Class(clazz);
                        while (classIterator.hasNext()) {
                            J9ObjectPointer slot = classIterator.next();
                            if (!slot.notNull()) continue;
                            this.checkField(object, slot);
                        }
                        GCClassIteratorClassSlots classSlotIterator = GCClassIteratorClassSlots.fromJ9Class(clazz);
                        while (classSlotIterator.hasNext()) {
                            J9ClassPointer slot = classSlotIterator.next();
                            J9ObjectPointer classObject = ConstantPoolHelpers.J9VM_J9CLASS_TO_HEAPCLASS(slot);
                            if (!classObject.notNull()) continue;
                            this.checkField(object, classObject);
                        }
                    }
                }
            }
            catch (CorruptDataException e) {
                return false;
            }
            return true;
        }

        @Override
        public void finishVisit(J9ObjectPointer object, VoidPointer address) {
        }

        private void checkField(J9ObjectPointer object, J9ObjectPointer field) throws CorruptDataException {
            MM_HeapRegionDescriptorVLHGCPointer vlhgcFieldRegion;
            MM_AllocationContextTarokPointer fieldAllocationContext;
            GCHeapRegionDescriptor fieldRegion = this.heapRegionManager.regionDescriptorForAddress(field);
            if (fieldRegion == null) {
                fieldRegion = null;
            }
            if ((fieldAllocationContext = (vlhgcFieldRegion = MM_HeapRegionDescriptorVLHGCPointer.cast(fieldRegion.getHeapRegionDescriptorPointer()))._allocateData()._owningContext()).eq(this.allocationContext)) {
                J9ClassPointer objectClass = J9ObjectHelper.clazz(object);
                String objectClassString = J9ClassHelper.getJavaName(objectClass);
                J9ClassPointer targetObjectClass = J9ObjectHelper.clazz(field);
                String targetObjectClassString = J9ClassHelper.getJavaName(targetObjectClass);
                this.table.row("!j9object " + object.getHexAddress() + " //" + objectClassString, "!j9object " + field.getHexAddress() + " //" + targetObjectClassString);
                ++this.numExternalReferences;
            }
        }

        public int getNumExternalReferencesFound() {
            return this.numExternalReferences;
        }
    }
}

