/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.Pool;
import com.ibm.j9ddr.vm29_00.j9.SlotIterator;
import com.ibm.j9ddr.vm29_00.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29_00.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm29_00.pointer.U8Pointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9VMSystemPropertyPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9ClassHelper;
import java.util.Iterator;
import java.util.Properties;

public class J9JavaVMHelper {
    public static Properties getSystemProperties(J9JavaVMPointer vm) throws CorruptDataException {
        Properties result = new Properties();
        Pool<J9VMSystemPropertyPointer> sysprops = Pool.fromJ9Pool(vm.systemProperties(), J9VMSystemPropertyPointer.class);
        SlotIterator<J9VMSystemPropertyPointer> syspropsIterator = sysprops.iterator();
        int count = 0;
        while (syspropsIterator.hasNext()) {
            J9VMSystemPropertyPointer prop = (J9VMSystemPropertyPointer)syspropsIterator.next();
            if (prop != null) {
                String name = null;
                try {
                    name = prop.name().getCStringAtOffset(0L);
                }
                catch (CorruptDataException e) {
                    name = "Corrupt System Property[" + count + "]";
                }
                String value = null;
                try {
                    value = prop.value().getCStringAtOffset(0L);
                }
                catch (CorruptDataException e) {
                    value = "Corrupt Value";
                }
                result.setProperty(name, value);
            }
            ++count;
        }
        return result;
    }

    public static J9MethodPointer getMethodFromPC(J9JavaVMPointer vmPtr, U8Pointer pc) throws CorruptDataException {
        GCClassLoaderIterator it = GCClassLoaderIterator.from();
        while (it.hasNext()) {
            J9ClassLoaderPointer loader = it.next();
            Iterator<J9ClassPointer> classIt = ClassIterator.fromJ9Classloader(loader);
            while (classIt.hasNext()) {
                J9ClassPointer clazz = classIt.next();
                J9MethodPointer result = J9ClassHelper.getMethodFromPCAndClass(clazz, pc);
                if (result.isNull()) continue;
                return result;
            }
        }
        return J9MethodPointer.NULL;
    }

    public static boolean extendedRuntimeFlagIsSet(J9JavaVMPointer javaVM, long flag) throws CorruptDataException {
        return javaVM.extendedRuntimeFlags().allBitsIn(flag);
    }
}

