/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DTFJJavaMethod
implements JavaMethod {
    protected final DTFJJavaClass clazz;
    protected final J9ROMMethodPointer j9romMethod;
    protected final J9MethodPointer j9ramMethod;
    private List<Object> byteCodeSections;
    List<Object> compiledSections;

    public DTFJJavaMethod(DTFJJavaClass dtfjJavaClass, J9MethodPointer j9Method) throws CorruptDataException {
        this.clazz = dtfjJavaClass;
        this.j9ramMethod = j9Method;
        this.j9romMethod = J9MethodHelper.romMethod(j9Method);
    }

    public Iterator getBytecodeSections() {
        if (this.byteCodeSections == null) {
            this.byteCodeSections = new ArrayList<Object>();
            try {
                J9ROMMethodPointer originalRomMethod = ROMHelp.getOriginalROMMethod(this.j9ramMethod);
                if (!originalRomMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccNative)) {
                    U8Pointer bcStart = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(originalRomMethod);
                    UDATA bcSize = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(originalRomMethod);
                    J9DDRImageSection is = DTFJContext.getImageSection(bcStart.getAddress(), "bytecode section at " + this.j9ramMethod.bytecodes().getAddress());
                    is.setSize(bcSize.longValue());
                    this.byteCodeSections.add(is);
                    if (!this.j9romMethod.equals(originalRomMethod)) {
                        is = DTFJContext.getImageSection(this.j9ramMethod.bytecodes().getAddress(), "bytecode section at " + this.j9ramMethod.bytecodes().getAddress());
                        is.setSize(bcSize.longValue());
                        this.byteCodeSections.add(is);
                    }
                }
            }
            catch (Throwable t) {
                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                this.byteCodeSections.add(cd);
            }
        }
        return this.byteCodeSections.iterator();
    }

    public Iterator getCompiledSections() {
        if (this.compiledSections == null) {
            this.compiledSections = new ArrayList<Object>();
            List<J9JITExceptionTablePointer> metaDatas = DTFJContext.getJITMetaData(this.j9ramMethod);
            if (metaDatas != null) {
                for (J9JITExceptionTablePointer metaData : metaDatas) {
                    CorruptData cd;
                    J9DDRImageSection is;
                    String name;
                    long size;
                    long start;
                    try {
                        start = metaData.startPC().longValue();
                        size = metaData.endWarmPC().longValue() - start;
                        name = String.format("jit section (%s) at %s", metaData.getAddress(), start);
                        is = DTFJContext.getImageSection(start, name);
                        is.setSize(size);
                        this.compiledSections.add(is);
                    }
                    catch (Throwable t) {
                        cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                        this.compiledSections.add(cd);
                    }
                    try {
                        start = metaData.startColdPC().longValue();
                        if (start == 0L) continue;
                        size = metaData.endPC().longValue() - start;
                        name = String.format("cold jit section (%s) at %s", metaData.getAddress(), start);
                        is = DTFJContext.getImageSection(start, name);
                        is.setSize(size);
                        this.compiledSections.add(is);
                    }
                    catch (Throwable t) {
                        cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                        this.compiledSections.add(cd);
                    }
                }
            }
        }
        return this.compiledSections.iterator();
    }

    public JavaClass getDeclaringClass() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        return this.clazz;
    }

    public int getModifiers() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return J9ROMMethodHelper.getReflectModifiers(this.j9romMethod);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return J9ROMMethodHelper.getName(this.j9romMethod);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public String getSignature() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return J9ROMMethodHelper.getSignature(this.j9romMethod);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public String getFilename() throws com.ibm.dtfj.image.CorruptDataException {
        return this.clazz.getFilename();
    }

    public String toString() {
        try {
            return this.clazz.toString() + "." + this.getName() + this.getSignature();
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            return super.toString();
        }
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null || !(obj instanceof DTFJJavaMethod)) {
                return false;
            }
            DTFJJavaMethod method = (DTFJJavaMethod)obj;
            return this.j9ramMethod.getAddress() == method.j9ramMethod.getAddress();
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            return false;
        }
    }

    public int hashCode() {
        return this.j9ramMethod.hashCode();
    }
}

