/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.DoublePointer;
import com.ibm.j9ddr.vm29.pointer.FloatPointer;
import com.ibm.j9ddr.vm29.pointer.I16Pointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.pointer.helper.PrintObjectFieldsHelper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import com.ibm.j9ddr.vm29.types.U32;
import java.io.PrintStream;
import java.util.List;

public class J9ObjectStructureFormatter
extends BaseStructureFormatter {
    public static final int DEFAULT_ARRAY_FORMAT_BEGIN = 0;
    public static final int DEFAULT_ARRAY_FORMAT_END = 16;

    @Override
    public FormatWalkResult format(String type2, long address, PrintStream out, Context context, List<IFieldFormatter> fieldFormatters, String[] extraArgs) {
        if (type2.equalsIgnoreCase("j9object") || type2.equalsIgnoreCase("j9indexableobject")) {
            J9ClassPointer clazz = null;
            J9ObjectPointer object = null;
            try {
                object = J9ObjectPointer.cast(address);
                clazz = J9ObjectHelper.clazz(object);
                if (clazz.isNull()) {
                    out.println("<can not read RAM class address>");
                    return FormatWalkResult.STOP_WALKING;
                }
                boolean isArray = J9ClassHelper.isArrayClass(clazz);
                String className = J9UTF8Helper.stringValue(clazz.romClass().className());
                U8Pointer dataStart = U8Pointer.cast(object).add(ObjectModel.getHeaderSize(object));
                if (className.equals("java/lang/String")) {
                    this.formatStringObject(out, 0, clazz, dataStart, object, address);
                } else if (isArray) {
                    if (ValueTypeHelper.getValueTypeHelper().isJ9ClassIsFlattened(clazz) && extraArgs.length > 0 && extraArgs[0].startsWith("[")) {
                        this.formatObject(out, J9ArrayClassPointer.cast(clazz).componentType(), dataStart, object, address, extraArgs);
                    } else {
                        int begin = 0;
                        int end = 16;
                        if (extraArgs.length > 0) {
                            begin = Integer.parseInt(extraArgs[0]);
                        }
                        if (extraArgs.length > 1) {
                            end = Integer.parseInt(extraArgs[1]);
                        }
                        this.formatArrayObject(out, clazz, dataStart, J9IndexableObjectPointer.cast(object), begin, end);
                    }
                } else {
                    this.formatObject(out, clazz, dataStart, object, address, extraArgs);
                }
            }
            catch (MemoryFault ex2) {
                out.println("Unable to read object clazz at " + (object == null ? "(null)" : object.getHexAddress()) + " (clazz = " + (clazz == null ? "(null)" : clazz.getHexAddress()) + ")");
            }
            catch (CorruptDataException ex) {
                out.println("Error for ");
                ex.printStackTrace(out);
            }
            return FormatWalkResult.STOP_WALKING;
        }
        return FormatWalkResult.KEEP_WALKING;
    }

    private void formatObject(PrintStream out, J9ClassPointer localClazz, U8Pointer dataStart, J9ObjectPointer localObject, long address, String[] extraArgs) throws CorruptDataException {
        String[] nestHierarchy = null;
        if (ValueTypeHelper.getValueTypeHelper().areValueTypesSupported()) {
            String[] stringArray = nestHierarchy = extraArgs.length == 0 ? null : extraArgs[0].split("\\.");
        }
        if (null != nestHierarchy) {
            out.format("!J9Object %s %s {%n", localObject.getHexAddress(), extraArgs[0]);
        } else {
            out.format("!J9Object %s {%n", localObject.getHexAddress());
        }
        PrintObjectFieldsHelper.printJ9ObjectFields(out, 1, localClazz, dataStart, localObject, address, nestHierarchy, false);
        out.println("}");
    }

    private void formatArrayObject(PrintStream out, J9ClassPointer localClazz, U8Pointer dataStart, J9IndexableObjectPointer localObject, int begin, int end) throws CorruptDataException {
        String className = J9IndexableObjectHelper.getClassName(localObject);
        out.format("!J9IndexableObject %s {%n", localObject.getHexAddress());
        out.format("    struct J9Class* clazz = !j9arrayclass 0x%X   // %s%n", localClazz.getAddress(), className);
        out.format("    Object flags = %s;%n", J9IndexableObjectHelper.flags(localObject).getHexValue());
        U32 size = J9IndexableObjectHelper.size(localObject);
        if (size.anyBitsIn(Integer.MIN_VALUE)) {
            out.format("    U_32 size = %s; // Size exceeds Integer.MAX_VALUE!%n", size.getHexValue());
        } else {
            out.format("    U_32 size = %s;%n", size.getHexValue());
        }
        this.printSubArrayType(out, 1, localClazz, dataStart, begin, end, localObject);
        out.println("}");
    }

    void printSubArrayType(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, int begin, int end, J9IndexableObjectPointer array) throws CorruptDataException {
        int finish;
        U32 arraySize = J9IndexableObjectHelper.size(array);
        if (arraySize.anyBitsIn(Integer.MIN_VALUE)) {
            arraySize = new U32(Integer.MAX_VALUE);
        }
        if (begin < (finish = Math.min(arraySize.intValue(), end))) {
            String className = J9IndexableObjectHelper.getClassName(array);
            char signature = className.charAt(1);
            switch (signature) {
                case 'B': 
                case 'Z': {
                    for (int index = begin; index < finish; ++index) {
                        PrintObjectFieldsHelper.padding(out, tabLevel);
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 1);
                        out.format("[%d] = %3d, 0x%02x%n", index, U8Pointer.cast(slot).at(0L).longValue(), U8Pointer.cast(slot).at(0L).longValue());
                    }
                    break;
                }
                case 'C': {
                    for (int index = begin; index < finish; ++index) {
                        PrintObjectFieldsHelper.padding(out, tabLevel);
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 2);
                        long value = U16Pointer.cast(slot).at(0L).longValue();
                        out.format("[%d] = %5d, 0x%2$04x, '%c'%n", index, value, Character.valueOf((char)value));
                    }
                    break;
                }
                case 'S': {
                    for (int index = begin; index < finish; ++index) {
                        PrintObjectFieldsHelper.padding(out, tabLevel);
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 2);
                        out.format("[%d] = %6d, 0x%04x%n", index, I16Pointer.cast(slot).at(0L).longValue(), U16Pointer.cast(slot).at(0L).longValue());
                    }
                    break;
                }
                case 'F': 
                case 'I': {
                    for (int index = begin; index < finish; ++index) {
                        PrintObjectFieldsHelper.padding(out, tabLevel);
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 4);
                        out.format("[%d] = %10d, 0x%08x, %8.8fF%n", index, I32Pointer.cast(slot).at(0L).longValue(), U32Pointer.cast(slot).at(0L).longValue(), Float.valueOf(FloatPointer.cast(slot).floatAt(0L)));
                    }
                    break;
                }
                case 'D': 
                case 'J': {
                    for (int index = begin; index < finish; ++index) {
                        PrintObjectFieldsHelper.padding(out, tabLevel);
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 8);
                        out.format("[%d] = %2d, 0x%016x, %8.8fF%n", index, I64Pointer.cast(slot).at(0L).longValue(), I64Pointer.cast(slot).at(0L).longValue(), DoublePointer.cast(slot).doubleAt(0L));
                    }
                    break;
                }
                case 'L': 
                case 'Q': 
                case '[': {
                    if (ValueTypeHelper.getValueTypeHelper().isJ9ClassIsFlattened(localClazz)) {
                        this.formatFlattenedObjectArray(out, tabLevel, begin, finish, array);
                        break;
                    }
                    this.formatReferenceObjectArray(out, tabLevel, localClazz, begin, finish, array);
                }
            }
        }
        arraySize = J9IndexableObjectHelper.size(array);
        if (begin > 0 || arraySize.longValue() > (long)finish) {
            out.format("To print entire range: !j9indexableobject %s %d %d%n", array.getHexAddress(), 0, arraySize.longValue());
        }
    }

    private void formatReferenceObjectArray(PrintStream out, int tabLevel, J9ClassPointer localClazz, int begin, int finish, J9IndexableObjectPointer array) throws CorruptDataException {
        for (int index = begin; index < finish; ++index) {
            VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, (int)ObjectReferencePointer.SIZEOF);
            long pointer = J9ObjectHelper.compressObjectReferences ? U32Pointer.cast(slot).at(0L).longValue() : DataType.getProcess().getPointerAt(slot.getAddress());
            PrintObjectFieldsHelper.padding(out, tabLevel);
            if (pointer != 0L) {
                out.format("[%d] = !fj9object 0x%x = !j9object 0x%x%n", index, pointer, ObjectReferencePointer.cast(slot).at(0L).longValue());
                continue;
            }
            out.format("[%d] = null%n", index);
        }
    }

    private void formatFlattenedObjectArray(PrintStream out, int tabLevel, int begin, int finish, J9IndexableObjectPointer array) throws CorruptDataException {
        for (int index = begin; index < finish; ++index) {
            PrintObjectFieldsHelper.padding(out, tabLevel);
            out.format("[%d] = !j9object 0x%x [%d]%n", index, array.getAddress(), index);
        }
    }

    private void formatStringObject(PrintStream out, int tabLevel, J9ClassPointer localClazz, U8Pointer dataStart, J9ObjectPointer localObject, long address) throws CorruptDataException {
        out.format("J9VMJavaLangString at %s {%n", localObject.getHexAddress());
        PrintObjectFieldsHelper.printJ9ObjectFields(out, tabLevel, localClazz, dataStart, localObject, address);
        PrintObjectFieldsHelper.padding(out, tabLevel);
        out.format("\"%s\"%n", J9ObjectHelper.stringValue(localObject));
        out.println("}");
    }
}

