/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckClassHeap;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckClassLoaders;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckEngine;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckFinalizableList;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckJNIGlobalReferences;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckJNIWeakGlobalReferences;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckJVMTIObjectTagTables;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckMonitorTable;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckObjectHeap;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckOwnableSynchronizerList;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckRememberedSet;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckReporter;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckStringTable;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckUnfinalizedList;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckVMClassSlots;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckVMThreadStacks;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckVMThreads;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

class CheckCycle {
    private static final String[] checkNames;
    private static final Class<Check>[] checkClasses;
    private int _checkFlags;
    private int _miscFlags;
    private int _errorCount;
    private Check[] _checks = null;
    private CheckEngine _engine;
    private boolean _printHelp;

    public CheckCycle(J9JavaVMPointer javaVM, CheckEngine engine, String options) {
        this._engine = engine;
        this.initialize(options);
    }

    private void printHelp() {
        CheckReporter reporter = this._engine.getReporter();
        reporter.println("GC Check for J9, Version 2.7");
        reporter.println();
        reporter.println("Usage: -Xcheck:gc[:scanOption,...][:verifyOption,...][:miscOption,...]");
        reporter.println("scan options (default is all):");
        reporter.println("  all");
        reporter.println("  none");
        for (int i = 0; i < checkNames.length; ++i) {
            reporter.println("  [no]" + checkNames[i]);
        }
        reporter.println("  heap");
        reporter.println("  help");
        reporter.println();
        reporter.println("verify options (default is all):");
        reporter.println("  all");
        reporter.println("  none");
        reporter.println("  classslot");
        reporter.println("  range");
        reporter.println("  flags");
        reporter.println();
        reporter.println("misc options (default is verbose,check):");
        reporter.println("  verbose");
        reporter.println("  quiet");
        reporter.println("  [no]scan");
        reporter.println("  [no]check");
        reporter.println("  maxErrors=X");
        reporter.println("  darkmatter");
        reporter.println("  midscavenge");
        reporter.println("  scavengerbackout");
        reporter.println("  ownablesynchronizerconsistency");
        reporter.println();
    }

    private void initialize(String options) {
        int i;
        HashMap<String, Boolean> checksToRun = new HashMap<String, Boolean>();
        ArrayList separatedOptions = new ArrayList();
        ArrayList<Check> checks = new ArrayList<Check>();
        int checkFlags = 0;
        int miscFlags = 1025;
        for (i = 0; i < checkNames.length; ++i) {
            checksToRun.put(checkNames[i], false);
        }
        if (options.equalsIgnoreCase("help")) {
            this._printHelp = true;
        } else {
            StringTokenizer colonSeparated = new StringTokenizer(options, ":");
            while (colonSeparated.hasMoreTokens()) {
                StringTokenizer commaSeparated = new StringTokenizer(colonSeparated.nextToken(), ",");
                ArrayList<String> separated = new ArrayList<String>();
                while (commaSeparated.hasMoreTokens()) {
                    separated.add(commaSeparated.nextToken());
                }
                separatedOptions.add(separated);
            }
            if (separatedOptions.size() > 0) {
                ArrayList scanOptions = (ArrayList)separatedOptions.get(0);
                if (scanOptions.size() == 0) {
                    for (int i2 = 0; i2 < checkNames.length; ++i2) {
                        checksToRun.put(checkNames[i2], true);
                    }
                } else {
                    for (String scanOption : scanOptions) {
                        if (scanOption.equals("all")) {
                            for (int i3 = 0; i3 < checkNames.length; ++i3) {
                                checksToRun.put(checkNames[i3], true);
                            }
                            continue;
                        }
                        if (scanOption.equals("none")) {
                            for (int i4 = 0; i4 < checkNames.length; ++i4) {
                                checksToRun.put(checkNames[i4], false);
                            }
                            continue;
                        }
                        if (checksToRun.containsKey(scanOption)) {
                            checksToRun.put(scanOption, true);
                            continue;
                        }
                        if (scanOption.equals("heap")) {
                            checksToRun.put("objectheap", true);
                            checksToRun.put("classheap", true);
                            continue;
                        }
                        if (scanOption.startsWith("no")) {
                            String disableOption = scanOption.substring(2);
                            if (checksToRun.containsKey(disableOption)) {
                                checksToRun.put(disableOption, false);
                                continue;
                            }
                            if (disableOption.equals("heap")) {
                                checksToRun.put("objectheap", false);
                                checksToRun.put("classheap", false);
                                continue;
                            }
                        }
                        this._printHelp = true;
                        this._engine.getReporter().println("GC Check: unrecognized option '" + scanOption + "'");
                    }
                }
            } else {
                for (int i5 = 0; i5 < checkNames.length; ++i5) {
                    checksToRun.put(checkNames[i5], true);
                }
            }
            if (separatedOptions.size() > 1) {
                ArrayList checkOptions = (ArrayList)separatedOptions.get(1);
                if (checkOptions.size() == 0) {
                    checkFlags = -1;
                } else {
                    for (String checkOption : checkOptions) {
                        if (checkOption.equals("all")) {
                            checkFlags |= 0xFFFFFFFF;
                            continue;
                        }
                        if (checkOption.equals("none")) {
                            checkFlags |= 0xFFFFFFFF;
                            continue;
                        }
                        if (checkOption.equals("all")) {
                            checkFlags &= 0;
                            continue;
                        }
                        if (checkOption.equals("classslot")) {
                            checkFlags |= 1;
                            continue;
                        }
                        if (checkOption.equals("range")) {
                            checkFlags |= 2;
                            continue;
                        }
                        if (checkOption.equals("flags")) {
                            checkFlags |= 8;
                            continue;
                        }
                        this._printHelp = true;
                        this._engine.getReporter().println("GC Check: unrecognized option '" + checkOption + "'");
                    }
                }
            } else {
                checkFlags = -1;
            }
            if (separatedOptions.size() > 2) {
                for (String miscOption : (ArrayList)separatedOptions.get(2)) {
                    if (miscOption.equals("verbose")) {
                        miscFlags |= 1;
                        continue;
                    }
                    if (miscOption.equals("manual")) {
                        miscFlags |= 0x2000;
                        continue;
                    }
                    if (miscOption.equals("quiet")) {
                        miscFlags &= 0xFFFFFFFE;
                        miscFlags |= 0x800;
                        continue;
                    }
                    if (miscOption.equals("scan")) {
                        miscFlags |= 0x200;
                        continue;
                    }
                    if (miscOption.equals("noscan")) {
                        miscFlags &= 0xFFFFFDFF;
                        continue;
                    }
                    if (miscOption.equals("check")) {
                        miscFlags |= 0x400;
                        continue;
                    }
                    if (miscOption.equals("nocheck")) {
                        miscFlags &= 0xFFFFFBFF;
                        continue;
                    }
                    if (miscOption.startsWith("maxerrors=")) {
                        int max = Integer.parseInt(miscOption.substring("maxerrors=".length()));
                        this._engine.setMaxErrorsToReport(max);
                        continue;
                    }
                    if (miscOption.equals("darkmatter")) {
                        miscFlags |= 0x8000;
                        continue;
                    }
                    if (J9BuildFlags.J9VM_GC_MODRON_SCAVENGER || J9BuildFlags.J9VM_GC_VLHGC) {
                        if (miscOption.equals("midscavenge")) {
                            miscFlags |= 0x10000;
                            continue;
                        }
                        if (miscOption.equals("indexabledataaddress")) {
                            miscFlags |= 0x40000;
                            continue;
                        }
                    }
                    if (miscOption.equals("abort")) {
                        miscFlags |= 0x1000;
                        continue;
                    }
                    if (miscOption.equals("noabort")) {
                        miscFlags &= 0xFFFFEFFF;
                        continue;
                    }
                    if (miscOption.equals("dumpstack")) {
                        miscFlags |= 0x4000;
                        continue;
                    }
                    if (miscOption.equals("nodumpstack")) {
                        miscFlags &= 0xFFFFBFFF;
                        continue;
                    }
                    if (miscOption.startsWith("interval=")) {
                        miscFlags |= 2;
                        continue;
                    }
                    if (J9BuildFlags.J9VM_GC_MODRON_SCAVENGER && miscOption.startsWith("localinterval=")) {
                        miscFlags |= 8;
                        continue;
                    }
                    if (miscOption.startsWith("globalinterval=")) {
                        miscFlags |= 4;
                        continue;
                    }
                    if (miscOption.startsWith("startindex=")) {
                        miscFlags |= 0x10;
                        continue;
                    }
                    if (J9BuildFlags.J9VM_GC_MODRON_SCAVENGER) {
                        if (miscOption.equals("scavengerbackout")) {
                            miscFlags |= 0x20;
                            continue;
                        }
                        if (miscOption.equals("suppresslocal")) {
                            miscFlags |= 0x40;
                            continue;
                        }
                    }
                    if (miscOption.equals("suppressglobal")) {
                        miscFlags |= 0x80;
                        continue;
                    }
                    if (J9BuildFlags.J9VM_GC_GENERATIONAL && miscOption.equals("rememberedsetoverflow")) {
                        miscFlags |= 0x100;
                        continue;
                    }
                    if (miscOption.equals("ownablesynchronizerconsistency")) {
                        miscFlags |= 0x20000;
                        continue;
                    }
                    this._printHelp = true;
                    this._engine.getReporter().println("GC Check: unrecognized option '" + miscOption + "'");
                }
            }
        }
        for (i = 0; i < checkNames.length; ++i) {
            if (!((Boolean)checksToRun.get(checkNames[i])).booleanValue()) continue;
            try {
                Check check = checkClasses[i].newInstance();
                check.initialize(this._engine);
                checks.add(check);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        this._checks = checks.toArray(new Check[checks.size()]);
        this._checkFlags = checkFlags;
        this._miscFlags = miscFlags;
        if (((Boolean)checksToRun.get("objectheap")).booleanValue()) {
            this._engine.initializeOwnableSynchronizerCountOnHeap();
        }
        if (((Boolean)checksToRun.get("ownablesynchronizer")).booleanValue()) {
            this._engine.initializeOwnableSynchronizerCountOnList();
        }
    }

    public void run() throws CorruptDataException {
        if (this._printHelp) {
            this.printHelp();
        } else {
            this._engine.startCheckCycle(this);
            for (int i = 0; i < this._checks.length; ++i) {
                boolean check = 1024 == (this._miscFlags & 0x400);
                boolean scan = 512 == (this._miscFlags & 0x200);
                this._checks[i].run(check, scan);
            }
            this._engine.endCheckCycle();
        }
    }

    public int nextErrorCount() {
        return ++this._errorCount;
    }

    public int getCheckFlags() {
        return this._checkFlags;
    }

    public int getMiscFlags() {
        return this._miscFlags;
    }

    public void clearIndexableDataAddrCheckMiscFlag() {
        this._miscFlags &= 0xFFFBFFFF;
    }

    static {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Class<CheckVMThreadStacks>> classes = new ArrayList<Class<CheckVMThreadStacks>>();
        names.add("objectheap");
        classes.add(CheckObjectHeap.class);
        names.add("classheap");
        classes.add(CheckClassHeap.class);
        if (J9BuildFlags.J9VM_GC_GENERATIONAL) {
            names.add("rememberedset");
            classes.add(CheckRememberedSet.class);
        }
        if (J9BuildFlags.J9VM_GC_FINALIZATION) {
            names.add("unfinalized");
            classes.add(CheckUnfinalizedList.class);
            names.add("finalizable");
            classes.add(CheckFinalizableList.class);
        }
        names.add("ownablesynchronizer");
        classes.add(CheckOwnableSynchronizerList.class);
        names.add("stringtable");
        classes.add(CheckStringTable.class);
        names.add("classloaders");
        classes.add(CheckClassLoaders.class);
        names.add("jniglobalrefs");
        classes.add(CheckJNIGlobalReferences.class);
        names.add("jniweakglobalrefs");
        classes.add(CheckJNIWeakGlobalReferences.class);
        if (J9BuildFlags.J9VM_OPT_JVMTI) {
            names.add("jvmtiobjecttagtables");
            classes.add(CheckJVMTIObjectTagTables.class);
        }
        names.add("vmclassslots");
        classes.add(CheckVMClassSlots.class);
        names.add("monitortable");
        classes.add(CheckMonitorTable.class);
        names.add("vmthreads");
        classes.add(CheckVMThreads.class);
        names.add("threadstacks");
        classes.add(CheckVMThreadStacks.class);
        checkNames = names.toArray(new String[names.size()]);
        checkClasses = classes.toArray(new Class[classes.size()]);
    }
}

